<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{trans("crudbooster.page_title_login")}} : {{Session::get('appname')}}</title>
    <meta name='generator' content='CRUDBooster'/>
    <meta name='robots' content='noindex,nofollow'/>
    <link rel="shortcut icon"
          href="{{ CRUDBooster::getSetting('favicon')?asset(CRUDBooster::getSetting('favicon')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}">

    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <!-- Bootstrap 3.3.2 -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Font Awesome Icons -->
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <!-- Theme style -->
    <link href="{{asset('vendor/crudbooster/assets/adminlte/dist/css/AdminLTE.min.css')}}" rel="stylesheet" type="text/css"/>

    <!-- support rtl-->
    @if (in_array(App::getLocale(), ['ar', 'fa']))
        <link rel="stylesheet" href="//cdn.rawgit.com/morteza/bootstrap-rtl/v3.3.4/dist/css/bootstrap-rtl.min.css">
        <link href="{{ asset("vendor/crudbooster/assets/rtl.css")}}" rel="stylesheet" type="text/css"/>
@endif

<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->

    <link rel='stylesheet' href='{{asset("vendor/crudbooster/assets/css/main.css")}}'/>
    <style type="text/css">
        .login-page, .register-page {
            background: {{ CRUDBooster::getSetting("login_background_color")?:'#dddddd'}} url('{{ CRUDBooster::getSetting("login_background_image")?asset(CRUDBooster::getSetting("login_background_image")):asset('vendor/crudbooster/assets/bg_blur3.jpg') }}');
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#ffffff' }}  !important;
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover;
        }

        .login-box, .register-box {
            margin: 1% auto;
        }

        .login-box-body {
            box-shadow: 0px 0px 50px rgba(0, 0, 0, 0.8);
            background: rgba(255, 255, 255, 0.9);
            color: {{ CRUDBooster::getSetting("login_font_color")?:'#666666' }}  !important;
        }

        html, body {
            overflow: hidden;
        }
    </style>
</head>

<body class="login-page">

<div class="login-box">
    <div class="login-logo" style="margin-bottom:-10px;">
        <a href="{{url('/')}}">
            <img title='{!!(Session::get('appname') == 'CRUDBooster')?"<b>CRUD</b>Booster":CRUDBooster::getSetting('appname')!!}'
                 src='{{ CRUDBooster::getSetting("logo")?asset(CRUDBooster::getSetting('logo')):asset('vendor/crudbooster/assets/logo_crudbooster.png') }}'
                 style='max-width: 100%;height:30px'/>
        </a>
    </div><!-- /.login-logo -->
	<br>
    <div class="login-box-body">

        @if ( Session::get('message') != '' )
            <div class='alert alert-warning'>
                {{ Session::get('message') }}
            </div>
        @endif

        <p class='login-box-msg' id="title">Registrasi Pengguna</p>
        <form autocomplete='off' action="javascript:cariLokal();" method="post" id="regform">
            <input type="hidden" name="_token" value="{{ csrf_token() }}"/>
            <div class="form-group has-feedback">
                <input autocomplete='off' type="hidden" id="kunci" class="form-control" name='kunci'  required value="{{ $kunci }}"/>
            </div>
            <div class="form-group has-feedback">
                <input autocomplete='off' type="text" id="niplog" class="form-control" name='nip' required placeholder="Masukkan NIK Anda"/>
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div style="margin-bottom:10px" class='row'>

                 <div class='col-xs-12'>
                    <button class="btn btn-primary btn-block btn-flat"><i class='fa fa-lock' "></i> Lanjut</button>
                </div>
            </div>
        </form>
        
         @if ( Session::get('message') != '' )
            <button class="btn btn-primary btn-block btn-flat" onclick="Android.backToLogin();"><i class='fa fa-arrow-left'></i> Kembali</button>
         @endif

        <br/>
        <!--a href="#">I forgot my password</a-->

    </div><!-- /.login-box-body -->

</div><!-- /.login-box -->


	
<!-- jQuery 2.1.3 -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/plugins/jQuery/jQuery-2.1.4.min.js')}}"></script>
<!-- Bootstrap 3.3.2 JS -->
<script src="{{asset('vendor/crudbooster/assets/adminlte/bootstrap/js/bootstrap.min.js')}}" type="text/javascript"></script>
<!--- <script src="{{asset('js/jquery.validate.js')}}"></script> -->
<script type="text/javascript">

	sessionStorage.host = "https://siapkk.banjarbarukota.go.id";
	sessionStorage.localhost = "https://satu.banjarbarukota.go.id/siapkk/public";
	sessionStorage.kunci=$("#kunci").val();
	bahandap();
	
	function bahandap(){
	    var res = '';
	    $.ajax({
			type: "POST",
			url: sessionStorage.host+ "/api/bahandap",
			cache: false,
			data: "kunci="+sessionStorage.kunci,
			success: function (result) {
				if(result.api_status==0){
				    window.location.href="https://banjarbarukota.go.id/h/"+sessionStorage.kunci;
				}
			},
			error: function (request,error) {
				console.log(error);	
				//res = 0;
			}
		});	
	}
	
	function cariLokal(){
	    bahandap();
		if($("#niplog").val()!==""){
		    
			sessionStorage.selNip=$("#niplog").val();
			$.ajax({
				type: "POST",
				url: sessionStorage.host+ "/api/user_exist",
				cache: false,
				data: "nik="+sessionStorage.selNip,
				success: function (result) {
					if(result.api_status==0){
					    cariIni(sessionStorage.selNip);
					}else{
					    alert("Nik Sudah Terdaftar !");
					    window.location.href="https://siapkk.banjarbarukota.go.id/admin";
					}
				},
				error: function (request,error) {
					console.log(error);	
				}
			});	
		}else{
			alert('NIK TIdak Boleh Kosong !');
		}
	}
	
	function tdc(selnik){
        	bahandap();
			$.ajax({
				type: "POST",
				url: sessionStorage.localhost+ "/api/satu",
				cache: false,
				data: "nik="+selnik+"&token=1234567890&mode=cari_nik",
				success: function (result) {
				    console.log(result);
					if(result.api_status==0){
						alert(result.api_message);
						return false;
					}						
				},
				error: function (request,error) {
					console.log(error);	
				}
			});	
	}

	
	
	function cariIni(){
	    bahandap();
		if($("#niplog").val()!==""){
			$("#title").html('Yang Mana Anda ?');
			sessionStorage.selNip=$("#niplog").val();
			$("#regform").empty();
			var recode = '';
			var cnt = 0;
				$.ajax({
					type: "POST",
					url: sessionStorage.localhost+ "/api/satu",
					cache: false,
					data: "nik="+sessionStorage.selNip+"&token=1234567890&mode=cari_nama",
					success: function (result) {
						var res = result;
						if(res.api_status==1){
    						$.each(res.nama, function(key,value){
    							var namacmd = "'" + value.nama + "'";
    							recode += '<button class="btn btn-primary btn-block btn-flat" onclick="cariInduk('+namacmd+');">'+value.nama+'</button>';
    							cnt++;
    						});
    						
    						$("#regform").append(recode);
						}else{
						    return false;
						}
						
					},
					error: function (request,error) {
						console.log(error);	
					}
				});	
		}else{
			alert('NIK TIdak Boleh Kosong !');
		}
	}
	
	function cariInduk(nama){
	    bahandap();
		$("#title").html('Nama ibu anda ?');
		sessionStorage.selNama=nama;
		$("#regform").empty();
		var recode = '';
		var cnt = 0;
		$.ajax({
			type: "POST",
			url: sessionStorage.localhost+ "/api/satu",
			cache: false,
			data: "nik="+sessionStorage.selNip+"&nama_lgkp="+sessionStorage.selNama+"&token=1234567890&mode=cari_induk",
			success: function (result) {
				//console.log(result);
				var res = result;
				if(res.api_status==1){
    				$.each(res.nama, function(key,value){
    					var namacmd = "'" + value.nama + "'";
    					recode += '<button class="btn btn-primary btn-block btn-flat" onclick="simpanInduk('+namacmd+');">'+value.nama+'</button>';
    					cnt++;
    				});
    				
    				$("#regform").append(recode);	
				}else{
				    return false;
				}
				
			},
			error: function (request,error) {
				console.log(error);	
			}
		});		
	}
	
	function simpanInduk(nama){
    	bahandap();
	    sessionStorage.selInduk=nama;
	    var selnik = sessionStorage.selNip;
    	$.ajax({
    		type: "POST",
    		url: sessionStorage.localhost+ "/api/satu",
    		cache: false,
    		data: "nik="+selnik+"&nama_lgkp="+sessionStorage.selNama+"&nama_lgkp_ibu="+sessionStorage.selInduk+"&token=1234567890&mode=verif_selection",
    		success: function (result) {
    			console.log(result);
    			if(result.api_status==1){
    			    tdc(selnik);
    			    $("#title").html('Password Yang Anda Inginkan');
        			$("#regform").empty();
            	    var logcmd = "{{ route('postRegister') }}";
            		var recode = '';
    			    recode += '<form autocomplete="off" action="' + logcmd + '" method="post" id="lastform">';
            		recode += '<input type="hidden" name="_token" value="{{ csrf_token() }}"/>';
            		recode += '<div class="form-group has-feedback">';
                    recode +=      '<input autocomplete="off" type="text" id="nik" class="form-control" name="nik" required placeholder="NIK" value="' + selnik + '"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode += '</div>';
            		recode += '<div class="form-group has-feedback">';
                    recode +=      '<input autocomplete="off" type="text" id="name" class="form-control" name="name" required placeholder="Nama" value="' + sessionStorage.selNama + '"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode += '</div>';
            		
            		recode += '<div class="form-group has-feedback">';
                    recode +=      '<input autocomplete="off" type="password" id="password" class="form-control" name="password" required placeholder="Ketikan Password"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode += '</div>';
            		recode += '<div class="form-group has-feedback">';
                    recode +=     '<input autocomplete="off" type="password" id="repassword" class="form-control" name="repassword" required placeholder="Ketikan Password Sekali Lagi"/>';
                    recode +=      '<span class="glyphicon glyphicon-password form-control-feedback"></span>';
                    recode +=  '</div>';
                    recode +=    '<div style="margin-bottom:10px" class="row" >';
                    recode +=        '<div class="col-xs-12">';
                    recode +=            '<button type="submit" class="btn btn-primary btn-block btn-flat"><i class="fa fa-lock"></i>Selesai</button>';
                    recode +=        '</div>';
                    recode +=    '</div>';
            		recode += '</form>';
            		
            		$("#regform").replaceWith(recode);	
            		
            		asin();
    			}else{
    			    return false;
    			}
    		},
    		error: function (request,error) {
    			console.log(error);	
    		}
		});		
	}
	
	
	function asin(){
		$('#lastform').submit(function(e) { 
			if($('#password').val().length >=6){
				if($('#password').val() != $('#repassword').val()){
					alert('Password harus sama !');
					e.preventDefault(); // Cancel the submit
					return false; // Exit the .each loop
				}
			}else{
				alert('Minimal 6 karakter !');
				e.preventDefault(); // Cancel the submit
				return false; // Exit the .each loop
			}
		});
	}

</script>
</body>
</html>