<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;
	use User;
	use Barryvdh\DomPDF\Facade as PDF;
	use \PhpOffice\PhpWord as WORD;
	use File;
	use Illuminate\Support\Facades\Schema;
	use App\QRlib\QRCodeProv;
	use App\Signature\Esign;
	use App\Signature\Client\BasicRest;

	class AdminAgendaController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "mulai,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_dropdown";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "agenda";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Kegiatan","name"=>"kegiatan"];
			$this->col[] = ["label"=>"Deskripsi","name"=>"deskripsi"];
			$this->col[] = ["label"=>"Lokasi","name"=>"lokasi"];
			$this->col[] = ["label"=>"Mulai","name"=>"mulai"];
			$this->col[] = ["label"=>"Sampai","name"=>"sampai"];
			$this->col[] = ["label"=>"Reses","name"=>"reses"];
			$this->col[] = ["label"=>"Aktif","name"=>"aktif"];
			$this->col[] = ["label"=>"Notulen","name"=>"gen_pdf","download"=>true];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Kegiatan','name'=>'kegiatan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Deskripsi','name'=>'deskripsi','type'=>'textarea','validation'=>'required|string|min:5','width'=>'col-sm-7'];
			
			$this->form[] = ['label'=>'Lokasi','name'=>'lokasi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-7'];
			$this->form[] = ['label'=>'Reses','name'=>'reses','type'=>'radio','validation'=>'required|min:1|max:255','width'=>'col-sm-3','dataenum'=>'1|Ya;0|Tidak','value'=>0];
			$this->form[] = ['label'=>'Mulai','name'=>'mulai','type'=>'datetime','validation'=>'required|date_format:Y-m-d H:i:s','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Sampai','name'=>'sampai','type'=>'datetime','validation'=>'required|date_format:Y-m-d H:i:s','width'=>'col-sm-5'];
			
			$columns[] = ['label'=>'Dasar','name'=>'dasar','type'=>'text'];
			$this->form[] = ['label'=>'Dasar - Dasar','name'=>'agenda_dasar','type'=>'child','columns'=>$columns,'width'=>'col-sm-7','table'=>'agenda_dasar','parent'=>'agenda','foreign_key'=>'agenda_id'];
			
			$this->form[] = ['label'=>'Dewan','name'=>'dewan','type'=>'checkbox','datatable'=>'dewan,nama_dewan'];
			
			$this->form[] = ['label'=>'Kepala SKPD','name'=>'pejabat','type'=>'checkbox','datatable'=>'jabatan,jabatan','datatable_where'=>'jabatan LIKE "KEPALA DINAS%"'];
			$this->form[] = ['label'=>'Camat','name'=>'pejabat','type'=>'checkbox','datatable'=>'jabatan,jabatan','datatable_where'=>'jabatan LIKE "CAMAT%"'];
			$this->form[] = ['label'=>'Lurah','name'=>'pejabat','type'=>'checkbox','datatable'=>'jabatan,jabatan','datatable_where'=>'jabatan LIKE "LURAH%"'];
			
			
// 			$columns1[] = ['label'=>'Pilih','name'=>'dprd_id','type'=>'select','datatable'=>'dprd,nama'];
// 			$this->form[] = ['label'=>'Pimpinan dan Komisi II','name'=>'agenda_pimpinan','type'=>'child','columns'=>$columns1,'width'=>'col-sm-7','table'=>'agenda_pimpinan','parent'=>'agenda','foreign_key'=>'agenda_id'];
			
			$columns2[] = ['label'=>'Pilih','name'=>'cms_users_id','type'=>'select','datatable'=>'cms_users,name','datatable_where'=>'dinas_id = 3'];
			$this->form[] = ['label'=>'Pendamping','name'=>'agenda_pendamping','type'=>'child','columns'=>$columns2,'width'=>'col-sm-7','table'=>'agenda_pendamping','parent'=>'agenda','foreign_key'=>'agenda_id'];
			
			
			$this->form[] = ['label'=>'Aktif','name'=>'aktif','type'=>'radio','validation'=>'required|min:1|max:255','width'=>'col-sm-3','dataenum'=>'1|Ya;0|Tidak','value'=>0];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Aktif","name"=>"aktif","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Deskripsi","name"=>"deskripsi","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Kegiatan","name"=>"kegiatan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lokasi","name"=>"lokasi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Mulai","name"=>"mulai","type"=>"datetime","required"=>TRUE,"validation"=>"required|date_format:Y-m-d H:i:s"];
			//$this->form[] = ["label"=>"Reses","name"=>"reses","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Sampai","name"=>"sampai","type"=>"datetime","required"=>TRUE,"validation"=>"required|date_format:Y-m-d H:i:s"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        if(CRUDBooster::myPrivilegeId()<>1 && CRUDBooster::myPrivilegeId()<>41 && CRUDBooster::myPrivilegeId()<>43){
    	        $this->sub_module[] = ['label'=>'Dokumentasi','path'=>'agenda_dokumentasi','parent_columns'=>'kegiatan','foreign_key'=>'agenda_id','button_color'=>'warning','button_icon'=>'fa fa-image'];
    	        $this->sub_module[] = ['label'=>'Usulan Warga','path'=>'agenda_usulan_warga','parent_columns'=>'kegiatan','foreign_key'=>'agenda_id','button_color'=>'danger','button_icon'=>'fa fa-flag'];
    	    }
	       // if(CRUDBooster::myPrivilegeId()==43){
	       //    $this->sub_module[] = ['label'=>'Notulen 1','path'=>'agenda_notulen','parent_columns'=>'kegiatan','foreign_key'=>'agenda_id','button_color'=>'info','button_icon'=>'fa fa-note']; 
	       // }
	        


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
            if(CRUDBooster::myPrivilegeId()==43){
               $this->addaction[] = ['label'=>'WA','url'=>CRUDBooster::mainpath().'/kirim-wa/[id]','icon'=>'fa fa-send','color'=>'success']; 
	           $this->addaction[] = ['label'=>'Notulen','url'=>CRUDBooster::mainpath().'/notulen/[id]','icon'=>'fa fa-note','color'=>'info']; 
	           $this->addaction[] = ['label'=>'Cetak','url'=>CRUDBooster::mainpath().'/cetak-notulen/[id]','icon'=>'fa fa-print','color'=>'warning']; 
	        }

	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();
	        $this->button_selected = array(["label"=>"Kirim WA","icon"=>"fa-letter","name"=>"kirimwa"]);

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        if(CRUDBooster::myPrivilegeId()<>1 && CRUDBooster::myPrivilegeId()<>41 && CRUDBooster::myPrivilegeId()<>43){
    	        $query->join('agenda_pimpinan','agenda_pimpinan.agenda_id','agenda.id')
    	               ->where('agenda_pimpinan.cms_users_id',CRUDBooster::myId());
	        }
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $postdata['created_by'] = CRUDBooster::myId();
            $postdata['updated_by'] = CRUDBooster::myId();
            $postdata['created_at'] = now();
            
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        DB::table('agenda_pimpinan')->where('agenda_id',$id)->delete();
            $agenda = DB::table('agenda')->where('id',$id)->first();
            $dewans = explode(";",$agenda->dewan);
            foreach($dewans as $dewan){
                $dwn = DB::table('dewan')->where('nama_dewan',$dewan)->first();
                $anggotadewan = DB::table('dewan_dprd')->where('dewan_id',$dwn->id)->get();
                
                foreach($anggotadewan as $andew){
                    $dprd = DB::table('dprd')->where('id',$andew->dprd_id)->first();
                    // dd(CRUDBooster::wargaToCms($dprd->warga_bjb_id)->id);
                    DB::table('agenda_pimpinan')->insert(['agenda_id'=>$id,'dprd_id'=>$andew->dprd_id,'cms_users_id'=>CRUDBooster::wargaToCms($dprd->warga_bjb_id)->id]);
                    
                }
                
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {    
            $postdata['updated_by'] = CRUDBooster::myId();
            $postdata['created_at'] = now();
            
            
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        DB::table('agenda_pimpinan')->where('agenda_id',$id)->delete();
            $agenda = DB::table('agenda')->where('id',$id)->first();
            $dewans = explode(";",$agenda->dewan);
            foreach($dewans as $dewan){
                $dwn = DB::table('dewan')->where('nama_dewan',$dewan)->first();
                $anggotadewan = DB::table('dewan_dprd')->where('dewan_id',$dwn->id)->get();
                
                foreach($anggotadewan as $andew){
                    $dprd = DB::table('dprd')->where('id',$andew->dprd_id)->first();
                    // dd(CRUDBooster::wargaToCms($dprd->warga_bjb_id)->id);
                    DB::table('agenda_pimpinan')->insert(['agenda_id'=>$id,'dprd_id'=>$andew->dprd_id,'cms_users_id'=>CRUDBooster::wargaToCms($dprd->warga_bjb_id)->id]);
                    
                }
                
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }
	    
	    public function getNotulen($id) {
	         if(!CRUDBooster::isUpdate() && $this->global_privilege==FALSE || $this->button_edit==FALSE) {    
                CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
              }
              
              $data = [];
              $data['page_title'] = 'Edit Data';
              $data['row'] = DB::table('agenda_notulen')->where('agenda_id',$id)->first();
              $data['peserta'] = DB::table('agenda_pimpinan')->join('cms_users','cms_users.id','agenda_pimpinan.cms_users_id')->join('dprd','dprd.id','agenda_pimpinan.dprd_id')->where('agenda_pimpinan.agenda_id',$id)->get();
              $data['agenda'] = DB::table('agenda')->where('id',$id)->first();
              $pejabats = explode(";",$data['agenda']->pejabat);
              
              foreach($pejabats as $pj){
                  $jabatan = DB::table('jabatan')->where('jabatan',$pj)->first();
                  $pejabat = DB::table('pejabat')->where('jabatan_id',$jabatan->id)->first();
                  if($pejabat){
                      $pejabat->name = $pejabat->nama_pejabat;
                      
                      $data['peserta']->push($pejabat);
                  }
              }
              
              if($data['row']){
                  $data['new'] = false; 
              }else{
                  $data['new'] = true; 
              }
              
              $this->cbView('notulen.index',$data);

	    }

        public function postSaveNotulen($id) {
            
            if(Request::input('new')==1){
                DB::table('agenda_notulen')->insert([
                        'agenda_id' => $id,
                        'cms_users_id' => CRUDBooster::myId(),
                        'isi' => Request::input('isi'),
                        'created_by' => CRUDBooster::myId()
                    ]);
            }else{
                // dd(Request::input('isi'));
                DB::table('agenda_notulen')->where('id',$id)->update([
                        'cms_users_id' => CRUDBooster::myId(),
                        'isi' => Request::input('isi'),
                        'created_by' => CRUDBooster::myId()
                    ]);
            }
            
            return redirect(CRUDBooster::mainpath())->with(['message'=>'Notulen berhasil disimpan ','message_type'=>'success'])->send();
            exit();
        }
        
        public function getCetakNotulen($id) {
            $template = DB::table('agenda_notulen_template')->where('aktif',1)->first();
            $agenda = DB::table('agenda')->where('id',$id)->first();
            $notulen = DB::table('agenda_notulen')->where('agenda_id',$id)->first();
            setlocale(LC_TIME, 'id_ID');
		    setlocale(LC_ALL, 'IND');
		    Carbon::setlocale('id');
		    
		    
		    
    		    $path = $template->file_doc;
    			$fileName = storage_path('app/' . $path);
    			$file = basename($path);
    			$file = basename($path , ".docx");
    			
    			//dd($file);
    			
    			$templateProcessor = new WORD\TemplateProcessor($fileName);
    			
    			
    			$templateProcessor->setValue('kegiatan', $agenda->kegiatan);
    			
    			$mulai = strftime( "%d %B %Y", strtotime($agenda->mulai));
    			
    			$templateProcessor->setValue('mulai', $mulai);
    			
    			$templateProcessor->setValue('lokasi', $agenda->lokasi);
    			
    			$templateProcessor->setValue('dewan', $agenda->dewan);
                
                $dom = new \DOMDocument;
                $dom->loadHTML($notulen->isi);
            
                //dd($dom->saveXml($dom));
    			
    			$templateProcessor->setValue('isi', strip_tags($dom->saveXml($dom)));
    			
    			
    			
    			$kunci = CRUDBooster::generateRandomString(12);
    			
    			
    			$qrfolder = 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m");
                $qrpath = 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/' . $kunci . '.png';
                $realqrpath = storage_path('app/'.$qrpath);
                if (!file_exists(storage_path('app/'.$qrfolder))) {
                    mkdir(storage_path('app/'.$qrfolder), 0755, true);
                }
                $qr = new QRCodeProv();
                $qr->makeqr($text = 'https://bjb.city/' . $kunci ,$path = storage_path('app/'.$qrpath));
                
                $templateProcessor->setImageValue(
                    'qr',
                    array('path' => $realqrpath, 'width' => 100, 'height' => 100, 'ratio' => false)
                );
                
                $templateProcessor->setImageValue(
                    'footer',
                    array('path' => storage_path('app/'.CRUDBooster::getSetting('logo_bsre')), 'width' => 100, 'height' => 58, 'ratio' => false)
                    );
                    
                $templateProcessor->setValue(
                    'footer_text',
                    'Dokumen ini akan/telah ditandatangani secara elektronik menggunakan sertifikat elektronik yang diterbitkan oleh Balai Sertifikasi Elektronik (BSrE), BSSN.'
                    );
    			
    			$nama_file = 'agenda_'. str_slug($agenda->kegiatan, '_');
    			$nama_file_surat = $nama_file . '.docx';
    			
    			$file = public_path('surat_gen/'. $nama_file_surat);
    			$path = storage_path('surat_gen/'. $nama_file_surat);
    			
    			
    			
    			$templateProcessor->saveAs($file);
    			
    			
    			
    			$durl = CRUDBooster::convertPdf($file,$nama_file);
    			

    			
    			sleep(2);
    		
    			
    			if($durl){
    			    $newgenpdf = CRUDBooster::downloadGenPdf($durl);
    			    DB::table('agenda')->where('id',$id)->update(['gen_pdf'=>$newgenpdf]);
    			    $newhandap = DB::table('bahandap')->insertGetId(['kunci'=>$kunci,'redurl'=>CRUDBooster::adminPath($newgenpdf),'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId(),'gen'=>1,'hit_limit'=>0]);
    			}else{
    			   $newgenpdf = null; 
    			}
    			
    			
    	        
    	        $headers = [
                  'Content-Type' => 'application/docx',
              ];
    
               return response()->download($file, $nama_file_surat, $headers);
               

        }
        
        public function getKirimWa($id) {
	         if(!CRUDBooster::isUpdate() && $this->global_privilege==FALSE || $this->button_edit==FALSE) {    
                CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
              }
              
              $data = [];
              $data['page_title'] = 'Kirim Undangan';
              $data['row'] = DB::table('agenda_notulen')->where('agenda_id',$id)->first();
              
              $data['peserta'] = DB::table('agenda_pimpinan')->join('cms_users','cms_users.id','agenda_pimpinan.cms_users_id')->join('dprd','dprd.id','agenda_pimpinan.dprd_id')->where('agenda_pimpinan.agenda_id',$id)->get();
              
              
              if($data['row']){
                  $data['new'] = false; 
              }else{
                  $data['new'] = true; 
              }
              
              $this->cbView('notulen.index',$data);

	    }
        
	    //By the way, you can still create your own method in here... :) 
    

	}