<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminAsetController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "aset";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"uid","name"=>"(SELECT CONCAT(aset_jenis_barang.kode_jenis_barang,'-',aset.id) FROM aset,aset_jenis_barang WHERE aset.aset_jenis_barang_id = aset_jenis_barang.id) as uid","callback_php"=>"$row->uid","qrcode"=>true,"mainurl"=>"bjb.city"];
			if(CRUDBooster::myPrivilegeId()==1){
    			$this->col[] = ["label"=>"Unit","name"=>"jabatan_id","join"=>"jabatan,jabatan"];
			    $this->col[] = ["label"=>"Satuan Kerja","name"=>"dinas_id","join"=>"satuan_kerja,satuan_kerja"];
			}
			
			$this->col[] = ["label"=>"Ruangan","name"=>"aset_ruangan_id","join"=>"aset_ruangan,ruangan"];
			$this->col[] = ["label"=>"Lantai","name"=>"aset_ruangan_id","join"=>"aset_ruangan,lantai"];
			$this->col[] = ["label"=>"Jenis Barang","name"=>"aset_jenis_barang_id","join"=>"aset_jenis_barang,jenis_barang"];
			$this->col[] = ["label"=>"Merek","name"=>"aset_merek_id","join"=>"aset_merek,merek"];
			$this->col[] = ["label"=>"Model","name"=>"aset_model_id","join"=>"aset_model,model"];
			$this->col[] = ["label"=>"Ukuran","name"=>"aset_ukuran_id","join"=>"aset_ukuran,ukuran"];
			$this->col[] = ["label"=>"Bahan","name"=>"aset_bahan_id","join"=>"aset_bahan,bahan"];
			$this->col[] = ["label"=>"Nomor Seri","name"=>"nomor_seri"];
			$this->col[] = ["label"=>"Tahun","name"=>"tahun"];
			$this->col[] = ["label"=>"Kode Barang","name"=>"aset_jenis_barang_id","join"=>"aset_jenis_barang,kode_jenis_barang"];
			$this->col[] = ["label"=>"Jumlah","name"=>"jumlah"];
			$this->col[] = ["label"=>"Nilai","name"=>"nilai_satuan"];
			$this->col[] = ["label"=>"Kondisi","name"=>"kondisi"];
			$this->col[] = ["label"=>"Updated by","name"=>"updated_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Updated at","name"=>"updated_at"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			if(CRUDBooster::myPrivilegeId()==1){
    			$this->form[] = ['label'=>'Unit','name'=>'jabatan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'jabatan,jabatan'];
    			$this->form[] = ['label'=>'Satuan Kerja','name'=>'dinas_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'satuan_kerja,satuan_kerja'];
			}else{
			    $this->form[] = ['label'=>'Unit','name'=>'jabatan_id','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-5','value'=>CRUDBooster::me()->jabatan_id];
			    $this->form[] = ['label'=>'Satuan Kerja','name'=>'dinas_id','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-5','value'=>CRUDBooster::me()->dinas_id];
			}
			$this->form[] = ['label'=>'Ruangan','name'=>'aset_ruangan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'aset_ruangan,ruangan'];
			$this->form[] = ['label'=>'Jenis Barang','name'=>'aset_jenis_barang_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'aset_jenis_barang,jenis_barang','datatable_format'=>"kode_jenis_barang,' - ',jenis_barang"];
			$this->form[] = ['label'=>'Merek','name'=>'aset_merek_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'aset_merek,merek'];
			$this->form[] = ['label'=>'Model','name'=>'aset_model_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'aset_model,model'];
			$this->form[] = ['label'=>'Ukuran','name'=>'aset_ukuran_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'aset_ukuran,ukuran'];
			$this->form[] = ['label'=>'Bahan','name'=>'aset_bahan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'aset_bahan,bahan'];
			$this->form[] = ['label'=>'Nomor Seri','name'=>'nomor_seri','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-7'];
			$this->form[] = ['label'=>'Tahun','name'=>'tahun','type'=>'number','validation'=>'required|integer|min:1980','width'=>'col-sm-3'];
			$this->form[] = ['label'=>'Jumlah','name'=>'jumlah','type'=>'number','validation'=>'required|integer|min:1','width'=>'col-sm-3'];
			$this->form[] = ['label'=>'Nilai Satuan','name'=>'nilai_satuan','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-7'];
			$this->form[] = ['label'=>'Kondisi','name'=>'kondisi','type'=>'radio','validation'=>'required|min:1|max:50','width'=>'col-sm-10','dataenum'=>'Baik;Kurang Baik;Rusak Berat'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','width'=>'col-sm-10','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Created at','name'=>'created_at','type'=>'hidden','width'=>'col-sm-10','value'=>now()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Jabatan Id","name"=>"jabatan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"jabatan,id"];
			//$this->form[] = ["label"=>"Dinas Id","name"=>"dinas_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"dinas,id"];
			//$this->form[] = ["label"=>"Aset Jenis Barang Id","name"=>"aset_jenis_barang_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"aset_jenis_barang,id"];
			//$this->form[] = ["label"=>"Aset Merek Id","name"=>"aset_merek_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"aset_merek,id"];
			//$this->form[] = ["label"=>"Aset Ukuran Id","name"=>"aset_ukuran_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"aset_ukuran,id"];
			//$this->form[] = ["label"=>"Aset Bahan Id","name"=>"aset_bahan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"aset_bahan,id"];
			//$this->form[] = ["label"=>"Nomor Seri","name"=>"nomor_seri","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tahun","name"=>"tahun","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Jumlah","name"=>"jumlah","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Nilai Satuan","name"=>"nilai_satuan","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Kondisi","name"=>"kondisi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Update By","name"=>"update_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}