<?php namespace App\Http\Controllers;

use Session;
use Request;
use DB;
use CRUDbooster;

class AdminCmsUsersController extends \crocodicstudio\crudbooster\controllers\CBController {


	public function cbInit() {
		# START CONFIGURATION DO NOT REMOVE THIS LINE
		$this->table               = 'cms_users';
		$this->primary_key         = 'id';
		$this->title_field         = "name";
		$this->button_action_style = 'button_icon';	
		$this->button_import 	   = FALSE;	
		$this->button_export 	   = FALSE;	
		$this->button_show    = FALSE;
		# END CONFIGURATION DO NOT REMOVE THIS LINE
	
		# START COLUMNS DO NOT REMOVE THIS LINE
		$this->col = array();
		if(CRUDBooster::myPrivilegeId()==1){
		    $this->col[] = array("label"=>"ID","name"=>"id");
		}
		$this->col[] = array("label"=>"Name","name"=>"name");
		//$this->col[] = array("label"=>"Email","name"=>"email");
		$this->col[] = array("label"=>"NIK","name"=>"nik");
		$this->col[] = ["label"=>"Telp","name"=>"no_telp"];
		$this->col[] = array("label"=>"Privilege","name"=>"id_cms_privileges","join"=>"cms_privileges,name");
		$this->col[] = ["label"=>"Dinas","name"=>"dinas_id","join"=>"satuan_kerja,satuan_kerja"];
		$this->col[] = ["label"=>"Jabatan","name"=>"jabatan_id","join"=>"jabatan,jabatan"];
// 		$this->col[] = ["label"=>"Kecamatan","name"=>"district_id","join"=>"districts,name"];
// 		$this->col[] = ["label"=>"Kelurahan","name"=>"village_id","join"=>"villages,name"];	
// 		$this->col[] = ["label"=>"RT","name"=>"rt"];	
// 		$this->col[] = ["label"=>"RW","name"=>"rw"];
        $this->col[] = ["label"=>"multi privs","name"=>"(SELECT GROUP_CONCAT(cms_privileges.name) FROM multi_privs JOIN cms_privileges ON cms_privileges.id = multi_privs.cms_privileges_id WHERE cms_users_id = cms_users.id) as privs","callback_php"=>"$row->privs"];
		$this->col[] = array("label"=>"Kategori","name"=>"cms_users.kategori_id","join"=>"kategori,nama_kategori");
		$this->col[] = array("label"=>"Photo","name"=>"cms_users.photo","image"=>1);
		//$this->col[] = array("label"=>"Map Icon","name"=>"cms_users.icon","image"=>1);
		$this->col[] = ["label"=>"Hashtag","name"=>"hashtag"];
		$this->col[] = array("label"=>"Created By","name"=>"created_by","join"=>"cms_users,name");
		//$this->col[] = array("label"=>"Spesimen TTE","name"=>"cms_users.specimen_tte","image"=>1);
			
		# END COLUMNS DO NOT REMOVE THIS LINE

		# START FORM DO NOT REMOVE THIS LINE
		$this->form = array(); 		
		$this->form[] = array("label"=>"Nama","name"=>"name",'required'=>true,'validation'=>'required|min:3','width'=>'col-sm-5');
		$this->form[] = array("label"=>"Email","name"=>"email",'type'=>'email','validation'=>'email|unique:cms_users,email,'.CRUDBooster::getCurrentId(),'width'=>'col-sm-5');
			
		$this->form[] = array("label"=>"Photo","name"=>"photo","type"=>"upload","help"=>"Recommended resolution is 200x200px",'validation'=>'image|max:1000|mimes:jpeg,png,jpg','resize_width'=>90,'resize_height'=>90,'width'=>'col-sm-5');											
		
		if(CRUDBooster::myPrivilegeId()==1){
		    $this->form[] = array("label"=>"Privilege","name"=>"id_cms_privileges","type"=>"select","datatable"=>"cms_privileges,name",'required'=>true);
		    
		    $columns[] = ['label'=>'Privilege','name'=>'cms_privileges_id','type'=>'select','width'=>'col-sm-5','datatable'=>'cms_privileges,name'];
			
            $this->form[] = ['label'=>'Multi Privileges','name'=>'multi_privs','type'=>'child','columns'=>$columns,'width'=>'col-sm-10','table'=>'multi_privs','parent'=>'cms_users','foreign_key'=>'cms_users_id'];

			$this->form[] = array("label"=>"NIK","name"=>"nik",'required'=>true,'type'=>'text');
			$this->form[] = ['label'=>'Satuan Kerja','name'=>'dinas_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'satuan_kerja,satuan_kerja'];
			$this->form[] = ['label'=>'Jabatan','name'=>'jabatan_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'jabatan,jabatan'];
			$this->form[] = ['label'=>'Kabupaten','name'=>'regency_id','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-6','value'=>CRUDBooster::getSetting('kode_provinsi')];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'districts,name','datatable_where'=>'regency_id ='.CRUDBooster::getSetting('kode_kabupaten')];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'villages,name','datatable_where'=>'district_id like "'.CRUDBooster::getSetting('kode_kabupaten').'%"','parent_select'=>'district_id'];
			$this->form[] = ['label'=>'RT','name'=>'rt','type'=>'number','validation'=>'min:1|max:300','width'=>'col-sm-3'];
			$this->form[] = ['label'=>'RW','name'=>'rw','type'=>'number','validation'=>'min:1|max:300','width'=>'col-sm-3'];
			$this->form[] = ['label'=>'Telepon','name'=>'no_telp','type'=>'text','validation'=>'min:10|max:20','width'=>'col-sm-3'];
			$this->form[] = ['label'=>'Kategori','name'=>'cms_users.kategori_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'kategori,nama_kategori'];
			
    	}
//else if(CRUDBooster::myPrivilegeId()==14){
// 		  //  $this->form[] = array("label"=>"NIK","name"=>"nik",'required'=>true,'type'=>'text');
// 		    //$this->col[] = ["label"=>"NIK Pemilik","name"=>"nik","join"=>"warga_bjb,nik"];
// 		    $this->form[] = array("label"=>"Privilege","name"=>"id_cms_privileges","type"=>"select","datatable"=>"cms_privileges,name",'required'=>true,'datatable_where'=>'id < 10 AND id <> 1');
		    
// 		     $columns[] = ['label'=>'Privilege','name'=>'cms_privileges_id','type'=>'select','width'=>'col-sm-5','datatable'=>'cms_privileges,name','datatable_where'=>'id < 10 AND id <> 1 OR id = 20'];
			
//             $this->form[] = ['label'=>'Multi Privileges','name'=>'multi_privs','type'=>'child','columns'=>$columns,'width'=>'col-sm-10','table'=>'multi_privs','parent'=>'cms_users','foreign_key'=>'cms_users_id'];
// 		}else{
// 		    //$this->form[] = array("label"=>"NIK","name"=>"nik",'type'=>'text','disabled'=>true);
// 		}
		
		if(CRUDBooster::myPrivilegeId() != 2){
		    //$this->form[] = array("label"=>"Icon di Peta","name"=>"icon","type"=>"upload","help"=>"Recommended resolution is 70x70px",'validation'=>'image|max:40|mimes:jpeg,png,jpg','resize_width'=>70,'resize_height'=>70,'width'=>'col-sm-5');
		    $this->form[] = array("label"=>"Spesimen Tandatangan","name"=>"spesimen_tte","type"=>"upload","help"=>"Recommended resolution is 100x90px",'validation'=>'image|max:40|mimes:jpeg,png,jpg','resize_width'=>100,'resize_height'=>90);	
        }
		//$this->form[] = array("label"=>"NIP","name"=>"nip",'type'=>'text');
		//$this->form[] = ['label'=>'Aksi Persetujuan','name'=>'approve_id','type'=>'select2','width'=>'col-sm-4','datatable'=>'status_surat,status'];
// 		$this->form[] = ['label'=>'Hashtag','name'=>'hashtag','type'=>'text','width'=>'col-sm-4'];
		
		$this->form[] = array("label"=>"Password","name"=>"password","type"=>"password","help"=>"Biarkan Kosong Jika Tidak Ada Perubahan",'width'=>'col-sm-4');
		
		$this->form[] = array("label"=>"CREATED BY","name"=>"created_by",'required'=>true,'type'=>'hidden','value'=>CRUDBooster::myId());
		# END FORM DO NOT REMOVE THIS LINE
			
		// $this->load_js[] = asset("js/user.js");
		
		$this->script_js = '
                
                $("#district_id").change(function() {
                  var sel = $("#district_id option:selected").val();
                  $.get("https://siapkk.banjarbarukota.go.id/api/list_kel?district_id=" + sel, function(data, status){
                    
                    $("#village_id").empty();
                    $("#village_id").append("<option value=>** Silahkan pilih Kelurahan</option>");
                    $.each(data.data, function(key,value) {
                      console.log(value.name);
                      var id = value.id;
                      var caption = value.name;
                      $("#village_id").append("<option value=" + id + ">" + caption + "</option>");
                    });
                  });
                });
                
                $("#dinas_id").change(function() {
                  var sel = $("#dinas_id option:selected").val();
                  $.get("https://siapkk.banjarbarukota.go.id/api/list_jabatan?satuan_kerja_id=" + sel, function(data, status){
                    
                    $("#jabatan_id").empty();
                    $("#jabatan_id").append("<option value=>** Silahkan pilih Jabatan</option>");
                    $.each(data.data, function(key,value) {
                      console.log(value.jabatan);
                      var id = value.id;
                      var caption = value.jabatan;
                      $("#jabatan_id").append("<option value=" + id + ">" + caption + "</option>");
                    });
                  });
                });
	        ';
	}
	
	 public function hook_query_index(&$query) {
	     if(CRUDBooster::myPrivilegeId()<>1){
	        $query->where('id_cms_privileges','>','1')
	              ->where('id_cms_privileges','<','30');	
	     }
     }


	public function getProfile() {			

		$this->button_addmore = FALSE;
		$this->button_cancel  = TRUE;
		$this->button_show    = FALSE;			
		$this->button_add     = FALSE;
		$this->button_delete  = FALSE;
		$this->button_save  = TRUE;
		$this->command  = "edit";	
		$this->hide_form 	  = ['id_cms_privileges'];

		$data['page_title'] = trans("crudbooster.label_button_profile");
		$data['row']        = CRUDBooster::first('cms_users',CRUDBooster::myId());		
		// $data['row']        = DB::table('cms_users') 
							 // ->join('warga_bjb','cms_users.nik','=','warga_bjb.nik')
							 // ->join('districts','warga_bjb.nama_kec','=','districts.id')
							 // ->join('villages','warga_bjb.nama_kel','=','villages.id')
							 // ->where('cms_users.id',$id)
							 // ->select('cms_users.*','warga_bjb.*','villages.name as kelurahan','districts.name as  kecamatan')
							 // ->first();		
		$this->cbView('crudbooster::default.form',$data);				
	}
}
