<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminCovid19Controller extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "covid19";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Nama","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nik"];
			$this->col[] = ["label"=>"Tanggal Positif","name"=>"tgl_konfirm_positif"];
			$this->col[] = ["label"=>"Status Perawatan","name"=>"status_perawatan"];
			$this->col[] = ["label"=>"Telepon","name"=>"telp"];
			
			//$this->col[] = ["label"=>"Koordinat","name"=>"CONCAT(covid19.lat,' , ',covid19.lon) as koordinat"];
// 			$this->col[] = ["label"=>"Lat","name"=>"lat"];
// 			$this->col[] = ["label"=>"Lon","name"=>"lon"];
			//$this->col[] = ["label"=>"Umur","name"=>"(SELECT TIMESTAMPDIFF(YEAR, warga_bjb.tgl_lhr, CURDATE() FROM warga_bjb WHERE warga_bjb.id = covid19.warga_bjb_id) as age","callback_php"=>"$row->age)"];
			$this->col[] = ["label"=>"Nama","name"=>"warga_bjb_id","join"=>"warga_bjb,alamat2"];
			$this->col[] = ["label"=>"Kelurahan","name"=>"(SELECT (SELECT name FROM villages WHERE id = warga_bjb.nama_kel) As kelurahan FROM warga_bjb WHERE id = covid19.warga_bjb_id ) as kelurahan","callback_php"=>'$row->kelurahan'];
			$this->col[] = ["label"=>"Kecamatan","name"=>"(SELECT (SELECT name FROM districts WHERE id = warga_bjb.nama_kec) As kecamatan FROM warga_bjb WHERE id = covid19.warga_bjb_id ) as kecamatan","callback_php"=>'$row->kecamatan'];
			//$this->col[] = ["label"=>"Alamat","name"=>"(SELECT CONCAT(alamat2, ' RT.', rt , ' RW.', rw, ' KEL.', (SELECT name FROM villages WHERE id = warga_bjb.nama_kel), ' KEC.', (SELECT name FROM districts WHERE id = warga_bjb.nama_kec)) As alamat FROM warga_bjb WHERE id = covid19.warga_bjb_id ) as alamat","callback_php"=>'$row->alamat'];
			$this->col[] = ["label"=>"Keterangan","name"=>"keterangan"];
			$this->col[] = ["label"=>"Updated by","name"=>"updated_by","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'ID WARGA','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required','width'=>'col-sm-6','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat2','datamodal_columns_alias'=>'NIK,Nama,Tmpt Lahir,Tgl Lahir,Alamat','datamodal_size'=>'large'];
			$this->form[] = ['label'=>'Tanggal Konfirmasi Positif','name'=>'tgl_konfirm_positif','type'=>'date','validation'=>'required','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Telepon/WA','name'=>'telp','type'=>'text','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Status Perawatan','name'=>'status_perawatan','type'=>'radio','validation'=>'required','dataenum'=>'Isoman;Rawat Inap;Tidak Ada'];
			$this->form[] = ['label'=>'Kebutuhan Selama Isoman','name'=>'kebutuhan','type'=>'checkbox','validation'=>'required','dataenum'=>'Makanan;Obat-obatan;Oksigen;Konsultasi Kesehatan'];
			$this->form[] = ['label'=>'Penyakit Bawaan','name'=>'penyakit_bawaan','type'=>'checkbox','validation'=>'required','dataenum'=>'Penyakit Paru;Diabetes;Hipertensi;Penyakit Jantung;Penyakit Ginjal;Tidak ada'];
			$this->form[] = ['label'=>'Status Vaksinasi','name'=>'vaksinasi','type'=>'radio','validation'=>'required','dataenum'=>'Belum Pernah;Vaksin 1;Vaksin 2'];
			$this->form[] = ['label'=>'Keluhan','name'=>'keluhan','type'=>'textarea','width'=>'col-sm-6'];
			
			$this->form[] = ['label'=>'Gps','name'=>'gps','type'=>'osm','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Lat','name'=>'lat','type'=>'text','width'=>'col-sm-4','readonly'=>true];
			$this->form[] = ['label'=>'Lon','name'=>'lon','type'=>'text','width'=>'col-sm-4','readonly'=>true];
			
			$columns[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'date'];
			$columns[] = ['label'=>'Status','name'=>'covid19_status_id','type'=>'select','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'covid19_status,status'];
			$columns[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','width'=>'col-sm-2','value'=>CRUDBooster::myId()];
			
			$this->form[] = ['label'=>'History','name'=>'covid_history','type'=>'child','columns'=>$columns,'width'=>'col-sm-10','table'=>'covid19_history','parent'=>'covid19','foreign_key'=>'covid19_id'];
			
			$this->form[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'textarea','width'=>'col-sm-10'];
			
			$this->form[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','validation'=>'min:1|max:5000','width'=>'col-sm-2','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Gps","name"=>"gps","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Lat","name"=>"lat","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Lon","name"=>"lon","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Keterangan","name"=>"keterangan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();
	        if(CRUDBooster::myPrivilegeId()==13){
	            $this->index_button[] = ['label'=>'Import file excell', 'url'=>CRUDBooster::mainpath('pilih-file'),'icon'=>'fa fa-arrow-down'];
	        }
	        
	



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    
	    public function getPilihFile(){
	           $data=[];
	           $data['uploaded']=DB::table('uploaded')
	                            ->join('cms_users','cms_users.id','uploaded.updated_by')
	                            ->join('cms_privileges','cms_privileges.id','uploaded.updated_by_priv')
	                            ->where('updated_by_priv',CRUDBooster::myPrivilegeId())
	                            ->selectRaw('uploaded.*,cms_users.name as nama_user, cms_privileges.name as role')
	                            ->get();
	           
	           return view('import.pilih',$data);
	     }
	     
	     public function getImportFile($id){
	        $uploaded=DB::table('uploaded')->where('id',$id)->first();
	        $data['id']=$id;
	        $data['excel']=$uploaded->file;
	       // if(strlen($bantuan->upload_file)>0){
                 $this->cbView('import.xlsx',$data);
	    //    }else{
	            
	      //  }
	    }
	    
	    public function postImportExcel($id){
	        $selected_kolom=Request::input('selected_kolom');
	        $rows=Session::get('rows');
	        $excel=Request::input('excel');
	        $result = array();
	        
	        $ketemu=0;
	        $baru=0;
	        $sudah=0;
	        $tidakketemu=0;
	        $capilyes=0;
	        $capilno=0;
	       
        	foreach($rows as $ro){
        	    $datearr = explode("/",$ro['Tanggal']);
        	    $tgl = date('Y-m-d', strtotime($datearr[2] . '-' . $datearr[1] . '-' . $datearr[0])); 
        	    
        	    $kebut = str_replace(',', ';', $ro['Kebutuhan']);
        	    $penyakit = str_replace(',', ';', $ro['Penyakit']);
        	    $vaksin = str_replace(',', ';', $ro['Vaksinasi']);
        	    
        	    
        	    $found=DB::table('warga_bjb')->where('nik',$ro[$selected_kolom])->first();
        	    if($found){

	                $ketemu++;
        	        $exists=DB::table('covid19')->where('warga_bjb_id',$found->id)->first();
        	        if(!$exists){
        	            $baru++;
        	            DB::table('covid19')->insert(['warga_bjb_id'=>$found->id,'telp'=>$ro['Telp'],'kebutuhan'=>$kebut,'keluhan'=>$ro['Keluhan'],'penyakit_bawaan'=>$penyakit,'vaksinasi'=>$vaksin,'tgl_konfirm_positif'=>$tgl,'updated_by'=>CRUDBooster::myId()]);
    	                array_push($result, $ro[$selected_kolom] . ' ditambahkan - detail ('. implode(",",$ro) . ')' );
        	        }else{
        	            $sudah++;
        	            DB::table('covid19')->where('id',$exist->id)->update(['warga_bjb_id'=>$found->id,'telp'=>$ro['Telp'],'kebutuhan'=>$kebut,'keluhan'=>$ro['Keluhan'],'penyakit_bawaan'=>$penyakit,'vaksinasi'=>$vaksin,'tgl_konfirm_positif'=>$tgl,'updated_by'=>CRUDBooster::myId()]);
        	            array_push($result, $ro[$selected_kolom] . ' data sudah ada, update ' . $ro['Tanggal'] );
        	        }

        	    }else{
        	        $strnama = explode(" ",$ro["Nama"]);
        	        if(sizeof($strnama)>0){
        	            $foundname=DB::table('warga_bjb')->where('nama_lgkp','like',$strnama[0].'%')->get();
        	            if(sizeof($foundname)>0){
        	                foreach($foundname as $fn){
        	                   // $foundsim=DB::table('warga_bjb')->whereRaw('SIMILARITY_STRING(nama_lgkp,"' .$strnama[0] . '") > 70')->first();
        	                   similar_text($fn->nama_lgkp,$ro['Nama'],$percentnama);
                    	        if($percentnama>90){
                    	            similar_text($fn->alamat2,$ro['Alamat'],$percentalamat);
                	                if($percentalamat>75){
                    	                $ketemu++;
                            	        $exists=DB::table('covid19')->where('warga_bjb_id',$fn->id)->first();
                            	        if(!$exists){
                            	            $baru++;
                            	            DB::table('covid19')->insert(['warga_bjb_id'=>$fn->id,'telp'=>$ro['Telp'],'kebutuhan'=>$kebut,'keluhan'=>$ro['Keluhan'],'penyakit_bawaan'=>$penyakit,'vaksinasi'=>$vaksin,'tgl_konfirm_positif'=>$tgl,'updated_by'=>CRUDBooster::myId()]);
                        	                array_push($result, $ro[$selected_kolom] . ' Mungkin ini ? - detail ('. $fn->nik . ')' );
                            	        }else{
                            	            $sudah++;
                            	            DB::table('covid19')->where('id',$exist->id)->update(['warga_bjb_id'=>$found->id,'telp'=>$ro['Telp'],'kebutuhan'=>$kebut,'keluhan'=>$ro['Keluhan'],'penyakit_bawaan'=>$penyakit,'vaksinasi'=>$vaksin,'tgl_konfirm_positif'=>$tgl,'updated_by'=>CRUDBooster::myId()]);
                            	            array_push($result, $ro[$selected_kolom] . ' Mungkin data sudah ada, update' );
                            	        }
                        	        }else{
                        	            $tidakketemu++;
                        	            array_push($result, $ro[$selected_kolom] . ' sangat meragukan - detail ('. implode(",",$ro) . ')' );
                        	        }
                    	       }
        	                }
        	            }
        	        }else{
        	           $foundname=DB::table('warga_bjb')->where('nama_lgkp','like',$ro["Nama"].'%')->get();
        	            if(sizeof($foundname)>0){
        	                foreach($foundname as $fn){
        	                   // $foundsim=DB::table('warga_bjb')->whereRaw('SIMILARITY_STRING(nama_lgkp,"' .$strnama[0] . '") > 70')->first();
        	                   similar_text($fn->nama_lgkp,$ro['Nama'],$percentnama);
                    	        if($percentnama>90){
                    	            similar_text($fn->alamat2,$ro['Alamat'],$percentalamat);
                	                if($percentalamat>75){
                    	                $ketemu++;
                            	        $exists=DB::table('covid19')->where('warga_bjb_id',$fn->id)->first();
                            	        if(!$exists){
                            	            $baru++;
                            	            DB::table('covid19')->insert(['warga_bjb_id'=>$fn->id,'telp'=>$ro['Telp'],'kebutuhan'=>$kebut,'keluhan'=>$ro['Keluhan'],'penyakit_bawaan'=>$penyakit,'vaksinasi'=>$vaksin,'tgl_konfirm_positif'=>$tgl,'updated_by'=>CRUDBooster::myId()]);
                        	                array_push($result, $ro[$selected_kolom] . ' Mungkin ini ? - detail ('. $fn->nik . ')' );
                            	        }else{
                            	            $sudah++;
                            	            DB::table('covid19')->where('id',$exist->id)->update(['warga_bjb_id'=>$found->id,'telp'=>$ro['Telp'],'kebutuhan'=>$kebut,'keluhan'=>$ro['Keluhan'],'penyakit_bawaan'=>$penyakit,'vaksinasi'=>$vaksin,'tgl_konfirm_positif'=>$tgl,'updated_by'=>CRUDBooster::myId()]);
                            	            array_push($result, $ro[$selected_kolom] . ' Mungkin data sudah ada, update' );
                            	        }
                        	        }else{
                        	            $tidakketemu++;
                        	            array_push($result, $ro[$selected_kolom] . ' sangat meragukan - detail ('. implode(",",$ro) . ')' );
                        	        }
                    	       }
        	                }
        	            }
        	        }
        	        
        	    }
        	}
        	//DB::table('uploaded')->where('id',$id)->update(['logs'=>$ketemu. ' nik ditemukan, '. $baru . ' ditambahkan, '. $sudah . ' sudah ada, '. $tidakketemu . ' nik tidak ditemukan, ' . $capilyes . ' diambil di capil, ' . $capilno . ' tidak teregister.']);
        	array_push($result,$ketemu. ' nik ditemukan, '. $baru . ' ditambahkan, '. $sudah . ' sudah ada, '. $tidakketemu . ' nik tidak ditemukan, ' . $capilyes . ' diambil di capil, ' . $capilno . ' tidak teregister.' );
	        $data['result'] = $result;
	        $this->cbView('import.result',$data);
	        
	        //var_dump($result);
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}