<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use PDF;
	use App\Signature\Esign;
	use App\Signature\Client\BasicRest;
    use App\QRlib\QRCodeProv;
    use PhpOffice\PhpWord as WORD;
	use File;
	

	class AdminDokumenController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "dokumen";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Tanggal","name"=>"created_at"];
			$this->col[] = ["label"=>"Nomor","name"=>"nomor_surat"];
			$this->col[] = ["label"=>"Pengirim","name"=>"pengirim"];
			$this->col[] = ["label"=>"Perihal","name"=>"perihal"];
			//$this->col[] = ["label"=>"Pejabat Id","name"=>"pejabat_id","join"=>"pejabat,nama_pejabat"];
			$this->col[] = ["label"=>"Penerima","name"=>"(select GROUP_CONCAT(DISTINCT cms_users.name ORDER BY idv_data.cms_users_id ASC) from idv_data,cms_users where idv_data.parent_table = 'dokumen' and idv_data.parent_id = dokumen.id and idv_data.cms_users_id = cms_users.id GROUP BY dokumen.id) as send_to", "callback_php"=>'$row->send_to'];
// 			$this->col[] = ["label"=>"Signed By","name"=>"signed_by","join"=>"pejabat,nama_pejabat"];
// 			$this->col[] = ["label"=>"Signed At","name"=>"signed_at"];
// 			$this->col[] = ["label"=>"Created By Priv","name"=>"created_by_priv","join"=>"cms_privileges,name"];
// 			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
// 			$this->col[] = ["label"=>"Updated By_priv","name"=>"updated_by_priv","join"=>"cms_privileges,name"];
            $this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			$this->col[] = ["label"=>"Draft","name"=>"docx_file","download"=>true];
		//	$this->col[] = ["label"=>"Converted","name"=>"converted","download"=>true];
			$this->col[] = ["label"=>"Pdf","name"=>"pdf_file","download"=>true];
			$this->col[] = ["label"=>"Gen QR","name"=>"gen_qr","callback_php" => '($row->gen_qr == 1? "ON" : "OFF")'];
			$this->col[] = ["label"=>"bjb.city","name"=>"bahandap_id","join"=>"bahandap,kunci"];
			$this->col[] = ["label"=>"QR","name"=>"qr_file","image"=>true];
// 			$this->col[] = ["label"=>"Signed Pdf","name"=>"signed_file","download"=>true];
			$this->col[] = ["label"=>"Admin","name"=>"created_by","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
		
		    $this->form[] = ['label'=>'Nomor','name'=>'nomor_surat','validation'=>'min:1|max:255','width'=>'col-sm-5'];
	        $this->form[] = ['label'=>'Pengirim','name'=>'pengirim','validation'=>'required|min:1|max:255','width'=>'col-sm-7'];
		    $this->form[] = ['label'=>'Perihal','name'=>'perihal','validation'=>'required|min:1|max:255','width'=>'col-sm-7'];
		    $this->form[] = ['label'=>'Draft','name'=>'docx_file','type'=>'upload','validation'=>'max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Pdf File','name'=>'pdf_file','type'=>'upload','validation'=>'max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Buat QR Link','name'=>'gen_qr','type'=>'radio','validation'=>'required','width'=>'col-sm-6','dataenum'=>'1|Ya;0|Tidak', 'value'=>0];
		//	$this->form[] = ['label'=>'Kop','name'=>'kop_id','type'=>'select2','width'=>'col-sm-10','datatable'=>'kop,nama_kop'];
			//$this->form[] = ['label'=>'Isi','name'=>'isi','type'=>'wysiwyg'];
			
// 			$columns[] = ['label'=>'Nama','name'=>'cms_users_id','type'=>'select','width'=>'col-sm-5','datatable'=>'cms_users,name','datatable_where'=>'EXISTS (SELECT * FROM pejabat WHERE pejabat.user_id = cms_users.id)',"required"=>true ];
// 			$columns[] = ['label'=>'Tag Ttd/Paraf','name'=>'tag_to_sign','type'=>'text','width'=>'col-sm-5'];
// 			$columns[] = ['label'=>'Table','name'=>'parent_table','type'=>'hidden','width'=>'col-sm-5',"value"=>"dokumen"];
			
//             $this->form[] = ['label'=>'Penerima','name'=>'idv_data','type'=>'child','columns'=>$columns,'width'=>'col-sm-10','table'=>'idv_data','parent'=>'dokumen','foreign_key'=>'parent_id'];
			//$this->form[] = ['label'=>'Pejabat','name'=>'pejabat_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'pejabat,nama_pejabat'];
// 			$this->form[] = [
// 				"label" => "Kepada",
// 				"name" => "send_to",
// 				"type" => "select2",
// 				"select2_multiple" => true,
// 				"datatable" => "cms_users,name,id_cms_privileges,id",
// 				// "datatable_where" => "cms_users.id <> CRUDBooster::myId()",
// 				"relationship_table" => "send_to",
// 				"required" => false,
// 			];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Updated By Priv','name'=>'updated_by_priv','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Pdf File","name"=>"pdf_file","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Pejabat Id","name"=>"pejabat_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pejabat,nama_pejabat"];
			//$this->form[] = ["label"=>"Signed By","name"=>"signed_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Signed At","name"=>"signed_at","type"=>"datetime","required"=>TRUE,"validation"=>"required|date_format:Y-m-d H:i:s"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Created By Priv","name"=>"created_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By Priv","name"=>"updated_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Penerima','path'=>'idv_data','parent_columns'=>'pengirim,perihal','foreign_key'=>'parent_id','button_color'=>'info','button_icon'=>'fa fa-bars'];//,'showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId() OR [created_by_priv] == CRUDBooster::myParentPriv() '];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        //$this->addaction[] = ['label'=>'DURL','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('download-gen-pdf').'/[id]'];
	        //$this->addaction[] = ['label'=>'Preview','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('preview-html').'/[id]'];
	         $this->addaction[] = ['label'=>'Lihat','icon'=>'fa fa-address-card','color'=>'success','url'=>CRUDBooster::mainpath('preview-tte').'/[id]','showIf'=>'[pdf_file]<>""']; //.$this->pejabat->id];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
        public function getIndex2() {
	        //Your code here
	       $data = [];
	       
	       return view('dokumen.index',$data);
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        if(CRUDBooster::myPrivilegeId()==2){
	            $query->where('dokumen.created_by',CRUDBooster::myId());
	        }else{
	           // $query->where('dokumen.created_by_priv',CRUDBooster::myPrivilegeId())->orWhere('dokumen.created_by',CRUDBooster::myId());
	           $query->where('dokumen.created_by_priv',CRUDBooster::myPrivilegeId());
	        }
	        //Your code here
	       // $query->whereExists(function ($q) {
        //       $q->select(DB::raw(1))
        //              ->from('idv_data')
        //              ->where('idv_data.parent_table','dokumen')
        //              ->whereColumn('idv_data.parent_id','dokumen.id')
        //              ->where('idv_data.cms_users_id', CRUDBooster::myId());
        //         })->orWhere('dokumen.created_by',CRUDBooster::myId());    
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $postdata['created_by'] = CRUDBooster::myId();
            $postdata['created_at'] = now();
            $postdata['created_by_priv'] = CRUDBooster::myPrivilegeId();
            
            $nomorada = DB::table('dokumen')->where('nomor_surat',$postdata['nomor_surat'])->first();
            
            if($nomorada){
                CRUDBooster::redirectBack("Nomor " . $postdata['nomor_surat'] . " sudah ada !", "danger");
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        $kunci = $this->generateRandomString(17);
	        
	        $handapexist = DB::table('bahandap')->where('kunci',$kunci)->first();
	        
	        while($handapexist){
                $kunci = $this->generateRandomString(17);
            }
            
            $current = DB::table('dokumen')->where('id',$id)->first();

            if($current->gen_qr==1){
                $newhandap = DB::table('bahandap')->insertGetId(['kunci'=>$kunci,'redurl'=>CRUDBooster::adminPath($current->pdf_file),'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId(),'gen'=>1,'hit_limit'=>0]);
                $qrpath = 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/' . $kunci . '.png';
                $realqrpath = storage_path('app/'.$qrpath);
                $qr = new QRCodeProv();
                $qr->makeqr($text = 'https://bjb.city/' . $kunci ,$path = storage_path('app/'.$qrpath));
            }else{
                $newhandap = NULL;
                $qrpath = NULL;
                $realqrpath = NULL;
            }
            
            sleep(2);
            
            //dd(storage_path('app/' . $current->docx_file));
            DB::table('dokumen')->where('id',$id)->update(['bahandap_id'=>$newhandap,'qr_file'=>$qrpath]);  
            
            if($current->docx_file && !$current->pdf_file){
                $newgen = $this->addQRToWord($iddok = $id, $wordpath = storage_path('app/' . $current->docx_file), $qrpath =  $realqrpath, $nomor_surat = $current->nomor_surat);
                //jangan lupa diganti
                DB::table('bahandap')->where('id',$newhandap)->update(['redurl'=>CRUDBooster::adminPath($newgen),'updated_by'=>CRUDBooster::myId()]);
            }elseif(!$current->docx_file && $current->pdf_file){
                DB::table('bahandap')->where('id',$current->bahandap_id)->update(['redurl'=>CRUDBooster::adminPath($current->pdf_file),'updated_by'=>CRUDBooster::myId()]);
            }
            
                  
            
            // $new = DB::table($this->table)->where('id',$id)->first();
            // if($new->pejabat_id){
                
            // }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        
            $nomorada = DB::table('dokumen')->where('nomor_surat',$postdata['nomor_surat'])->where('id','<>',$id)->first();
            
            if($nomorada){
                CRUDBooster::redirectBack("Nomor " . $postdata['nomor_surat'] . " sudah ada !", "danger");
            }
            // $new = DB::table($this->table)->where('id',$id)->first();
            // if($new->pejabat_id){
            //     //var_dump($new->pejabat_id);
            // }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        
            $current = DB::table('dokumen')->where('id',$id)->first();
            
            
            if($current->bahandap_id){
                $currenthandap = DB::table('bahandap')->where('id',$current->bahandap_id)->first();
                
                // if(!$current->qr_file){
                //     $qrpath = 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/' . $currenthandap->kunci . '.png';
                //     $qr = new QRCodeProv();
                //     $qr->makeqr($text = 'https://bjb.city/' . $currenthandap->kunci,$path = storage_path('app/'.$qrpath));
                //     DB::table('dokumen')->where('id',$id)->update(['qr_file'=>$qrpath]);
                // }
                //jangan lupa di ganti
                if($current->docx_file && !$current->pdf_file){
                    $newgen = $this->addQRToWord($iddok = $id, $wordpath = storage_path('app/' . $current->docx_file), $qrpath = storage_path('app/' . $current->qr_file),$nomor_surat = $current->nomor_surat);
                    DB::table('bahandap')->where('id',$current->bahandap_id)->update(['redurl'=>CRUDBooster::adminPath($newgen),'updated_by'=>CRUDBooster::myId()]);
                }elseif(!$current->docx_file && $current->pdf_file){
                    DB::table('bahandap')->where('id',$current->bahandap_id)->update(['redurl'=>CRUDBooster::adminPath($current->pdf_file),'updated_by'=>CRUDBooster::myId()]);
                }
                
            }else{
                $kunci = $this->generateRandomString(17);
	        
    	        $handapexist = DB::table('bahandap')->where('kunci',$kunci)->first();
    	        
    	        while($handapexist){
                    $kunci = $this->generateRandomString(17);
                }
                
                
                
               if($current->gen_qr==1){
                    $newhandap = DB::table('bahandap')->insertGetId(['kunci'=>$kunci,'redurl'=>CRUDBooster::adminPath($current->pdf_file),'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId(),'gen'=>1,'hit_limit'=>0]);
                    $qrpath = 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/' . $kunci . '.png';
                    $realqrpath = storage_path('app/'.$qrpath);
                    $qr = new QRCodeProv();
                    $qr->makeqr($text = 'https://bjb.city/' . $kunci ,$path = storage_path('app/'.$qrpath));
                }else{
                    $newhandap = NULL;
                    $qrpath = NULL;
                    $realqrpath = NULL;
                }
                
                $this->addQRToWord($iddok = $id, $wordpath = storage_path('app/' . $current->docx_file), $qrpath = $realqrpath, $nomor_surat = $current->nomor_surat);
                
                DB::table('dokumen')->where('id',$id)->update(['bahandap_id'=>$newhandap,'qr_file'=>$qrpath]);    
            }
            
            
	        //edit gtemplate di web
            // $data = [];
            // $new = DB::table($this->table)->where('id',$id)->first();
            // $data['kop'] = DB::table('kop')->where('id',$new->kop_id)->first();
            // $data['surat'] = $new;
            // if(is_null($new->pdf_file)){
            //     if(!is_null($new->isi)){
            //         $pdf = PDF::loadView('pdf.genpdf',$data);
    	        
        	   //     $path = public_path('gen_pdfs');
            //         $fileName =  'dok_' . CRUDBooster::myId() . '.' . 'pdf' ;
            //         $pdf->save($path . '/' . $fileName);
                    
            //         DB::table($this->table)->where('id',$id)->update(['pdf_file'=>'gen_pdfs/' . $fileName,'updated_by'=>CRUDBooster::myId()]);
                    
            //     }
            // }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        DB::table('idv_data')->where('parent_id',$id)->where('parent_table','dokumen')->delete();

	    }
	    
	    public function getPreviewHtml($id) {
	        //Your code here
            $data = [];
            $data['surat'] = DB::table('dokumen')->where('id',$id)->first();
            $data['kop'] = DB::table('kop')->where('id',$data['surat']->kop_id)->first();

            return view('pdf.genpdf',$data);

	    }
	    
	    public function getPreviewTte($id) {
	        $data = [];
	        $data['id'] = $id; 
	        $data['batal'] = 'dokumen';
	        $data['surat'] = DB::table('dokumen')->where('id',$id)->first();
	        
	       // dd($data['surat']->pdf_file);
	        if($data['surat']->pdf_file){
	            $data['pdf_path'] = $data['surat']->pdf_file;
	            $data['signed'] = 0;
	            return view('pdf.preview',$data);
	        }else{
	            CRUDBooster::redirectBack("File PDF tidak tersedia !", "danger");
	        }
	        
	      
            
	    }
	    
	    public function postTte(){
	        $data = [];
	        $data['surat'] = DB::table('dokumen')->where('id',Request::input('id'))->first();
            
	        $esign = new Esign();
            //$response = $esign->checkStatus('0803202100007062');
            //print_r( $response->message);
            $response = $esign->sign($nik = CRUDBooster::me()->nik, $pass = Request::input('pass'), $doc = public_path().'/'.$data['surat']->pdf_file);
            //$response = $esign->sign($nik = CRUDBooster::me()->nik, $pass = Request::input('pass'), $doc = '/gen_pdfs/rekom_tte_122729.pdf');
            $response = json_decode($response);
            if($response->esign_status==1){
                $pdfpath = 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/' . $response->esign_file;
                DB::table('dokumen')->where('id',Request::input('id'))->update(['pdf_file'=>$pdfpath,'updated_by'=>CRUDBooster::myId()]);
                
                CRUDBooster::redirect(CRUDBooster::mainpath('preview-tte/'.Request::input('id').'/1'),$response->esign_message,"success");
            }else{
                CRUDBooster::redirectBack($response->esign_message, "danger");
                //var_dump($response);
            }
            
            
 
	    }
	    
	    public function generateRandomString($length = 10) {
            $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $charactersLength = strlen($characters);
            $randomString = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[rand(0, $charactersLength - 1)];
            }
            return $randomString;
        }
        
        public function addQRToWord($iddok = '',$wordpath = '', $qrpath ='', $nomor_surat = ''){
            $path = $wordpath;
			$fileName = $path;
			$file = basename($path);
			$file = basename($path , ".docx");
			
			//dd($qrpath);
			
			$phpWord = new WORD\TemplateProcessor($fileName);
			
			if($nomor_surat){
			    $phpWord->setValue(
                'nomor_surat',
                 $nomor_surat
                );
			}
			
			if($qrpath){
                $phpWord->setImageValue(
                    'qr',
                    array('path' => $qrpath, 'width' => 100, 'height' => 100, 'ratio' => false)
                );
			}else{
			    $phpWord->setValue(
                'qr',
                ''
                );
			}
            
            $phpWord->setImageValue(
                'footer',
                array('path' => storage_path('app/'.CRUDBooster::getSetting('logo_bsre')), 'width' => 100, 'height' => 58, 'ratio' => false)
                );
                
            $phpWord->setValue(
                'footer_text',
                'Dokumen ini telah ditanda tangani secara elektronik menggunakan sertifikat elektronik yang diterbitkan oleh Balai Sertifikasi Elektronik (BSrE), BSSN.'
                );
            
            $nama_file_surat = 'qr'.$file;
            
            $wordgen = storage_path('surat_gen/'. $nama_file_surat);
			
			$phpWord->saveAs($wordgen . '.docx');
			
			//convert ke PDF
			$durl = $this->convertPdf($wordgen. '.docx',$file);
			
			sleep(3);
            
            $newgenpdf = $this->downloadGenPdf($durl);
            
            sleep(3);
            
            DB::table('dokumen')->where('id',$iddok)->update(['converted'=>$newgenpdf,'pdf_file'=>$newgenpdf]);
            
            return $newgenpdf;

        }
        
        public function convertPdf($word,$name){
            $url = 'http://103.146.105.252:8000'; // The URL to upload to
		    

            if (function_exists('curl_file_create')) { // php 5.5+
              $cFile = curl_file_create($word, mime_content_type($word), $name . '.docx');
            } else { // 
              $cFile = '@' . realpath($word);
            }
            $post = array('file' => $cFile);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL,$url);
            curl_setopt($ch, CURLOPT_POST,1);
            $headers[] = "Content-Type: multipart/form-data";
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result=curl_exec ($ch);
            
            $result = json_decode($result);
            curl_close ($ch);
            
            return $result->url;
            //dd($result->url);
        }
        
        public function convertDomPdf(){
                        // $domPdfPath = realpath('/home/siapkkroot/dev/vendor/phpoffice/phpword/src/PhpWord/Writer/PDF/TCPDF.php');
// 			$domPdfPath = realpath('/home/siapkkroot/dev/vendor/dompdf/dompdf/src/Dompdf.php');
//           // dd($domPdfPath);
//             \PhpOffice\PhpWord\Settings::setPdfRendererPath($domPdfPath);
//             \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
			
// 			$phpWord = new \PhpOffice\PhpWord\PhpWord();
			
            
//             //Open template and save it as docx
//             //$document = $phpWord->loadTemplate($wordgen . '.docx');
//             //$document->saveAs(storage_path($wordgen . '_temp.docx'));
            
//             //Load temp file
            
            
//             $phpWord = \PhpOffice\PhpWord\IOFactory::load($wordgen . '.docx'); 
            
//             //Save it
//             $xmlWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord , 'PDF');
//             $xmlWriter->save($wordgen . '_result.pdf'); 
        }
        
        public function downloadGenPdf($url){

            $file_name = basename($url);
            $pathasli = storage_path('app/uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/gen_' . $file_name);
            
            if (file_put_contents($pathasli, file_get_contents($url)))
            {
                echo "File downloaded successfully";
            }
            else
            {
                echo "File downloading failed.";
            }
            
            return 'uploads/' . CRUDBooster::myId() . '/' . date("Y") . '-' . date("m") . '/gen_' . $file_name;
            
            // $ch = curl_init();
            // // setting option url target di curl
            // curl_setopt($ch, CURLOPT_URL, $url);
            // // setting option nama file hasil unduhan 
            // $filename = $pathasli;
            // $fp = fopen($filename, 'wb');
            // curl_setopt($ch, CURLOPT_FILE, $fp);
            // // jalankan curl
            // curl_exec($ch);
            // // tutup curl
            // curl_close($ch);
            // // tutup file hasil unduhan
            // fclose($fp);
            
            //CRUDBooster::redirectBack($curr->converted, "info");
        }



	    //By the way, you can still create your own method in here... :) 


	}