<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminDprdController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "dprd";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Photo","name"=>"photo","image"=>true];
			$this->col[] = ["label"=>"Partai","name"=>"partai_politik_id","join"=>"partai_politik,photo","image"=>true];
			$this->col[] = ["label"=>"Dapil","name"=>"dapil_id","join"=>"dapil,nama_dapil"];
			$this->col[] = ["label"=>"Suara Sah","name"=>"suara_sah"];
			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nik"];
			$this->col[] = ["label"=>"Nama","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Alamat","name"=>"warga_bjb_id","join"=>"warga_bjb,alamat2"];
            $this->col[] = ["label"=>"Jabatan","name"=>"(SELECT GROUP_CONCAT(DISTINCT CONCAT( tier.nama_tier,' ',dewan.nama_dewan) ) FROM dewan_dprd JOIN tier ON dewan_dprd.tier_id = tier.id JOIN dewan ON dewan_dprd.dewan_id = dewan.id  WHERE dewan_dprd.dprd_id = dprd.id) as jabatan","callback_php"=>"$row->jabatan"];
			
			//$this->col[] = ["label"=>"Updated By","name"=>"updated_by"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Partai','name'=>'partai_politik_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-5','datatable'=>'partai_politik,nama_partai'];
			$this->form[] = ['label'=>'Dapil','name'=>'dapil_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-5','datatable'=>'dapil,nama_dapil'];
			$this->form[] = ['label'=>'Suara Sah','name'=>'suara_sah','type'=>'text','validation'=>'required|integer|min:0','width'=>'col-sm-3'];
			$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|integer|min:0','width'=>'col-sm-5','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK,Nama Lengkap,Tempat Lahir, Tanggal Lahir'];
            $this->form[] = ['label'=>'Agama','name'=>'agama','type'=>'select','width'=>'col-sm-3','dataenum'=>'Islam;Katolik;Protestan;Hidu;Budha'];
// 			$this->form[] = ['label'=>'User Id','name'=>'cms_user_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-5','datatable'=>'cms_users,name'];
			$this->form[] = ['label'=>'Photo','name'=>'photo','type'=>'upload','validation'=>'required|image|max:3000','width'=>'col-sm-7','help'=>'Tipe file yang didukung: JPG, JPEG, PNG, GIF, BMP'];
			
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'cms_user,id'];
			//$this->form[] = ['label'=>'User Id','name'=>'cms_user_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-5','datatable'=>'dewan,nama_dewan'];
			//$this->form[] = ['label'=>'Dewan','name'=>'dewan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'partai_politik,nama_partai'];
			//$this->form[] = ['label'=>'Fraksi','name'=>'partai_politik_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','help'=>'Tipe file yang didukung: JPG, JPEG, PNG, GIF, BMP'];
			//$this->form[] = ['label'=>'Photo','name'=>'photo','type'=>'upload','validation'=>'required|image|max:3000','width'=>'col-sm-7','datatable'=>'tier,nama_tier'];
			//$this->form[] = ['label'=>'Tier','name'=>'tier_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK,Nama Lengkap, Tempat Lahir, Tanggal Lahir'];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Jabatan','path'=>'dewan_dprd','parent_columns'=>'nama,alamat','foreign_key'=>'dprd_id','button_color'=>'success','button_icon'=>'fa fa-arrow-down'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
            $this->addaction[] = ["label"=>"Profil","url"=>CRUDBooster::adminPath('dprd/profil/[id]'),"icon"=>"fa fa-user","color"=>"primary"];

	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();
	        $this->index_button[] = ["label"=>"Table View","url"=>CRUDBooster::mainPath(),"icon"=>"fa fa-list"];
	        $this->index_button[] = ["label"=>"Grid View","url"=>CRUDBooster::mainPath('anggota-grid'),"icon"=>"fa fa-list"];
	       // $this->index_button[] = ["label"=>"Tambah Data Warga","url"=>CRUDBooster::adminPath('umkm_warga_bjb/add?return_url='. CRUDBooster::adminPath('dprd')),"icon"=>"fa fa-plus"];



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
	        $warga = DB::table('warga_bjb')->where('id',$postdata['warga_bjb_id'])->first();
	        $postdata['nama'] = $warga->nama_lgkp;
	        $postdata['tmpt_lhr'] = $warga->tmpt_lhr;
	        $postdata['tgl_lhr'] = $warga->tgl_lhr;
	        $postdata['alamat'] = $warga->alamat2;
	        $postdata['pendidikan'] = $warga->pddk_akhir;
	        if($warga->jk=="L"){
	            $postdata['jk'] = "Laki-Laki";
	        }else{
	            $postdata['jk'] = "Perempuan";
	        }
            $postdata['updated_by'] = CRUDBooster::myId();
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here
	        $warga = DB::table('warga_bjb')->where('id',$postdata['warga_bjb_id'])->first();
	        $postdata['nama'] = $warga->nama_lgkp;
	        $postdata['tmpt_lhr'] = $warga->tmpt_lhr;
	        $postdata['tgl_lhr'] = $warga->tgl_lhr;
	        $postdata['alamat'] = $warga->alamat2;
	        $postdata['pendidikan'] = $warga->pddk_akhir;
	        if($warga->jk=="L"){
	            $postdata['jk'] = "Laki-Laki";
	        }else{
	            $postdata['jk'] = "Perempuan";
	        }
            $postdata['updated_by'] = CRUDBooster::myId();
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }

        public function getProfil($id) {
	        $data['dprd'] = DB::table('dprd')
	                            ->join('partai_politik','dprd.partai_politik_id','partai_politik.id')
	                            ->where('dprd.id',$id)
	                            ->selectRaw('dprd.*,partai_politik.nama_partai,partai_politik.photo as photo_partai,partai_politik.fraksi_id')
	                            ->first();
	        $data['jabatan'] = DB::table('dewan_dprd')
	                               ->join('tier','tier.id','dewan_dprd.tier_id')
	                               ->join('dewan','dewan.id','dewan_dprd.dewan_id')
	                               ->where('dewan_dprd.dprd_id',$id)
	                               ->get();
	        $data['partai'] = DB::select(DB::raw('SELECT GROUP_CONCAT(nama_partai) as apartai FROM partai_politik WHERE fraksi_id = '.$data['dprd']->fraksi_id));
	       // dd($data['partai']);
            $data['fraksi'] = DB::table('fraksi')
                                ->where('id',$data['dprd']->fraksi_id)
                                ->first();
            $data['dapil'] = DB::table('dapil')
                                ->where('id',$data['dprd']->dapil_id)
                                ->first();
            
            $this->cbView( 'dprd.profil',$data);
	    }
	    
	     public function getAgenda($id) {
	        $data['dprd'] = DB::table('dprd')
	                            ->join('partai_politik','dprd.partai_politik_id','partai_politik.id')
	                            ->where('dprd.id',$id)
	                            ->selectRaw('dprd.*,partai_politik.nama_partai,partai_politik.photo as photo_partai,partai_politik.fraksi_id')
	                            ->first();
	        $data['jabatan'] = DB::table('dewan_dprd')
	                               ->join('tier','tier.id','dewan_dprd.tier_id')
	                               ->join('dewan','dewan.id','dewan_dprd.dewan_id')
	                               ->where('dewan_dprd.dprd_id',$id)
	                               ->get();

            $data['pimpin'] = DB::table('agenda_pimpinan')
                                ->join('agenda','agenda.id','agenda_pimpinan.agenda_id')
                                ->where('dprd_id',$id)
                                ->get();
            $data['dampingi'] = DB::table('agenda_pendamping')
                                ->join('agenda','agenda.id','agenda_pendamping.agenda_id')
                                ->where('cms_users_id',CRUDBooster::wargaToCms($data['dprd']->warga_bjb_id)->id)
                                ->get();
                                
            $merged = $data['pimpin']->merge($data['dampingi']);

            $data['agenda'] = $merged->all();
            $this->cbView( 'dprd.agenda',$data);
	    }
	    
	    public function getLaporan($id) {
	        $data['dprd'] = DB::table('dprd')
	                            ->join('partai_politik','dprd.partai_politik_id','partai_politik.id')
	                            ->where('dprd.id',$id)
	                            ->selectRaw('dprd.*,partai_politik.nama_partai,partai_politik.photo as photo_partai,partai_politik.fraksi_id')
	                            ->first();
	        $data['jabatan'] = DB::table('dewan_dprd')
	                               ->join('tier','tier.id','dewan_dprd.tier_id')
	                               ->join('dewan','dewan.id','dewan_dprd.dewan_id')
	                               ->where('dewan_dprd.dprd_id',$id)
	                               ->get();

            $data['notulen'] = DB::table('agenda_notulen')
                                ->join('agenda','agenda.id','agenda_notulen.agenda_id')
                                ->where('agenda_id',$id)
                                ->get();

            $this->cbView( 'dprd.laporan',$data);
	    }
	    
	    public function getDokumentasi($id) {
	        $data['dprd'] = DB::table('dprd')
	                            ->join('partai_politik','dprd.partai_politik_id','partai_politik.id')
	                            ->where('dprd.id',$id)
	                            ->selectRaw('dprd.*,partai_politik.nama_partai,partai_politik.photo as photo_partai,partai_politik.fraksi_id')
	                            ->first();
	        $data['jabatan'] = DB::table('dewan_dprd')
	                               ->join('tier','tier.id','dewan_dprd.tier_id')
	                               ->join('dewan','dewan.id','dewan_dprd.dewan_id')
	                               ->where('dewan_dprd.dprd_id',$id)
	                               ->get();

            $data['dokumentasi'] = DB::table('agenda_dokumentasi')
                                ->join('agenda','agenda.id','agenda_dokumentasi.agenda_id')
                                ->where('agenda_id',$id)
                                ->get();

            $this->cbView( 'dprd.dokumentasi',$data);
	    }
	    
	    public function getAnggotaGrid() {
	        $data['dprd'] = DB::table('dprd')
	                            ->join('partai_politik','dprd.partai_politik_id','partai_politik.id')
	                            ->join('fraksi','fraksi.id','partai_politik.fraksi_id')
	                            ->where('dprd.partai_politik_id','<>','NULL')
	                            ->selectRaw('dprd.*,partai_politik.nama_partai,partai_politik.photo as photo_partai,partai_politik.fraksi_id, fraksi.nama_fraksi')
	                            ->get();
	       foreach($data['dprd'] as $dprd){
	           $dapil = DB::table('dapil')
                                ->where('id',$dprd->dapil_id)
                                ->first();
               $dprd->dapil = $dapil;
	       }

            //dd($data['dprd']);
            $this->cbView( 'dprd.anggota',$data);
	    }
	    
	    public function getAnggotaGridByPartai($partaiid) {
	        $data['dprd'] = DB::table('dprd')
	                            ->join('partai_politik','dprd.partai_politik_id','partai_politik.id')
	                            ->join('fraksi','fraksi.id','partai_politik.fraksi_id')
	                            ->where('dprd.partai_politik_id',$partaiid)
	                            ->selectRaw('dprd.*,partai_politik.nama_partai,partai_politik.photo as photo_partai,partai_politik.fraksi_id, fraksi.nama_fraksi')
	                            ->get();

            //dd($data['dprd']);
            $this->cbView( 'dprd.anggota',$data);
	    }

	    //By the way, you can still create your own method in here... :) 


	}