<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminHomecareCatatanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = false;
			$this->button_delete = false;
			$this->button_detail = false;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "homecare_catatan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Homecare Id","name"=>"homecare_id","join"=>"homecare,id"];
			$this->col[] = ["label"=>"Isi","name"=>"catatan"];
			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Score","name"=>"(SELECT SUM(score) FROM homecare_catatan_vote WHERE homecare_catatan_id = homecare_catatan.id ) as score","callback_php"=>"$row->score"];
			$this->col[] = ["label"=>"Updated At","name"=>"updated_at"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Homecare Id','name'=>'homecare_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'homecare,id'];
			$this->form[] = ['label'=>'Catatan','name'=>'catatan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Pengirim','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-10','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Homecare Id","name"=>"homecare_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"homecare,nama"];
			//$this->form[] = ["label"=>"Catatan","name"=>"catatan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	         $this->addaction[] = ['label'=>'','icon'=>'fa fa-trash','color'=>'warning','url'=>CRUDBooster::mainpath('hapus').'/[id]/[homecare_id]','showIf'=>'[updated_by]=="'.CRUDBooster::myId() .'"']; //.$this->pejabat->id];
	         $this->addaction[] = ['label'=>'','icon'=>'fa fa-thumbs-up','color'=>'primary','url'=>CRUDBooster::mainpath('like').'/[id]/[homecare_id]','showIf'=>'[updated_by]<>"'.CRUDBooster::myId() .'"'];
	        $this->addaction[] = ['label'=>'','icon'=>'fa fa-thumbs-down','color'=>'danger','url'=>CRUDBooster::mainpath('dislike').'/[id]/[homecare_id]','showIf'=>'[updated_by]<>"'.CRUDBooster::myId() .'"'];
	       // $this->addaction[] = ['label'=>'Selesai','color'=>'warning','url'=>CRUDBooster::mainpath('selesai').'/[id]','showIf'=>'[updated_by]<>"'.CRUDBooster::myId() .'" AND [score] >2'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	       
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here
            $added = DB::table('homecare_catatan')->where('id',$id)->first();
            DB::table('homecare')->where('id',$added->homecare_id)->update(['status'=>'diproses']);
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }

         public function getHapus($id,$homecare_id) {
            DB::table('homecare_catatan')->where('id',$id)->delete();
	        return CRUDBooster::redirect(CRUDBooster::mainpath('?return_url=https%3A%2F%2Fsiapkk.banjarbarukota.go.id%2Fadmin%2Fhomecare&parent_table=homecare&parent_columns=isi&parent_columns_alias=&parent_id='.$homecare_id.'&foreign_key=homecare_id&label=Homecare'),'Gambar Dihapus.','success');
	    }
	    
	     public function getLike($id,$homecare_id) {
	         $voted = DB::table('homecare_catatan_vote')->where('homecare_catatan_id',$id)->where('updated_by',CRUDBooster::myId())->first();
	        if($voted){
	            DB::table('homecare_catatan_vote')->where('homecare_catatan_id',$id)->where('updated_by',CRUDBooster::myId())->update(['score'=>1]);
    	        return CRUDBooster::redirect(CRUDBooster::mainpath('?return_url=https%3A%2F%2Fsiapkk.banjarbarukota.go.id%2Fadmin%2Fhomecare&parent_table=homecare&parent_columns=isi&parent_columns_alias=&parent_id='.$homecare_id.'&foreign_key=homecare_id&label=Homecare'),'Vote Update.','success');
	        }else{
                DB::table('homecare_catatan_vote')->insert(['homecare_catatan_id'=>$id,'score'=>1,'updated_by'=>CRUDBooster::myId()]);
    	        return CRUDBooster::redirect(CRUDBooster::mainpath('?return_url=https%3A%2F%2Fsiapkk.banjarbarukota.go.id%2Fadmin%2Fhomecare&parent_table=homecare&parent_columns=isi&parent_columns_alias=&parent_id='.$homecare_id.'&foreign_key=homecare_id&label=Homecare'),'Vote DiTambah.','success');
	        }
	    }
	    
	     public function getDislike($id,$homecare_id) {
             $voted = DB::table('homecare_catatan_vote')->where('homecare_catatan_id',$id)->where('updated_by',CRUDBooster::myId())->first();
	        if($voted){
	            DB::table('homecare_catatan_vote')->where('homecare_catatan_id',$id)->where('updated_by',CRUDBooster::myId())->update(['score'=>-1]);
    	        return CRUDBooster::redirect(CRUDBooster::mainpath('?return_url=https%3A%2F%2Fsiapkk.banjarbarukota.go.id%2Fadmin%2Fhomecare&parent_table=homecare&parent_columns=isi&parent_columns_alias=&parent_id='.$homecare_id.'&foreign_key=homecare_id&label=Homecare'),'Vote Update.','warning');
	        }else{
                DB::table('homecare_catatan_vote')->insert(['homecare_catatan_id'=>$id,'score'=>-1,'updated_by'=>CRUDBooster::myId()]);
    	        return CRUDBooster::redirect(CRUDBooster::mainpath('?return_url=https%3A%2F%2Fsiapkk.banjarbarukota.go.id%2Fadmin%2Fhomecare&parent_table=homecare&parent_columns=isi&parent_columns_alias=&parent_id='.$homecare_id.'&foreign_key=homecare_id&label=Homecare'),'Catatan Dihapus.','warning');
	        }
	    }

	    //By the way, you can still create your own method in here... :) 


	}