<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminHomecareController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			
			//if(CRUDBooster::myPrivilegeId()==1){
			    $this->button_detail = true;
// 			}else{
// 			    $this->button_detail = false;
// 			}
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "homecare";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"NIK","name"=>"nik"];
			$this->col[] = ["label"=>"Nama","name"=>"nama"];
			$this->col[] = ["label"=>"Alamat","name"=>"alamat"];
			$this->col[] = ["label"=>"Created By","name"=>"created_by"];
			$this->col[] = ["label"=>"Keterangan","name"=>"detail"];
			//$this->col[] = ["label"=>"Binaan","name"=>"(SELECT GROUP_CONCAT(satuan_kerja.satuan_kerja) FROM homecare_handle JOIN satuan_kerja ON satuan_kerja.id = homecare_handle.id_satuan_kerja WHERE homecare_handle.id_homecare = homecare.id GROUP BY homecare.id) as binaan","callback_php"=>'$row->binaan'];
			$this->col[] = ["label"=>"Detail Chat","name"=>"keterangan"];
			$this->col[] = ["label"=>"Lat","name"=>"lat"];
			$this->col[] = ["label"=>"Lon","name"=>"lon"];
			$this->col[] = ["label"=>"Score saya","name"=>"(SELECT (COUNT(DISTINCT(homecare_catatan.id))/SUM(homecare_catatan_vote.score) * 100) FROM homecare_catatan JOIN homecare_catatan_vote ON homecare_catatan_vote.homecare_catatan_id = homecare_catatan.id WHERE homecare_catatan.homecare_id = homecare.id AND homecare_catatan.updated_by = " . CRUDBooster::myId() . " ) as score","callback_php"=>"$row->score"];
			//$this->col[] = ["label"=>"Catatan saya","name"=>"(SELECT COUNT(homecare_catatan.id) FROM homecare_catatan WHERE homecare_catatan.updated_by = " . CRUDBooster::myId() . " ) as catatan","callback_php"=>"$row->catatan"];
			$this->col[] = ["label"=>"Status","name"=>"status"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'NIK','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Nama','name'=>'nama','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Alamat','name'=>'alamat','type'=>'textarea','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'text','validation'=>'required|string|min:0','width'=>'col-sm-7','readonly'=>'readonly'];
			$this->form[] = [
				"label" => "Binaan",
				"name" => "faskes",
				"type" => "select2",
				"select2_multiple" => true,
				"datatable" => "satuan_kerja,satuan_kerja,id",
				"relationship_table" => "homecare_handle",
				"required" => false,
			];
			$this->form[] = ['label'=>'Keterangan','name'=>'detail','type'=>'text','validation'=>'string|min:5','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Detail Chat','name'=>'keterangan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10','readonly'=>'readonly'];
			$this->form[] = ['label'=>'Koordinat','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Lat','name'=>'lat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5','readonly'=>'readonly'];
			$this->form[] = ['label'=>'Lon','name'=>'lon','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5','readonly'=>'readonly'];
			
			$columns[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
			$columns[] = ['label'=>'After','name'=>'after','type'=>'hidden','value'=>0];
			$columns[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Foto Masuk','name'=>'homecare_media','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'homecare_media','parent'=>'homecare','foreign_key'=>'homecare_id'];
			
			$columns3[] = ['label'=>'Saran','name'=>'catatan','type'=>'chat'];
			//$columns3[] = ['label'=>'Created At','name'=>'created_at','type'=>'text','value'=>now()];
			$columns3[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'select','datatable'=>'cms_users,name'];
			
			$this->form[] = ['label'=>'Catatan','name'=>'homecare_catatan','type'=>'child','columns'=>$columns3,'width'=>'col-sm-10','table'=>'homecare_catatan','parent'=>'homecare','foreign_key'=>'homecare_id'];
			
			
			$columns2[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
			$columns2[] = ['label'=>'After','name'=>'after','type'=>'hidden','value'=>1];
			$columns2[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Foto Sesudah','name'=>'homecare_after','type'=>'slider','columns'=>$columns2,'width'=>'col-sm-10','table'=>'homecare_after','parent'=>'homecare','foreign_key'=>'homecare_id'];
			
// 			$this->form[] = ['label'=>'Status','name'=>'status','type'=>'radio','validation'=>'min:1|max:255','width'=>'col-sm-4','dataenum'=>'diproses;selesai'];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Alamat","name"=>"alamat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Faskes Id","name"=>"faskes_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"faskes,nama"];
			//$this->form[] = ["label"=>"Keterangan","name"=>"keterangan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Lat","name"=>"lat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lon","name"=>"lon","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama","name"=>"nama","type"=>"text","required"=>TRUE,"validation"=>"required|string|min:3|max:70","placeholder"=>"Anda hanya dapat memasukkan huruf saja"];
			//$this->form[] = ["label"=>"Nik","name"=>"nik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Status","name"=>"status","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"User Id","name"=>"user_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"user,id"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Catatan','path'=>'homecare_catatan','parent_columns'=>'created_by','foreign_key'=>'homecare_id','button_color'=>'info','button_icon'=>'fa fa-bars'];
	        $this->sub_module[] = ['label'=>'Gambar Update','path'=>'homecare_after','parent_columns'=>'created_by','foreign_key'=>'homecare_id','button_color'=>'success','button_icon'=>'fa fa-image'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	       // $this->addaction[] = ['label'=>'','icon'=>'fa fa-thumbs-up','color'=>'primary','url'=>CRUDBooster::mainpath('like').'/[id]'];
	       // $this->addaction[] = ['label'=>'','icon'=>'fa fa-thumbs-down','color'=>'danger','url'=>CRUDBooster::mainpath('dislike').'/[id]'];
	        $this->addaction[] = ['label'=>'Selesaikan','color'=>'warning','url'=>CRUDBooster::mainpath('selesaikan').'/[id]','showIf'=>'[updated_by]<>"'.CRUDBooster::myId() .'" AND [score] >=60'];
	        $this->addaction[] = ['label'=>'Batalkan','color'=>'danger','url'=>CRUDBooster::mainpath('batalkan').'/[id]','showIf'=>'[updated_by]<>"'.CRUDBooster::myId() .'" AND [score] >=60'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();
	        $this->index_statistic[] = ['label'=>'Pengaduan Baru','count'=>DB::table($this->table)->where('status','baru')->count(),'icon'=>'fa fa-bars','color'=>'red','width'=>'col-sm-3'];
	        $this->index_statistic[] = ['label'=>'Diproses','count'=>DB::table($this->table)->where('status','diproses')->count(),'icon'=>'fa fa-eye','color'=>'yellow','width'=>'col-sm-3'];
	        $this->index_statistic[] = ['label'=>'Selesai','count'=>DB::table($this->table)->where('status','selesai')->count(),'icon'=>'fa fa-thumbs-up','color'=>'green','width'=>'col-sm-3'];
	        $this->index_statistic[] = ['label'=>'Dibatalkan','count'=>DB::table($this->table)->where('status','dibatalkan')->count(),'icon'=>'fa fa-thumbs-down','color'=>'red','width'=>'col-sm-3'];
	        $this->index_statistic[] = ['label'=>'Dibatalkan Pelapor','count'=>DB::table($this->table)->where('status','dibatalkan pelapor')->count(),'icon'=>'fa fa-thumbs-down-o','color'=>'orange','width'=>'col-sm-3'];



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}