<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminInformasiController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "judul";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "informasi";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"ID","name"=>"id"];
			$this->col[] = ["label"=>"Judul","name"=>"judul"];
			$this->col[] = ["label"=>"Kategori","name"=>"kategori_id","join"=>"kategori,nama_kategori"];
			//$this->col[] = ["label"=>"Kategori ID","name"=>"kategori_id"];
			//$this->col[] = ["label"=>"Tags","name"=>"tags"];
			$this->col[] = ["label"=>"Gambar Utama","name"=>"gambar_utama","image"=>true];
			$this->col[] = ["label"=>"Slug","name"=>"slug"];
			$this->col[] = ["label"=>"Halaman Statik","name"=>"statik"];
			//$this->col[] = ["label"=>"Mode","name"=>"mode_id","join"=>"jenis_informasi,jenis"];
			$this->col[] = ["label"=>"Oleh","name"=>"created_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Role","name"=>"created_by_priv","join"=>"cms_privileges,name"];
			$this->col[] = ["label"=>"Dibuat","name"=>"created_at"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Judul','name'=>'judul','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Sub Judul','name'=>'sub_judul','type'=>'textarea','validation'=>'required|string|min:3|max:70','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Kategori','name'=>'kategori_id','type'=>'select','width'=>'col-sm-6','datatable'=>'kategori,nama_kategori','datatable_where'=>'created_by_priv='.CRUDBooster::myPrivilegeId()];
			$this->form[] = ['label'=>'Gambar Utama','name'=>'gambar_utama','type'=>'upload','validation'=>'image|max:10000','width'=>'col-sm-6'];
			
// 			$columns[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
// 			$columns[] = ['label'=>'Keterangan','name'=>'caption','type'=>'text'];
// 			$this->form[] = ['label'=>'Galeri Foto','name'=>'media','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'media','parent'=>'informasi','foreign_key'=>'id_ortu'];
		
			$this->form[] = ['label'=>'Isi','name'=>'isi','type'=>'wysiwyg','validation'=>'required|string|min:5|max:50000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Halaman Statik','name'=>'statik','type'=>'radio','validation'=>'required|string|min:1','width'=>'col-sm-10','dataenum'=>'1|Ya;0|Tidak'];
			//$this->form[] = ['label'=>'Tags','name'=>'tags','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'hidden','width'=>'col-sm-9','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Role','name'=>'created_by_priv','type'=>'hidden','width'=>'col-sm-9','value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ['label'=>'Judul','name'=>'judul','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-10'];
			////	$this->form[] = ['label'=>'Kategori Id','name'=>'kategori_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'kategori,nama_kategori','value'=>CRUDBooster::me()->kategori_id];
			//
			//$this->form[] = ['label'=>'Gambar Utama','name'=>'gambar_utama','type'=>'upload','validation'=>'image|max:1000','width'=>'col-sm-10'];
			//$columns[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
			////$columns[] = ['label'=>'Embed','name'=>'url','type'=>'iframe'];
			//$columns[] = ['label'=>'Keterangan','name'=>'caption','type'=>'text'];
			////$columns[] = ['label'=>'Tabel','name'=>'nama_tabel','type'=>'tabel'];
			//$this->form[] = ['label'=>'Galeri Foto','name'=>'media','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'media','parent'=>'informasi','foreign_key'=>'id_ortu'];
			//$this->form[] = ['label'=>'Isi','name'=>'isi','type'=>'wysiwyg','validation'=>'required|string|min:5|max:50000','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Tags','name'=>'tags','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			////$this->form[] = ['label'=>'Created','name'=>'tags','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	       if(CRUDBooster::myPrivilegeId()!== "1"){
	           $query->where('informasi.created_by_priv',CRUDBooster::myPrivilegeId());
	       }
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $postdata['slug'] = str_slug($postdata['judul']);
            //$postdata['kategori_id'] = CRUDBooster::me()->kategori_id;
            $postdata['created_by'] = CRUDBooster::myId();
            $postdata['created_at'] = now();
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here
            $postdata['slug'] = str_slug($postdata['judul']);
           // $postdata['kategori_id'] = CRUDBooster::me()->kategori_id;
            $postdata['created_by'] = CRUDBooster::myId();
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}