<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminLaporanPeneriamaBantuanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = false;
			$this->button_bulk_action = false;
			$this->button_action_style = "button_dropdown";
			$this->button_add = false;
			$this->button_edit = false;
			$this->button_delete = false;
			$this->button_detail = false;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = true;
			$this->table = "surat_permohonan_bantuan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			//$this->col[] = ["label"=>"Nama Bantuan","name"=>"relasi_id","join"=>"bantuan,bantuan"];
			$this->col[] = ["label"=>"Created at","name"=>"created_at"];
			$this->col[] = ["label"=>"Updated at","name"=>"updated_at"];
			$this->col[] = ["label"=>"NIK","name"=>"(SELECT CONCAT('\'',nik) FROM warga_bjb WHERE id = surat_permohonan_bantuan.warga_bjb_id) as nik","callback_php"=>$row->nik];
			$this->col[] = ["label"=>"NO KK","name"=>"(SELECT CONCAT('\'',no_kk) FROM warga_bjb WHERE id = surat_permohonan_bantuan.warga_bjb_id) as no_kk","callback_php"=>$row->no_kk];
			$this->col[] = ["label"=>"Nama Lengkap","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Tanggal Lahir","name"=>"warga_bjb_id","join"=>"warga_bjb,tgl_lhr"];
			$this->col[] = ["label"=>"Jenis Kelamin","name"=>"warga_bjb_id","join"=>"warga_bjb,jk"];
			$this->col[] = ["label"=>"Alamat","name"=>"warga_bjb_id","join"=>"warga_bjb,alamat2"];
			$this->col[] = ["label"=>"Item Bantuan","name"=>"(SELECT item_name FROM bantuan_item WHERE bantuan_item_id = bantuan_item.id) as item","callback_php"=>$row->item];
			$this->col[] = ["label"=>"Provinsi","name"=>"(SELECT provinces.name FROM warga_bjb JOIN provinces ON warga_bjb.nama_prop = provinces.id WHERE warga_bjb.id = surat_permohonan_bantuan.warga_bjb_id ) as prov","callback_php"=>'$row->prov'];
			$this->col[] = ["label"=>"Kab/Kota","name"=>"(SELECT regencies.name FROM warga_bjb JOIN regencies ON warga_bjb.nama_kab = regencies.id WHERE warga_bjb.id = surat_permohonan_bantuan.warga_bjb_id ) as kab","callback_php"=>'$row->kab'];
			$this->col[] = ["label"=>"Kecamatan","name"=>"(SELECT districts.name FROM warga_bjb JOIN districts ON warga_bjb.nama_kec = districts.id WHERE warga_bjb.id = surat_permohonan_bantuan.warga_bjb_id ) as kec","callback_php"=>'$row->kec'];
			$this->col[] = ["label"=>"Kelurahan","name"=>"(SELECT villages.name FROM warga_bjb JOIN villages ON warga_bjb.nama_kel = villages.id WHERE warga_bjb.id = surat_permohonan_bantuan.warga_bjb_id ) as kel","callback_php"=>'$row->kel'];
			$this->col[] = ["label"=>"Alamat Usaha","name"=>"umkm_usaha_id","join"=>"umkm_usaha,alamat_usaha"];
			$this->col[] = ["label"=>"Provinsi Usaha","name"=>"(SELECT provinces.name FROM umkm_usaha JOIN provinces ON umkm_usaha.province_id = provinces.id WHERE umkm_usaha.id = umkm_usaha_id ) as provinsi","callback_php"=>'$row->provinsi'];
			$this->col[] = ["label"=>"Kab/Kota Usaha","name"=>"(SELECT regencies.name FROM umkm_usaha JOIN regencies ON umkm_usaha.regency_id = regencies.id WHERE umkm_usaha.id = umkm_usaha_id ) as kabupaten","callback_php"=>'$row->kabupaten'];
			$this->col[] = ["label"=>"Kecamatan Usaha","name"=>"(SELECT districts.name FROM umkm_usaha JOIN districts ON umkm_usaha.district_id = districts.id WHERE umkm_usaha.id = umkm_usaha_id ) as kecamatan","callback_php"=>'$row->kecamatan'];
			$this->col[] = ["label"=>"Kelurahan Usaha","name"=>"(SELECT villages.name FROM umkm_usaha JOIN villages ON umkm_usaha.village_id = villages.id WHERE umkm_usaha.id = umkm_usaha_id ) as kelurahan","callback_php"=>'$row->kelurahan'];
			$this->col[] = ["label"=>"Bidang Usaha","name"=>"umkm_usaha_id","join"=>"umkm_usaha,bidang_usaha"];
			$this->col[] = ["label"=>"No IUMK/UMK","name"=>"(SELECT CONCAT('\'',no_iumk) FROM umkm_pemilik WHERE id = surat_permohonan_bantuan.umkm_pemilik_id) as no_iumk","callback_php"=>$row->no_iumk];
			$this->col[] = ["label"=>"NIB/SKU","name"=>"(SELECT CONCAT('\'',nib_sku) FROM umkm_pemilik WHERE id = surat_permohonan_bantuan.umkm_pemilik_id) as nib_sku","callback_php"=>$row->nib_sku];
			$this->col[] = ["label"=>"Telepon","name"=>"(SELECT CONCAT('\'',no_telp) FROM umkm_pemilik WHERE id = surat_permohonan_bantuan.umkm_pemilik_id) as no_telp","callback_php"=>$row->no_telp];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Relasi','name'=>'relasi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Relasi Id','name'=>'relasi_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'relasi,id'];
			$this->form[] = ['label'=>'Warga Bjb Id','name'=>'warga_bjb_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'warga_bjb,nama_lgkp'];
			$this->form[] = ['label'=>'Umkm Usaha Id','name'=>'umkm_usaha_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'umkm_usaha,nama_usaha'];
			$this->form[] = ['label'=>'Grup Id','name'=>'grup_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'grup,nama_grup'];
			$this->form[] = ['label'=>'Owner Priv','name'=>'owner_priv','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Status Id','name'=>'status_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'status,id'];
			$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Created By Priv','name'=>'created_by_priv','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Relasi","name"=>"relasi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Relasi Id","name"=>"relasi_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"relasi,id"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Umkm Usaha Id","name"=>"umkm_usaha_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"umkm_usaha,nama_usaha"];
			//$this->form[] = ["label"=>"Grup Id","name"=>"grup_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"grup,nama_grup"];
			//$this->form[] = ["label"=>"Owner Priv","name"=>"owner_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Created By Priv","name"=>"created_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	       $query->where('owner_priv',CRUDBooster::myPrivilegeId());
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}