<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminLokasiController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama";
			$this->limit = "20";
			$this->orderby = "nama,asc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "lokasi";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			//$this->col[] = ["label"=>"Kategori Lokasi Id","name"=>"kategori_lokasi_id","join"=>"kategori_lokasi,nama"];
			
			$this->col[] = ["label"=>"Nama","name"=>"nama"];
			$this->col[] = ["label"=>"Lat","name"=>"lat"];
			$this->col[] = ["label"=>"Lon","name"=>"lon"];
			$this->col[] = ["label"=>"Gambar Utama","name"=>"gambar_utama","image"=>true];
			$this->col[] = ["label"=>"Default Icon","name"=>"default_icon","join"=>"kategori_lokasi,icon","image"=>true];
			$this->col[] = ["label"=>"Icon","name"=>"icon","image"=>true];
			$this->col[] = ["label"=>"Tags","name"=>"tags"];
			$this->col[] = ["label"=>"Pemilik","name"=>"Owner","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = [
				"label" => "Tags",
				"name" => "tags",
				"type" => "select2",
				"select2_multiple" => true,
				"datatable" => "kategori_lokasi,nama,id",
				"relationship_table" => "tags",
				"required" => true,
			];
			$this->form[] = ['label'=>'Kategori Lokasi','name'=>'kategori_lokasi_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'kategori_lokasi,nama'];
			$this->form[] = ['label'=>'Koordinat','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Lat','name'=>'lat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Lon','name'=>'lon','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			//$this->form[] = ['label'=>'Kategori Lokasi','name'=>'kategori_lokasi_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'kategori_lokasi,nama'];
			$this->form[] = ['label'=>'Nama Tempat','name'=>'nama','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Deskripsi','name'=>'deskripsi','type'=>'textarea','validation'=>'string|min:3|max:70','width'=>'col-sm-7'];
			if(CRUDBooster::myId()==1){
			    $this->form[] = ['label'=>'Pemilik','name'=>'owner','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-10','datatable'=>'cms_users,name'];
			}else{
			    $this->form[] = ['label'=>'Pemilik','name'=>'owner','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-10','datatable'=>'cms_users,name','value'=>CRUDBooster::myId()];
			}
			
			$this->form[] = ['label'=>'Alamat','name'=>'jalan','type'=>'text','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Nomor','name'=>'nomor','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Kota','name'=>'regency_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'regencies,name','value'=>'6372'];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'districts,name','datatable_where'=>'regency_id LIKE "6372%"'];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'villages,name','datatable_where'=>'district_id LIKE "6372%"'];
			$this->form[] = ['label'=>'Kode Pos','name'=>'kode_pos','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Telepon','name'=>'telepon','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10','placeholder'=>'Mohon input telepon dengan benar'];
			$this->form[] = ['label'=>'Website','name'=>'website','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Email','name'=>'email','type'=>'email','validation'=>'min:1|max:255|email|unique:lokasi','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Facebook','name'=>'facebook_id','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Instagram','name'=>'instagram_id','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Twitter','name'=>'twintter_id','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','width'=>'col-sm-10','value'=>CRUDBooster::myId()];
			
			$this->form[] = ['label'=>'Gambar Utama','name'=>'gambar_utama','type'=>'upload','validation'=>'image|max:3000','width'=>'col-sm-9'];
			$this->form[] = ['label'=>'Default Icon','name'=>'default_icon','type'=>'select2icon','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'kategori_lokasi,nama,icon'];
			$this->form[] = ['label'=>'Icon (48x48)','name'=>'icon','type'=>'upload','validation'=>'image|max:40','width'=>'col-sm-9'];
			
			//$this->form[] = ['label'=>'Galeri Foto','name'=>'multi_image_table','type'=>'multiimage','validation'=>'image|max:15','width'=>'col-sm-9'];
			
			//$columns[] = ['label'=>'Jenis','name'=>'jenis','type'=>'select','datatable'=>'jenis_media,nama', 'required'=>true];
			$columns[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
			// $columns[] = ['label'=>'Video','name'=>'file','type'=>'video','upload_type'=>'video'];
			//$columns[] = ['label'=>'Embed','name'=>'url','type'=>'iframe'];
			$columns[] = ['label'=>'Keterangan','name'=>'caption','type'=>'text'];
			//$columns[] = ['label'=>'Tabel','name'=>'nama_tabel','type'=>'tabel'];
			
			$this->form[] = ['label'=>'Galeri Foto','name'=>'media','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'media','parent'=>'lokasi','foreign_key'=>'id_ortu'];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ['label'=>'Koordinat','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			//
			//$this->form[] = ['label'=>'Lat','name'=>'lat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10','readonly'=>'readonly'];
			//$this->form[] = ['label'=>'Lon','name'=>'lon','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10','readonly'=>'readonly'];
			//$this->form[] = ['label'=>'Kategori Lokasi','name'=>'kategori_lokasi_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'kategori_lokasi,nama'];
			//$this->form[] = ['label'=>'Nama','name'=>'nama','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Icon','name'=>'icon','type'=>'upload','validation'=>'image|max:15','width'=>'col-sm-9'];
			//
			//$columns[] = ['label'=>'Jenis','name'=>'jenis','type'=>'select','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'jenis_media,nama'];
			//$columns[] = ['label'=>'File','name'=>'file','type'=>'upload',"image"=>true];
			//$columns[] = ['label'=>'URL','name'=>'url','type'=>'text'];
			//$columns[] = ['label'=>'Caption','name'=>'caption','type'=>'text'];
			//
			//$this->form[] = ['label'=>'Tinjauan','name'=>'media','type'=>'child','columns'=>$columns,'table'=>'media','foreign_key'=>'id_ortu'];
			//
			//$this->form[] = ['label'=>'Nomor','name'=>'nomor','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Jalan','name'=>'jalan','type'=>'text','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Kota','name'=>'regency_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'regencies,name'];
			//$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'districts,name'];
			//$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-10','datatable'=>'villages,name'];
			//$this->form[] = ['label'=>'Kode Pos','name'=>'kode_pos','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Telepon','name'=>'telepon','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10','placeholder'=>'Mohon input alamat email dengan benar'];
			//$this->form[] = ['label'=>'Website','name'=>'website','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Email','name'=>'email','type'=>'email','validation'=>'min:1|max:255|email|unique:lokasi','width'=>'col-sm-10'];
			////$this->form[] = ['label'=>'Akses Internet','name'=>'akses_internet','type'=>'checkbox','validation'=>'integer|min:0','width'=>'col-sm-10'];
			////$this->form[] = ['label'=>'Selalu Buka','name'=>'selalu_buka','type'=>'checkbox','validation'=>'min:1|max:255','width'=>'col-sm-10'];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Produk','path'=>'produk','parent_columns'=>'lokasi,nama,alamat','foreign_key'=>'lokasi_id','button_color'=>'info','button_icon'=>'fa fa-bars','showIf'=>'[kategori_lokasi_id] == 34'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
			$this->addaction[] = ['label'=>'Komentar','icon'=>'fa fa-comments','color'=>'default','url'=>CRUDBooster::adminPath('komentar/komentar').'/[id]/'.$this->table];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();
			//$this->index_button[] = ["label"=>"Lihat Peta","icon"=>"fa fa-maps","url"=>CRUDBooster::mainpath('map')];



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }

        public function getMap(){
			$data = [];
			
			$this->cbView('leafletmap.index',$data);
		}

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	        if(CRUDBooster::myPrivilegeId()==2){
	            $query->where('owner', CRUDBooster::myId());
	        }
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here
			$tags = DB::Table('tags')->join('kategori_lokasi','kategori_lokasi.id','tags.id_kategori_lokasi')->where('tags.id_lokasi',$id)->select(DB::raw("GROUP_CONCAT(kategori_lokasi.nama separator ',') as TAGS"))->get();
			if($tags){
				DB::Table('lokasi')->where('id',$id)->update(['tags'=>$tags[0]->TAGS]);
			}
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 
			$tags = DB::Table('tags')->join('kategori_lokasi','kategori_lokasi.id','tags.id_kategori_lokasi')->where('tags.id_lokasi',$id)->select(DB::raw("GROUP_CONCAT(kategori_lokasi.nama separator ',') as TAGS"))->get();
			if($tags){
				DB::Table('lokasi')->where('id',$id)->update(['tags'=>$tags[0]->TAGS]);
			}
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}