<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use PDF;
	use App\Signature\Esign;
	use App\Signature\Client\BasicRest;

	class AdminPejabatController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_pejabat";
			$this->limit = "20";
			$this->orderby = "parent_id,asc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "pejabat";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Nama Pejabat","name"=>"nama_pejabat"];
			$this->col[] = ["label"=>"NIP Pejabat","name"=>"nip_pejabat"];
			$this->col[] = ["label"=>"Pangkat","name"=>"pangkat_id","join"=>"pangkat,pangkat"];
			$this->col[] = ["label"=>"Eselon","name"=>"eselon_id","join"=>"eselon,eselon"];
			$this->col[] = ["label"=>"Jabatan","name"=>"jabatan_id","join"=>"jabatan,jabatan"];
			$this->col[] = ["label"=>"Satuan Kerja","name"=>"dinas_id","join"=>"satuan_kerja,satuan_kerja"];
			$this->col[] = ["label"=>"Unit Kerja","name"=>"unit_kerja_id","join"=>"unit_kerja,unit_kerja"];
			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nik"];
			$this->col[] = ["label"=>"User","name"=>"user_id"];
			$this->col[] = ["label"=>"Status TTE","name"=>"status_tte"];
// 			$this->col[] = ["label"=>"Created By","name"=>"created_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Oleh","name"=>"created_by_priv","join"=>"cms_privileges,name"];
			$this->col[] = ["label"=>"Parent","name"=>"parent_id","visible"=>false];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Nama Pejabat','name'=>'nama_pejabat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'NIP Pejabat','name'=>'nip_pejabat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Pangkat','name'=>'pangkat_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-7','datatable'=>'pangkat,pangkat'];
			$this->form[] = ['label'=>'Eselon','name'=>'eselon_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-7','datatable'=>'eselon,eselon'];
			$this->form[] = ['label'=>'Jabatan','name'=>'jabatan_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-7','datatable'=>'jabatan,jabatan'];
			if(CRUDBooster::myPrivilegeId()==1){
			    $this->form[] = ['label'=>'Satuan Kerja','name'=>'dinas_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'satuan_kerja,satuan_kerja'];
			}else{
			    $this->form[] = ['label'=>'Satuan Kerja','name'=>'dinas_id','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-7','value'=>Session::get('dinas_id')];
			}
			$this->form[] = ['label'=>'Unit Kerja','name'=>'unit_kerja_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'unit_kerja,unit_kerja'];
			$this->form[] = ['label'=>'Atasan','name'=>'parent_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-7','datatable'=>'pejabat,nip_pejabat','datatable_format'=>'nip_pejabat," (",nama_pejabat," - ",(SELECT jabatan FROM jabatan WHERE id = pejabat.jabatan_id)," )"','datatable_where'=>'dinas_id = '. Session::get('dinas_id')];
			$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'min:0|max:255','width'=>'col-sm-8','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat','datamodal_size'=>'large','datamodal_columns_alias'=>'NIK,Nama Lengkap,Tempat Lahir,Tanggal Lahir, Alamat'];
			
			$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'hidden','width'=>'col-sm-3','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Created By Priv','name'=>'created_by_priv','type'=>'hidden','width'=>'col-sm-3','value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Nama Pejabat","name"=>"nama_pejabat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nip Pejabat","name"=>"nip_pejabat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Jabatan","name"=>"jabatan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Dinas Id","name"=>"dinas_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"dinas,nama_dinas"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Created By Priv","name"=>"created_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Bawahan','path'=>'pejabat','foreign_key'=>'parent_id','button_color'=>'primary','parent_columns'=>'nama_pejabat,nip_pejabat,jabatan','showIf'=>'[parent_id]==0'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        //$this->addaction[] = ['label'=>'NIK','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::adminpath('warga_bjb/add'),'showIf'=>'[warga_bjb_id]==""'];
	        $this->addaction[] = ['label'=>'1LOGIN','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::mainpath('cek-login').'/[id]','showIf'=>'[user_id]==""'];
	        $this->addaction[] = ['label'=>'CEK ESIGN','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('cek-tte').'/[warga_bjb_id]/[user_id]'];
	        $this->addaction[] = ['label'=>'1LOGIN','icon'=>'fa fa-address-card','color'=>'success','url'=>'#','showIf'=>'[user_id]<>""'];//.$this->pejabat->id];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }
	    
	    public function getCekLogin($id) {
	        $data = [];
	        $data['id'] = $id; 
	        $data['batal'] = 'tte';
	        $data['pejabat'] = DB::table('pejabat')->where('id',$id)->first();
	        $data['warga'] = DB::table('warga_bjb')->where('id',$data['pejabat']->warga_bjb_id)->first();
	        $data['user'] = DB::table('cms_users')->where('nik',$data['warga']->nik)->first();
	        
	       // dd($data['surat']->pdf_file);
	        if($data['warga']){
    	        if($data['user']){
    	            similar_text(strtoupper($data['pejabat']->nama_pejabat),strtoupper($data['user']->name),$similar);
    	            if($similar > 85){
    	                similar_text(strtoupper($data['pejabat']->nama_pejabat),strtoupper($data['warga']->nama_lgkp),$similar);
        	            if($similar > 85){
        	                DB::table('pejabat')->where('id',$id)->update(['user_id'=>$data['user']->id]);
        	                CRUDBooster::redirectBack("Data pejabat sudah siap memerima dokumen untuk ditandatangani secara digital" , "success");
        	            }else{
        	                CRUDBooster::redirectBack("Nama pejabat tidak akurat dengan nama di database capil !", "danger");
        	            }
    	            }else{
    	                CRUDBooster::redirectBack("Nama pejabat " . $data['pejabat']->nama_pejabat . " tidak akurat dengan nama user " . $data['user']->name . " !" . $similar, "danger");
    	            }
    	        }else{
    	            similar_text(strtoupper($data['pejabat']->nama_pejabat),strtoupper($data['warga']->nama_lgkp),$similar);
    	            if($similar > 85){
    	                //DB::table('cms_users')->insertGetId(['name'=>$data['warga']->nama_lgkp,'nik'=>$data['warga']->nik,'password'=>'1212121212']);
    	                CRUDBooster::redirectBack("NIK " . $data['warga']->nik . " telah di daftarkan, atas nama " . $data['warga']->nama_lgkp . " dengan password sementara : PASS" , "success");
    	            }else{
    	                CRUDBooster::redirectBack("Nama pejabat " . $data['pejabat']->nama_pejabat . " tidak akurat dengan nama di database capil " . $data['warga']->nama_lgkp . " !" . $similar, "danger");
    	            }
        	    }
	       
	        }else{
	            CRUDBooster::redirectBack($data['warga']->nama_lgkp .   " Belum terekam dalam database SIAPKK, Hubungi Wahyu !", "danger");
	        }   
	        
	    }
	    
	    public function getCekTte($warga,$user_id){
	        $data = [];
	        $data['warga'] = DB::table('warga_bjb')->where('id',$warga)->first();
            
	        $esign = new Esign();
            $response = $esign->checkStatus($data['warga']->nik);
            //print_r( $response);
            //$response = json_decode($response);
            if($response->status_code==1111){
                DB::table('pejabat')->where('user_id',$user_id)->update(['status_tte'=>1]);
                CRUDBooster::redirectBack($response->message, "success");
                
               // print_r( $response->message);
            //     CRUDBooster::redirect(CRUDBooster::mainpath('preview-tte/'.Request::input('id').'/1'),$response->esign_message,"success");
             }else{
                 CRUDBooster::redirectBack($response->message, "danger");
             //    print_r( $response->message);\
            //     //var_dump($response);
            }
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	       //$query->where('pejabat.created_by_priv',CRUDBooster::myPrivilegeId())
	       //      ->where('pejabat.dinas_id',Session::get("dinas_id"));
	       // dd(Session::get("dinas_id"));
	       if(!g('parent_id')){
	           //$query->whereRaw('pejabat.parent_id=null');
	       }
	        if(CRUDBooster::myPrivilegeId()==21 || CRUDBooster::myPrivilegeId()==1 ){
	            
	        }else{
	            $query->where('pejabat.dinas_id',Session::get("dinas_id"));
	        }
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}