<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminPengesahanPeraturanPerusahaanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_dropdown";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "pengesahan_peraturan_perusahaan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Tanggal","name"=>"created_at"];
			$this->col[] = ["label"=>"Akta Pendirian","name"=>"akta_pendirian"];
			$this->col[] = ["label"=>"Perusahaan ","name"=>"perusahaan_id","join"=>"perusahaan,nama_perusahaan"];
			$this->col[] = ["label"=>"Bpjs","name"=>"bpjs"];
			$this->col[] = ["label"=>"Draft PP","name"=>"draft_pp"];
			$this->col[] = ["label"=>"Permohonan","name"=>"permohonan"];
			$this->col[] = ["label"=>"Pernyataan Belum Terbentuk Sp","name"=>"pernyataan_belum_terbentuk_sp"];
			$this->col[] = ["label"=>"Created By","name"=>"created_by"];
			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			
			if(CRUDBooster::myPrivilegeId()==47){
			    $this->form[] = ['label'=>'Upload File Bertandatangan','name'=>'signed_pdf','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf | Max : 50 MB)'];
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "proses" ){
			    $this->form[] = ['label'=>'File Hasil','name'=>'gen_doc','type'=>'upload','validation'=>'readonly|max:50000','width'=>'col-sm-4','help'=>'(tipe file .docx| Max : 50 MB)'];

			    $this->form[] = ['label'=>'Upload File','name'=>'upload_doc','type'=>'upload','validation'=>'max:50000','width'=>'col-sm-4','help'=>'(tipe file .docx| Max : 50 MB)'];
			 //   $this->form[] = ['label'=>'Catatan','name'=>'catatan','type'=>'textarea','validation'=>'string','width'=>'col-sm-10'];
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "final"){
			    $this->form[] = ['label'=>'Upload SK Bertandatangan','name'=>'signed_pdf','type'=>'upload','validation'=>'max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf| Max : 50 MB)'];
			}else{
			    $this->form[] = ['label'=>'Warga id','name'=>'warga_bjb_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::menik(CRUDBooster::me()->nik)->id];
    			$this->form[] = ['label'=>'Perusahaan','name'=>'perusahaan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-4','datatable'=>'perusahaan,nama_perusahaan','datatable_where'=>'perusahaan.created_by='.CRUDBooster::myId(). ' AND perusahaan.status_data_id = 3'];
    			$this->form[] = ['label'=>'Peruntukan','name'=>'peruntukan','type'=>'select','validation'=>'required','width'=>'col-sm-4','dataenum'=>'Pengesahan Baru Peraturan Perusahaan;Pembaruan Peraturan Perusaahaan;Perpanjangan Peraturan Perusaahaan;Perubahan Peraturan Perusahaan;'];
    			$this->form[] = ['label'=>'Fotocopy WLKP yang masih berlaku','name'=>'wlkp','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Fotocopy Akta Pendirian Perusahaan','name'=>'akta_pendirian','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Nomor Ijin Berusaha','name'=>'nib','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Fotocopy sertifikat kepesertaan BPJS Ketenagakerjaan dan BPJS Kesehatan dan/atau bukti pembayaran iuran terakhir','name'=>'bpjs','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Permohonan Pengesahan PP','name'=>'permohonan','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Surat pernyataan bahwa PP sudah dimintakan saran dan pertimbangan dari wakil pekerja, SP/SB','name'=>'pernyataan_wakil_pekerja','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Surat pernyataan bahwa di Perusahaan belum terbentuk SP/SB','name'=>'pernyataan_belum_terbentuk_sp','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Surat pernyataan sudah / belum memiliki struktur upah dan skala upah dan sudah dilaksanakan','name'=>'pernyataan_struktur_upah','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Struktur upah dan skala upah asli untuk ditunjuk ke pegawai / petugas pengoreksi PP','name'=>'struktur_upah','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Draft PP sebanyak 3 eksemplar yang sudah di paraf oleh pimpinan Perusahaan','name'=>'draft_pp','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
			}
			// $this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-4'];
			// $this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-4'];
			
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Akta Pendirian","name"=>"akta_pendirian","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Bpjs","name"=>"bpjs","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Draft Pp","name"=>"draft_pp","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Permohonan","name"=>"permohonan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Pernyataan Belum Terbentuk Sp","name"=>"pernyataan_belum_terbentuk_sp","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Pernyataan Struktur Upah","name"=>"pernyataan_struktur_upah","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Pernyataan Wakil Pekerja","name"=>"pernyataan_wakil_pekerja","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Perusahaan Id","name"=>"perusahaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"perusahaan,nama_perusahaan"];
			//$this->form[] = ["label"=>"Struktur Upah","name"=>"struktur_upah","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Wlkp","name"=>"wlkp","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        // $this->load_js = array();
			$this->load_js[] = asset("js/customform.js");
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {      
			$postdata['created_by'] = CRUDBooster::myId();  
			$postdata['updated_by'] = CRUDBooster::myId();   
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
			CRUDBooster::initSurat($this->table,$id);
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {     
			$postdata['updated_by'] = CRUDBooster::myId();   
			if(CRUDBooster::myPrivilegeId()==2){
	            $postdata['nomor'] = null;
	        }      
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        $updated = DB::table($this->table)->where('id',$id)->first();
	        if(strlen($updated->signed_pdf)>0){
	            dd($updated);
	            DB::table('surat_idv')->where('parent_table',$this->table)->where('parent_id',$id)->update(['signed_pdf'=>$updated->signed_pdf,'status_id'=>5,'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>47]);
	        
	            CRUDBooster::sendNotifikasi($updated->created_by,2,'Permohonan Anda  Telah Disetujui.',CRUDBooster::adminPath('surat_idv'));
	        }
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }


         public function getTeruskan($id,$idv) {
            if(!CRUDBooster::isUpdate() && $this->global_privilege==FALSE || $this->button_edit==FALSE) {    
                CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
            }
            
            $data = [];
            $data['page_title'] = 'Teruskan Permohonan';
            $data['row'] = DB::table('pengesahan_peraturan_perusahaan')
                            ->join('perusahaan','perusahaan.id','pengesahan_peraturan_perusahaan.perusahaan_id')
                            ->where('pengesahan_peraturan_perusahaan.id',$id)
                            ->first();
            $data['next'] = CRUDBooster::mainpath('teruskanttd/'.$id);
            $data['back'] = CRUDBooster::adminPath('suratidv/'.$idv);
            
            //Please use view method instead view method from laravel
            return $this->cbView('custom.mediator.edit',$data);
        }

        public function postTeruskanttd($id) {
            if(!CRUDBooster::isUpdate() && $this->global_privilege==FALSE || $this->button_edit==FALSE) {    
                CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
            }
            
            $data = DB::table('pengesahan_peraturan_perusahaan')
                            ->join('perusahaan','perusahaan.id','pengesahan_peraturan_perusahaan.perusahaan_id')
                            ->where('pengesahan_peraturan_perusahaan.id',$id)
                            ->first();
            
            $esign = new Esign();
            $resp = $esign->sign($nik = '1234567890123456', $pass = Request::input('passphrase'), $pdf = $data->gen_pdf, $tag = '#', $imageTTD = CRUDBooster::me()->spesimen_tte);
            $response = json_decode($resp);
            // dd($response);
            DB::table('esign_log')->insert(['cms_users_id'=>CRUDBooster::myId(),'response'=>$resp]);
            
    //         $durl = CRUDBooster::convertPdf($path . $nama_file_surat,$nama_file);
		  //  DB::table('surat_idv')->where('jenis_surat_id',$surat_masuk->jenis_surat_id)->where('parent_id',$parent_data->id)->update(['status_id'=>3,'gen_doc'=>'uploads/0/'. date('Y') . '-' . date('m') .'/surat_gen/'.$nama_file_surat,'gen_pdf'=>$durl,'updated_by' => CRUDBooster::myId()]); 
		  //  DB::table($surat_masuk->parent_table)->where('id',$surat_masuk->parent_id)->update(['gen_doc'=>'uploads/0/'. date('Y') . '-' . date('m') .'/surat_gen/'.$nama_file_surat,'gen_pdf'=>$durl,'updated_by' => CRUDBooster::myId()]); 
	        if($response->esign_status==1){
	            return CRUDBooster::redirect(CRUDBooster::adminPath('surat_idv'),'Permohonan ' . $id .' berhasil diteruskan.','success');
	        }else{
	            return CRUDBooster::redirect(CRUDBooster::adminPath('surat_idv'),'Proses penandatanganan digital ' . $id .' gagal, silahkan mencoba kembali. ' . $response->esign_message,'danger');
	        }

        }
	    //By the way, you can still create your own method in here... :) 


	}