<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminPenyelesaianPerselisihanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "penyelesaian_perselisihan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Perusahaan Id","name"=>"perusahaan_id","join"=>"perusahaan,nama_perusahaan"];
			$this->col[] = ["label"=>"Peruntukan","name"=>"peruntukan"];
			$this->col[] = ["label"=>"Permohonan","name"=>"permohonan"];
			$this->col[] = ["label"=>"Permintaan","name"=>"permintaan"];
			$this->col[] = ["label"=>"Daftar Hadir","name"=>"daftar_hadir"];
			$this->col[] = ["label"=>"Risalah","name"=>"risalah"];
			$this->col[] = ["label"=>"Nomor","name"=>"nomor"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			if(CRUDBooster::myPrivilegeId()==47){
			    $this->form[] = ['label'=>'Upload File Bertandatangan','name'=>'signed_pdf','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf | Max : 50 MB)'];
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "final"){
			    $this->form[] = ['label'=>'Upload SK Bertandatangan','name'=>'signed_pdf','type'=>'upload','validation'=>'max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf| Max : 50 MB)'];
			}else{
    			$this->form[] = ['label'=>'Warga id','name'=>'warga_bjb_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::menik(CRUDBooster::me()->nik)->id];
    			$this->form[] = ['label'=>'Perusahaan','name'=>'perusahaan_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-4','datatable'=>'perusahaan,nama_perusahaan','datatable_where'=>'perusahaan.created_by='.CRUDBooster::myId(). ' AND perusahaan.status_data_id = 3'];
    			$this->form[] = ['label'=>'Peruntukan','name'=>'peruntukan','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Permintaan Fasilitasi Bipartit;Pencatatan PPHI'];
    			$this->form[] = ['label'=>'Permohonan pencatatan Penyelesaian Perselisihan Hubungan Industrial','name'=>'permohonan','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Surat permohonan permintaan perundingan Bipartit','name'=>'permintaan','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Daftar hadir perundingan bipartit','name'=>'daftar_hadir','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Risalah perundingan bipartit','name'=>'risalah','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
			}
			// $this->form[] = ['label'=>'Terlapor','name'=>'terlapor','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			// $this->form[] = ['label'=>'Kronologi','name'=>'kronologi','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-7'];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Perusahaan Id","name"=>"perusahaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"perusahaan,nama_perusahaan"];
			//$this->form[] = ["label"=>"Peruntukan","name"=>"peruntukan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Permohonan","name"=>"permohonan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Permintaan","name"=>"permintaan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Daftar Hadir","name"=>"daftar_hadir","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Risalah","name"=>"risalah","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Nomor","name"=>"nomor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|min:1|max:255","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Terlapor","name"=>"terlapor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Kronologi","name"=>"kronologi","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Pejabat Id","name"=>"pejabat_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pejabat,nama_pejabat"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        // $this->load_js = array();
			$this->load_js[] = asset("js/customform.js");
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {     
			$postdata['created_by'] = CRUDBooster::myId();  
			$postdata['updated_by'] = CRUDBooster::myId();     
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {
			CRUDBooster::initSurat($this->table,$id);          
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {    
			$postdata['updated_by'] = CRUDBooster::myId();   
			if(CRUDBooster::myPrivilegeId()==2){
	            $postdata['nomor'] = null;
	        }     
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        $updated = DB::table($this->table)->where('id',$id)->first();
	        if(strlen($updated->signed_pdf)>0){
	            DB::table('surat_idv')->where('parent_table',$this->table)->where('parent_id',$id)->update(['signed_pdf'=>$updated->signed_pdf,'status_id'=>5,'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId()]);
	            CRUDBooster::sendNotifikasi($updated->created_by,2,'Permohonan Anda  Telah Disetujui.',CRUDBooster::adminPath('surat_idv'));
	        }
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}