<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use App\Signature\Esign;
	use App\Signature\Client\BasicRest;

	class AdminPerjanjianKerjaWaktuTertentuController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "perjanjian_kerja_waktu_tertentu";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Nomor","name"=>"nomor"];
			$this->col[] = ["label"=>"Created By","name"=>"created_by","visible"=>false];
			$this->col[] = ["label"=>"Pengirim","name"=>"created_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Perusahaan","name"=>"(SELECT nama_perusahaan FROM perusahaan WHERE id = perjanjian_kerja_waktu_tertentu.perusahaan_id) as nama_perusahaan","callback_php"=>"$row->nama_perusahaan"];
			$this->col[] = ["label"=>"Daftar Pekerja","name"=>"daftar_pekerja","download"=>true];
			$this->col[] = ["label"=>"Permohonan","name"=>"permohonan","download"=>true];
			$this->col[] = ["label"=>"Akta","name"=>"akta","download"=>true];
			$this->col[] = ["label"=>"Peruntukan","name"=>"peruntukan"];
			$this->col[] = ["label"=>"Nomor Depan","name"=>"nomor_depan_child"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
// 			dd($page_title);
			if(CRUDBooster::myPrivilegeId()==47){// penandatangan
			    $this->form[] = ['label'=>'Upload File Bertandatangan','name'=>'signed_pdf','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf | Max : 50 MB)'];
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "proses"){

			    $this->form[] = ['label'=>'Dokumen Hasil','name'=>'gen_doc','type'=>'upload','validation'=>'readonly|max:50000','width'=>'col-sm-4','help'=>'(tipe file .docx| Max : 50 MB)'];

    			
			    $columns[] = ['label'=>'Nama','name'=>'nama','type'=>'text'];
    			$columns[] = ['label'=>'Jabatan','name'=>'jabatan','type'=>'text'];
    			$columns[] = ['label'=>'Upah','name'=>'upah','type'=>'number'];
    			$columns[] = ['label'=>'Tanggal Penandatangann PKWT','name'=>'tanggal_tandatangan','type'=>'date'];
    // 			$columns[] = ['label'=>'Nomor Pencatatan','name'=>'nomor_pencatatan','type'=>'text','value'=>''];
    			$columns[] = ['label'=>'Tanggal Pencatatan PKWT','name'=>'tanggal_pencatatan','type'=>'date'];
    			$columns[] = ['label'=>'Nomor','name'=>'nomor_pencatatan','type'=>'childseqid'];
    			$columns[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'text'];
    			
    			$this->form[] = ['label'=>'Daftar Nama Pekerja','name'=>'media','type'=>'child','columns'=>$columns,'width'=>'col-sm-10','table'=>$this->table. '_child','foreign_key'=>'parent_id', 'parent'=>$this->table];
    			
			 
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "teruskan"){
			     //$this->form[] = ['label'=>'Dokumen Hasil','name'=>'gen_doc','type'=>'upload','validation'=>'readonly|max:50000','width'=>'col-sm-4','help'=>'(tipe file .docx| Max : 50 MB)'];
			     $this->form[] = ['label'=>'Upload Dokumen','name'=>'upload_doc','type'=>'upload','validation'=>'max:50000','width'=>'col-sm-4','help'=>'(tipe file .docx| Max : 50 MB)'];
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "catatan"){
			    $this->form[] = ['label'=>'File Hasil','name'=>'gen_doc','type'=>'upload','validation'=>'readonly|max:50000','width'=>'col-sm-4','help'=>'(tipe file .docx| Max : 50 MB)'];
			    $this->form[] = ['label'=>'Catatan','name'=>'catatan','type'=>'textarea','validation'=>'string','width'=>'col-sm-10'];
			}elseif(CRUDBooster::myPrivilegeId()==48 && g("command") == "final"){
			    $this->form[] = ['label'=>'Upload SK Bertandatangan','name'=>'signed_pdf','type'=>'upload','validation'=>'max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf| Max : 50 MB)'];
			    $this->form[] = ['label'=>'Surat permohonan pencacatan PKWT','name'=>'permohonan','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf | Max : 50 MB)','visible'=>false];
			}else{
    			$this->form[] = ['label'=>'Warga id','name'=>'warga_bjb_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::menik(CRUDBooster::me()->nik)->id];
    // 			$this->form[] = ['label'=>'Pengirim','name'=>'created_by','type'=>'select2','width'=>'col-sm-4','datatable'=>'cms_users,name'];
    			$this->form[] = ['label'=>'Perusahaan','name'=>'perusahaan_id','type'=>'select','validation'=>'required|integer|min:0','width'=>'col-sm-4','datatable'=>'perusahaan,nama_perusahaan','datatable_where'=>'perusahaan.created_by='.CRUDBooster::myId(). ' AND perusahaan.status_data_id = 3'];
    			$this->form[] = ['label'=>'Peruntukan','name'=>'peruntukan','type'=>'select','validation'=>'required|max:50000','width'=>'col-sm-4','dataenum'=>'Pencatatan PKWT'];
    			$this->form[] = ['label'=>'Surat permohonan pencacatan PKWT','name'=>'permohonan','type'=>'upload','validation'=>'required|max:200000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)','visible'=>false];
    			$this->form[] = ['label'=>'Daftar nama pekerja / buruh PKWT','name'=>'daftar_pekerja','type'=>'upload','validation'=>'required|max:200000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Asli PKWT yang sudah ditandatangani oleh para pihak (pengusaha dan pekerja)','name'=>'pwkt_asli','type'=>'upload','validation'=>'required|max:200000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Fotocopy WLKP yang masih berlaku','name'=>'wlkp','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
    			$this->form[] = ['label'=>'Fotocopy Akta Pendirian Perusahaan','name'=>'akta','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
			    $this->form[] = ['label'=>'Nomor Ijin Berusaha','name'=>'nib','type'=>'upload','validation'=>'required|max:50000','width'=>'col-sm-4','help'=>'(tipe file .pdf/.jpg/.jpeg/.png | Max : 50 MB)'];
			 //   $this->form[] = ['label'=>'Catatan','name'=>'catatan','type'=>'textarea','validation'=>'required','width'=>'col-sm-10'];
			}
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Akta","name"=>"akta","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Daftar Pekerja","name"=>"daftar_pekerja","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Nomor","name"=>"nomor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Permohonan","name"=>"permohonan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Peruntukan","name"=>"peruntukan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Perusahaan Id","name"=>"perusahaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"perusahaan,nama_perusahaan"];
			//$this->form[] = ["label"=>"Pwkt Asli","name"=>"pwkt_asli","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|min:1|max:255","datatable"=>"warga_bjb,nama_kab"];
			//$this->form[] = ["label"=>"Wlkp","name"=>"wlkp","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Daftar Pekerja','path'=>'perjanjian_kerja_waktu_tertentu_child','foreign_key'=>'parent_id','button_color'=>'danger','parent_columns'=>'pemohon,nama_perusahaan,nomor,peruntukan'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        // $this->load_js = array();
	        if(g("command") != "proses"){
			    $this->load_js[] = asset("js/customform.js");
	        }
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	       // $query->join('perusahaan','perusahaan.id',$this->table.'.perusahaan_id');
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	   
	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {   
	        $postdata['created_by'] = CRUDBooster::myId();  
			$postdata['updated_by'] = CRUDBooster::myId();   
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) { 
	        CRUDBooster::initSurat($this->table,$id);
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {    
	        $postdata['updated_by'] = CRUDBooster::myId();
	        if(CRUDBooster::myPrivilegeId()==2){
	            $postdata['nomor'] = null;
	        }
	        if(CRUDBooster::myPrivilegeId()==48){
	           // dd($postdata);
	        }
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        $updated = DB::table($this->table)->where('id',$id)->first();
	        if(strlen($updated->signed_pdf)>0){
	            DB::table('surat_idv')->where('parent_table',$this->table)->where('parent_id',$id)->update(['signed_pdf'=>$updated->signed_pdf,'status_id'=>5,'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId()]);
	            CRUDBooster::sendNotifikasi($updated->created_by,2,'Permohonan Anda  Telah Disetujui.',CRUDBooster::adminPath('surat_idv'));
	        }

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }
        
        public function getTeruskan($id,$idv) {
            if(!CRUDBooster::isUpdate() && $this->global_privilege==FALSE || $this->button_edit==FALSE) {    
                CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
            }
            
            $data = [];
            $data['page_title'] = 'Teruskan Permohonan';
            $data['row'] = DB::table('perjanjian_kerja_waktu_tertentu')
                            ->join('perusahaan','perusahaan.id','perjanjian_kerja_waktu_tertentu.perusahaan_id')
                            ->where('perjanjian_kerja_waktu_tertentu.id',$id)
                            ->first();
            $data['next'] = CRUDBooster::mainpath('teruskanttd/'.$id);
            $data['back'] = CRUDBooster::adminPath('suratidv/'.$idv);
            //Please use view method instead view method from laravel
            return $this->cbView('custom.mediator.edit',$data);
        }

        public function postTeruskanttd($id) {
            if(!CRUDBooster::isUpdate() && $this->global_privilege==FALSE || $this->button_edit==FALSE) {    
                CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
            }
            
            $data = DB::table('perjanjian_kerja_waktu_tertentu')
                            ->join('perusahaan','perusahaan.id','perjanjian_kerja_waktu_tertentu.perusahaan_id')
                            ->where('perjanjian_kerja_waktu_tertentu.id',$id)
                            ->first();
            
            $esign = new Esign();
            $resp = $esign->sign($nik = '1234567890123456', $pass = Request::input('passphrase'), $pdf = $data->gen_pdf, $tag = '@', $imageTTD = CRUDBooster::me()->spesimen_tte);
            $response = json_decode($resp);
            // dd($response);
            DB::table('esign_log')->insert(['cms_users_id'=>CRUDBooster::myId(),'response'=>$resp]);
            
    //         $durl = CRUDBooster::convertPdf($path . $nama_file_surat,$nama_file);
		  //  DB::table('surat_idv')->where('jenis_surat_id',$surat_masuk->jenis_surat_id)->where('parent_id',$parent_data->id)->update(['status_id'=>3,'gen_doc'=>'uploads/0/'. date('Y') . '-' . date('m') .'/surat_gen/'.$nama_file_surat,'gen_pdf'=>$durl,'updated_by' => CRUDBooster::myId()]); 
		  //  DB::table($surat_masuk->parent_table)->where('id',$surat_masuk->parent_id)->update(['gen_doc'=>'uploads/0/'. date('Y') . '-' . date('m') .'/surat_gen/'.$nama_file_surat,'gen_pdf'=>$durl,'updated_by' => CRUDBooster::myId()]); 
	        if($response->esign_status==1){
	            return CRUDBooster::redirect(CRUDBooster::adminPath('surat_idv'),'Permohonan ' . $id .' berhasil diteruskan.','success');
	        }else{
	            return CRUDBooster::redirect(CRUDBooster::adminPath('surat_idv'),'Proses penandatanganan digital ' . $id .' gagal, silahkan mencoba kembali. ' . $response->esign_message,'danger');
	        }

        }
	    //By the way, you can still create your own method in here... :) 


	}