<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminPerusahaanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_perusahaan";
			$this->limit = "20";
			$this->orderby = "updated_at,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = true;
			$this->table = "perusahaan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Admin","name"=>"created_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Nama","name"=>"nama_perusahaan"];
			$this->col[] = ["label"=>"Alamat","name"=>"alamat_perusahaan"];
			$this->col[] = ["label"=>"Telepon Perusahaan","name"=>"telp_perusahaan","callback_php"=>"$row->telp_perusahaan"];
			$this->col[] = ["label"=>"Email Perusahaan","name"=>"email_perusahaan"];
			$this->col[] = ["label"=>"Tipe","name"=>"tipe_perusahaan_id","join"=>"tipe_perusahaan,tipe"];
			$this->col[] = ["label"=>"Sektor","name"=>"sektor_perusahaan_id"];
			$this->col[] = ["label"=>"Kantor","name"=>"status_perusahaan_id","join"=>"status_perusahaan,status"];
			$this->col[] = ["label"=>"Penanaman Modal","name"=>"status_penanaman_modal_id","join"=>"status_penanaman_modal,status"];
			$this->col[] = ["label"=>"BPJS Ketenagakerjaan","name"=>"no_bjps_naker"];
			$this->col[] = ["label"=>"BPJS Kesehatan","name"=>"no_bpjs_kesehatan"];
			$this->col[] = ["label"=>"Status","name"=>"status_data_id","join"=>"status_data,status"];
			$this->col[] = ["label"=>"Updated","name"=>"updated_at"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			// $this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10', 'value'=>CRUDBooster::myId()];
			if(CRUDBooster::myPrivilegeId()==46){
			    $this->form[] = ['label'=>'Admin','name'=>'created_by','type'=>'select2','validation'=>'required|integer|min:1','width'=>'col-sm-7','datatable'=>'cms_users,name','datatable_where'=>'id > 1098','datatable_format'=>"name ,' - ', nik"];
			}
			$this->form[] = ['label'=>'Nama Perusahaan','name'=>'nama_perusahaan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-7'];
			$this->form[] = ['label'=>'Alamat Perusahaan','name'=>'alamat_perusahaan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Telepon Perusahaan','name'=>'telp_perusahaan','type'=>'tel','validation'=>'required|min:9|max:15','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Email Perusahaan','name'=>'email_perusahaan','type'=>'email','validation'=>'required|email|min:5','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Maps','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Latitude','name'=>'lat','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-5','readonly'=>true];
			$this->form[] = ['label'=>'Longitude','name'=>'lon','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-5','readonly'=>true];
			$this->form[] = ['label'=>'Tipe Perusahaan (Sesuai NIB)','name'=>'tipe_perusahaan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'tipe_perusahaan,tipe'];
			$this->form[] = ['label'=>'Sektor/Nama KBLI (Sesuai NIB)','name'=>'sektor_perusahaan_id','type'=>'text','validation'=>'required|min:5','width'=>'col-sm-7'];
			// $this->form[] = ['label'=>'Sektor Perusahaan','name'=>'sektor_perusahaan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'sektor_perusahaan,id'];
			$this->form[] = ['label'=>'Status Perusahaan','name'=>'status_perusahaan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'status_perusahaan,status'];
			$this->form[] = ['label'=>'Status Penanaman Modal','name'=>'status_penanaman_modal_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'status_penanaman_modal,status'];
			
			$columns[] = ['label'=>'Nomor','name'=>'no_kep_izin_usaha','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-5'];
			$columns[] = ['label'=>'Tanggal','name'=>'tgl_kep_izin_usaha','type'=>'date','validation'=>'required','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Surat Keputusan Izin Usaha (Nomor dan Tanggal Surat)','name'=>'izin_usaha','type'=>'group','columns'=>$columns,'width'=>'col-sm-10'];
			
			// $this->form[] = ['label'=>'No Izin Usaha','name'=>'no_kep_izin_usaha','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			// $this->form[] = ['label'=>'Tanggal Kep Izin Usaha','name'=>'tgl_kep_izin_usaha','type'=>'date','validation'=>'required|date','width'=>'col-sm-10'];
			
			
			
			$columns2[] = ['label'=>'Laki-laki','name'=>'tn_laki','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-5','value'=>0];
			$columns2[] = ['label'=>'Wanita','name'=>'tn_wanita','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-5','value'=>0];
			$this->form[] = ['label'=>'Jumlah Tenaga Kerja','name'=>'tenaga_kerja','type'=>'group','columns'=>$columns2,'width'=>'col-sm-10'];

			// $this->form[] = ['label'=>'Tenaga Kerja Laki-laki','name'=>'tn_laki','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-5'];
			// $this->form[] = ['label'=>'Tenaga Kerja Wanita','name'=>'tn_wanita','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-5'];
			$columns3[] = ['label'=>'PKWT','name'=>'pwkt','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3','value'=>0];
			$columns3[] = ['label'=>'PKWTT','name'=>'pkwtt','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3','value'=>0];
			$columns3[] = ['label'=>'Outsourcing','name'=>'outsourcing','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3','value'=>0];
			$columns3[] = ['label'=>'WNA','name'=>'wna','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3','value'=>0];
			$this->form[] = ['label'=>'Status Hubungan Kerja','name'=>'hubungan_kerja','type'=>'group','columns'=>$columns3,'width'=>'col-sm-10'];
			
			// $this->form[] = ['label'=>'PWKT','name'=>'pwkt','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3'];
			// $this->form[] = ['label'=>'Outsourcing','name'=>'outsourcing','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3'];
			// $this->form[] = ['label'=>'WNA','name'=>'wna','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-3'];

			$columns4[] = ['label'=>'Ketenagakerjaan','name'=>'no_bjps_naker','type'=>'text','validation'=>'required|min:1|max:25','width'=>'col-sm-6','check'=>'Belum Memiliki'];
			$columns4[] = ['label'=>'Kesehatan','name'=>'no_bpjs_kesehatan','type'=>'text','validation'=>'required|min:1|max:25','width'=>'col-sm-6','check'=>'Belum Memiliki'];
			$this->form[] = ['label'=>'Nomor Kepesertaan BPJS','name'=>'bpjs','type'=>'group','columns'=>$columns4,'width'=>'col-sm-10'];

			// $this->form[] = ['label'=>'BPJS Ketenagakerjaan','name'=>'no_bjps_naker','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			// $this->form[] = ['label'=>'BPJS Kesehatan','name'=>'no_bpjs_kesehatan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];

			// $this->form[] = ['label'=>'Status Data','name'=>'status_data_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-7','datatable'=>'status_data,id','value'=>1];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Alamat Perusahaan","name"=>"alamat_perusahaan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Nama Perusahaan","name"=>"nama_perusahaan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"No Bjps Naker","name"=>"no_bjps_naker","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"No Bpjs Kesehatan","name"=>"no_bpjs_kesehatan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"No Kep Izin Usaha","name"=>"no_kep_izin_usaha","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Outsourcing","name"=>"outsourcing","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Pwkt","name"=>"pwkt","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Sektor Perusahaan Id","name"=>"sektor_perusahaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"sektor_perusahaan,id"];
			//$this->form[] = ["label"=>"Status Data Id","name"=>"status_data_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status_data,id"];
			//$this->form[] = ["label"=>"Status Penanaman Modal Id","name"=>"status_penanaman_modal_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status_penanaman_modal,id"];
			//$this->form[] = ["label"=>"Status Perusahaan Id","name"=>"status_perusahaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status_perusahaan,id"];
			//$this->form[] = ["label"=>"Tgl Kep Izin Usaha","name"=>"tgl_kep_izin_usaha","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Tipe Perusahaan Id","name"=>"tipe_perusahaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"tipe_perusahaan,id"];
			//$this->form[] = ["label"=>"Tn Laki","name"=>"tn_laki","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Tn Wanita","name"=>"tn_wanita","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Wna","name"=>"wna","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        if(CRUDBooster::myPrivilegeId()==46) { //Admin naker
				$this->addaction[] = ['label'=>'Aktifkan','color'=>'warning','url'=>CRUDBooster::mainpath('aktifkan').'/[id]/3','showIf'=>'[status_data_id] != 3'];
			    $this->addaction[] = ['label'=>'Non-aktifkan','icon'=>'fa fa-chat','color'=>'danger','url'=>CRUDBooster::mainpath('aktifkan').'/[id]/1','showIf'=>'[status_data_id] == 3'];
	            
	        }


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();  
	        $this->table_row_color[] = ['condition'=>'[status_data_id] == 1','color'=>'info'];
	        $this->table_row_color[] = ['condition'=>'[status_data_id] == 2','color'=>'danger'];
	        $this->table_row_color[] = ['condition'=>'[status_data_id] == 3','color'=>'success'];

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    
	    public function getAktifkan($id,$stat){
	        if(CRUDBooster::myPrivilegeId()==46){
    	        DB::table('perusahaan')->where('id',$id)->update(['status_data_id'=>$stat]);
    	        $updated = DB::table('perusahaan')->where('id',$id)->first();
    	        if($stat==3){
    	            CRUDBooster::sendNotifikasi($updated->created_by,2,'Selamat ! Perusahaan ' . $updated->nama_perusahaan . ' telah diaktifkan.',CRUDBooster::adminPath());
    	        }else{
    	            CRUDBooster::sendNotifikasi($updated->created_by,2,'Mohon maaf ! Perusahaan ' . $updated->nama_perusahaan . ' telah dinon-aktifkan.',CRUDBooster::adminPath());
    	        }
	        }
	        return redirect(CRUDBooster::mainpath(''));
	    }

		// if(CRUDBooster::myPrivilegeId()==2){
		// 	public function getIndex() {
		// 		$data = [];
		// 		$data['app_name'] = "PERUSAHAAN";
				
				
		// 		if(CRUDBooster::myPrivilegeId()==2){
					
		// 			return redirect(CRUDBooster::adminPath(''));
		// 		}
				
				
		// 	}
		// }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {   
			$postdata['created_by'] = CRUDBooster::myId();  
			$postdata['updated_by'] = CRUDBooster::myId();     
			$postdata['status_data_id'] = 1; 
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {
	        if(CRUDBooster::myPrivilegeId()==2){
    	        $added = DB::table('perusahaan')->where('id',$id)->first();
    	        CRUDBooster::sendNotifikasi(0,46, CRUDBooster::myName() . ' Mendaftarkan Perusahaan ' . $added->nama_perusahaan ,CRUDBooster::adminPath('perusahaan/detail/'.$id).'?activate_mode=3');
	        }
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {     
			$postdata['updated_by'] = CRUDBooster::myId(); 
			if(CRUDBooster::myPrivilegeId()==2){
			    $postdata['status_data_id'] = 2;
			}
	        //Your code here
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
			if(CRUDBooster::myPrivilegeId()==2){
    	        $updated = DB::table('perusahaan')->where('id',$id)->first();
    	        CRUDBooster::sendNotifikasi(0,46, CRUDBooster::myName() . ' Mengubah Data Perusahaan ' . $updated->nama_perusahaan ,CRUDBooster::adminPath('perusahaan/detail/'.$id).'?activate_mode=3');
	        }
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}