<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminProdukController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_produk_jasa";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = false;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = false;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "produk";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
		//	$this->col[] = ["label"=>"Gambar","name"=>"(SELECT file FROM photo_produk WHERE produk_id = produk.id LIMIT 1) as gambar","callback_php"=> $row->gambar,"image"=>true];
			$this->col[] = ["label"=>"Nama Produk","name"=>"nama_produk_jasa"];
		//	$this->col[] = ["label"=>"Harga","name"=>"(SELECT CONCAT(mata_uang.simbol,' ',harga) FROM produk JOIN mata_uang ON mata_uang.id = produk.mata_uang_id) as price","callback_php"=>$row->price];
			$this->col[] = ["label"=>"Mata Uang","name"=>"mata_uang_id","join"=>"mata_uang,simbol"];
			$this->col[] = ["label"=>"Harga","name"=>"harga"];
			$this->col[] = ["label"=>"Umkm Usaha","name"=>"umkm_usaha_id","join"=>"umkm_usaha,nama_usaha"];
			$this->col[] = ["label"=>"Tempat","name"=>"lokasi_id","join"=>"lokasi,nama"];
		//	$this->col[] = ["label"=>"Deskripsi Singkat","name"=>"deskripsi_singkat"];
		//	$this->col[] = ["label"=>"Deskripsi Produk","name"=>"deskripsi_produk"];
		 //   $this->col[] = ["label"=>"Berat","name"=>"(SELECT CONCAT(berat,' ', berat.simbol) FROM produk JOIN berat ON berat.id = produk.satuan_berat ) as berat","callback_php"=>$row->berat];
	    	$this->col[] = ["label"=>"Berat","name"=>"berat"];
	    	$this->col[] = ["label"=>"Satuan","name"=>"satuan_berat","join"=>"berat,simbol"];
	    	$this->col[] = ["label"=>"Kategori","name"=>"kategori_produk_id","join"=>"kategori_produk,nama_kategori"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Nama Produk','name'=>'nama_produk_jasa','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Harga','name'=>'harga','type'=>'money','validation'=>'required','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Mata Uang','name'=>'mata_uang_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-6','datatable'=>'mata_uang,nama_mt','value'=>1];
			
			$columns[] = ['label'=>'Photo','name'=>'file','type'=>'upload','upload_type'=>'image'];
			//$columns[] = ['label'=>'Tabel','name'=>'nama_tabel','type'=>'tabel'];
			
			$this->form[] = ['label'=>'Photo Produk','name'=>'photo_produk','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'photo_produk','parent'=>'produk','foreign_key'=>'produk_id'];
			
			$this->form[] = ['label'=>'Usaha','name'=>'umkm_usaha_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6','datatable'=>'umkm_usaha,nama_usaha'];
			$this->form[] = ['label'=>'Lokasi','name'=>'lokasi_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6','datatable'=>'lokasi,nama'];
			$this->form[] = ['label'=>'Deskripsi Singkat','name'=>'deskripsi_singkat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Deskripsi Produk','name'=>'deskripsi_produk','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-8'];
			$this->form[] = ['label'=>'Berat','name'=>'berat','type'=>'number','validation'=>'required|min:1|max:1000','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Satuan Berat','name'=>'satuan_berat','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-6','datatable'=>'berat,nama_berat','value'=>1];
			$this->form[] = ['label'=>'Kategori','name'=>'kategori_produk_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-6','datatable'=>'kategori_produk,nama_kategori'];
		//	$this->form[] = ['label'=>'Kategori Produk','name'=>'kategori_produk','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'Status Produk','name'=>'status_produk','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Status Produk','name'=>'status_produk','type'=>'radio','width'=>'col-sm-6','dataenum'=>'1|Tersedia;0|Habis;-1|Sembunyikan','validation'=>'required'];
// 			$this->form[] = ['label'=>'Etalase Id','name'=>'etalase_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'etalase,id'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4', 'value' => CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Nama Produk Jasa","name"=>"nama_produk_jasa","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Harga","name"=>"harga","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Mata Uang Id","name"=>"mata_uang_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"mata_uang,id"];
			//$this->form[] = ["label"=>"Umkm Usaha Id","name"=>"umkm_usaha_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"umkm_usaha,nama_usaha"];
			//$this->form[] = ["label"=>"Deskripsi Singkat","name"=>"deskripsi_singkat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Deskripsi Produk","name"=>"deskripsi_produk","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Berat","name"=>"berat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Satuan Berat","name"=>"satuan_berat","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Kategori Produk","name"=>"kategori_produk","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Status Produk","name"=>"status_produk","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Etalase Id","name"=>"etalase_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"etalase,id"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}