<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminPutusanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "judul";
			$this->limit = "20";
			$this->orderby = "tahun,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "peraturan";
			$this->parent_id = 4;
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Jenis Putusan","name"=>"jenis_id","join"=>"tipe_dokumen,nama"];
			$this->col[] = ["label"=>"Judul","name"=>"judul"];
			$this->col[] = ["label"=>"T.E.U Badan","name"=>"teu"];
			$this->col[] = ["label"=>"Nomor Putusan","name"=>"nomor"];
			$this->col[] = ["label"=>"Jenis Peradilan","name"=>"jenis_peradilan"];
			$this->col[] = ["label"=>"Singkatan Jenis Peradilan","name"=>"singkatan_jenis"];
			$this->col[] = ["label"=>"Tempat Peradilan","name"=>"tempat"];
			$this->col[] = ["label"=>"Tanggal Dibacakan","name"=>"tanggal"];
			$this->col[] = ["label"=>"Sumber","name"=>"sumber"];
			$this->col[] = ["label"=>"Subjek","name"=>"(SELECT GROUP_CONCAT(subjek.subjek) FROM subjek JOIN peraturan_subjek ON peraturan_subjek.id_subjek = subjek.id WHERE peraturan_subjek.id_peraturan=peraturan.id) as subjek","callback_php"=>"$row->subjek"];
			$this->col[] = ["label"=>"Status Putusan","name"=>"status"];
			$this->col[] = ["label"=>"Bahasa","name"=>"bahasa_id","join"=>"bahasa,bahasa"];
			$this->col[] = ["label"=>"Bidang Hukum","name"=>"(SELECT GROUP_CONCAT(bidang_hukum.bidang_hukum) FROM bidang_hukum JOIN peraturan_bidang_hukum ON peraturan_bidang_hukum.id_bidang_hukum = bidang_hukum.id WHERE peraturan_bidang_hukum.id_peraturan=peraturan.id) as bidang_hukum","callback_php"=>"$row->bidang_hukum"];
			$this->col[] = ["label"=>"Lampiran","name"=>"lampiran","download"=>true];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Jenis Putusan','name'=>'jenis_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-5','datatable'=>'tipe_dokumen,nama','datatable_where'=>'parent_id='.$this->parent_id];
			$this->form[] = ['label'=>'Judul','name'=>'judul','type'=>'text','validation'=>'required|string|min:7','width'=>'col-sm-7','help'=>'*Format : Nama jenis putusan - nomor putusan -tahun putusan - para pihak yang berperkara'];
			$this->form[] = ['label'=>'Nomor Putusan','name'=>'nomor','type'=>'text','validation'=>'required|string|min:7','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Jenis Peradilan','name'=>'jenis_peradilan','type'=>'text','validation'=>'required|string|min:7','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Singkatan Jenis Peradilan','name'=>'singkatan_jenis','type'=>'text','validation'=>'required|string|min:1','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Tempat Peradilan','name'=>'tempat','type'=>'text','validation'=>'required|string|min:7','width'=>'col-sm-7'];
			$this->form[] = ['label'=>'Tanggal Dibacakan','name'=>'tanggal','type'=>'date','validation'=>'required','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Sumber','name'=>'sumber','type'=>'text','validation'=>'required|string|min:7','width'=>'col-sm-7'];
			$this->form[] = [
				"label" => 'Subjek',
				"name" => 'peraturan_subjek',
				"type" => "select2",
				"select2_multiple" => true,
				"datatable" => "subjek,subjek,id",
				"relationship_table" => "peraturan_subjek",
				"required" => true,
			];
			
			$this->form[] = ['label'=>'Status Putusan','name'=>'status','type'=>'text','validation'=>'required|string|min:3','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Bahasa','name'=>'bahasa_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-3','datatable'=>'bahasa,bahasa'];
			$this->form[] = [
				"label" => 'Bidang Hukum',
				"name" => 'peraturan_bidang_hukum',
				"type" => "select2",
				"select2_multiple" => true,
				"datatable" => "bidang_hukum,bidang_hukum,id",
				"relationship_table" => "peraturan_bidang_hukum",
				"required" => true,
			];
			$this->form[] = ['label'=>'Lampiran','name'=>'lampiran','type'=>'upload','validation'=>'required','width'=>'col-sm-7','help'=>'*Format : 4 digit tahun perkara+singkatan peradilan+4 digit kode wilayah+nomor putusan'];
			$this->form[] = ['label'=>'Created By Priv','name'=>'created_by','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-10','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Created By','name'=>'created_by_priv','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-10','value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Bahasa Id","name"=>"bahasa_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"bahasa,id"];
			//$this->form[] = ["label"=>"Bidang Hukum Id","name"=>"bidang_hukum_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"bidang_hukum,id"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Created By Priv","name"=>"created_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Deskripsi Fisik","name"=>"deskripsi_fisik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Dokumen Terkait","name"=>"dokumen_terkait","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Edisi","name"=>"edisi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Gambar Sampul","name"=>"gambar_sampul","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Jenis Id","name"=>"jenis_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"jenis,id"];
			//$this->form[] = ["label"=>"Judul","name"=>"judul","type"=>"text","required"=>TRUE,"validation"=>"required|string|min:3|max:70","placeholder"=>"Anda hanya dapat memasukkan huruf saja"];
			//$this->form[] = ["label"=>"Lampiran","name"=>"lampiran","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Lokasi Id","name"=>"lokasi_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"lokasi,nama"];
			//$this->form[] = ["label"=>"Nomor","name"=>"nomor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nomor Panggil","name"=>"nomor_panggil","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Pemrakarsa","name"=>"pemrakarsa","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Penandatangan","name"=>"penandatangan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Penerbit","name"=>"penerbit","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Peraturan Terkait","name"=>"peraturan_terkait","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Singkatan Jenis","name"=>"singkatan_jenis","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Status","name"=>"status","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Subjek Id","name"=>"subjek_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"subjek,id"];
			//$this->form[] = ["label"=>"Sumber","name"=>"sumber","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tahun","name"=>"tahun","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Tanggal","name"=>"tanggal","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Tanggal2","name"=>"tanggal2","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Tempat","name"=>"tempat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Teu","name"=>"teu","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Urusan","name"=>"urusan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        $tipe = DB::table('tipe_dokumen')->where('parent_id',$this->parent_id)->pluck('id');

	        $query->whereIn('jenis_id', $tipe);
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        $postdata['created_at'] = now();

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}