<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;

	class AdminSkbmrWargaController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = true;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat_masuk";
			$this->jenis_surat_id = 2;
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Tanggal","name"=>"created_at"];
			$this->col[] = ["label"=>"Surat","name"=>"(select nama_surat from surat where id = surat_masuk.jenis_surat_id) as jenis_surat", "callback_php"=>"$row->jenis_surat"];
			$this->col[] = ["label"=>"Keperluan","name"=>"keperluan"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			$this->col[] = ["label"=>"Oleh","name"=>"status_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Level","name"=>"status_by_priv","join"=>"cms_privileges,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			//$this->form[] = ['label'=>'Metode','name'=>'metode','type'=>'text','visible'=>'false', 'width'=>'col-sm-4',"readonly"=>true,value=>CRUDBooster::getCurrentMethod()];
			$this->form[] = ['label'=>'ID','name'=>'id','type'=>'hidden','width'=>'col-sm-4',"readonly"=>true];
			//$this->form[] = ["label"=>"Persyaratan","name"=>"persyaratan","type"=>"child","controller"=>"AdminPersyaratanController"];
			//$this->form[] = ['label'=>'Surat Masuk','name'=>'surat_masuk_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'surat_masuk,id'];
			$this->form[] = ['label'=>'Nomor','name'=>'nomor','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-4',"readonly"=>true];
			$this->form[] = ['label'=>'Jenis Surat','name'=>'jenis_surat_id','type'=>'hidden','validation'=>'required','width'=>'col-sm-9','datamodal_table'=>'surat','datamodal_columns'=>'nama_surat,template_file',"value"=>$this->jenis_surat_id];
// 			$this->form[] = ['label'=>'Tanggal Pernyataan','name'=>'tgl_pernyataan','type'=>'date','validation'=>'required|date','width'=>'col-sm-4'];
// 			$this->form[] = ['label'=>'Nomor SK RT','name'=>'no_sk_rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
// 			$this->form[] = ['label'=>'Tanggal SK RT','name'=>'tgl_sk_rt','type'=>'date','validation'=>'required|date','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'NIK','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','placeholder'=>'Anda hanya dapat memasukkan angka saja','value' => CRUDBooster::me()->nik,"readonly"=>true];
			$this->form[] = ["label"=>"Nama","name"=>"nama_lgkp",'required'=>true,'type'=>'text','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->nama_lgkp,"readonly"=>true];
			
			$this->form[] = ['label'=>'Tempat Lahir','name'=>'tmpt_lhr','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->tmpt_lhr,"readonly"=>true];
			$this->form[] = ['label'=>'Tanggal Lahir','name'=>'tgl_lhr','type'=>'date','validation'=>'required|date','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->tgl_lhr,"readonly"=>true];
			$this->form[] = ['label'=>'Alamat','name'=>'alamat','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->alamat2,"readonly"=>true];
			$this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->rt,"readonly"=>true];
			$this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->rw,"readonly"=>true];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'districts,name','datatable_where'=>'regency_id ='.CRUDBooster::getSetting('kode_kabupaten'),'value' => CRUDBooster::menik(CRUDBooster::me()->nik)->nama_kec,"readonly"=>true];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'villages,name','datatable_where'=>'district_id like "'.CRUDBooster::getSetting('kode_kabupaten').'%"','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->nama_kel,"readonly"=>true];
			$this->form[] = ['label'=>'Jenis Kelamin','name'=>'jk','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'L|Laki-laki;P|Perempuan','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->jk,"readonly"=>true];
			//$this->form[] = ['label'=>'Ket Warneg','name'=>'ket_warneg','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Warga Negara','name'=>'wn','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Indonesia;Asing'];
			$this->form[] = ['label'=>'Agama','name'=>'agama','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Islam;Kristen;Katolik;Hindu;Budha'];
			$this->form[] = ['label'=>'Status Perkawinan','name'=>'status_kawin','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Lajang;Menikah;Janda;Duda'];
			//$this->form[] = ['label'=>'Golongan Darah','name'=>'gol_darah','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'-;A;B;AB;O'];
			$this->form[] = ['label'=>'Pekerjaan','name'=>'pekerjaan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->pekerjaan,"readonly"=>true];
			$this->form[] = ['label'=>'No Telp','name'=>'no_telp','type'=>'text','validation'=>'required|min:1|max:16','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->telp,"readonly"=>true];
			//$this->form[] = ['label'=>'No Pengantar Rt','name'=>'no_pengantar_rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Tgl Pengantar Rt','name'=>'tgl_pengantar_rt','type'=>'date','validation'=>'required|date','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'File Pengantar Rt','name'=>'file_pengantar_rt','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Keperluan','name'=>'keperluan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-8'];
			
			//$columns[] = ['label'=>'User ID','name'=>'user_id','type'=>'hidden','required'=>true,'value' => CRUDBooster::myId()];
			//$columns[] = ['label'=>'No Surat Pengantar RT/RW','name'=>'file','type'=>'text','required'=>true];
			//$this->form[] = ['label'=>'Data Pendukung','name'=>'unggahan','type'=>'child','columns'=>$columns,'table'=>'unggahan','foreign_key'=>'surat_masuk_id'];
			
			//$this->form[] = ['label'=>'Verif Ket Rt Id','name'=>'verif_ket_rt_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Verif Lurah Id','name'=>'verif_lurah_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Verif Camat Id','name'=>'verif_camat_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Verif Kapolsek Id','name'=>'verif_kapolsek_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'verif_ket_rt,id'];
			
			 //$this->form[] = ['label'=>'Status','name'=>'status_id','type'=>'text','validation'=>'integer|min:0','width'=>'col-sm-4',"readonly"=>true];
			 $this->form[] = ['label'=>'Tertanda','name'=>'created_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Surat Masuk Id","name"=>"surat_masuk_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"surat_masuk,id"];
			//$this->form[] = ["label"=>"Jenis Surat Id","name"=>"jenis_surat_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"jenis_surat,id"];
			//$this->form[] = ["label"=>"Mode Nik","name"=>"mode_nik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama","name"=>"nama","type"=>"text","required"=>TRUE,"validation"=>"required|string|min:3|max:70","placeholder"=>"Anda hanya dapat memasukkan huruf saja"];
			//$this->form[] = ["label"=>"Nik","name"=>"nik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Tempat Lahir","name"=>"tempat_lahir","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tanggal Lahir","name"=>"tanggal_lahir","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Alamat","name"=>"alamat","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Rt","name"=>"rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Rw","name"=>"rw","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"District Id","name"=>"district_id","type"=>"select2","required"=>TRUE,"validation"=>"required|min:1|max:255","datatable"=>"district,id"];
			//$this->form[] = ["label"=>"Village Id","name"=>"village_id","type"=>"select2","required"=>TRUE,"validation"=>"required|min:1|max:255","datatable"=>"village,id"];
			//$this->form[] = ["label"=>"Jenis Kelamin","name"=>"jenis_kelamin","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Warga Negara","name"=>"warga_negara","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Ket Warneg","name"=>"ket_warneg","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Agama","name"=>"agama","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Status Kawin","name"=>"status_kawin","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Gol Darah","name"=>"gol_darah","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Pekerjaan","name"=>"pekerjaan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"No Telp","name"=>"no_telp","type"=>"number","required"=>TRUE,"validation"=>"required|numeric","placeholder"=>"Anda hanya dapat memasukkan angka saja"];
			//$this->form[] = ["label"=>"No Pengantar Rt","name"=>"no_pengantar_rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tgl Pengantar Rt","name"=>"tgl_pengantar_rt","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"File Pengantar Rt","name"=>"file_pengantar_rt","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Keperluan","name"=>"keperluan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Verif Ket Rt Id","name"=>"verif_ket_rt_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"verif_ket_rt,id"];
			//$this->form[] = ["label"=>"Verif Lurah Id","name"=>"verif_lurah_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"verif_lurah,id"];
			//$this->form[] = ["label"=>"Verif Camat Id","name"=>"verif_camat_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"verif_camat,id"];
			//$this->form[] = ["label"=>"Verif Kapolsek Id","name"=>"verif_kapolsek_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"verif_kapolsek,id"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Status","name"=>"status","type"=>"hidden","required"=>TRUE,"validation"=>"required|integer|min:0"];
			
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	       // $this->load_js = array();
			$this->load_js[] = asset("js/pelayanan.js");
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css[] = asset("css/syarat_head.css");
	        
	        
	    }
		
		public function postAddSave(){
			//var_dump(Request::input());
			$last_id = DB::table('surat_masuk')->insertGetId([
					'jenis_surat_id' => Request::input('jenis_surat_id'),
					//'jenis_surat_id' => $this->jenis_surat_id,
					'nik' => Request::input('nik'),
					'nama_lgkp' => Request::input('nama_lgkp'),
					'tmpt_lhr' => Request::input('tmpt_lhr'),
					'tgl_lhr' => Request::input('tgl_lhr'),
					'alamat' => Request::input('alamat'),
					'rt' => Request::input('rt'),
					'rw' => Request::input('rw'),
					'district_id' => Request::input('district_id'),
					'village_id' => Request::input('village_id'),
					'jk' => Request::input('jk'),
					'agama' => Request::input('agama'),
					'status_kawin' => Request::input('status_kawin'),
					'pekerjaan' => Request::input('pekerjaan'),
					'no_telp' => Request::input('no_telp'),
					'no_sk_rt' => Request::input('no_sk_rt'),
					'tgl_pernyataan' => Request::input('tgl_pernyataan'),
					'tgl_sk_rt' => Request::input('tgl_sk_rt'),
					'keperluan' => Request::input('keperluan'),
					'created_at' => Carbon::now(),
					'created_by' => CRUDBooster::myId(),
					'status_id' => 1,
					'status_by' => CRUDBooster::myId(),
					'status_by_priv' => CRUDBooster::myPrivilegeId()
				]);
			
			for($i=1;$i<=Request::input('add-cnt');$i++){
				DB::table('unggahan')->insert([
					'user_id' => CRUDBooster::myId(),
					'surat_masuk_id' => $last_id,
					'syarat_id' => Request::input('add-2-'.$i),
					'file' => Request::input('add-1-'.$i)
				]);
			}
			
			DB::table('verifikasi_surat')->insert([
						'user_id' => CRUDBooster::myId(),
						'privilege_id' => CRUDBooster::myPrivilegeId(),
						'jenis_surat_id' => Request::input('jenis_surat_id'),
						'surat_id' => $last_id,
						'token' => " ",
						'aksi' => 1,
					]);
			
			// $config['content'] = CRUDBooster::myName() . " membuat permohonan SKCK";
			// $config['to'] = CRUDBooster::adminPath('surat_masuk/' . $id);
			
			//cari grup users
			//$notified_user = CRUDBooster::userDalamNotasi(Request::input('jenis_surat_id'),CRUDBooster::adminPath('surat_masuk/' . $id));
			
			// $config['id_cms_users'] = $notified_user;
			
			// CRUDBooster::sendNotification($config);
			
			CRUDBooster::notifUserTerlibat(Request::input('jenis_surat_id'),CRUDBooster::myName() . " membuat permohonan SKCK",CRUDBooster::adminPath('surat_masuk/' . $id));
			
			return CRUDBooster::redirect(CRUDBooster::adminPath('skbmr_warga'),'Berhasil Membuat Permohonan.','info');
		}
		
		public function postEditSave($id){
			var_dump(Request::input());
			$last_id = DB::table('surat_masuk')
					->where('id', $id)
					->update([					
					'agama' => Request::input('agama'),
					'status_kawin' => Request::input('status_kawin'),
					'no_telp' => Request::input('no_telp'),					
					'no_sk_rt' => Request::input('no_sk_rt'),
					'tgl_sk_rt' => Request::input('tgl_sk_rt'),
					'keperluan' => Request::input('keperluan'),
					'created_by' => CRUDBooster::myId(),
					'status_id' => 1,
					'status_by' => CRUDBooster::myId(),
					'status_by_priv' => CRUDBooster::myPrivilegeId()
				]);
			
			for($i=1;$i<=Request::input('add-cnt');$i++){
				DB::table('unggahan')
						->where('id', Request::input('add-id-'.$i))
						->update([
					'file' => Request::input('add-1-'.$i)
				]);
			}
			
			DB::table('verifikasi_surat')->insert([
						'user_id' => CRUDBooster::myId(),
						'privilege_id' => CRUDBooster::myPrivilegeId(),
						'jenis_surat_id' => Request::input('jenis_surat_id'),
						'surat_id' => $last_id,
						'token' => " ",
						'aksi' => 1,
					]);
			
			//singkatan surat masih bisa dinamis tapi masi koler
			CRUDBooster::notifUserTerlibat(Request::input('jenis_surat_id'),CRUDBooster::myName() . " mengubah permohonan SKBMR",CRUDBooster::adminPath('surat_masuk/' . $id));
			
			return CRUDBooster::redirect(CRUDBooster::adminPath('skbmr_warga'),'Berhasil Mungubah Permohonan.','info');
		}

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        $query->where('surat_masuk.nik',CRUDBooster::me()->nik);
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {   
		   $postdata['jenis_surat_id']	= $this->jenis_surat_id;	//skbmr
	       $postdata['status_id'] = 1; //baru
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here
			// $data['jenis_surat_id']	= 1;
			// $data['created_by']	= CRUDBooster::myId();
			// $data['created_at']	= Carbon::now();
			// $data['status_id']	= 1; //dibuat oleh warga
			// $data['surat_id']	= $id;
			// $idsurat = json_decode(app('App\Http\Controllers\SuratMasukController')->store($data)->getContent());
			//$postdata['surat_masuk_id'] = $idsurat->last_insert_id;
			//$row = CRUDBooster::first($this->table,$id);
			DB::table('verifikasi_surat')->insert([
						'user_id' => CRUDBooster::myId(),
						'privilege_id' => CRUDBooster::myPrivilegeId(),
						'jenis_surat_id' => $this->jenis_surat,
						'surat_id' => $id,
						'token' => " ",
						'aksi' => 1,
					]);
			
			$config['content'] = CRUDBooster::myName() . " membuat permohonan SKBMR";
			$config['to'] = CRUDBooster::adminPath('skbmr_warga/' . $id);
			//cari rt
			$config['id_cms_users'] = [1,3];
			
			CRUDBooster::sendNotification($config);
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 



	    //By the way, you can still create your own method in here... :) 


	}