<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use SuratMasuk;
	use Carbon;
	//use Debugbar;
	use User;
	use Barryvdh\DomPDF\Facade as PDF;
	use \PhpOffice\PhpWord as WORD;
	use File;

	class AdminSkckController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = true;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "skck";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			//$this->col[] = ["label"=>"Jenis Surat","name"=>"jenis_surat_id","join"=>"surat,nama_surat"];
			//$this->col[] = ["label"=>"Surat Masuk Id","name"=>"surat_masuk_id"];
			$this->col[] = ["label"=>"Tanggal","name"=>"created_at","join"=>"surat_masuk,created_at"];
			$this->col[] = ["label"=>"Nik","name"=>"nik"];
			$this->col[] = ["label"=>"Nama","name"=>"nama"];
			$this->col[] = ["label"=>"Alamat","name"=>"alamat"];
			$this->col[] = ["label"=>"Nomor Telepon","name"=>"no_telp"];
			//$this->col[] = ["label"=>"Verif Ket_rt_id","name"=>"verif_ket_rt_id"];
			//$this->col[] = ["label"=>"Verif Lurah_id","name"=>"verif_lurah_id"];
			//$this->col[] = ["label"=>"Verif Camat_id","name"=>"verif_camat_id"];
			//$this->col[] = ["label"=>"Verif Kapolsek_id","name"=>"verif_kapolsek_id"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			//$this->col[] = ["label"=>"Status","name"=>"(select status from status_surat where id = skck.status_id) as status","callback_php"=>"$row->status"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Jenis Surat','name'=>'jenis_surat_id','type'=>'datamodal','validation'=>'required','width'=>'col-sm-9','datamodal_table'=>'surat','datamodal_columns'=>'nama_surat,template_file'];
			$this->form[] = ['label'=>'Surat Masuk Id','name'=>'surat_masuk_id','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-2'];
			//$this->form[] = ['label'=>'Mode Input','name'=>'mode_nik','type'=>'radio','validation'=>'required|min:1|max:255','width'=>'col-sm-6','dataenum'=>'1|Dari eKTP;2|Manual','value'=>1];
			$this->form[] = ['label'=>'NIK','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6','placeholder'=>'Masukkan NIK Anda'];
			$this->form[] = ['label'=>'PILIH NIK','name'=>'warga_bjb_id','type'=>'datamodal','width'=>'col-sm-6','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp','datamodal_size'=>'large','datamodal_columns_alias'=>'NIK,NAMA','datamodal_select_to'=>'nik:nik,nama_lgkp:nama,tmpt_lhr:tempat_lahir,tgl_lhr:tanggal_lahir,alamat:alamat,nama_kec:district_id,nama_kel:village_id'];
			$this->form[] = ['label'=>'Nama','name'=>'nama','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Tempat Lahir','name'=>'tempat_lahir','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Tanggal Lahir','name'=>'tanggal_lahir','type'=>'date','validation'=>'required|date','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Alamat','name'=>'alamat','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'districts,name','datatable_where'=>'regency_id = 6372'];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'villages,name','datatable_where'=>'district_id like "6372%"'];
			$this->form[] = ['label'=>'Jenis Kelamin','name'=>'jenis_kelamin','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'L|Laki-laki;P|Perempuan'];
			$this->form[] = ['label'=>'Warga Negara','name'=>'warga_negara','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Indonesia;Asing'];
			$this->form[] = ['label'=>'Agama','name'=>'agama','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Islam;Kristen;Katolik;Hindu;Budha'];
			$this->form[] = ['label'=>'Status Perkawinan','name'=>'status_kawin','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Lajang;Menikah;Janda;Duda'];
			$this->form[] = ['label'=>'Golongan Darah','name'=>'gol_darah','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'-;A;B;AB;O'];
			$this->form[] = ['label'=>'Pekerjaan','name'=>'pekerjaan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'No Telp','name'=>'no_telp','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-6','placeholder'=>'You can only enter the number only'];
			$this->form[] = ['label'=>'Surat Pengantar RT','name'=>'no_pengantar_rt','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Tanggal  Pengantar RT','name'=>'tgl_pengantar_rt','type'=>'date','validation'=>'date','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'File Pengantar RT','name'=>'file_pengantar_rt','type'=>'upload','validation'=>'string','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Keperluan','name'=>'keperluan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Verif Ket Rt Id','name'=>'verif_ket_rt_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6','datatable'=>'verifikasi_surat,id'];
			//$this->form[] = ['label'=>'Verif Lurah Id','name'=>'verif_lurah_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Verif Camat Id','name'=>'verif_camat_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Verif Kapolsek Id','name'=>'verif_kapolsek_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ['label'=>'Surat Masuk Id','name'=>'surat_masuk_id','type'=>'text','validation'=>'integer|min:0','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'NIK','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6','placeholder'=>'Masukkan NIK Anda'];
			//$this->form[] = ['label'=>'PILIH NIK','name'=>'nik','type'=>'datamodal','width'=>'col-sm-6','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp','datamodal_size'=>'large'];
			//$this->form[] = ['label'=>'Nama','name'=>'nama','type'=>'text','validation'=>'required|string|min:3|max:70','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Tempat Lahir','name'=>'tempat_lahir','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Tanggal Lahir','name'=>'tanggal_lahir','type'=>'date','validation'=>'required|date','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Alamat','name'=>'alamat','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Jenis Kelamin','name'=>'jenis_kelamin','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'Warga Negara','name'=>'warga_negara','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Indonesia;Asing'];
			//$this->form[] = ['label'=>'Agama','name'=>'agama','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-7','dataenum'=>'Islam;Kristen;Katolik;Hibu;Budha'];
			//$this->form[] = ['label'=>'Status Perkawinan','name'=>'status_kawin','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Lajang;Menikah;Janda;Duda'];
			//$this->form[] = ['label'=>'Golongan Darah','name'=>'gol_darah','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'-;A;B;AB;O'];
			//$this->form[] = ['label'=>'Pekerjaan','name'=>'pekerjaan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'No Telp','name'=>'no_telp','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-6','placeholder'=>'You can only enter the number only'];
			//$this->form[] = ['label'=>'Surat Pengantar RT','name'=>'no_pengantar_rt','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Tanggal  Pengantar RT','name'=>'tgl_pengantar_rt','type'=>'date','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'File Pengantar RT','name'=>'file_pengantar_rt','type'=>'upload','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Keperluan','name'=>'keperluan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Verif Ket Rt Id','name'=>'verif_ket_rt_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6','datatable'=>'verifikasi_surat,id'];
			//$this->form[] = ['label'=>'Verif Lurah Id','name'=>'verif_lurah_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Verif Camat Id','name'=>'verif_camat_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Verif Kapolsek Id','name'=>'verif_kapolsek_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-6'];
			//$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-4'];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
			$this->addaction[] = ['label'=>'','url'=>'http://localhost/paten/public/admin/skck/cetak-skck/[id]','target'=>'','icon'=>'fa fa-print'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	       // $this->load_js = array();
			$this->load_js[] = asset("js/skck.js");
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
		
		public function getCetakSkck($id)
		{
			//setlocale (LC_TIME, 'id_ID'); //linux
			setlocale (LC_TIME, 'INDONESIA');  //windows
			
			if(!CRUDBooster::isView()) CRUDBooster::denyAccess();
			$surat = DB::table('skck')
							->join('surat_masuk','skck.surat_masuk_id','=','surat_masuk.id')
							->join('surat','surat_masuk.jenis_surat_id','=','surat.id')
							->join('districts','skck.district_id','=','districts.id')
							->join('villages','skck.village_id','=','villages.id')
							->where('skck.id',$id)
							->select('skck.*', 'surat_masuk.jenis_surat_id', 'districts.name as kecamatan', 'villages.name as kelurahan', 'surat.kode', 'surat.nama_surat', 'surat.kode_depan', 'surat.kode_belakang', 'surat.model', 'surat.template_file')
							->first();
			
			

			
			$path = $surat->template_file;
			$fileName = storage_path('app/' . $path);
			$file = basename($path);         // $file is set to "index.php"
			$file = basename($path , ".docx");
			
			$templateProcessor = new WORD\TemplateProcessor($fileName);
			
			$templateProcessor->setValue('kecamatan', $surat->kecamatan);
			
			$templateProcessor->setValue('kelurahan', $surat->kelurahan);
			
			$templateProcessor->setValue('nomor_surat', $surat->kode_depan . $surat->id . $surat->kode_belakang);
			
			$templateProcessor->setValue('nama', $surat->nama);
			
			$templateProcessor->setValue('nik', $surat->nik);
			
			$templateProcessor->setValue('tempat_lahir', $surat->tempat_lahir);
			
			$date = strftime( "%d %B %Y", strtotime($surat->tanggal_lahir));
			
			$templateProcessor->setValue('tanggal_lahir', $date);
			
			$templateProcessor->setValue('alamat', $surat->alamat);
			
			if($surat->jenis_kelamin == "L"){
				$templateProcessor->setValue('jenis_kelamin', 'Laki-laki');
			}else{
				$templateProcessor->setValue('jenis_kelamin', 'Perempuan');
			}	
			
			$templateProcessor->setValue('warga_negara', $surat->warga_negara);
			
			$templateProcessor->setValue('agama', $surat->agama);
			
			$templateProcessor->setValue('status_perkawinan', $surat->status_kawin);
			
			$templateProcessor->setValue('golongan_darah', $surat->golongan_darah);
			
			$templateProcessor->setValue('pekerjaan', $surat->pekerjaan);
			
			$templateProcessor->setValue('rt', $surat->rt);
			
			$templateProcessor->setValue('rw', $surat->rw);
			
			$templateProcessor->setValue('keperluan', $surat->keperluan);
			
			$created_date = strftime( "%d %B %Y", strtotime($surat->created_at));
			
			$templateProcessor->setValue('tanggal', $created_date);
			
			$templateProcessor->saveAs(storage_path('surat_gen/skck' . $id . '.docx'));
			
			
			$data = [
				'docfile' => 'http://paten.banjarbarukota.go.id/storage/surat_gen/skck' . $id . '.docx'
			];
			
			
			//$this->cbView('viewdoc',$data);
			var_dump($data);
		}


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {
			$data['jenis_surat_id']	= 1;
			$data['created_by']	= CRUDBooster::myId();
			$data['created_at']	= now();
			$data['status_id']	= 3; //dibuat oleh operator
			$idsurat = json_decode(app('App\Http\Controllers\SuratMasukController')->store($data)->getContent());
			$postdata['surat_masuk_id'] = $idsurat->last_insert_id;
		}

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}