<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminSkshController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_lgkp";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = true;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat_masuk";
			$this->jenis_surat_id = 7;
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Tanggal","name"=>"created_at"];
			$this->col[] = ["label"=>"Surat","name"=>"(select nama_surat from surat where id = surat_masuk.jenis_surat_id) as jenis_surat","callback_php"=>'$row->jenis_surat'];
			$this->col[] = ["label"=>"Keperluan","name"=>"keperluan"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			$this->col[] = ["label"=>"Oleh","name"=>"status_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Level","name"=>"status_by_priv","join"=>"cms_privileges,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
	    	$this->form[] = ['label'=>'ID','name'=>'id','type'=>'hidden','width'=>'col-sm-4',"readonly"=>true];
			$this->form[] = ['label'=>'Nomor','name'=>'nomor','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-4',"readonly"=>true];
			$this->form[] = ['label'=>'Jenis Surat','name'=>'jenis_surat_id','type'=>'hidden','validation'=>'required','width'=>'col-sm-9','datamodal_table'=>'surat','datamodal_columns'=>'nama_surat,template_file',"value"=>7];
			//$this->form[] = ['label'=>'Nomor SK RT','name'=>'no_sk_rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'Tanggal SK RT','name'=>'tgl_sk_rt','type'=>'date','validation'=>'required|date','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'NIK','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','placeholder'=>'Anda hanya dapat memasukkan angka saja','value' => CRUDBooster::me()->nik,"readonly"=>true];
			$this->form[] = ["label"=>"Nama","name"=>"nama_lgkp",'required'=>true,'type'=>'text','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->nama_lgkp,"readonly"=>true];
			$this->form[] = ['label'=>'Tempat Lahir','name'=>'tmpt_lhr','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->tmpt_lhr,"readonly"=>true];
			$this->form[] = ['label'=>'Tanggal Lahir','name'=>'tgl_lhr','type'=>'date','validation'=>'required|date','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->tgl_lhr,"readonly"=>true];
			$this->form[] = ['label'=>'Alamat','name'=>'alamat','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->alamat2,"readonly"=>true];
			$this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->rt,"readonly"=>true];
			$this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->rw,"readonly"=>true];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'districts,name','datatable_where'=>'regency_id ='.CRUDBooster::getSetting('kode_kabupaten'),'value' => CRUDBooster::menik(CRUDBooster::me()->nik)->nama_kec,"readonly"=>true];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'villages,name','datatable_where'=>'district_id like "'.CRUDBooster::getSetting('kode_kabupaten').'%"','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->nama_kel,"readonly"=>true];
			$this->form[] = ['label'=>'Jenis Kelamin','name'=>'jk','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'L|Laki-laki;P|Perempuan','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->jk,"readonly"=>true];
		//	$this->form[] = ['label'=>'Agama','name'=>'agama','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Islam;Kristen;Katolik;Hindu;Budha'];
		//	$this->form[] = ['label'=>'Status Perkawinan','name'=>'status_kawin','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Lajang;Menikah;Janda;Duda'];
			$this->form[] = ['label'=>'Pekerjaan','name'=>'pekerjaan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->pekerjaan,"readonly"=>true];
			$this->form[] = ['label'=>'No Telp','name'=>'no_telp','type'=>'text','validation'=>'required|min:1|max:16','width'=>'col-sm-4','value' => CRUDBooster::menik(CRUDBooster::me()->nik)->telp];

			$this->form[] = ['label'=>'Keperluan','name'=>'keperluan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-8'];
			
			$columns[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
			$columns[] = ['label'=>'Keterangan','name'=>'caption','type'=>'text'];
			$this->form[] = ['label'=>'Upload Lampiran','name'=>'media','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'media','parent'=>'sksh','foreign_key'=>'id_ortu'];
			 $this->form[] = ['label'=>'Tertanda','name'=>'created_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Jenis Surat Id","name"=>"jenis_surat_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"jenis_surat,id"];
			//$this->form[] = ["label"=>"Nomor","name"=>"nomor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nik","name"=>"nik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Lgkp","name"=>"nama_lgkp","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tmpt Lhr","name"=>"tmpt_lhr","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tgl Lhr","name"=>"tgl_lhr","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Alamat","name"=>"alamat","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Rt","name"=>"rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Rw","name"=>"rw","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"District Id","name"=>"district_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"district,id"];
			//$this->form[] = ["label"=>"Village Id","name"=>"village_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"village,id"];
			//$this->form[] = ["label"=>"Jk","name"=>"jk","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Wn","name"=>"wn","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Ket Wn","name"=>"ket_wn","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Agama","name"=>"agama","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Status Kawin","name"=>"status_kawin","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Gol Darah","name"=>"gol_darah","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Pekerjaan","name"=>"pekerjaan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"No Telp","name"=>"no_telp","type"=>"number","required"=>TRUE,"validation"=>"required|numeric","placeholder"=>"Anda hanya dapat memasukkan angka saja"];
			//$this->form[] = ["label"=>"Keperluan","name"=>"keperluan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Tgl Pernyataan","name"=>"tgl_pernyataan","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"No Sk Rt","name"=>"no_sk_rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tgl Sk Rt","name"=>"tgl_sk_rt","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Penghasilan","name"=>"penghasilan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Foto Sk Rt","name"=>"foto_sk_rt","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			//$this->form[] = ["label"=>"Status By","name"=>"status_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Status By Priv","name"=>"status_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Notasi","name"=>"notasi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Expired At","name"=>"expired_at","type"=>"datetime","required"=>TRUE,"validation"=>"required|date_format:Y-m-d H:i:s"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}