<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;

	class AdminSuratBelumPunyaRumahController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat_belum_punya_rumah";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Nomor","name"=>"nomor"];
			$this->col[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Nomor SKRT","name"=>"no_sk_rt"];
			$this->col[] = ["label"=>"Keperluan","name"=>"keperluan"];
// 			$this->col[] = ["label"=>"Pejabat","name"=>"pejabat_id","join"=>"pejabat,nama_pejabat"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			//$this->form[] = ['label'=>'Surat','name'=>'jenis_surat_id','type'=>'text','width'=>'col-sm-4','value'=>2];
			if(CRUDBooster::myPrivilegeId()==2){
			    $this->form[] = ['label'=>'User id','name'=>'cms_user_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			    $this->form[] = ['label'=>'Warga id','name'=>'warga_bjb_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::menik(CRUDBooster::me()->nik)->id];
			    
			}else{
		    	$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|min:1|max:255','width'=>'col-sm-8','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK','Nama Lengkap','Tempat Lahir','Tanggal Lahir'];
			}
			//$this->form[] = ['label'=>'Upload SKRT','name'=>'sk_rt','type'=>'upload','validation'=>'max:5000','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Deskripsi','name'=>'deskripsi','type'=>'textarea','validation'=>'min:1|max:255','width'=>'col-sm-5','value' => "Nama : " . CRUDBooster::menik(CRUDBooster::me()->nik)->nama_lgkp . "\nNIK : " . CRUDBooster::me()->nik . "\nTTL : " . CRUDBooster::menik(CRUDBooster::me()->nik)->tmpt_lhr . "," .CRUDBooster::menik(CRUDBooster::me()->nik)->tgl_lhr . ". \nAlamat : " . CRUDBooster::menik(CRUDBooster::me()->nik)->alamat . "\n\nMengajukan permohonan Surat Keterangan Belum Memiliki Rumah.","readonly"=>true];
			$this->form[] = ['label'=>'Agama','name'=>'agama','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Islam;Katolik;Protestan;Budha;Hindu'];
			$this->form[] = ['label'=>'Status Perkawinan','name'=>'status_perkawinan','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','dataenum'=>'Lajang;Menikah;Janda;Duda'];
			$this->form[] = ['label'=>'Keperluan','name'=>'keperluan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Upload Pengantar RT','name'=>'file_sk_rt','type'=>'upload','validation'=>'max:5000','width'=>'col-sm-5',"help"=>"*opsional"];
			$this->form[] = ['label'=>'Nomor Pengantar RT','name'=>'no_sk_rt','type'=>'text','validation'=>'max:50','width'=>'col-sm-3',"help"=>"Wajib mengisikan nomor pengantar setelah mengupload file"];
			$this->form[] = ['label'=>'Tanggal Pengantar RT','name'=>'tgl_sk_rt','type'=>'date','width'=>'col-sm-3',"help"=>"Wajib mengisikan tanggal pengantar setelah mengupload file"];
			if(CRUDBooster::myPrivilegeId()==5){
    			$this->form[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'date','validation'=>'required|date','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Nomor','name'=>'nomor','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			}

			$this->form[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-6','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Updated Priv','name'=>'updated_by_priv','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-6','value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Nomor","name"=>"nomor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Sk Rt","name"=>"sk_rt","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"No Sk Rt","name"=>"no_sk_rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Keperluan","name"=>"keperluan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Pejabat Id","name"=>"pejabat_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pejabat,nama_pejabat"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	       // $this->load_js = array();
	        $this->load_js[] = asset("js/pelayanan.js");
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css[] = asset("css/syarat_head.css");
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        $query->where('cms_user_id',CRUDBooster::myId());
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            unset($postdata['deskripsi']);
            if($postdata['file_sk_rt']){
                if(!$postdata['no_sk_rt']){
                    CRUDBooster::redirectBack('Nomor pengantar wajib di isi !','danger');
                }
                if(!$postdata['tgl_sk_rt']){
                    CRUDBooster::redirectBack('Tanggal pengantar wajib di isi !','danger');
                }
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        if(CRUDBooster::MyPrivilegeId()==2){
	            $surat_baru = DB::table($this->table)->where('id',$id)->first();
	            $warga_bjb = DB::table('warga_bjb')->where('id',$surat_baru->warga_bjb_id)->first();
	            $jenis_surat = DB::table('surat')->where('tabel',$this->table)->first();
	            
	            $notasiku = DB::table('notasi_surat')->where('id_surat',$jenis_surat->id)->where('id_cms_privileges',CRUDBooster::myPrivilegeId())->first();
	            
	            
	            $newid = DB::table('surat_idv')->insertGetId([
                            'parent_table' => $this->table,
                            'parent_id' => $id,
                            'cms_privilege_id' => CRUDBooster::myPrivilegeId(),
                            'status_req' => $notasiku->aksi_diperlukan_id,
                            'status_id' => 1,
                        	'jenis_surat_id' => $jenis_surat->id,
        					'sender_id' => CRUDBooster::myId(),
        					'sender_priv' => CRUDBooster::myPrivilegeId(),
        					'nik' => $warga_bjb->nik,
        					'nama_lgkp' => $warga_bjb->nama_lgkp,
        					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
        					'tgl_lhr' => $warga_bjb->tgl_lhr,
        					'alamat' => $warga_bjb->alamat2,
        					'agama' => $surat_baru->agama,
        					'status_perkawinan' => $surat_baru->status_perkawinan,
        					'rt' => $warga_bjb->rt,
        					'rw' => $warga_bjb->rw,
        					'file_sk_rt' => $surat_baru->file_sk_rt,
        					'no_sk_rt' => $surat_baru->no_sk_rt,
        					'tgl_sk_rt' => $surat_baru->tgl_sk_rt,
        					'village_id' => $warga_bjb->nama_kel,
        					'district_id' => $warga_bjb->nama_kec,
        					'regency_id' => $warga_bjb->nama_kab,
        					'province_id' => $warga_bjb->nama_prov,
        					'jk' => $warga_bjb->jk,
        					'pekerjaan' => $warga_bjb->pekerjaan,
        					'no_telp' => $warga_bjb->telp,
        					'keperluan' => $surat_masuk->keperluan,
        					'next_priv' => $notasiku->privilege_tujuan,
        					'created_at' => now()
                        ]);
                        
                if($surat_baru->file_sk_rt){
                    $notasinext = DB::table('notasi_surat')->where('id_surat',$jenis_surat->id)->where('urutan','<=',$notasiku->urutan + 2)->where('urutan','<>',$notasiku->urutan)->get();
                }else{
                    $notasinext = DB::table('notasi_surat')->where('id_surat',$jenis_surat->id)->where('urutan',$notasiku->urutan + 1)->get();
                }
                
                $notified_user = array(); 
                
                foreach($notasinext as $nn){
                    DB::table('surat_idv')->insert([
                                'parent_table' => $this->table,
                                'parent_id' => $id,
                                'cms_privilege_id' => $nn->id_cms_privileges,
                                'status_req' => $nn->aksi_diperlukan_id,
                                'status_id' => 1,
                            	'jenis_surat_id' => $jenis_surat->id,
            					'sender_id' => CRUDBooster::myId(),
            					'sender_priv' => CRUDBooster::myPrivilegeId(),
            					'nik' => $warga_bjb->nik,
            					'nama_lgkp' => $warga_bjb->nama_lgkp,
            					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
            					'tgl_lhr' => $warga_bjb->tgl_lhr,
            					'alamat' => $warga_bjb->alamat2,
            					'agama' => $surat_baru->agama,
            					'status_perkawinan' => $surat_baru->status_perkawinan,
            					'rt' => $warga_bjb->rt,
            					'rw' => $warga_bjb->rw,
            					'file_sk_rt' => $surat_baru->file_sk_rt,
            					'no_sk_rt' => $surat_baru->no_sk_rt,
            					'tgl_sk_rt' => $surat_baru->tgl_sk_rt,
            					'village_id' => $warga_bjb->nama_kel,
            					'district_id' => $warga_bjb->nama_kec,
            					'regency_id' => $warga_bjb->nama_kab,
            					'province_id' => $warga_bjb->nama_prov,
            					'jk' => $warga_bjb->jk,
            					'pekerjaan' => $warga_bjb->pekerjaan,
            					'no_telp' => $warga_bjb->telp,
            					'keperluan' => $surat_masuk->keperluan,
            					'next_priv' => $nn->privilege_tujuan,
            					'created_at' => now()
                            ]);
                    $next_notified = DB::table('multi_privs')
                                    ->join('cms_users','cms_users.id','multi_privs.cms_users_id')
                                    ->where('multi_privs.cms_privileges_id',$nn->id_cms_privileges)
                                    ->where('cms_users.rt',(int)$warga_bjb->rt)
                                    ->where('cms_users.rw',(int)$warga_bjb->rw)
                                    ->where('cms_users.village_id',$warga_bjb->nama_kel)
                                    ->selectRaw('multi_privs.*,cms_users.no_telp')
                                    ->get();
                    foreach($next_notified as $neno){
                        array_push($notified_user,$neno->cms_users_id);
                        
                         if($neno->no_telp!=null){
                            
                            $subtelp = substr($neno->no_telp,0,1);
                            if($subtelp == 0){
                                $subtelp = substr_replace($neno->no_telp,"62",0,1);
                                $chat_id = $subtelp . "@c.us";
                            }else{
                                $chat_id = $d->no_telp . "@c.us";
                            }
                            
                            DB::table('wa_notif')->insert([
                                'warga_bjb_id'=>CRUDBooster::idToWarga($neno->cms_users_id)->id,
                                'cms_users_id'=> $neno->cms_users_id,
                                'no_telp' => $neno->no_telp,
                                'chat_id'=>$chat_id,
                                'isi'=> CRUDBooster::myPrivilegeName() . " " .  CRUDBooster::myName()  . " membuat permohonan ". $jenis_surat->nama_surat . ". Silahkan masuk ke SIAPKK " . CRUDBooster::publicPath()
                                ]);
                        }
                    }
                }
	            
                //dd($notified_user);
	            //$notasiketahui = DB::table('notasi_surat')->where('aksi_diperlukan_id',4)->get();
				
				//notif WA kelurahan

    			
    // 			$config['id_cms_users'] = $notified_user;
    // 			$config['content'] = CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat;
    // 			$config['to'] = CRUDBooster::adminPath('surat_idv');
    			
    // 			CRUDBooster::sendNotification($config);
    			
    			//CRUDBooster::createMasterNotif($jenis_surat->id,CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat,$this->table,"openUrl;".$id.";".CRUDBooster::adminPath('surat_masuk'));
    			return redirect(CRUDBooster::adminPath('surat_idv'));
            }else{
                
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}