<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;

	class AdminSuratBlankoPeriksaHewanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_hewan";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = true;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat_blanko_periksa_hewan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Macam Hewan","name"=>"macam_hewan"];
			$this->col[] = ["label"=>"Nama Hewan","name"=>"nama_hewan"];
			$this->col[] = ["label"=>"Signalemen","name"=>"signalemen"];
			$this->col[] = ["label"=>"Penyakit","name"=>"penyakit"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			if(CRUDBooster::myPrivilegeId()==2){
			    $this->form[] = ['label'=>'Warga id','name'=>'warga_bjb_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::menik(CRUDBooster::me()->nik)->id];
			}else{
		    	$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|min:1|max:255','width'=>'col-sm-8','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK','Nama Lengkap','Tempat Lahir','Tanggal Lahir'];
			 //   $this->form[] = ['label'=>'Anamnesa','name'=>'anamnesa','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    // 			$this->form[] = ['label'=>'Status Paesens','name'=>'status_paesens','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Keadaan Umum','name'=>'keadaan_umum','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Frek Nafas','name'=>'frek_nafas','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Frek Pulsus','name'=>'frek_pulsus','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Suhu Tubuh','name'=>'suhu_tubuh','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Kulit Dan Rambut','name'=>'kulit_dan_rambut','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Selaput Lendir','name'=>'selaput_lendir','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Susunan Alat Pernafasan','name'=>'susunan_alat_pernafasan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Susunan Alat Peredaran Darah','name'=>'susunan_alat_peredaran_darah','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Susunan Alat Pencernaan','name'=>'susunan_alat_pencernaan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Susunan Alat Kelamin Dan Perkemihan','name'=>'susunan_alat_kelamin_dan_perkemihan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Susunan Urat Syaraf','name'=>'susunan_urat_syaraf','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Anggota Gerak','name'=>'anggota_gerak','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Lain Lain','name'=>'lain_lain','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Berat Badan','name'=>'berat_badan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Lab Feces','name'=>'lab_feces','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Lab Konsistensi','name'=>'lab_konsistensi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Lab Natif','name'=>'lab_natif','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Lab Centrifuge','name'=>'lab_centrifuge','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Lab Lain Lain','name'=>'lab_lain_lain','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Diag Urine','name'=>'diag_urine','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Diag Reaksi','name'=>'diag_reaksi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Diag Protein','name'=>'diag_protein','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Diag Sediment','name'=>'diag_sediment','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Diag Lain Lain','name'=>'diag_lain_lain','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Prog Darah','name'=>'prog_darah','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Prog Sifat','name'=>'prog_sifat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Prog Kadar Hb','name'=>'prog_kadar_hb','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Prog Pr Apus','name'=>'prog_pr_apus','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Prog Lain Lain','name'=>'prog_lain_lain','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Terapi','name'=>'terapi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			}
    			$this->form[] = ['label'=>'Macam Hewan','name'=>'macam_hewan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Nama Hewan','name'=>'nama_hewan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Signalemen','name'=>'signalemen','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Penyakit','name'=>'penyakit','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Gambar','name'=>'photo','type'=>'upload','validation'=>'max:3000','upload_type'=>'image'];
                
			
			$this->form[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-6','value'=>CRUDBooster::myId()];
			if(CRUDBooster::myPrivilegeId()==12){
    			$this->form[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'date','validation'=>'required|date','width'=>'col-sm-5'];
    			$this->form[] = ['label'=>'Nomor','name'=>'nomor','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			}
			
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Macam Hewan","name"=>"macam_hewan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Hewan","name"=>"nama_hewan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Signalemen","name"=>"signalemen","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Penyakit","name"=>"penyakit","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Anamnesa","name"=>"anamnesa","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Status Paesens","name"=>"status_paesens","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Keadaan Umum","name"=>"keadaan_umum","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Frek Nafas","name"=>"frek_nafas","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Frek Pulsus","name"=>"frek_pulsus","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Suhu Tubuh","name"=>"suhu_tubuh","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Kulit Dan Rambut","name"=>"kulit_dan_rambut","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Selaput Lendir","name"=>"selaput_lendir","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Susunan Alat Pernafasan","name"=>"susunan_alat_pernafasan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Susunan Alat Peredaran Darah","name"=>"susunan_alat_peredaran_darah","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Susunan Alat Pencernaan","name"=>"susunan_alat_pencernaan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Susunan Alat Kelamin Dan Perkemihan","name"=>"susunan_alat_kelamin_dan_perkemihan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Susunan Urat Syaraf","name"=>"susunan_urat_syaraf","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Anggota Gerak","name"=>"anggota_gerak","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lain Lain","name"=>"lain_lain","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Berat Badan","name"=>"berat_badan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lab Feces","name"=>"lab_feces","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lab Konsistensi","name"=>"lab_konsistensi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lab Natif","name"=>"lab_natif","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lab Centrifuge","name"=>"lab_centrifuge","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lab Lain Lain","name"=>"lab_lain_lain","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Diag Urine","name"=>"diag_urine","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Diag Reaksi","name"=>"diag_reaksi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Diag Protein","name"=>"diag_protein","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Diag Sediment","name"=>"diag_sediment","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Diag Lain Lain","name"=>"diag_lain_lain","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Prog Darah","name"=>"prog_darah","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Prog Sifat","name"=>"prog_sifat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Prog Kadar Hb","name"=>"prog_kadar_hb","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Prog Pr Apus","name"=>"prog_pr_apus","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Prog Lain Lain","name"=>"prog_lain_lain","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Terapi","name"=>"terapi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nomor","name"=>"nomor","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tanggal","name"=>"tanggal","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By Priv","name"=>"updated_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        if(CRUDBooster::MyPrivilegeId()==2){
	            $surat_baru = DB::table($this->table)->where('id',$id)->first();
	            $warga_bjb = DB::table('warga_bjb')->where('id',$surat_baru->warga_bjb_id)->first();
	            $jenis_surat = DB::table('surat')->where('tabel',$this->table)->first();
	            $last_id = DB::table('surat_masuk')->insertGetId([
					'jenis_surat_id' => $jenis_surat->id,
					'owner_priv' => 12,
					'nik' => $warga_bjb->nik,
					'nama_lgkp' => $warga_bjb->nama_lgkp,
					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
					'tgl_lhr' => $warga_bjb->tgl_lhr,
					'alamat' => $warga_bjb->alamat,
					'rt' => $warga_bjb->rt,
					'rw' => $warga_bjb->rw,
					'district_id' => $warga_bjb->nama_kec,
					'village_id' => $warga_bjb->nama_kel,
					'jk' => $warga_bjb->jk,
					'pekerjaan' => $warga_bjb->pekerjaan,
					'no_telp' => $warga_bjb->telp,
					'created_at' => Carbon::now(),
					'created_by' => CRUDBooster::myId(),
					'status_id' => 1,
					'status_by' => CRUDBooster::myId(),
					'status_by_priv' => CRUDBooster::myPrivilegeId(),
					'rel_table' => $this->table,
					'rel_id' => $id
				]);
				

    			
    			// $config['id_cms_users'] = $notified_user;
    			
    			// CRUDBooster::sendNotification($config);
    			
    			CRUDBooster::createMasterNotif($jenis_surat->id,CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat,$this->table,"openUrl;".$last_id.";".CRUDBooster::adminPath('surat_masuk'));
    			return redirect(CRUDBooster::adminPath('skck_warga'));
            }

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}