<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use File;

	class AdminSuratController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_surat";
			$this->limit = "20";
			$this->orderby = "urutan,asc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"No","name"=>"urutan"];
			$this->col[] = ["label"=>"Icon","name"=>"icon_layanan",'image'=>true];
			$this->col[] = ["label"=>"Singkatan","name"=>"kode"];
			$this->col[] = ["label"=>"Nama Surat","name"=>"nama_surat"];
			//$this->col[] = ["label"=>"Kode Depan","name"=>"kode_depan"];
			//$this->col[] = ["label"=>"Nomor Terakhir","name"=>"nomor_terakhir"];
			//$this->col[] = ["label"=>"Kode Belakang","name"=>"kode_belakang"];
			$this->col[] = ["label"=>"Notasi","name"=>"(select GROUP_CONCAT(DISTINCT cms_privileges.name ORDER BY notasi_surat.urutan ASC SEPARATOR '->') from notasi_surat,cms_privileges where notasi_surat.id_surat = surat.id and notasi_surat.id_cms_privileges = cms_privileges.id GROUP BY surat.id ) as notasi_surat", "callback_php"=>'$row->notasi_surat'];
			$this->col[] = ["label"=>"Template File","name"=>"template_file","download"=>true];
			$this->col[] = ["label"=>"Module","name"=>"model", "join" => "cms_moduls,path","visible"=>false];
			$this->col[] = ["label"=>"Warna","name"=>"warna","visible"=>false];
			$this->col[] = ["label"=>"Tempat Layanan","name"=>"tempat_layanan"];
			//$this->col[] = ["label"=>"Owner","name"=>"owner_priv","join" => "cms_privileges,name"];
			$this->col[] = ["label"=>"Tabel","name"=>"tabel","visible"=>false];
			$this->col[] = ["label"=>"Aksi Mobile","name"=>"aksi","visible"=>false];
			$this->col[] = ["label"=>"Aksi Web","name"=>"aksi_web","visible"=>false];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Singkatan','name'=>'kode','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
			$this->form[] = ['label'=>'Nama Surat','name'=>'nama_surat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Module','name'=>'model','type'=>'select2','width'=>'col-sm-9',"datatable"=>"cms_moduls,path"];
			$this->form[] = [
				"label" => "Persyaratan",
				"name" => "syarat",
				"type" => "select2",
				"select2_multiple" => true,
				"datatable" => "syarat,deskripsi,id",
				"relationship_table" => "persyaratan",
			];
			// $this->form[] = [
				// "label" => "Notasi",
				// "name" => "notasi",
				// "type" => "select2",
				// "select2_multiple" => true,
				// "datatable" => "cms_privileges,name,id",
				// "relationship_table" => "notasi_surat",
				// "required" => true,
			// ];
// 			$columns[] = ['label'=>'Privilege','name'=>'id_cms_privileges','type'=>'select','datatable'=>'cms_privileges,name','required'=>true];
// 			$columns[] = ['label'=>'Aksi','name'=>'aksi_diperlukan_id','type'=>'select','datatable'=>'aksi_diperlukan,nama_aksi','required'=>true];
// 			$columns[] = ['label'=>'Controller','name'=>'cms_modules_id','type'=>'select','datatable'=>'cms_moduls,controller','required'=>true];
// 			$columns[] = ['label'=>'Path','name'=>'path','type'=>'text'];
// 			$columns[] = ['label'=>'View','name'=>'view','type'=>'text'];
// 			//$columns[] = ['label'=>'Privilege Tujuan','name'=>'privilege_tujuan','type'=>'select','datatable'=>'cms_privileges,name'];
			
// 			$this->form[] = ['label'=>'Notasi','name'=>'notasi_surat','type'=>'child','columns'=>$columns,'width'=>'col-sm-10','table'=>'notasi_surat','foreign_key'=>'id_surat'];
			//$this->form[] = ['label'=>'Format','name'=>'format','type'=>'wysiwyg','width'=>'col-sm-9'];
			$this->form[] = ['label'=>'Template File','name'=>'template_file','type'=>'upload','width'=>'col-sm-9'];
			
			$columns[] = ['label'=>'Kode Depan','name'=>'kode_depan','type'=>'text','validation'=>'required|min:1|max:50','width'=>'col-sm-3'];
			$columns[] = ['label'=>'Nomor Terakhir','name'=>'nomor_terakhir','type'=>'number','validation'=>'required','width'=>'col-sm-3','value'=>0];
			$columns[] = ['label'=>'Kode Belakang','name'=>'kode_belakang','type'=>'text','validation'=>'required|min:1|max:50','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Format Penomoran','name'=>'penomoran','type'=>'group','columns'=>$columns,'width'=>'col-sm-10'];

            $this->form[] = ['label'=>'Masa Berlaku','name'=>'masa_berlaku','type'=>'number','validation'=>'required|numeric','width'=>'col-sm-3','value'=>2,'help'=>'Tahun'];
			$this->form[] = ['label'=>'Icon','name'=>'icon_layanan','type'=>'upload','validation'=>'max:5000','width'=>'col-sm-9'];
			$this->form[] = ['label'=>'Urutan','name'=>'urutan','type'=>'number','validation'=>'integer','width'=>'col-sm-2','value'=>0];
// 			$this->form[] = ['label'=>'Template HTML','name'=>'template_html','type'=>'wysiwyg','width'=>'col-sm-10'];
			if(CRUDBooster::myPrivilegeId()==1){
    			$this->form[] = ['label'=>'Icon','name'=>'icon_layanan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
    			$this->form[] = ['label'=>'Warna','name'=>'warna','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
    			$this->form[] = ['label'=>'Tempat Layanan','name'=>'tempat_layanan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
    		//	$this->form[] = ['label'=>'Owner','name'=>'owner_priv','type'=>'select2','width'=>'col-sm-9',"datatable"=>"cms_privileges,name"];
    			$this->form[] = ['label'=>'Tabel','name'=>'tabel','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
    			$this->form[] = ['label'=>'Aksi Mobile','name'=>'aksi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
    			$this->form[] = ['label'=>'Aksi Web','name'=>'aksi_web','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
			}
			
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ['label'=>'Singkatan','name'=>'kode','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
			//$this->form[] = ['label'=>'Nama Surat','name'=>'nama_surat','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Kode Depan','name'=>'kode_depan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Nomor Terakhir','name'=>'nomor_terakhir','type'=>'number','validation'=>'integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Kode Belakang','name'=>'kode_belakang','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Model','name'=>'model','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-9'];
			//$this->form[] = ['label'=>'Format','name'=>'format','type'=>'wysiwyg','width'=>'col-sm-9'];
			//$this->form[] = ['label'=>'Template File','name'=>'template_file','type'=>'filemanager','width'=>'col-sm-9'];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Alur','path'=>'notasi_surat','foreign_key'=>'id_surat','button_color'=>'primary','parent_columns'=>'kode,nama_surat'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();

	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
		
		


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        if(CRUDBooster::myPrivilegeId()!=1){
	            $query->where('surat.id','>=',18);    
	        }
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {  
	        if(CRUDBooster::myPrivilegeId()==2){
	            $postdata['nomor'] = null;
	        }
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 
// 			$row = CRUDBooster::first($this->table,$id);
// 			File::put('../resources/views/skck.blade.php',$row->format);	
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}