<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminSuratPermohonanBantuanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = false;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat_permohonan_bantuan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
// 			$this->col[] = ["label"=>"Relasi","name"=>"relasi"];
// 			$this->col[] = ["label"=>"Relasi Id","name"=>"relasi_id"];
			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Usaha","name"=>"umkm_usaha_id","join"=>"umkm_usaha,nama_usaha"];
			$this->col[] = ["label"=>"Kelompok","name"=>"grup_id","join"=>"grup,nama_grup"];
			$this->col[] = ["label"=>"Item","name"=>"bantuan_item_id","join"=>"bantuan_item,item_name"];
			//$this->col[] = ["label"=>"Owner Priv","name"=>"owner_priv","join"=>"cms_privileges,name"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
		//	$this->form[] = ['label'=>'Relasi','name'=>'relasi','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10', 'value'=>'bantuan'];
		//	$this->form[] = ['label'=>'Relasi Id','name'=>'relasi_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|min:1|max:255','width'=>'col-sm-8','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK','Nama Lengkap','Tempat Lahir','Tanggal Lahir'];
			$this->form[] = ['label'=>'Usaha','name'=>'umkm_usaha_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-10','datatable'=>'umkm_usaha,nama_usaha','datatable_where'=>'status_id = 5','parent_select'=>'warga_bjb_id'];
			$this->form[] = ['label'=>'Kelompok','name'=>'grup_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-10','datatable'=>'grup,nama_grup'];
		//	$this->form[] = ['label'=>'Owner Priv','name'=>'owner_priv','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Status','name'=>'status_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'status_surat,status'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-10','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Relasi","name"=>"relasi","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Relasi Id","name"=>"relasi_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"relasi,id"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Umkm Usaha Id","name"=>"umkm_usaha_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"umkm_usaha,nama_usaha"];
			//$this->form[] = ["label"=>"Owner Priv","name"=>"owner_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        $this->addaction[] = ['label'=>'Aprove','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('aproval').'/[id]/5','showIf'=>'[status_id] < 4'];
	        $this->addaction[] = ['label'=>'Batalkan','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('aproval').'/[id]/3','showIf'=>'[status_id] <> 3'];
	        $this->addaction[] = ['label'=>'Tolak','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::mainpath('aproval').'/[id]/4','showIf'=>'[status_id] <> 4'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();
            // $this->index_statistic[] = ['label'=>'Bantuan disetujui','count'=>DB::table($this->table)
												// 							 ->where('status_id',5)
												// 							 ->where('relasi_id','[id]')
												// 							 ->count(),'icon'=>'fa fa-bars','color'=>'red','width'=>'col-sm-3'];
// 			$this->index_statistic[] = ['label'=>'Permohonan Diproses','count'=>DB::table($this->table)
// 																									 ->where('status_id',2)
// 																									 ->where('surat_masuk.owner_priv',CRUDBooster::myPrivilegeId())
// 																									 ->where('surat_masuk.jenis_surat_id','=',8)
// 																									 ->count(),'icon'=>'fa fa-bars','color'=>'green','width'=>'col-sm-3'];
// 			$this->index_statistic[] = ['label'=>'Permohonan Selesai','count'=>DB::table($this->table)
// 																									 ->where('status_id',5)
// 																									 ->where('surat_masuk.status_by_priv',CRUDBooster::myPrivilegeId())
// 																									 ->where('surat_masuk.jenis_surat_id','=',8)
// 																									 ->count(),'icon'=>'fa fa-bars','color'=>'blue','width'=>'col-sm-3'];


	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	        //$query->where('surat_permohonan_bantuan.status_id',5);
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }
	    
	    public function getAproval($id,$val){
	        DB::table('surat_permohonan_bantuan')->where('id',$id)->update(['status_id'=>$val,'updated_by'=>CRUDBooster::myId()]);
	        
	        CRUDBooster::redirectBack("Data berhasil di update","success");
	    }



	    //By the way, you can still create your own method in here... :) 


	}