<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use PDF;
	use App\Signature\Esign;
	use App\Signature\Client\BasicRest;

	class AdminSuratPermohonanTteController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "status_id,asc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = false;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "surat_permohonan_tte";
			$this->pejabat = DB::table('pejabat')->where('warga_bjb_id',CRUDBooster::idToWarga(CRUDBooster::myId())->id)->first();
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			//$this->col[] = ["label"=>"Nomor","name"=>"nomor_surat"];
			$this->col[] = ["label"=>"NIP","name"=>"pejabat_id","join"=>"pejabat,nip_pejabat"];
			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nik"];
			//$this->col[] = ["label"=>"Jabatan","name"=>"pejabat_id","join"=>"pejabat,jabatan"];
			$this->col[] = ["label"=>"Nama","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Jabatan","name"=>"(SELECT jabatan.jabatan FROM pejabat JOIN jabatan ON pejabat.jabatan = jabatan.id WHERE pejabat.id = pejabat_id ) as jabatannya","callback_php"=>"$row->jabatannya"];
			$this->col[] = ["label"=>"Telepon","name"=>"no_telp"];
			$this->col[] = ["label"=>"Scan Ektp","name"=>"scan_ektp","image"=>1];
			
			$this->col[] = ["label"=>"Rekomendasi Oleh","name"=>"rekomendasi_by","join"=>"pejabat,nama_pejabat"];
			$this->col[] = ["label"=>"Created By","name"=>"created_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Created At","name"=>"created_at"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Updated At","name"=>"updated_at"];
			$this->col[] = ["label"=>"PDF","name"=>"pdf_path","download"=>1];
			
			$this->col[] = ["label"=>"Signed PDF","name"=>"signed_pdf_path","download"=>1];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			
			if(CRUDBOoster::myPrivilegeId()==21){
			   // $this->form[] = ['label'=>'Nomor','name'=>'nomor_surat','type'=>'text','width'=>'col-sm-6'];

			    $this->form[] = ['label'=>'Pejabat','name'=>'pejabat_id','type'=>'datamodal','width'=>'col-sm-8','datamodal_table'=>'pejabat','datamodal_columns'=>'nama_pejabat,nip_pejabat,jabatan','datamodal_size'=>'large','datamodal_columns_alias'=>'Nama,NIP,Jabatan'];
			    //$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|min:1|max:255','width'=>'col-sm-8','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK','Nama Lengkap','Tempat Lahir','Tanggal Lahir'];
			}
			$this->form[] = ['label'=>'Telepon','name'=>'no_telp','type'=>'text','validation'=>'required|string|min:10|max:15','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Email Resmi','name'=>'email_resmi','type'=>'email','validation'=>'string|min:0|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Scan/Foto Ektp','name'=>'scan_ektp','type'=>'upload','width'=>'col-sm-10','validation'=>'required'];
		//	$this->form[] = ['label'=>'Scan Rekomendasi','name'=>'scan_rekomendasi','type'=>'upload','width'=>'col-sm-10'];
			
// 			$this->form[] = ['label'=>'Created By','name'=>'created_by','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
 			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','value'=>CRUDBooster::myId()];
            if(CRUDBOoster::myPrivilegeId()==21){
                $this->form[] = ['label'=>'Rekomendasi Oleh','name'=>'rekomendasi_by','type'=>'select2','width'=>'col-sm-10','datatable'=>'pejabat,nama_pejabat'];
			    $this->form[] = ['label'=>'Status Id','name'=>'status_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'status_surat,status'];
			    $this->form[] = ['label'=>'Tanggal Cetak','name'=>'tanggal','type'=>'date'];
			}
			
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Scan Ektp","name"=>"scan_ektp","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Scan Rekomendasi","name"=>"scan_rekomendasi","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Created By","name"=>"created_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Status Id","name"=>"status_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status,id"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        $this->addaction[] = ['label'=>'Preview','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('preview-html').'/[id]','showIf'=>'[rekomendasi_by]<>""'];
	        $this->addaction[] = ['label'=>'Buat PDF','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('cetak').'/[id]','showIf'=>'[rekomendasi_by]<>""'];
	        $this->addaction[] = ['label'=>'ESELON','icon'=>'fa fa-address-card','color'=>'success','url'=>'#','showIf'=>'[pejabat_id]<>NULL'];
	        $this->addaction[] = ['label'=>'Tandatangani','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::mainpath('preview-tte').'/[id]','showIf'=>'[rekomendasi_by]<>""']; //.$this->pejabat->id];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $postdata['created_by'] = CRUDBooster::myId();
            $postdata['created_at'] = now();
            
            
            if(CRUDBooster::myPrivilegeId() == 21){
                $pejabat = DB::table('pejabat')->where('id',$postdata['pejabat_id'])->first(); 
                $warga = DB::table('warga_bjb')->where('id',$pejabat->warga_bjb_id)->first();
            }else{
                $pejabat = CRUDBooster::wargaToPejabat(CRUDBooster::idToWarga(CRUDBooster::myId())->id);
                
                if($pejabat){
                   $warga = DB::table('warga_bjb')->where('id',$pejabat->warga_bjb_id)->first();
                   
                   $postdata['pejabat_id'] = $pejabat->id;
                }else{
                   $warga = DB::table('warga_bjb')->where('id',CRUDBooster::idToWarga(CRUDBooster::myId())->id)->first();
                   
                }
            }
            
            
            $postdata['warga_bjb_id'] = $warga->id;
            $eksis = DB::table('surat_permohonan_tte')->where('warga_bjb_id',$warga->id)->first();
            if($eksis){
                CRUDBooster::redirectBack("Data permohonan ini sudah ada !", "danger");
            }
            
           // dd($postdata);
            
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here
            if(CRUDBooster::myPrivilegeId() <> 21){
                redirect('skck_warga');
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here
            //$postdata['updated_by'] = CRUDBooster::myId();
            
            // if(!$postdata['pejabat_id']){
            //     $postdata['warga_bjb_id']=CRUDBooster::idToWarga($postdata['created_by'])->id;
            // }
            
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }
        
        public function getCetak($id) {
	        $data = [];
	        $data['id'] = $id; 
	        $data['surat'] = DB::table('surat_permohonan_tte')->where('id',$id)->first();
	        $data['kop'] = DB::table('kop')->where('id',$id)->first();
	        if($data['surat']->pejabat_id<>NULL){
    	        $data['pejabat'] = DB::table('pejabat')
    	                            ->join('warga_bjb','warga_bjb.id','pejabat.warga_bjb_id')
    	                            ->join('pangkat','pangkat.id','pejabat.pangkat_id')
    	                            ->join('eselon','eselon.id','pejabat.eselon_id')
    	                            ->join('unit_kerja','unit_kerja.id','pejabat.unit_kerja_id')
    	                            ->join('jabatan','jabatan.id','pejabat.jabatan')
    	                            //->join('dinas','dinas.id','pejabat.dinas_id')
    	                            ->where('pejabat.id',$data['surat']->pejabat_id)
    	                            ->selectRaw('pejabat.*,pangkat.pangkat,eselon.eselon,unit_kerja.unit_kerja,jabatan.jabatan,warga_bjb.nik')//,dinas.dinas')
    	                            ->first();
    	        $data['is_pejabat'] = 1;
	        }else{
	            $data['is_pejabat'] = 0;
	            $data['warga'] = DB::table('warga_bjb')->where('id', $data['surat']->warga_bjb_id)->first();
	            
	        }
	                            
	        $data['rekomender'] = DB::table('pejabat')
	                            ->join('warga_bjb','warga_bjb.id','pejabat.warga_bjb_id')
	                            ->join('pangkat','pangkat.id','pejabat.pangkat_id')
	                            ->join('eselon','eselon.id','pejabat.eselon_id')
	                            ->join('unit_kerja','unit_kerja.id','pejabat.unit_kerja_id')
	                            ->join('jabatan','jabatan.id','pejabat.jabatan')
	                            //->join('dinas','dinas.id','pejabat.dinas_id')
	                            ->where('pejabat.id',$data['surat']->rekomendasi_by)
	                            ->selectRaw('pejabat.*,warga_bjb.nik,pangkat.pangkat,eselon.eselon,unit_kerja.unit_kerja,unit_kerja.kop_id,jabatan.jabatan')//,dinas.dinas')
	                            ->first();
	                            
	         $data['kop'] = DB::table('kop')->where('id',$data['rekomender']->kop_id)->first();                  
	        
	        //var_dump(app_path());
	        
	        if($data['is_pejabat']==1){
    	        $pdf = PDF::loadView('pdf.rektte',$data);
    	        
    	        //Storage::put('public/pdf/ttedoc.pdf', $pdf->output());
    	        
    	        $path = public_path('gen_pdfs');
                $fileName =  'rekom_tte_' . $data['pejabat']->warga_bjb_id . '.' . 'pdf' ;
                $pdf->save($path . '/' . $fileName);
                
                DB::table('surat_permohonan_tte')->where('id',$id)->update(['pdf_path'=>'gen_pdfs/' . $fileName,'updated_by'=>CRUDBooster::myId()]);
    	        
                
                CRUDBooster::redirectBack("Pdf berhasil di generate", "success");
                
                return $pdf->download($fileName);
	        }
        
           // return view('pdf.rektte',$data);
	    }
	    
	    public function getPreviewHtml($id) {
	        $data = [];
	        $data['id'] = $id; 
	        $data['surat'] = DB::table('surat_permohonan_tte')->where('id',$id)->first();
	        $data['kop'] = DB::table('kop')->where('id',$id)->first();
	        if($data['surat']->pejabat_id<>NULL){
    	        $data['pejabat'] = DB::table('pejabat')
    	                            ->join('warga_bjb','warga_bjb.id','pejabat.warga_bjb_id')
    	                            ->join('pangkat','pangkat.id','pejabat.pangkat_id')
    	                            ->join('eselon','eselon.id','pejabat.eselon_id')
    	                            ->join('unit_kerja','unit_kerja.id','pejabat.unit_kerja_id')
    	                            ->join('jabatan','jabatan.id','pejabat.jabatan')
    	                            //->join('dinas','dinas.id','pejabat.dinas_id')
    	                            ->where('pejabat.id',$data['surat']->pejabat_id)
    	                            ->selectRaw('pejabat.*,pangkat.pangkat,eselon.eselon,unit_kerja.unit_kerja,jabatan.jabatan,warga_bjb.nik')//,dinas.dinas')
    	                            ->first();
    	        $data['is_pejabat'] = 1;
	        }else{
	            $data['is_pejabat'] = 0;
	            $data['warga'] = DB::table('warga_bjb')->where('id', $data['surat']->warga_bjb_id)->first();
	            
	        }
	                            
	        $data['rekomender'] = DB::table('pejabat')
	                            ->join('warga_bjb','warga_bjb.id','pejabat.warga_bjb_id')
	                            ->join('pangkat','pangkat.id','pejabat.pangkat_id')
	                            ->join('eselon','eselon.id','pejabat.eselon_id')
	                            ->join('unit_kerja','unit_kerja.id','pejabat.unit_kerja_id')
	                            ->join('jabatan','jabatan.id','pejabat.jabatan')
	                            //->join('dinas','dinas.id','pejabat.dinas_id')
	                            ->where('pejabat.id',$data['surat']->rekomendasi_by)
	                            ->selectRaw('pejabat.*,warga_bjb.nik,pangkat.pangkat,eselon.eselon,unit_kerja.unit_kerja,unit_kerja.kop_id,jabatan.jabatan')//,dinas.dinas')
	                            ->first();
	                            
	         $data['kop'] = DB::table('kop')->where('id',$data['rekomender']->kop_id)->first();                  
	        
	      
            return view('pdf.previewtte',$data);
	    }
	    
	    public function getPreviewTte($id,$signed=0) {
	        $data = [];
	        $data['id'] = $id; 
	        $data['batal'] = 'surat_permohonan_tte';
	        $data['surat'] = DB::table('surat_permohonan_tte')->where('id',$id)->first();
	        if($signed==0){
	            $data['pdf_path'] = $data['surat']->pdf_path;
	        }else{
	            $data['pdf_path'] = $data['surat']->signed_pdf_path;
	        }
	        $data['signed'] = $signed;
	      
            return view('pdf.preview',$data);
	    }
	    
	    public function postTte(){
	        $data = [];
	        $data['surat'] = DB::table('surat_permohonan_tte')->where('id',Request::input('id'))->first();

	        $esign = new Esign();
            // $response = $esign->checkStatus('0803202100007062');
            // var_dump( $response->message);
            $response = $esign->sign($nik = CRUDBooster::me()->nik, $pass = Request::input('pass'), $doc = public_path().'/'.$data['surat']->pdf_path);
            $response = json_decode($response);
            if($response->esign_status==1){
                DB::table('surat_permohonan_tte')->where('id',Request::input('id'))->update(['signed_pdf_path'=>'gen_pdfs/' . $response->esign_file,'updated_by'=>CRUDBooster::myId()]);
                //notify sender
                
                CRUDBooster::redirect(CRUDBooster::mainpath('preview-tte/'.Request::input('id').'/1'),$response->esign_message,"success");
                // $data['surat'] = DB::table('surat_permohonan_tte')->where('id',Request::input('id'))->first();
                // $data['pdf_path'] = $data['surat']->signed_pdf_path;
                // $data['signed'] = 1;
                // return view('pdf.preview',$data);
                //var_dump('success');
            }else{
                CRUDBooster::redirectBack($response->esign_message, "danger");
            }
            
            
 
	    }

	    //By the way, you can still create your own method in here... :) 


	}