<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;

	class AdminSuratRegPelatihanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {
	    	# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->table 			   = "surat_reg_pelatihan";	        
			$this->title_field         = "id";
			$this->limit               = 20;
			$this->orderby             = "id,desc";
			$this->show_numbering      = FALSE;
			$this->global_privilege    = FALSE;	        
			$this->button_table_action = TRUE;   
			$this->button_action_style = "button_icon";     
			$this->button_add          = TRUE;
			$this->button_delete       = TRUE;
			$this->button_edit         = TRUE;
			$this->button_detail       = TRUE;
			$this->button_show         = TRUE;
			$this->button_filter       = TRUE;        
			$this->button_export       = FALSE;	        
			$this->button_import       = FALSE;
			$this->button_bulk_action  = TRUE;	
			$this->sidebar_mode		   = "normal"; //normal,mini,collapse,collapse-mini
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
// 			$this->col[] = ["label"=>"Pelatihan","name"=>"pelatihan_id","join"=>"pelatihan,nama_pelatihan"];
// 			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nik"];
// 			$this->col[] = ["label"=>"Nama","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
// 			$this->col[] = ["label"=>"Alamat","name"=>"warga_bjb_id","join"=>"warga_bjb,alamat"];
			$this->col[] = ["label"=>"NIK","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Usaha","name"=>"umkm_usaha_id","join"=>"umkm_usaha,nama_usaha"];
			$this->col[] = ["label"=>"Kelompok","name"=>"grup_id","join"=>"grup,nama_grup"];
			//$this->col[] = ["label"=>"Owner Priv","name"=>"owner_priv","join"=>"cms_privileges,name"];
			$this->col[] = ["label"=>"Status","name"=>"status_id","join"=>"status_surat,status"];
			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
// 			$this->form[] = ['label'=>'Pelatihan','name'=>'pelatihan_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'pelatihan,nama_pelatihan'];
// 			$this->form[] = ['label'=>'Warga','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|integer|min:0','width'=>'col-sm-10','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp','datamodal_module_path'=>'AdminUmkmUsahaController'];
// 			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|min:1|max:255','width'=>'col-sm-8','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr,alamat','datamodal_size'=>'large','datamodal_columns_alias_name'=>'NIK','Nama Lengkap','Tempat Lahir','Tanggal Lahir'];
			$this->form[] = ['label'=>'Usaha','name'=>'umkm_usaha_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-10','datatable'=>'umkm_usaha,nama_usaha','datatable_where'=>'status_id = 5','parent_select'=>'warga_bjb_id'];
			$this->form[] = ['label'=>'Kelompok','name'=>'grup_id','type'=>'select2','validation'=>'integer|min:0','width'=>'col-sm-10','datatable'=>'grup,nama_grup'];
		//	$this->form[] = ['label'=>'Owner Priv','name'=>'owner_priv','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Status','name'=>'status_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'status_surat,status'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-10','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Pelatihan Id","name"=>"pelatihan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pelatihan,nama_pelatihan"];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Hari Ke","name"=>"hari_ke","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
            $this->addaction[] = ['label'=>'Aprove','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('aproval').'/[id]/5','showIf'=>'[status_id] < 4'];
	        $this->addaction[] = ['label'=>'Batalkan','icon'=>'fa fa-address-card','color'=>'warning','url'=>CRUDBooster::mainpath('aproval').'/[id]/3','showIf'=>'[status_id] >= 4'];
	        $this->addaction[] = ['label'=>'Tolak','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::mainpath('aproval').'/[id]/4','showIf'=>'[status_id] < 4'];
	        $this->addaction[] = ['label'=>'Hadir','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('aproval').'/[id]/6','showIf'=>'[status_id] == 5'];

	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    
	    public function getDaftarPeserta($pelatihan_id) {
          //First, Add an auth
           if(!CRUDBooster::isView()) CRUDBooster::redirect(CRUDBooster::adminPath(),trans('crudbooster.denied_access'));
           
           //Create your own query 
           $data = [];
           $data['pelatihan']  = DB::table('pelatihan')->where('id',$pelatihan_id)->first();
           $data['page_title'] = 'Daftar peserta ' . $data['pelatihan']->nama_pelatihan ;
            if(CRUDBooster::myPrivilegeId()==2){
               $data['result'] = DB::table('surat_reg_pelatihan')
                                ->join('warga_bjb','warga_bjb.id','surat_reg_pelatihan.warga_bjb_id')
                                ->leftJoin('umkm_pemilik','warga_bjb.id','umkm_pemilik.warga_bjb_id')
                                ->where('surat_reg_pelatihan.pelatihan_id',$pelatihan_id)
                                ->where('surat_reg_pelatihan.status_id',5)
                                ->select('surat_reg_pelatihan.*','warga_bjb.nik','warga_bjb.nama_lgkp','warga_bjb.alamat2','warga_bjb.telp','umkm_pemilik.no_telp')
                                ->orderby('surat_reg_pelatihan.status_id','desc')
                                ->paginate(10);
    	    }else{
    	        $data['result'] = DB::table('surat_reg_pelatihan')
                                ->join('warga_bjb','warga_bjb.id','surat_reg_pelatihan.warga_bjb_id')
                                ->leftJoin('umkm_pemilik','warga_bjb.id','umkm_pemilik.warga_bjb_id')
                                ->where('surat_reg_pelatihan.pelatihan_id',$pelatihan_id)
                                ->select('surat_reg_pelatihan.*','warga_bjb.nik','warga_bjb.nama_lgkp','warga_bjb.alamat2','warga_bjb.telp','umkm_pemilik.no_telp')
                                ->orderby('surat_reg_pelatihan.status_id','desc')
                                ->paginate(10);
    	    }
            
           //Create a view. Please use `cbView` method instead of view method from laravel.
           $this->cbView('pelatihan.peserta',$data);
        }
        
        
	    
	    public function getSistemPelatihan(){
	        $data = [];
	        
	        $data['pelatihan'] = DB::table('pelatihan')->orderBy('tanggal_akhir','DESC')->get();
	        
	        foreach($data['pelatihan'] as $pa){
	           $peserta = DB::table('surat_reg_pelatihan')
	                        ->where('pelatihan_id',$pa->id)
	                        ->where('status_id',5)
	                        ->count();
	           
	           $pa->booked = $peserta;
	        }
	        
	        $data['pelatihan_baru'] = DB::table('pelatihan')
	                                ->whereDate('akhir_daftar', '>=', date("Y-m-d"))
	                                ->orderBy('akhir_daftar','DESC')
	                                ->get();
	       
	       foreach($data['pelatihan_baru'] as $pb){
	           $peserta = DB::table('surat_reg_pelatihan')
	                        ->where('pelatihan_id',$pb->id)
	                        ->where('status_id',5)
	                        ->count();
	           $pb->booked = $peserta;
	       }
	       
	                                
	       $data['pelatihan_akan_datang'] = DB::table('pelatihan')
	                                ->whereDate('tanggal_mulai', '>', date("Y-m-d"))
	                                ->orderBy('akhir_daftar','DESC')
	                                ->get();
	                                
	       foreach($data['pelatihan_akan_datang'] as $pad){
	           $peserta = DB::table('surat_reg_pelatihan')
	                        ->where('pelatihan_id',$pad->id)
	                        ->where('status_id',5)
	                        ->count();
	           $pad->booked = $peserta;
	       }
	       
	       $data['pelatihan_lampau'] = DB::table('pelatihan')
	                                ->whereDate('tanggal_akhir', '<', date("Y-m-d"))
	                                ->orderBy('akhir_daftar','DESC')
	                                ->get();
	                                
	       foreach($data['pelatihan_lampau'] as $pl){
	           $peserta = DB::table('surat_reg_pelatihan')
	                        ->where('pelatihan_id',$pl->id)
	                        ->where('status_id',5)
	                        ->count();
	           $pl->booked = $peserta;
	       }
	        
	        return view('pelatihan.index',$data);
	        
	    }
	    
	    public function getSistem(){
            $this->getSistemPelatihan();
        }
	    
	    public function getDaftarPelatihan($id){
	        if(CRUDBooster::myPrivilegeId()==2){
	            $data['warga_bjb_id'] = CRUDBooster::menik(CRUDBooster::me()->nik)->id;
	            $data['warga_bjb'] = DB::table('warga_bjb')
            	                            ->join('districts','warga_bjb.nama_kec','districts.id')
            	                            ->join('villages','warga_bjb.nama_kel','villages.id')
            	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
            	                            ->where('nik',CRUDBooster::me()->nik)
            	                            ->first();
            	$data['page_title'] = "Data Anda " . CRUDBooster::me()->nik;
                $data['id'] = $id;
                
                $data['bantuan'] = DB::table('pelatihan')->where('id',$id)->first();
                
                $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb_id'])
                            ->where('status_id',5)
                            ->get();
                            
                $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                ->where('warga_bjb_id',$data['warga_bjb_id'])
                                ->where('status_id',5)
                                ->get();
                
                $data['owner_priv'] = $data['bantuan']->created_by_priv;
	            $data['row'] = DB::table('pelatihan')->where('id',$id)->first();
	            $data['hari'] = array(
                    'Minggu',
                    'Senin', 
                    'Selasa', 
                    'Rabu', 
                    'Kamis', 
                    'Jumat', 
                    'Sabtu', 
                 );
	            
	            if($data['row']->usaha_required==1){
    	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb_id'])->first();
    	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb_id'])->get();
    	            
    	            if(CRUDBooster::myPrivilegeId()==2){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
    	            }else{
    	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
    	            }
    	            
    	            $data['next'] = CRUDBooster::mainpath("step3") ;
    	            $data['prev'] = CRUDBooster::mainpath() ;
	                $data['galat'] = CRUDBooster::mainpath() ;
    	            
    	            return view('bantuan.step2', $data);
    	        }elseif($data['row']->usaha_required==2){
    	            $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->get();
    	            $data['next'] = CRUDBooster::mainpath("step4") ;
    	            $data['prev'] = CRUDBooster::mainpath() ;
	                $data['galat'] = CRUDBooster::mainpath() ;
    	            
    	            if(CRUDBooster::myPrivilegeId()==2){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
    	            }else{
    	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
    	            }
    	            
    	           return view('bantuan.step2', $data);
    	        }elseif($data['row']->usaha_required==0){
                    $data['next'] = CRUDBooster::mainpath("step4") ;
                    $data['prev'] = CRUDBooster::mainpath() ;
	                $data['galat'] = CRUDBooster::mainpath() ;
    	            
    	            if(CRUDBooster::myPrivilegeId()==2){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
    	            }else{
    	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
    	            }
    	            
    	            return view('bantuan.step2', $data);
    	        }
	            
	             //return view('pelatihan.registrasi',$data);
	        }else{
	            return CRUDBooster::redirect(CRUDBooster::adminPath('surat_masuk'),'Anda admin');
	        }
	    }
	    
	    public function postStep3(){
	        $data = [];
	        $data['page_title'] = "Kelengkapan Data Usaha Anda";
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
	        $data['warga_bjb_id'] = Request::input('warga_bjb_id');
	        $data['usaha_baru'] = Request::input('usaha_baru');
	        $data['usaha_required'] = Request::input('usaha_required');
	        
	        if(Request::input('usaha_required')==1){
    	        //if(Request::input('no_iumk') && Request::input('no_npwp') && Request::input('nib_sku') && Request::input('no_telp') ){
    	        if( Request::input('no_telp') ){
    	            if(Request::input('pemilik_id')){
    	                DB::table('umkm_pemilik')->where('id',Request::input('pemilik_id'))->update(['no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp')]);
    	                $data['pemilik_id'] = Request::input('pemilik_id');
    	            }else{
    	                $pemilik = DB::table('umkm_pemilik')->insertGetId(['warga_bjb_id'=>Request::input('warga_bjb_id'),'no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp')]);
    	            
    	                $data['pemilik_id'] = $pemilik;
    	            }
    	            
    	            if(Request::input('usaha_baru')==0){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->first();
    	            }else{
    	                $data['usaha_baru'] = Request::input('usaha_baru');
    	            }
    	            $data['bidang_usaha'] =  DB::table('umkm_jenis_usaha')->get();
    	            $data['kecamatan'] =  DB::table('districts')->where('regency_id','6372')->get();
    	            $data['kelurahan'] =  DB::table('villages')->where('district_id','like','6372%')->get();
    	            $data['umkm_status_tempat'] =  DB::table('umkm_status_tempat')->get();
    	            $data['umkm_perizinan'] =  DB::table('umkm_perizinan')->get();
    	            $data['umkm_permodalan'] =  DB::table('umkm_permodalan')->get();
    	           // $data['umkm_pemasaran'] =  DB::table('umkm_sistem_pemasaran')->get();
    	            
    	            //return redirect(CRUDBooster::adminPath('umkm_usaha/edit/'.Request::input('usaha_id')));
    	            $data['next'] = CRUDBooster::mainpath("step4") ;
    	            
    	            return view('bantuan.step3', $data);
    	        } else{
    	          //    CRUDBooster::redirectBack('Harap Lengkapi Data','warning');
    	            return redirect()->back()->with('pemilikreq', 'Harap Isi Data Ini !'); 
    	        }
	        }elseif(Request::input('usaha_required')==2){
	            
	            
	            return view('bantuan.step4', $data);
	        }
	    }
	    
	    public function postStep4(){
	        $data = [];
	        $data['page_title'] = "Selesai";
            $data['id'] = Request::input('id');
            
            if(CRUDBooster::myId()==2){
                $status_permohonan = 1;
            }else{
                $status_permohonan = 3;
            }
	        
	        //var_dump();
	        if(Request::input('usaha_required')==1){
    	        if(Request::input('usaha_baru')==0){
    	            DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->update([
    	                    'nama_usaha'=>Request::input('nama_usaha'),
    	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
    	                    'brand'=>Request::input('brand'),
    	                    'alamat_usaha'=>Request::input('alamat_usaha'),
    	                    'province_id'=>63,
    	                    'regency_id'=>6372,
    	                    'district_id'=>Request::input('district_id'),
    	                    'village_id'=>Request::input('village_id'),
    	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
    	                    'perizinan'=>implode(";",Request::input('perizinan')),
    	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
    	                    'pemasaran_id'=>3,
    	                    'j_kary_l'=>Request::input('j_kary_l'),
    	                    'j_kary_p'=>Request::input('j_kary_p'),
    	                    'j_kary'=>Request::input('j_kary'),
    	                    'modal_awal'=>Request::input('modal_awal'),
    	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
    	                    'aset_tetap'=>Request::input('aset_tetap'),
    	                    'omset'=>Request::input('omset')
    	                ]);
    	                
    	                $exist = DB::table('surat_reg_pelatihan')
    	                    ->where('pelatihan_id',Request::input('id'))
    	                    ->where('warga_bjb_id',Request::input('warga_bjb_id'))
    	                    ->where('umkm_usaha_id',Request::input('usaha_id'))
    	                    ->first();
    	                    
    	               //var_dump($exist);
    	                    
    	               if(!$exist){
    	                   $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
        	                       'pelatihan_id'=>Request::input('id'),
        	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
        	                       'umkm_pemilik_id'=>Request::input('pemilik_id'),
        	                       'umkm_usaha_id'=>Request::input('usaha_id'),
        	                       'created_by'=>CRUDBooster::myId(),
        	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
        	                       'created_at'=>now(),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'owner_priv'=>Request::input('owner_priv'),
        	                       'status_id'=>$status_permohonan
    	                       ]);
    	                    
    	                    $this->suratMasukPelatihan($surat_baru,Request::input('warga_bjb_id'),$newusaha,Request::input('pemilik_id'),Request::input('owner_priv'));
    	                   CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
    	               }else{
    	                   CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data sudah ada","warning");
    	                   //return redirect(CRUDBooster::mainpath())->with(['Data sudah ada', 'warning']);  
    	               }
    	        }elseif(Request::input('usaha_baru')==1){
    	            $newusaha = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->insertGetId([
    	                            'warga_bjb_id'=>Request::input('warga_bjb_id'),
            	                    'nama_usaha'=>Request::input('nama_usaha'),
            	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
            	                    'brand'=>Request::input('brand'),
            	                    'alamat_usaha'=>Request::input('alamat_usaha'),
            	                    'province_id'=>63,
            	                    'regency_id'=>6372,
            	                    'district_id'=>Request::input('district_id'),
            	                    'village_id'=>Request::input('village_id'),
            	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
            	                    'perizinan'=>implode(";",Request::input('perizinan')),
            	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
            	                    'pemasaran_id'=>3,
            	                    'j_kary_l'=>Request::input('j_kary_l'),
            	                    'j_kary_p'=>Request::input('j_kary_p'),
            	                    'j_kary'=>Request::input('j_kary'),
            	                    'modal_awal'=>Request::input('modal_awal'),
            	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
            	                    'aset_tetap'=>Request::input('aset_tetap'),
            	                    'omset'=>Request::input('omset'),
            	                    'updated_by'=>CRUDBooster::myId()
            	                ]);
            	   
            	   $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
        	                       'pelatihan_id'=>Request::input('id'),
        	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
        	                       'umkm_pemilik_id'=>Request::input('pemilik_id'),
        	                       'umkm_usaha_id'=>$newusaha,
        	                       'created_by'=>CRUDBooster::myId(),
        	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
        	                       'created_at'=>now(),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'owner_priv'=>Request::input('owner_priv'),
        	                       'status_id'=>$status_permohonan
    	                       ]);
    	                       
    	           $this->suratMasukPelatihan($surat_baru,Request::input('warga_bjb_id'),$newusaha,Request::input('pemilik_id'),Request::input('owner_priv'));
    	           CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
    	                       
            	   //$exist = DB::table('surat_permohonan_bantuan')->where('pelatihan_id',Request::input('id'))->where('warga_bjb_id',Request::input('warga_bjb_id'))->where('umkm_usaha_id',$newusaha)->first();
    	        }
	        }elseif(Request::input('usaha_required')==2){
	            if(Request::input('grup_id')>0){
    	            $exist = DB::table('surat_reg_pelatihan')
                        ->where('pelatihan_id',Request::input('id'))
                        ->where('warga_bjb_id',Request::input('warga_bjb_id'))
                        ->where('grup_id',Request::input('grup_id'))
                        ->first();
                        
                   if(!$exist){
                       $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
    	                       'pelatihan_id'=>Request::input('id'),
    	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
    	                       'grup_id'=>Request::input('grup_id'),
    	                       'created_by'=>CRUDBooster::myId(),
    	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
    	                       'created_at'=>now(),
    	                       'updated_by'=>CRUDBooster::myId(),
    	                       'owner_priv'=>Request::input('owner_priv'),
    	                       'status_id'=>$status_permohonan
                           ]);
                        
                        $this->suratMasukPelatihan($surat_baru,Request::input('warga_bjb_id'),$newusaha,Request::input('pemilik_id'),Request::input('owner_priv'));
                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
                   }else{
                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data sudah ada","warning");
                   }
	            }else{
	               CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Harap Memilih Kelompok","warning"); 
	            }
	        }else{
	            $exist = DB::table('surat_reg_pelatihan')
                    ->where('pelatihan_id',Request::input('id'))
                    ->where('warga_bjb_id',Request::input('warga_bjb_id'))
                    ->first();
                    
               if(!$exist){
                   $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
	                       'pelatihan_id'=>Request::input('id'),
	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
	                       'created_by'=>CRUDBooster::myId(),
	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
	                       'created_at'=>now(),
	                       'updated_by'=>CRUDBooster::myId(),
	                       'owner_priv'=>Request::input('owner_priv'),
	                       'status_id'=>$status_permohonan
                       ]);
                       
                    $this->suratMasukPelatihan($surat_baru,Request::input('warga_bjb_id'),$newusaha,Request::input('pemilik_id'),Request::input('owner_priv'));  
                   CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
               }else{
                   CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data sudah ada","warning");
               }
	        }
            
	            
	       // return redirect(CRUDBooster::mainpath());

	    }
	    
	    public function suratMasukPelatihan($id,$warga_bjb_id,$usaha_id,$pemilik_id,$owner_priv){
	                $warga_bjb = DB::table('warga_bjb')->where('id',$warga_bjb_id)->first();
    	            $jenis_surat = DB::table('surat')->where('tabel','surat_reg_pelatihan')->first();
    	            $last_id = DB::table('surat_masuk')->insertGetId([
    					'jenis_surat_id' => $jenis_surat->id,
    					'owner_priv' => $owner_priv,
    					'nik' => $warga_bjb->nik,
    					'nama_lgkp' => $warga_bjb->nama_lgkp,
    					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
    					'tgl_lhr' => $warga_bjb->tgl_lhr,
    					'alamat' => $warga_bjb->alamat,
    					'rt' => $warga_bjb->rt,
    					'rw' => $warga_bjb->rw,
    					'district_id' => $warga_bjb->nama_kec,
    					'village_id' => $warga_bjb->nama_kel,
    					'jk' => $warga_bjb->jk,
    					'pekerjaan' => $warga_bjb->pekerjaan,
    					'no_telp' => $warga_bjb->telp,
    					'created_at' => Carbon::now(),
    					'created_by' => CRUDBooster::myId(),
    					'status_id' => 1,
    					'status_by' => CRUDBooster::myId(),
    					'status_by_priv' => CRUDBooster::myPrivilegeId(),
    					'rel_table' => 'surat_reg_pelatihan',
    					'rel_id' =>  $id
    				]);
    				
                    //var_dump($last_id);
        			
        			// $config['id_cms_users'] = $notified_user;
        			
        			// CRUDBooster::sendNotification($config);
        			
        			CRUDBooster::createMasterNotif($jenis_surat->id,CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat,$this->table,"openUrl;".$last_id.";".CRUDBooster::adminPath('surat_masuk'));
        			
        			//CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");

	    }
	    
	    public function postDaftarPelatihan(){
	        if(CRUDBooster::MyPrivilegeId()==2){
	            $exist = DB::table('surat_reg_pelatihan')->where('pelatihan_id',Request::input('id'))->where('warga_bjb_id',Request::input('warga_bjb_id'))->first();
	            if(!$exist){
    	            $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId(['pelatihan_id'=>Request::input('id'),'warga_bjb_id'=>Request::input('warga_bjb_id'),'updated_by'=>CRUDBooster::myId(),'owner_priv'=>Request::input('owner_priv')]);
    	            $warga_bjb = DB::table('warga_bjb')->where('id',Request::input('warga_bjb_id'))->first();
    	            $jenis_surat = DB::table('surat')->where('tabel','surat_reg_pelatihan')->first();
    	            $last_id = DB::table('surat_masuk')->insertGetId([
    					'jenis_surat_id' => $jenis_surat->id,
    					'owner_priv' => Request::input('owner_priv'),
    					'nik' => $warga_bjb->nik,
    					'nama_lgkp' => $warga_bjb->nama_lgkp,
    					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
    					'tgl_lhr' => $warga_bjb->tgl_lhr,
    					'alamat' => $warga_bjb->alamat,
    					'rt' => $warga_bjb->rt,
    					'rw' => $warga_bjb->rw,
    					'district_id' => $warga_bjb->nama_kec,
    					'village_id' => $warga_bjb->nama_kel,
    					'jk' => $warga_bjb->jk,
    					'pekerjaan' => $warga_bjb->pekerjaan,
    					'no_telp' => $warga_bjb->telp,
    					'created_at' => Carbon::now(),
    					'created_by' => CRUDBooster::myId(),
    					'status_id' => 1,
    					'status_by' => CRUDBooster::myId(),
    					'status_by_priv' => CRUDBooster::myPrivilegeId(),
    					'rel_table' => 'surat_reg_pelatihan',
    					'rel_id' =>  $surat_baru
    				]);
    				
                    //var_dump($last_id);
        			
        			// $config['id_cms_users'] = $notified_user;
        			
        			// CRUDBooster::sendNotification($config);
        			
        			CRUDBooster::createMasterNotif($jenis_surat->id,CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat,$this->table,"openUrl;".$last_id.";".CRUDBooster::adminPath('surat_masuk'));
        			return redirect(CRUDBooster::adminPath('skck_warga'));
	            }else{
	                return redirect()->back()->with('pelatihan_exist', 'Anda sudah terdaftar !');  
	            }
            }
	    }
	    
	    public function getPintasan($aksi,$warga_bjb_id,$pelatihan_id){
	        $data = [];
	        $data['warga']  = DB::table('warga_bjb')->where('id',$warga_bjb_id)->first();
	       // $data['reg']  = DB::table('surat_reg_pelatihan')->where('id',$pelatihan_id)->where('warga_bjb_id',$warga_bjb_id)->first();
	        //$data['surat_masuk']  = DB::table('surat_masuk')->where('rel_id',$pelatihan_id)->where('rel_table','surat_reg_pelatihan')->first();
	        if($aksi=="hist"){
                $data['page_title'] = 'History Pelatihan ' . $data['warga']->nama_lgkp ;
                $data['result'] = DB::table('surat_reg_pelatihan')
                                ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                                ->where('warga_bjb_id',$warga_bjb_id)
                                ->where('status_id',6)
                                ->paginate(10);
                
               //Create a view. Please use `cbView` method instead of view method from laravel.
               $this->cbView('pelatihan.history',$data);
	        }elseif($aksi=="setuju"){
	            DB::table('surat_masuk')->where('rel_id',$pelatihan_id)->where('rel_table','surat_reg_pelatihan')->update(['status_id'=>5,'status_by'=>CRUDBooster::myId(),'status_by_priv'=>CRUDBooster::myPrivilegeId()]);
	            DB::table('surat_reg_pelatihan')->where('id',$pelatihan_id)->update(['status_id'=>5,'updated_by'=>CRUDBooster::myId()]);
	            
	            return redirect()->back();
	        }elseif($aksi=="batalkan"){
	            DB::table('surat_masuk')->where('rel_id',$pelatihan_id)->where('rel_table','surat_reg_pelatihan')->update(['status_id'=>2,'status_by'=>CRUDBooster::myId(),'status_by_priv'=>CRUDBooster::myPrivilegeId()]);
	            DB::table('surat_reg_pelatihan')->where('id',$pelatihan_id)->update(['status_id'=>2,'updated_by'=>CRUDBooster::myId()]);
	            
	            return redirect()->back();
	        }elseif($aksi=="hadir"){
	            DB::table('surat_masuk')->where('rel_id',$pelatihan_id)->where('rel_table','surat_reg_pelatihan')->update(['status_id'=>6,'status_by'=>CRUDBooster::myId(),'status_by_priv'=>CRUDBooster::myPrivilegeId()]);
	            DB::table('surat_reg_pelatihan')->where('id',$pelatihan_id)->update(['status_id'=>6,'updated_by'=>CRUDBooster::myId()]);
	            
	            return redirect()->back();
	            
	        }elseif($aksi=="batalhadir"){
	            DB::table('surat_masuk')->where('rel_id',$pelatihan_id)->where('rel_table','surat_reg_pelatihan')->update(['status_id'=>5,'status_by'=>CRUDBooster::myId(),'status_by_priv'=>CRUDBooster::myPrivilegeId()]);
	            DB::table('surat_reg_pelatihan')->where('id',$pelatihan_id)->update(['status_id'=>5,'updated_by'=>CRUDBooster::myId()]);
	            
	            return redirect()->back();
	            
	        }
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }
	    
	    public function getAproval($id,$val){
	        DB::table('surat_reg_pelatihan')->where('id',$id)->update(['status_id'=>$val,'updated_by'=>CRUDBooster::myId()]);
	        
	        CRUDBooster::redirectBack("Data berhasil di update","success");
	    }



	    //By the way, you can still create your own method in here... :) 


	}