<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;
//	require_once '/home/siapkkroot/siapkk/public/vendor/xlsx/SimpleXLSX.php';
	use PDF;

	class AdminUmkmBantuanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "id";
			$this->limit = "20";
			$this->orderby = "id,asc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "bantuan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Tanggal","name"=>"tanggal"];
			$this->col[] = ["label"=>"Bantuan","name"=>"bantuan"];
			$this->col[] = ["label"=>"Pemberi Bantuan","name"=>"pemberi_bantuan"];
			$this->col[] = ["label"=>"Jumlah","name"=>"jumlah"];
			$this->col[] = ["label"=>"Satuan","name"=>"satuan_id","join"=>"satuan,satuan"];
			$this->col[] = ["label"=>"Item","name"=>"(SELECT COUNT(id) FROM bantuan_item WHERE bantuan_id = bantuan.id ) as items","callback_php"=>"$row->items" ];
			//$this->col[] = ["label"=>"Total","name"=>"total"];
			//$this->col[] = ["label"=>"Satuan Total","name"=>"satuan_total","join"=>"satuan,satuan"];
			$this->col[] = ["label"=>"Keterangan","name"=>"keterangan"];
			$this->col[] = ["label"=>"Persyaratan","name"=>"usaha_required","callback_php"=>'($row->usaha_required == 1? "Usaha" : ($row->usaha_required == 2? "Kelompok" : "Pribadi"))'];
			if(CRUDBooster::myPrivilegeId()==14){
    			$this->col[] = ["label"=>"Excel File","name"=>"upload_file"];
    			$this->col[] = ["label"=>"Import log","name"=>"hasil_import"];
			}
			$this->col[] = ["label"=>"Dibuat Oleh","name"=>"created_by_priv","join"=>"cms_privileges,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'date','validation'=>'required','width'=>'col-sm-4','value'=>now()];
			$this->form[] = ['label'=>'Nama Bantuan','name'=>'bantuan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Pemberi Bantuan','name'=>'pemberi_bantuan','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Jumlah','name'=>'jumlah','type'=>'number','validation'=>'required','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Satuan','name'=>'satuan_id','type'=>'select2','validation'=>'required','width'=>'col-sm-4','datatable'=>'satuan,satuan'];
			//$this->form[] = ['label'=>'Total','name'=>'total','type'=>'number','validation'=>'integer','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'Satuan Total','name'=>'satuan_total','type'=>'select2','width'=>'col-sm-4','datatable'=>'satuan,satuan'];
			$this->form[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'wysiwyg','validation'=>'min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Membutuhkan Usaha/Kelompok','name'=>'usaha_required','type'=>'radio','width'=>'col-sm-6','dataenum'=>'2|Kelompok;1|Usaha;0|Pribadi'];
			$this->form[] = ['label'=>'Gambar','name'=>'photo','type'=>'upload','validation'=>'image|max:3000','width'=>'col-sm-5','help'=>'Tipe file yang didukung: JPG, JPEG, PNG, GIF, BMP'];
			$this->form[] = ['label'=>'Aktif','name'=>'aktif','type'=>'radio','width'=>'col-sm-6','dataenum'=>'1|Ya;0|Tidak'];
			$this->form[] = ['label'=>'Excel File (.xlsx)','name'=>'upload_file','type'=>'upload','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Updated By Priv','name'=>'updated_by_priv','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myPrivilegeId()];
			if(CRUDBooster::myPrivilegeId()==5){
    			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::me()->village_id];
			}
			if(CRUDBooster::myPrivilegeId()==5){
    			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'hidden','width'=>'col-sm-4','value'=>CRUDBooster::me()->district_id];
			}
			if(CRUDBooster::myPrivilegeId()==1){
    			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'districts,name','datatable_where'=>'regency_id ='.CRUDBooster::getSetting('kode_kabupaten')];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-6','datatable'=>'villages,name','datatable_where'=>'district_id like "'.CRUDBooster::getSetting('kode_kabupaten').'%"','parent_select'=>'district_id'];
			}
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Bantuan","name"=>"bantuan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Item','path'=>'bantuan_item','parent_columns'=>'bantuan,pemberi_bantuan','foreign_key'=>'bantuan_id','button_color'=>'info','button_icon'=>'fa fa-bars','showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId() OR [created_by_priv] == CRUDBooster::myParentPriv() OR [created_by_priv] == CRUDBooster::myParentPriv() '];
            $this->sub_module[] = ['label'=>'Penerima Bantuan','path'=>'surat_permohonan_bantuan','parent_columns'=>'bantuan,pemberi_bantuan','foreign_key'=>'relasi_id','button_color'=>'success','button_icon'=>'fa fa-bars','showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId() OR [created_by_priv] == CRUDBooster::myParentPriv() '];
            $this->sub_module[] = ['label'=>'Laporan','path'=>'laporan_peneriama_bantuan','parent_columns'=>'bantuan,pemberi_bantuan','foreign_key'=>'relasi_id','button_color'=>'success','button_icon'=>'fa fa-user','showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId()'];
            //$this->sub_module[] = ['label'=>'Tambah Pemohon','path'=>'surat_permohonan_bantuan','parent_columns'=>'bantuan,pemberi_bantuan','foreign_key'=>'relasi_id','button_color'=>'success','button_icon'=>'fa fa-bars'];

	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        //$this->addaction[] = ['label'=>'Daftar Penerima','icon'=>'fa fa-address-card','color'=>'warning','url'=>CRUDBooster::mainpath('penerima').'/[id]/'];
    	        $this->addaction[] = ['label'=>'Import','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('import-file').'/[id]','showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId()'];
    	        $this->addaction[] = ['label'=>'Tambah Pemohon','icon'=>'fa fa-address-card','color'=>'success','url'=>CRUDBooster::mainpath('by-admin').'/[id]'];
	        


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    
	    public function getSistemBantuan(){
	        $data = [];
	        
	        $data['bantuan'] = DB::table('bantuan')->where('aktif',1)->orderBy('tanggal','DESC')->get();
	        
	        
	       // foreach($data['bantuan'] as $bantuan){
	       //     $media = DB::table('media_bantuan')->where('id_ortu',$bantuan->id)->get();
	            
	       //     $batuan['media'] = $media;
	       // }
	        
	        
	        return view('bantuan.index',$data);
	        
	    }
	    
	    public function getByAdmin($id){
	       // if (! CRUDBooster::isCreate() && $this->global_privilege == false) {
        //         CRUDBooster::insertLog(trans('crudbooster.log_try_add', ['module' => CRUDBooster::getCurrentModule()->name]));
        //         CRUDBooster::redirect(CRUDBooster::adminPath(), trans("crudbooster.denied_access"));
        //     }
	        
	        $data = [];
	        
	        $data['page_title'] = "Daftar Pemohon Bantuan";
	        $data['id'] = $id;
	        
	       // $data['created_by'] = CRUDBooster::myId();
	       // $data['created_by_priv'] = CRUDBooster::myPrivilegeId();
	        
	       // if($id>0){
	       //     $data['row'] = DB::table('permohonan_bantuan')->where('bantuan_id',$id)->first();
	       // }
	        $data['row'] = DB::table('bantuan')->where('id',$id)->first();
	        $data['bantuan_item'] = DB::table('bantuan_item')->where('bantuan_id',$id)->get();
	        
	        if(sizeof( $data['bantuan_item'])>0){
	            $data['next'] = CRUDBooster::mainpath("step1") ;
    	        $data['prev'] = CRUDBooster::mainpath() ;
    	        $data['galat'] = CRUDBooster::mainpath() ;
    	        
    	        return view('bantuan.addbyadmin', $data);
	        }else{
    	        $data['next'] = CRUDBooster::mainpath("step2") ;
    	        $data['prev'] = CRUDBooster::mainpath() ;
    	        $data['galat'] = CRUDBooster::mainpath() ;
    	        
    	        return view('bantuan.addbyadmin', $data);
	        }
	    }
	    
	    public function postStep1(){
	        $data = [];
	        $data['page_title'] = "Pilih item bantuan";
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
            $data['nik'] = Request::input('nik');
            $data['row'] = DB::table('bantuan')->where('id',Request::input('id'))->first();
            $data['bantuan_item'] = DB::table('bantuan_item')->where('bantuan_id',Request::input('id'))->get();
            
            $data['next'] = CRUDBooster::mainpath("step2") ;
	        $data['prev'] = CRUDBooster::mainpath() ;
	        $data['galat'] = CRUDBooster::mainpath() ;
            
            return view('bantuan.step1', $data);
	    }
	    
	    public function postStep2(){
	        $data = [];
	        $data['page_title'] = "Data Warga " . Request::input('nik');
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
            $data['bantuan'] = DB::table('bantuan')->where('id',Request::input('id'))->first();
            $data['bantuan_item'] = DB::table('bantuan_item')->where('bantuan_id',Request::input('id'))->get();
            $data['bantuan_item_id'] = Request::input('bantuan-item');
            $data['j_bantuan_item'] = Request::input('j-bantuan-item');
            
	        
	        if(Request::input('nik')){
	            $warga_cloud = DB::table('warga_bjb')
	                            ->join('districts','warga_bjb.nama_kec','districts.id')
	                            ->join('villages','warga_bjb.nama_kel','villages.id')
	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
	                            ->where('nik',Request::input('nik'))
	                            ->first();
	            
	           // if(!$warga_cloud->no_kk){
	           if(!$warga_cloud->nik){
    	            $capil = CRUDBooster::updateNik(Request::input('nik'));
                
                    //var_dump($capil->local_exist);
                    
                    if($capil->api_status=="1"){
                        $locally = $capil->local_exist;
                        
                        
            	        $data['warga_bjb'] = DB::table('warga_bjb')
            	                            ->join('districts','warga_bjb.nama_kec','districts.id')
            	                            ->join('villages','warga_bjb.nama_kel','villages.id')
            	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
            	                            ->where('nik',Request::input('nik'))
            	                            ->first();
            	       
            	       
                        $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb']->id)
                            ->where('status_id',5)
                            ->get();
                            
                        $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                        ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                        ->where('warga_bjb_id',$data['warga_bjb']->id)
                                        ->where('status_id',5)
                                        ->get();
            	       
            	        $data['pesan'] = "Data dari capil - " . $warga_cloud ;
            	        if($data['bantuan']->usaha_required==1){
            	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb']->id)->first();
            	            if(CRUDBooster::myPrivilegeId()==2){
            	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
            	            }else{
            	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	            }
            	            $data['next'] = CRUDBooster::mainpath("step3") ;
            	            $data['prev'] = CRUDBooster::mainpath() ;
	                        $data['galat'] = CRUDBooster::mainpath() ;
	                        
            	            
            	            return view('bantuan.step2', $data);
            	        }elseif($data['bantuan']->usaha_required==2){
            	            $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->get();
            	            if(CRUDBooster::myPrivilegeId()==2){
            	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
            	            }else{
            	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	            }
            	            
            	            $data['next'] = CRUDBooster::mainpath("step4") ;
            	            $data['prev'] = CRUDBooster::mainpath() ;
	                        $data['galat'] = CRUDBooster::mainpath() ;
            	            
            	            return view('bantuan.step2', $data);
            	        }elseif($data['bantuan']->usaha_required==0){
            	            if(CRUDBooster::myPrivilegeId()==2){
            	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
            	            }else{
            	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	            }
            	            
            	            $data['next'] = CRUDBooster::mainpath("step4") ;
            	            $data['prev'] = CRUDBooster::mainpath() ;
	                        $data['galat'] = CRUDBooster::mainpath() ;
            	            
            	            return view('bantuan.step2', $data);
            	        }
            	        
            	        
                        
                        // return CRUDBooster::redirectBack("Update data nik " . Request::input('nik') . " atas nama " . $locally->nama_lgkp . " berhasil", "success");
                    }else{
                        return CRUDBooster::redirectBack($capil->api_message, "warning");
                    }
	            }else{
                        
        	        $data['warga_bjb'] = $warga_cloud;
        	        
        	        $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb']->id)
                            ->where('status_id',5)
                            ->get();
                        
                    $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                    ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                    ->where('warga_bjb_id',$data['warga_bjb']->id)
                                    ->where('status_id',5)
                                    ->get();
        	        
        	        $data['pesan'] = "Data dari siapkk";
        	        if($data['bantuan']->usaha_required==1){
        	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb']->id)->first();
        	            if(CRUDBooster::myPrivilegeId()==2){
        	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
        	            }else{
        	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
        	            }
        	            $data['next'] = CRUDBooster::mainpath("step3") ;
        	            $data['prev'] = CRUDBooster::mainpath() ;
	                    $data['galat'] = CRUDBooster::mainpath() ;
        	            
        	            return view('bantuan.step2', $data);
        	        }elseif($data['bantuan']->usaha_required==2){
        	            $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->where('member.jabatan','Ketua')->get();
        	            if(CRUDBooster::myPrivilegeId()==2){
        	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
        	            }else{
        	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
        	            }
        	            $data['next'] = CRUDBooster::mainpath("step4") ;
        	            $data['prev'] = CRUDBooster::mainpath() ;
	                    $data['galat'] = CRUDBooster::mainpath() ;
        	            
        	            return view('bantuan.step2', $data);
        	        }elseif($data['bantuan']->usaha_required==0){
        	            if(CRUDBooster::myPrivilegeId()==2){
        	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->where('status_id',5)->get();
        	            }else{
        	                $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
        	            }
        	            $data['next'] = CRUDBooster::mainpath("step4") ;
        	            $data['prev'] = CRUDBooster::mainpath();
	                    $data['galat'] = CRUDBooster::mainpath();
	                    
        	            return view('bantuan.step2', $data);
        	            
        	        }
        	        
	            }
    	        
	        }else{
	            return redirect()->back()->with('nikreq', 'Harap isi NIK !'); 
	        }
	    }
	    
	    public function postStep3(){
	        //Khusus usaha_required
	        $data = [];
	        $data['page_title'] = "Kelengkapan Data Usaha";
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
	        $data['warga_bjb_id'] = Request::input('warga_bjb_id');
	        $data['usaha_baru'] = Request::input('usaha_baru');
	        $data['usaha_required'] = Request::input('usaha_required');
	        $data['bantuan_item_id'] = Request::input('bantuan_item_id');
	        
	        if(Request::input('usaha_required')==1){
    	        //if(Request::input('no_iumk') && Request::input('no_npwp') && Request::input('nib_sku') && Request::input('no_telp') ){
    	        if( Request::input('no_telp') ){
    	            if(Request::input('pemilik_id')){
    	                DB::table('umkm_pemilik')->where('id',Request::input('pemilik_id'))->update(['no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp')]);
    	                $data['pemilik_id'] = Request::input('pemilik_id');
    	            }else{
    	                $pemilik = DB::table('umkm_pemilik')->insertGetId(['warga_bjb_id'=>Request::input('warga_bjb_id'),'no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp'),'updated_by' => CRUDBooster::myId()]);
    	            
    	                $data['pemilik_id'] = $pemilik;
    	            }
    	            
    	            if(Request::input('usaha_baru')==0){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->first();
    	            }else{
    	                $data['usaha_baru'] = Request::input('usaha_baru');
    	            }
    	            //if(Request::input('usaha_id')){
        	            $data['bidang_usaha'] =  DB::table('umkm_jenis_usaha')->where('parent_id',0)->get();
        	            $data['sub_bidang_usaha'] =  DB::table('umkm_jenis_usaha')->where('parent_id','>',0)->get();
        	            $data['kecamatan'] =  DB::table('districts')->where('regency_id','6372')->get();
        	            $data['kelurahan'] =  DB::table('villages')->where('district_id','like','6372%')->get();
        	            $data['umkm_status_tempat'] =  DB::table('umkm_status_tempat')->get();
        	            $data['umkm_perizinan'] =  DB::table('umkm_perizinan')->get();
        	            $data['umkm_permodalan'] =  DB::table('umkm_permodalan')->get();
        	           // $data['umkm_pemasaran'] =  DB::table('umkm_sistem_pemasaran')->get();
    	           // }else{
    	           //    //return redirect()->back()->with('usahareq', 'Harap Isi Data Ini !'); 
    	           // }
    	            $data['next'] = CRUDBooster::mainpath("step4") ;
    	            $data['prev'] = CRUDBooster::mainpath() ;
	                $data['galat'] = CRUDBooster::mainpath() ;
    	            //return redirect(CRUDBooster::adminPath('umkm_usaha/edit/'.Request::input('usaha_id')));
    	            return view('bantuan.step3', $data);
    	        } else{
    	          //    CRUDBooster::redirectBack('Harap Lengkapi Data','warning');
    	            return redirect()->back()->with('usahareq', 'Harap Isi Data Ini !'); 
    	        }
	        }
	    }
	    
	    public function postStep4(){
	        $data = [];
	        $data['page_title'] = "Selesai";
            $data['id'] = Request::input('id');
	        $data['galat'] = CRUDBooster::mainpath() ;
	        $data['bantuan_item_id'] = Request::input('bantuan_item_id');
	        
	        $data['prev'] = CRUDBooster::mainpath() ;
	        $data['galat'] = CRUDBooster::mainpath() ;
	        
	        if(Request::input('sub_bidang_usaha')){
	            $sub_bidang_usaha = implode(";",Request::input('sub_bidang_usaha'));
	        }else{
	            $sub_bidang_usaha = "";
	        }
	        
	        //var_dump();
	        if(Request::input('usaha_required')==1){
    	        if(Request::input('usaha_baru')==0){
    	            DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->update([
    	                    'nama_usaha'=>Request::input('nama_usaha'),
    	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
    	                    'sub_bidang_usaha'=>$sub_bidang_usaha,
    	                    'brand'=>Request::input('brand'),
    	                    'alamat_usaha'=>Request::input('alamat_usaha'),
    	                    'province_id'=>63,
    	                    'regency_id'=>6372,
    	                    'district_id'=>Request::input('district_id'),
    	                    'village_id'=>Request::input('village_id'),
    	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
    	                    'perizinan'=>implode(";",Request::input('perizinan')),
    	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
    	                    'pemasaran_id'=>3,
    	                    'j_kary_l'=>Request::input('j_kary_l'),
    	                    'j_kary_p'=>Request::input('j_kary_p'),
    	                    'j_kary'=>Request::input('j_kary'),
    	                    'modal_awal'=>Request::input('modal_awal'),
    	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
    	                    'aset_tetap'=>Request::input('aset_tetap'),
    	                    'omset'=>Request::input('omset'),
    	                       'updated_by'=>CRUDBooster::myId()
    	                ]);
    	                
    	                $exist = DB::table('surat_permohonan_bantuan')
    	                    ->where('relasi_id',Request::input('id'))
    	                    ->where('warga_bjb_id',Request::input('warga_bjb_id'))
    	                    ->where('umkm_usaha_id',Request::input('usaha_id'))
    	                    ->first();
    	                    
    	               if(!$exist){
    	                   $surat_baru = DB::table('surat_permohonan_bantuan')->insertGetId([
        	                       'relasi_id'=>Request::input('id'),
        	                       'bantuan_item_id'=>Request::input('bantuan_item_id'),
        	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
        	                       'umkm_pemilik_id'=>Request::input('pemilik_id'),
        	                       'umkm_usaha_id'=>Request::input('usaha_id'),
        	                       'created_by'=>CRUDBooster::myId(),
        	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
        	                       'created_at'=>now(),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'owner_priv'=>Request::input('owner_priv'),
        	                       'status_id'=>3
    	                       ]);
    	                   if(CRUDBooster::myPrivilegeId()==2){
    	                       $this->suratMasuk($surat_baru,Request::input('warga_bjb_id'),Request::input('usaha_id'),Request::input('pemilik_id'),Request::input('owner_priv'),Request::input('grup_id'));
    	                       
    	                       //cetak pdf
    	                       $data['pemohon'] = DB::table('warga_bjb')
                    	                            ->join('districts','warga_bjb.nama_kec','districts.id')
                    	                            ->join('villages','warga_bjb.nama_kel','villages.id')
                    	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
                    	                            ->where('warga_bjb.id',Request::input('warga_bjb_id'))
                    	                            ->first();
                    	                            
                    	        $data['bantuan'] = DB::table('bantuan')->where('id',Request::input('id'))->first();
                    	        $data['bantuan_item'] = DB::table('bantuan_item')->where('id',Request::input('bantuan_item_id'))->first();
    	                       
    	                       $pdf = PDF::loadView('pdf.bantuan', $data);
    	                       $path = public_path('gen_pdfs');
                               $fileName =  'permohonan_bantuan_' . Request::input('id') . '_' . Request::input('warga_bjb_id') . '.pdf';
                               $pdf->save($path . '/' . $fileName);
                               
    	                       Session::flash('download.in.the.next.request', 'https://siapkk.banjarbarukota.go.id/gen_pdfs/' . $fileName);
                              // return $pdf->download('permohonan_bantuan_' . Request::input('id') . '_' . Request::input('warga_bjb_id') . '.pdf');
    	                       
    	                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan, Tekan tombol dibawah untuk mendownload.","success");
    	                   }else{    
    	                         CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
    	                   }
    	               }else{
    	                   if(CRUDBooster::myPrivilegeId()==2){
    	                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data sudah ada","warning");
    	                   }else{    
    	                         CRUDBooster::redirect(CRUDBooster::mainpath(),"Data sudah ada","warning");
    	                   }
    	                   
    	                   //return redirect(CRUDBooster::mainpath())->with(['Data sudah ada', 'warning']);  
    	               }
    	        }elseif(Request::input('usaha_baru')==1){
    	            $newusaha = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->insertGetId([
    	                            'warga_bjb_id'=>Request::input('warga_bjb_id'),
            	                    'nama_usaha'=>Request::input('nama_usaha'),
            	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
            	                    'sub_bidang_usaha'=>implode(";",Request::input('sub_bidang_usaha')),
            	                    'brand'=>Request::input('brand'),
            	                    'alamat_usaha'=>Request::input('alamat_usaha'),
            	                    'province_id'=>63,
            	                    'regency_id'=>6372,
            	                    'district_id'=>Request::input('district_id'),
            	                    'village_id'=>Request::input('village_id'),
            	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
            	                    'perizinan'=>implode(";",Request::input('perizinan')),
            	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
            	                    'pemasaran_id'=>3,
            	                    'j_kary_l'=>Request::input('j_kary_l'),
            	                    'j_kary_p'=>Request::input('j_kary_p'),
            	                    'j_kary'=>Request::input('j_kary'),
            	                    'modal_awal'=>Request::input('modal_awal'),
            	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
            	                    'aset_tetap'=>Request::input('aset_tetap'),
            	                    'omset'=>Request::input('omset'),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'status_id'=>3
            	                ]);
            	   
            	   $surat_baru = DB::table('surat_permohonan_bantuan')->insertGetId([
        	                       'relasi_id'=>Request::input('id'),
        	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
        	                       'umkm_pemilik_id'=>Request::input('pemilik_id'),
        	                       'umkm_usaha_id'=>$newusaha,
        	                       'created_by'=>CRUDBooster::myId(),
        	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
        	                       'created_at'=>now(),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'owner_priv'=>Request::input('owner_priv'),
        	                       'status_id'=>3
    	                       ]);
    	           
    	           if(CRUDBooster::myPrivilegeId()==2){
                       $this->suratMasuk($surat_baru,Request::input('warga_bjb_id'),$newusaha,Request::input('pemilik_id'),Request::input('owner_priv'),Request::input('grup_id'));
                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
                   }else{    
                         CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
                   }
    	                       
            	   //$exist = DB::table('surat_permohonan_bantuan')->where('relasi_id',Request::input('id'))->where('warga_bjb_id',Request::input('warga_bjb_id'))->where('umkm_usaha_id',$newusaha)->first();
    	        }
	        }elseif(Request::input('usaha_required')==2){
	            if(Request::input('grup_id')>0){
    	            $exist = DB::table('surat_permohonan_bantuan')
                        ->where('relasi_id',Request::input('id'))
                        ->where('warga_bjb_id',Request::input('warga_bjb_id'))
                        ->where('grup_id',Request::input('grup_id'))
                        ->first();
                        
                   if(!$exist){
                       $surat_baru = DB::table('surat_permohonan_bantuan')->insertGetId([
    	                       'relasi_id'=>Request::input('id'),
    	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
    	                       'grup_id'=>Request::input('grup_id'),
    	                       'created_by'=>CRUDBooster::myId(),
    	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
    	                       'created_at'=>now(),
    	                       'updated_by'=>CRUDBooster::myId(),
    	                       'owner_priv'=>Request::input('owner_priv'),
    	                       'status_id'=>3
                           ]);
                           
                       if(CRUDBooster::myPrivilegeId()==2){
	                       $this->suratMasuk($surat_baru,Request::input('warga_bjb_id'),Request::input('usaha_id'),Request::input('pemilik_id'),Request::input('owner_priv'),Request::input('grup_id'));
	                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
	                   }else{    
	                         CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
	                   }
                   }else{
                       if(CRUDBooster::myPrivilegeId()==2){
	                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data sudah ada","warning");
	                   }else{    
	                         CRUDBooster::redirect(CRUDBooster::mainpath(),"Data sudah ada","warning");
	                   }
                   }
	            }else{
	               CRUDBooster::redirect(CRUDBooster::mainpath(),"Harap Memilih Kelompok","warning"); 
	            }
	        }else{
	            $exist = DB::table('surat_permohonan_bantuan')
                    ->where('relasi_id',Request::input('id'))
                    ->where('warga_bjb_id',Request::input('warga_bjb_id'))
                    ->first();
                    
               if(!$exist){
                   $surat_baru = DB::table('surat_permohonan_bantuan')->insertGetId([
	                       'relasi_id'=>Request::input('id'),
	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
	                       'created_by'=>CRUDBooster::myId(),
	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
	                       'created_at'=>now(),
	                       'updated_by'=>CRUDBooster::myId(),
	                       'owner_priv'=>Request::input('owner_priv'),
	                       'status_id'=>3
                       ]);
                       
                   if(CRUDBooster::myPrivilegeId()==2){
                       $this->suratMasuk($surat_baru,Request::input('warga_bjb_id'),Request::input('usaha_id'),Request::input('pemilik_id'),Request::input('owner_priv'),Request::input('grup_id'));
                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data Berhasil Ditambahkan","success");
                   }else{    
                         CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
                   }
               }else{
                   if(CRUDBooster::myPrivilegeId()==2){
                       CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Data ini sudah ada","warning");
                   }else{    
                        CRUDBooster::redirect(CRUDBooster::mainpath(),"Data sudah ada","warning");
                   }
               }
	        }
            
	            
	       // return redirect(CRUDBooster::mainpath());

	    }
	    
	     public function suratMasuk($id,$warga_bjb_id,$usaha_id,$pemilik_id,$owner_priv,$grup_id){
	                $warga_bjb = DB::table('warga_bjb')->where('id',$warga_bjb_id)->first();
    	            $jenis_surat = DB::table('surat')->where('tabel','surat_permohonan_bantuan')->first();
    	            $last_id = DB::table('surat_masuk')->insertGetId([
    					'jenis_surat_id' => $jenis_surat->id,
    					'owner_priv' => $owner_priv,
    					'nik' => $warga_bjb->nik,
    					'nama_lgkp' => $warga_bjb->nama_lgkp,
    					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
    					'tgl_lhr' => $warga_bjb->tgl_lhr,
    					'alamat' => $warga_bjb->alamat,
    					'rt' => $warga_bjb->rt,
    					'rw' => $warga_bjb->rw,
    					'district_id' => $warga_bjb->nama_kec,
    					'village_id' => $warga_bjb->nama_kel,
    					'jk' => $warga_bjb->jk,
    					'pekerjaan' => $warga_bjb->pekerjaan,
    					'no_telp' => $warga_bjb->telp,
    					'created_at' => Carbon::now(),
    					'created_by' => CRUDBooster::myId(),
    					'status_id' => 1,
    					'status_by' => CRUDBooster::myId(),
    					'status_by_priv' => CRUDBooster::myPrivilegeId(),
    					'rel_table' => 'surat_permohonan_bantuan',
    					'rel_id' =>  $id
    				]);
        			
        			CRUDBooster::createMasterNotif($jenis_surat->id,CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat,$this->table,"openUrl;".$last_id.";".CRUDBooster::adminPath('surat_masuk'));
        			

	    }
	    
	    public function postPullCapil(){
            $capil = CRUDBooster::updateNik(Request::input('nik'));
            
            //var_dump($capil->local_exist);
            
            if($capil->api_status=="1"){
                $locally = $capil->local_exist;
                return CRUDBooster::redirectBack("Update data nik" . Request::input('nik') . " atas nama " . $locally->nama_lgkp . " berhasil", "success");
            }else{
                return CRUDBooster::redirectBack($capil->api_message, "warning");
            }
        }
	    
	    public function getDaftarBantuan($id){
	        $data = [];
	        $data['prev'] = CRUDBooster::mainpath() ;
        	$data['galat'] = CRUDBooster::mainpath() ;
        	
	        if(CRUDBooster::myPrivilegeId()==2){
	            $data['warga_bjb_id'] = CRUDBooster::menik(CRUDBooster::me()->nik)->id;
	            $data['warga_bjb'] = DB::table('warga_bjb')
            	                            ->join('districts','warga_bjb.nama_kec','districts.id')
            	                            ->join('villages','warga_bjb.nama_kel','villages.id')
            	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
            	                            ->where('warga_bjb.nik',CRUDBooster::me()->nik)
            	                            ->first();
            	                            
            	
            	                            
	            $data['row'] = DB::table('bantuan')->where('id',$id)->first();
	            $data['bantuan'] = DB::table('bantuan')->where('id',$id)->first();
	            $data['bantuan_item'] = DB::table('bantuan_item')->where('bantuan_id',$id)->get();
	            
    	        if(sizeof( $data['bantuan_item'])>0){
    	            $data['next'] = CRUDBooster::mainpath("step2") ;
        	        
        	        $data['page_title'] = "Pilih item bantuan";
                    $data['id'] = $id;
                    $data['owner_priv'] = $data['row']->created_by_priv;
                    $data['nik'] = CRUDBooster::me()->nik;
                    
                    
                    return view('bantuan.step1', $data);
    	        }else{
        	        $data['prev'] = CRUDBooster::mainpath() ;
        	        $data['galat'] = CRUDBooster::mainpath() ;
        	        $data['page_title'] = "Data Anda " . CRUDBooster::me()->nik;
                    $data['id'] = $id;
                    $data['owner_priv'] = $data['row']->created_by_priv;
                    
    	            if($data['row']->usaha_required == 1){
    	           
    	                $data['usaha_saya'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb_id'])->where('status_id',5)->get();   
    	                $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb_id'])->first();
        	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb_id'])->get();
        	            
        	            $data['next'] = CRUDBooster::mainpath("step3") ;
        	            
        	            
        	            $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                                ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                                ->where('surat_reg_pelatihan.warga_bjb_id',$data['warga_bjb']->id)
                                ->where('surat_reg_pelatihan.status_id',5)
                                ->get();
                                
                        $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                        ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                        ->where('surat_permohonan_bantuan.warga_bjb_id',$data['warga_bjb']->id)
                                        ->where('surat_permohonan_bantuan.status_id',5)
                                        ->get();
        	            
        	            return view('bantuan.step2', $data);
    	            }elseif($data['row']->usaha_required ==2){
    	                $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->where('member.jabatan','Ketua')->get();
    	                $data['usaha_saya'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb_id'])->where('status_id',5)->get();   
    	                $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb_id'])->first();
        	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb_id'])->get();
        	            
        	            $data['next'] = CRUDBooster::mainpath("step4") ;
        	            
        	            $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                                ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                                ->where('surat_reg_pelatihan.warga_bjb_id',$data['warga_bjb']->id)
                                ->where('surat_reg_pelatihan.status_id',5)
                                ->get();
                                
                        $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                        ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                        ->where('surat_permohonan_bantuan.warga_bjb_id',$data['warga_bjb']->id)
                                        ->where('surat_permohonan_bantuan.status_id',5)
                                        ->get();
        	            
        	            return view('bantuan.step2', $data);
    	            }
    	            return view('bantuan.registrasi',$data);
    	        }
	            
	            
	        }else{
	            return CRUDBooster::redirect(CRUDBooster::adminPath('surat_masuk'),'Mohon Maaf Anda dalam Mode Admin');
	        }
	    }
	    
	    public function postDaftarBantuan(){
	        if(CRUDBooster::MyPrivilegeId()==2){
	           // var_dump(Request::input('usaha'));
	           // var_dump(Request::input('usaha_required'));
	            if(Request::input('usaha_required')==1){
	                if(Request::input('usaha')==0){
	                    return redirect()->back()->with('surat_exist', 'Anda Belum Memilih usaha !');
	                }else{
	                    $exist = DB::table('surat_permohonan_bantuan')->where('relasi_id',Request::input('id'))->where('warga_bjb_id',Request::input('warga_bjb_id'))->where('umkm_usaha_id',Request::input('usaha'))->first();
	                }
	            }else{
	                $exist = DB::table('surat_permohonan_bantuan')->where('relasi_id',Request::input('id'))->where('warga_bjb_id',Request::input('warga_bjb_id'))->first();
	            }
	            //var_dump(Request::input('usaha'));
	            if(!$exist){
	                if(Request::input('usaha_required')==1){
	                    $pemilik = DB::table('umkm_pemilik')->where('warga_bjb_id',Request::input('warga_bjb_id'))->first();
    	                $surat_baru = DB::table('surat_permohonan_bantuan')->insertGetId(['relasi_id'=>Request::input('id'),'warga_bjb_id'=>Request::input('warga_bjb_id'),'umkm_pemilik_id'=>$pemilik->id,'umkm_usaha_id'=>Request::input('usaha'),'created_by'=>CRUDBooster::myId(),'created_at'=>now(),'updated_by'=>CRUDBooster::myId(),'owner_priv'=>Request::input('owner_priv')]);
	                }else{
	                    $surat_baru = DB::table('surat_permohonan_bantuan')->insertGetId(['relasi_id'=>Request::input('id'),'warga_bjb_id'=>Request::input('warga_bjb_id'),'created_by'=>CRUDBooster::myId(),'created_at'=>now(),'updated_by'=>CRUDBooster::myId(),'owner_priv'=>Request::input('owner_priv')]);
	                }
    	            $warga_bjb = DB::table('warga_bjb')->where('id',Request::input('warga_bjb_id'))->first();   
    	            $jenis_surat = DB::table('surat')->where('tabel','surat_permohonan_bantuan')->first();
    	            $last_id = DB::table('surat_masuk')->insertGetId([
    					'jenis_surat_id' => $jenis_surat->id,
    					'owner_priv' => Request::input('owner_priv'),
    					'nik' => $warga_bjb->nik,
    					'nama_lgkp' => $warga_bjb->nama_lgkp,
    					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
    					'tgl_lhr' => $warga_bjb->tgl_lhr,
    					'alamat' => $warga_bjb->alamat,
    					'rt' => $warga_bjb->rt,
    					'rw' => $warga_bjb->rw,
    					'district_id' => $warga_bjb->nama_kec,
    					'village_id' => $warga_bjb->nama_kel,
    					'jk' => $warga_bjb->jk,
    					'pekerjaan' => $warga_bjb->pekerjaan,
    					'no_telp' => $warga_bjb->telp,
    					'created_at' => Carbon::now(),
    					'created_by' => CRUDBooster::myId(),
    					'status_id' => 1,
    					'status_by' => CRUDBooster::myId(),
    					'status_by_priv' => CRUDBooster::myPrivilegeId(),
    					'rel_table' => 'surat_permohonan_bantuan',
    					'rel_id' =>  $surat_baru
    				]);
    				
                    //
        			
        			// $config['id_cms_users'] = $notified_user;
        			
        			// CRUDBooster::sendNotification($config);
        			
        			CRUDBooster::createMasterNotif($jenis_surat->id,CRUDBooster::myName() . " membuat permohonan ". $jenis_surat->nama_surat,$this->table,"openUrl;".$last_id.";".CRUDBooster::adminPath('surat_masuk'));
        			CRUDBooster::redirect(CRUDBooster::adminpath('umkm_usaha/index2'),"Permohonan Berhasil Ditambahkan","success");
        			//return redirect(CRUDBooster::adminPath('skck_warga'));
	            }else{
	               return redirect()->back()->with('surat_exist', 'Anda sudah pernah melakukan permohonan !');  
	            }
            }
	    }
	    
	    
	    public function getImportFile($id){
	        $bantuan=DB::table('bantuan')->where('id',$id)->first();
	        $data['id']=$id;
	        $data['excel']=$bantuan->upload_file;
	       // if(strlen($bantuan->upload_file)>0){
                 $this->cbView('import.xlsx',$data);
	    //    }else{
	            
	      //  }
	    }
	    
	    public function postImportExcel($id){
	        $selected_kolom=Request::input('selected_kolom');
	        $rows=Session::get('rows');
	        $excel=Request::input('excel');
	        $result = array();
	        
	        $ketemu=0;
	        $baru=0;
	        $sudah=0;
	        $tidakketemu=0;
	        $capilyes=0;
	        $capilno=0;
	       
        	foreach($rows as $ro){
        	    //var_dump( $selected_kolom . '-' .$ro[$selected_kolom] );
        	    $found=DB::table('warga_bjb')->where('nik',$ro[$selected_kolom])->first();
        	    if($found){
        	        $ketemu++;
        	        $exist=DB::table('history_bantuan')->where('warga_bjb_id',$found->id)->where('bantuan_id',$id)->first();
        	        
        	        if(!$exist){
        	            $baru++;
        	            DB::table('history_bantuan')->insert(['tanggal'=>now(),'warga_bjb_id'=>$found->id,'bantuan_id'=>$id,'keterangan'=>'Import dari file '.$excel,'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId()]);
        	            array_push($result, $ro[$selected_kolom] . ' ditambahkan - detail ('. implode(",",$ro) . ')' );
        	        }else{
        	            $sudah++;
        	            array_push($result, $ro[$selected_kolom] . ' data sudah ada' );
        	        }
        	    }else{
        	        $tidakketemu++;
        	        array_push($result, $ro[$selected_kolom] . ' Tidak Ditemukan ! - detail ('. implode(",",$ro) . ')'   );
        	       // $capil = CRUDBooster::updateNik($ro[$selected_kolom]);
        	       // if($capil->api_status=="1"){
        	       //     $capilyes++;
        	       //     array_push($result, $ro[$selected_kolom] . '-' .$ro['NAMA_PENERIMA'] . ' ada dalam data capil !'   );
        	       //    // $found2=DB::table('warga_bjb')->where('nik',$ro[$selected_kolom])->first();
        	       //    // DB::table('history_bantuan')->insert(['tanggal'=>now(),'warga_bjb_id'=>$found2->id,'bantuan_id'=>$id,'keterangan'=>'Import dari file '.$excel,'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId()]);
        	       //    // array_push($result, $ro[$selected_kolom] . ' ditambahkan' );
        	       //     //array_push($result, json_encode($capil)  );
        	       // }else{
        	       //     $capilno++;
        	       //     array_push($result, $ro[$selected_kolom] . '-' .$ro['NAMA_PENERIMA'] . ' Tidak teregistrasi !'   );
        	       // }
        	    }
        	}
        	DB::table('bantuan')->where('id',$id)->update(['hasil_import'=>$ketemu. ' nik ditemukan, '. $baru . ' ditambahkan, '. $sudah . ' sudah ada, '. $tidakketemu . ' nik tidak ditemukan, ' . $capilyes . ' diambil di capil, ' . $capilno . ' tidak teregister.']);
        	array_push($result,$ketemu. ' nik ditemukan, '. $baru . ' ditambahkan, '. $sudah . ' sudah ada, '. $tidakketemu . ' nik tidak ditemukan, ' . $capilyes . ' diambil di capil, ' . $capilno . ' tidak teregister.' );
	        $data['result'] = $result;
	        $this->cbView('import.result',$data);
	    }
	    
		


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	        if(CRUDBooster::myPrivilegeId()!=1){
	            if(CRUDBooster::myPrivilegeId()==5){
	               // $query->where('created_by_priv',CRUDBooster::myPrivilegeId())->orWhere('created_by_priv',CRUDBooster::myParentPriv());
	               $query->where('created_by_priv',CRUDBooster::myPrivilegeId())->where('district_id',CRUDBooster::me()->district_id)->where('village_id',CRUDBooster::me()->village_id);
	            }else{
	                $query->where('created_by_priv',CRUDBooster::myPrivilegeId())->orWhere('created_by_priv',CRUDBooster::myParentPriv());
	            }
	        }
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $postdata['created_by'] = CRUDBooster::myId();
            $postdata['created_by_priv'] = CRUDBooster::myPrivilegeId();
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}