<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;

	class AdminUmkmLaporanUsahaController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_usaha";
			$this->limit = "20";
			$this->orderby = "bidang_usaha,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = false;
			$this->button_action_style = "button_icon";
			$this->button_add = false;
			$this->button_edit = false;
			$this->button_delete = false;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = true;
			$this->table = "umkm_usaha";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			//$this->col[] = ["label"=>"ID","name"=>"id"];
			$this->col[] = ["label"=>"NIK","name"=>"(SELECT CONCAT('\'',nik) FROM warga_bjb WHERE warga_bjb.id = umkm_usaha.warga_bjb_id) as ektp","callback_php"=>"$row->ektp"];
			$this->col[] = ["label"=>"Nama Pemilik","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
			$this->col[] = ["label"=>"Alamat Pemilik","name"=>"(SELECT CONCAT(alamat2, ' RT.', rt , ' RW.', rw, ' KEL.', (SELECT name FROM villages WHERE id = warga_bjb.nama_kel), ' KEC.', (SELECT name FROM districts WHERE id = warga_bjb.nama_kec)) As alamat FROM warga_bjb WHERE warga_bjb.id=warga_bjb_id) as alamat","callback_php"=>'$row->alamat'];
			$this->col[] = ["label"=>"Kel. Pemilik","name"=>"(SELECT CONCAT((SELECT name FROM villages WHERE id = warga_bjb.nama_kel)) As kelpemilik FROM warga_bjb WHERE warga_bjb.id=warga_bjb_id) as kelpemilik","callback_php"=>'$row->kelpemilik'];
			$this->col[] = ["label"=>"Nama Usaha","name"=>"nama_usaha"];
			$this->col[] = ["label"=>"Brand","name"=>"brand"];
			$this->col[] = ["label"=>"Bidang Usaha","name"=>"bidang_usaha"];
			$this->col[] = ["label"=>"Sub Bidang Usaha","name"=>"sub_bidang_usaha"];
			$this->col[] = ["label"=>"Alamat Usaha","name"=>"alamat_usaha"];
			$this->col[] = ["label"=>"Kel. Usaha","name"=>"village_id","join"=>"villages,name"];
			$this->col[] = ["label"=>"No. Telp","name"=>"(SELECT CONCAT('\'',no_telp) FROM umkm_pemilik WHERE warga_bjb_id = umkm_usaha.warga_bjb_id) as no_telp","callback_php"=>'$row->no_telp'];
// 			$this->col[] = ["label"=>"Jumlah Bantuan","name"=>"(select count(id) from history_bantuan where warga_bjb_id = umkm_usaha.warga_bjb_id) as sum_bantuan","callback_php"=>'$row->sum_bantuan'];
// 		    $this->col[] = ["label"=>"Bantuan","name"=>"(SELECT GROUP_CONCAT(bantuan.bantuan SEPARATOR ', ') FROM history_bantuan JOIN bantuan ON history_bantuan.bantuan_id = bantuan.id WHERE warga_bjb_id = umkm_usaha.warga_bjb_id) as bantuan","callback_php"=>'$row->bantuan'];
			$this->col[] = ["label"=>"Izin yang dimiliki","name"=>"perizinan"];
			
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
				$this->form = [];
			$this->form[] = ['label'=>'NIK Pemilik','name'=>'warga_bjb_id','type'=>'select2','validation'=>'string|min:0','width'=>'col-sm-10','datatable'=>'warga_bjb,nik','datatable_format'=>"id,' - ',nik,' - ',nama_lgkp,' - ', tmpt_lhr,' - ',tgl_lhr",'datatable_where'=>'EXISTS (SELECT * FROM umkm_pemilik WHERE warga_bjb.id = umkm_pemilik.warga_bjb_id)'];//,'datamodal_table'=>'umkm_pemilik','datamodal_columns'=>'no_iumk','datamodal_size'=>'large'];//
			$this->form[] = ['label'=>'Nama Usaha','name'=>'nama_usaha','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Bidang Usaha','name'=>'bidang_usaha','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_jenis_usaha,bidang'];
			$this->form[] = ['label'=>'Brand','name'=>'brand','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Alamat Usaha','name'=>'alamat_usaha','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Provinsi','name'=>'province_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'provinces,name','value'=>'63'];
			$this->form[] = ['label'=>'Kota/Kabupaten','name'=>'regency_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'regencies,name','value'=>'6372'];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'districts,name'];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'villages,name'];
			$this->form[] = ['label'=>'Status Usaha','name'=>'status_usaha_id','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_status_tempat,status'];
			$this->form[] = ['label'=>'Perizinan Yang Dimiliki','name'=>'perizinan','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_perizinan,perizinan'];
			$this->form[] = ['label'=>'Fasilitas Pembiayaan/Permodalan','name'=>'permodalan_id','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_permodalan,permodalan'];
			//$this->form[] = ['label'=>'Penerima Bantuan','name'=>'penerima_bantuan','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_bantuan,bantuan'];
			$this->form[] = ['label'=>'Pemasaran','name'=>'pemasaran_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'umkm_sistem_pemasaran,sistem_pemasaran'];
			$this->form[] = ['label'=>'Jumlah Karyawan Laki-laki','name'=>'j_kary_l','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Jumlah Karyawan Perempuan','name'=>'j_kary_p','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Jumlah Karyawan','name'=>'j_kary','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Modal Awal','name'=>'modal_awal','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Modal Saat Ini','name'=>'modal_saat_ini','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Update Modal','name'=>'update_modal','type'=>'date','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Aset Tetap','name'=>'aset_tetap','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Omset','name'=>'omset','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Update Omset','name'=>'update_omset','type'=>'date','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'textarea','validation'=>'string|min:5|max:5000','width'=>'col-sm-6'];
			
			$this->form[] = ['label'=>'Koordinat','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Lat','name'=>'lat','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10','readonly'=>'readonly'];
			$this->form[] = ['label'=>'Lon','name'=>'lon','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-10','readonly'=>'readonly'];
			$this->form[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-6','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Warga Bjb Id","name"=>"warga_bjb_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"warga_bjb,nama_lgkp"];
			//$this->form[] = ["label"=>"Nama Usaha","name"=>"nama_usaha","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Bidang Usaha","name"=>"bidang_usaha","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Brand","name"=>"brand","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Mulai Usaha","name"=>"mulai_usaha","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Alamat Usaha","name"=>"alamat_usaha","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Province Id","name"=>"province_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"province,id"];
			//$this->form[] = ["label"=>"Regency Id","name"=>"regency_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"regency,id"];
			//$this->form[] = ["label"=>"District Id","name"=>"district_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"district,id"];
			//$this->form[] = ["label"=>"Village Id","name"=>"village_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"village,id"];
			//$this->form[] = ["label"=>"Status Usaha Id","name"=>"status_usaha_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"status_usaha,id"];
			//$this->form[] = ["label"=>"Perizinan","name"=>"perizinan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Permodalan Id","name"=>"permodalan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"permodalan,id"];
			//$this->form[] = ["label"=>"Pemasaran Id","name"=>"pemasaran_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pemasaran,id"];
			//$this->form[] = ["label"=>"Penerima Bantuan","name"=>"penerima_bantuan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"J Kary L","name"=>"j_kary_l","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"J Kary P","name"=>"j_kary_p","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"J Kary","name"=>"j_kary","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Modal Awal","name"=>"modal_awal","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Modal Saat Ini","name"=>"modal_saat_ini","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Update Modal","name"=>"update_modal","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Aset Tetap","name"=>"aset_tetap","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Omset","name"=>"omset","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Update Omset","name"=>"update_omset","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Keterangan","name"=>"keterangan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Gps","name"=>"gps","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lat","name"=>"lat","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Lon","name"=>"lon","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        if(CRUDBooster::myPrivilegeId()==5){
	            $query->where('umkm_usaha.village_id',CRUDBooster::me()->village_id)
	                  ->orWhere('warga_bjb.nama_kel',CRUDBooster::me()->village_id);
	        }
	            
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}