<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;

	class AdminUmkmPelatihanController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_pelatihan";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "pelatihan";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Nama Pelatihan","name"=>"nama_pelatihan"];
			$this->col[] = ["label"=>"Penyelenggara","name"=>"penyelenggara"];
			$this->col[] = ["label"=>"Mulai Pendaftaran","name"=>"awal_daftar"];
			$this->col[] = ["label"=>"Akhir Pendaftaran","name"=>"akhir_daftar"];
			$this->col[] = ["label"=>"Mulai Pelaksanaan","name"=>"tanggal_mulai"];
			$this->col[] = ["label"=>"Akhir Pelaksanaan","name"=>"tanggal_akhir"];
			$this->col[] = ["label"=>"Kuota","name"=>"kuota"];
			$this->col[] = ["label"=>"Tempat","name"=>"tempat"];
			$this->col[] = ["label"=>"Gambar","name"=>"gambar", "image"=>true];
			$this->col[] = ["label"=>"Persyaratan","name"=>"usaha_required","callback_php"=>'($row->usaha_required == 1? "Usaha" : ($row->usaha_required == 2? "Kelompok" : "Pribadi"))'];
			$this->col[] = ["label"=>"Keterangan","name"=>"keterangan"];
			$this->col[] = ["label"=>"Updated By","name"=>"created_by_priv","join"=>"cms_privileges,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Nama Pelatihan','name'=>'nama_pelatihan','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Penyelenggara','name'=>'penyelenggara','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Mulai Pendaftaran','name'=>'awal_daftar','type'=>'date','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Akhir Pendaftaran','name'=>'akhir_daftar','type'=>'date','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Mulai','name'=>'tanggal_mulai','type'=>'datetime','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Akhir','name'=>'tanggal_akhir','type'=>'datetime','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Kuota','name'=>'kuota','type'=>'number','validation'=>'required|integer|min:0|max:200','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Tempat','name'=>'tempat','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'wysiwyg','validation'=>'string|min:5|max:5000','width'=>'col-sm-5'];
			$this->form[] = ['label'=>'Gambar','name'=>'gambar','type'=>'upload','validation'=>'image|max:3000','width'=>'col-sm-5','help'=>'Tipe file yang didukung: JPG, JPEG, PNG, GIF, BMP'];
			$this->form[] = ['label'=>'Membutuhkan Usaha/Kelompok','name'=>'usaha_required','type'=>'radio','width'=>'col-sm-6','dataenum'=>'2|Kelompok;1|Usaha;0|Pribadi'];
			
// 			$columns[] = ['label'=>'Warga','name'=>'warga_bjb_id','type'=>'datamodal','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,alamat','datamodal_size'=>'large'];
            
//             $this->form[] = ['label'=>'Peserta','name'=>'peserta','type'=>'child','columns'=>$columns,'table'=>'surat_reg_pelatihan','foreign_key'=>'pelatihan_id'];
			
			
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Updated By Priv','name'=>'updated_by_priv','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Nama Pelatihan","name"=>"nama_pelatihan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Keterangan","name"=>"keterangan","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Peserta Pelatihan','path'=>'surat_reg_pelatihan','parent_columns'=>'nama_pelatihan,penyelenggara,tanggal_mulai,tanggal_akhir','foreign_key'=>'pelatihan_id','button_color'=>'success','button_icon'=>'fa fa-bars','showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId() OR [created_by_priv] == CRUDBooster::myParentPriv() '];
           // $this->sub_module[] = ['label'=>'Laporan','path'=>'laporan_reg_pelatihan','parent_columns'=>'bantuan,pemberi_bantuan','foreign_key'=>'relasi_id','button_color'=>'success','button_icon'=>'fa fa-user','showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId()'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        $this->addaction[] = ['label'=>'Tambah Pemohon','icon'=>'fa fa-address-card','color'=>'success','url'=>CRUDBooster::mainpath('by-admin').'/[id]'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    
	   

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        $query->where('created_by_priv',CRUDBooster::myPrivilegeId())->orWhere('created_by_priv',CRUDBooster::myParentPriv());
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $postdata['created_by'] = CRUDBooster::myId();
            $postdata['created_by_priv'] = CRUDBooster::myPrivilegeId();
            $postdata['created_at'] = now();
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    public function getByAdmin($id){
	       // if (! CRUDBooster::isCreate() && $this->global_privilege == false) {
        //         CRUDBooster::insertLog(trans('crudbooster.log_try_add', ['module' => CRUDBooster::getCurrentModule()->name]));
        //         CRUDBooster::redirect(CRUDBooster::adminPath(), trans("crudbooster.denied_access"));
        //     }
	        
	        $data = [];
	        
	        $data['page_title'] = "Daftar Pemohon Pelatihan";
	        $data['id'] = $id;
	       // $data['created_by'] = CRUDBooster::myId();
	       // $data['created_by_priv'] = CRUDBooster::myPrivilegeId();
	        
	       // if($id>0){
	       //     $data['row'] = DB::table('permohonan_bantuan')->where('bantuan_id',$id)->first();
	       // }
	        $data['row'] = DB::table('pelatihan')->where('id',$id)->first();
	        $data['next'] = CRUDBooster::mainpath("step2");
	        
	        return view('bantuan.addbyadmin', $data);
	    }
	    
	    public function postStep2(){
	        $data = [];
	        $data['page_title'] = "Data Warga " . Request::input('nik');
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
            $data['bantuan'] = DB::table('pelatihan')->where('id',Request::input('id'))->first();
            
           // var_dump($data['pelatihan']);
	        
	        if(Request::input('nik')){
	            $warga_cloud = DB::table('warga_bjb')
	                            ->join('districts','warga_bjb.nama_kec','districts.id')
	                            ->join('villages','warga_bjb.nama_kel','villages.id')
	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
	                            ->where('nik',Request::input('nik'))
	                            ->first();
	            
	            if(!$warga_cloud->no_kk){
    	            $capil = CRUDBooster::updateNik(Request::input('nik'));
                
                    //var_dump($capil->local_exist);
                    
                    if($capil->api_status=="1"){
                        $locally = $capil->local_exist;
                        
                        
            	        $data['warga_bjb'] = DB::table('warga_bjb')
            	                            ->join('districts','warga_bjb.nama_kec','districts.id')
            	                            ->join('villages','warga_bjb.nama_kel','villages.id')
            	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
            	                            ->where('nik',Request::input('nik'))
            	                            ->first();
            	                            
            	       $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb']->id)
                            ->where('status_id',5)
                            ->get();
                            
                        $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                        ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                        ->where('warga_bjb_id',$data['warga_bjb']->id)
                                        ->where('status_id',5)
                                        ->get();
            	       
            	        $data['pesan'] = "Data dari capil";
            	        if($data['bantuan']->usaha_required==1){
            	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb']->id)->first();
            	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	            $data['next'] = CRUDBooster::mainpath("step3") ;
            	            
            	            return view('bantuan.step2', $data);
            	        }elseif($data['bantuan']->usaha_required==2){
            	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	            $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->get();
            	            $data['next'] = CRUDBooster::mainpath("step4") ;
            	            
            	            return view('bantuan.step2', $data);
            	        }elseif($data['bantuan']->usaha_required==0){
            	            $data['next'] = CRUDBooster::mainpath("step4") ;
            	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	            $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->get();
            	            
            	            return view('bantuan.step2', $data);
            	        }
            	        
            	        
                        
                        // return CRUDBooster::redirectBack("Update data nik " . Request::input('nik') . " atas nama " . $locally->nama_lgkp . " berhasil", "success");
                    }else{
                        return CRUDBooster::redirectBack($capil->api_message, "warning");
                    }
	            }else{
                        
        	        $data['warga_bjb'] = $warga_cloud;
        	        
        	        $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb']->id)
                            ->where('status_id',5)
                            ->get();
                            
                    $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                    ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                    ->where('warga_bjb_id',$data['warga_bjb']->id)
                                    ->where('status_id',5)
                                    ->get();
        	        
        	        $data['pesan'] = "Data dari siapkk";
        	        if($data['bantuan']->usaha_required==1){
        	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb']->id)->first();
        	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
        	            $data['next'] = CRUDBooster::mainpath("step3");
        	            
        	            return view('bantuan.step2', $data);
        	        }elseif($data['bantuan']->usaha_required==2){
        	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
        	            $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->get();
        	            $data['next'] = CRUDBooster::mainpath("step4") ;
        	            
        	            return view('bantuan.step2', $data);
        	        }elseif($data['bantuan']->usaha_required==0){
        	            $data['next'] = CRUDBooster::mainpath("step4") ;
        	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
            	        $data['grup'] = DB::table('member')->join('grup','grup.id','member.grup_id')->where('member.username',$data['warga_bjb']->nik)->get();
        	            return view('bantuan.step2', $data);
        	        }
        	        
	            }
    	        
	        }else{
	            return redirect()->back()->with('nikreq', 'Harap isi NIK !'); 
	        }
	    }

    public function postStep3(){
	        $data = [];
	        $data['page_title'] = "Kelengkapan Data Usaha";
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
	        $data['warga_bjb_id'] = Request::input('warga_bjb_id');
	        $data['usaha_baru'] = Request::input('usaha_baru');
	        $data['usaha_required'] = Request::input('usaha_required');
	        
	        if(Request::input('usaha_required')==1){
    	        //if(Request::input('no_iumk') && Request::input('no_npwp') && Request::input('nib_sku') && Request::input('no_telp') ){
    	        if( Request::input('no_telp') ){
    	            if(Request::input('pemilik_id')){
    	                DB::table('umkm_pemilik')->where('id',Request::input('pemilik_id'))->update(['no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp')]);
    	                $data['pemilik_id'] = Request::input('pemilik_id');
    	            }else{
    	                $pemilik = DB::table('umkm_pemilik')->insertGetId(['warga_bjb_id'=>Request::input('warga_bjb_id'),'no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp')]);
    	            
    	                $data['pemilik_id'] = $pemilik;
    	            }
    	            
    	            if(Request::input('usaha_baru')==0){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->first();
    	            }else{
    	                $data['usaha_baru'] = Request::input('usaha_baru');
    	            }
    	            if(Request::input('usaha_id')){
        	            $data['bidang_usaha'] =  DB::table('umkm_jenis_usaha')->where('parent_id',0)->get();
        	            $data['sub_bidang_usaha'] =  DB::table('umkm_jenis_usaha')->where('parent_id','>',0)->get();
        	            $data['kecamatan'] =  DB::table('districts')->where('regency_id','6372')->get();
        	            $data['kelurahan'] =  DB::table('villages')->get();
        	            $data['umkm_status_tempat'] =  DB::table('umkm_status_tempat')->get();
        	            $data['umkm_perizinan'] =  DB::table('umkm_perizinan')->get();
        	            $data['umkm_permodalan'] =  DB::table('umkm_permodalan')->get();
        	           // $data['umkm_pemasaran'] =  DB::table('umkm_sistem_pemasaran')->get();
    	            }else{
    	               return redirect()->back()->with('usahareq', 'Harap Isi Data Ini !'); 
    	            }
    	            
    	            //return redirect(CRUDBooster::adminPath('umkm_usaha/edit/'.Request::input('usaha_id')));
    	            $data['next'] = CRUDBooster::mainpath("step4") ;
    	            
    	            return view('bantuan.step3', $data);
    	        } else{
    	          //    CRUDBooster::redirectBack('Harap Lengkapi Data','warning');
    	            return redirect()->back()->with('pemilikreq', 'Harap Isi Data Ini !'); 
    	        }
	        }elseif(Request::input('usaha_required')==2){
	            
	            
	            return view('bantuan.step4', $data);
	        }
	    }
	    
	    public function postStep4(){
	        $data = [];
	        $data['page_title'] = "Selesai";
            $data['id'] = Request::input('id');
            
            if(Request::input('sub_bidang_usaha')){
	            $sub_bidang_usaha = implode(";",Request::input('sub_bidang_usaha'));
	        }else{
	            $sub_bidang_usaha = "";
	        }
	        
	        //var_dump();
	        if(Request::input('usaha_required')==1){
    	        if(Request::input('usaha_baru')==0){
    	            DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->update([
    	                    'nama_usaha'=>Request::input('nama_usaha'),
    	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
    	                    'sub_bidang_usaha'=>$sub_bidang_usaha,
    	                    'brand'=>Request::input('brand'),
    	                    'alamat_usaha'=>Request::input('alamat_usaha'),
    	                    'province_id'=>63,
    	                    'regency_id'=>6372,
    	                    'village_id'=>Request::input('village_id'),
    	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
    	                    'perizinan'=>implode(";",Request::input('perizinan')),
    	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
    	                    'pemasaran_id'=>3,
    	                    'j_kary_l'=>Request::input('j_kary_l'),
    	                    'j_kary_p'=>Request::input('j_kary_p'),
    	                    'j_kary'=>Request::input('j_kary'),
    	                    'modal_awal'=>Request::input('modal_awal'),
    	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
    	                    'aset_tetap'=>Request::input('aset_tetap'),
    	                    'omset'=>Request::input('omset')
    	                ]);
    	                
    	                $exist = DB::table('surat_reg_pelatihan')
    	                    ->where('pelatihan_id',Request::input('id'))
    	                    ->where('warga_bjb_id',Request::input('warga_bjb_id'))
    	                    ->where('umkm_usaha_id',Request::input('usaha_id'))
    	                    ->first();
    	                    
    	               //var_dump($exist);
    	                    
    	               if(!$exist){
    	                   $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
        	                       'pelatihan_id'=>Request::input('id'),
        	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
        	                       'umkm_pemilik_id'=>Request::input('pemilik_id'),
        	                       'umkm_usaha_id'=>Request::input('usaha_id'),
        	                       'created_by'=>CRUDBooster::myId(),
        	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
        	                       'created_at'=>now(),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'owner_priv'=>Request::input('owner_priv'),
        	                       'status_id'=>3
    	                       ]);
    	                       
    	                   CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
    	               }else{
    	                   CRUDBooster::redirect(CRUDBooster::mainpath(),"Data sudah ada","warning");
    	                   //return redirect(CRUDBooster::mainpath())->with(['Data sudah ada', 'warning']);  
    	               }
    	        }elseif(Request::input('usaha_baru')==1){
    	            $newusaha = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->insertGetId([
    	                            'warga_bjb_id'=>Request::input('warga_bjb_id'),
            	                    'nama_usaha'=>Request::input('nama_usaha'),
            	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
            	                    'sub_bidang_usaha'=>implode(";",Request::input('sub_bidang_usaha')),
            	                    'brand'=>Request::input('brand'),
            	                    'alamat_usaha'=>Request::input('alamat_usaha'),
            	                    'province_id'=>63,
            	                    'regency_id'=>6372,
            	                    'village_id'=>Request::input('village_id'),
            	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
            	                    'perizinan'=>implode(";",Request::input('perizinan')),
            	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
            	                    'pemasaran_id'=>3,
            	                    'j_kary_l'=>Request::input('j_kary_l'),
            	                    'j_kary_p'=>Request::input('j_kary_p'),
            	                    'j_kary'=>Request::input('j_kary'),
            	                    'modal_awal'=>Request::input('modal_awal'),
            	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
            	                    'aset_tetap'=>Request::input('aset_tetap'),
            	                    'omset'=>Request::input('omset')
            	                ]);
            	   
            	   $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
        	                       'pelatihan_id'=>Request::input('id'),
        	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
        	                       'umkm_pemilik_id'=>Request::input('pemilik_id'),
        	                       'umkm_usaha_id'=>$newusaha,
        	                       'created_by'=>CRUDBooster::myId(),
        	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
        	                       'created_at'=>now(),
        	                       'updated_by'=>CRUDBooster::myId(),
        	                       'owner_priv'=>Request::input('owner_priv'),
        	                       'status_id'=>3
    	                       ]);
    	           
    	           CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
    	                       
            	   //$exist = DB::table('surat_permohonan_bantuan')->where('pelatihan_id',Request::input('id'))->where('warga_bjb_id',Request::input('warga_bjb_id'))->where('umkm_usaha_id',$newusaha)->first();
    	        }
	        }elseif(Request::input('usaha_required')==2){
	            if(Request::input('grup_id')>0){
    	            $exist = DB::table('surat_reg_pelatihan')
                        ->where('pelatihan_id',Request::input('id'))
                        ->where('warga_bjb_id',Request::input('warga_bjb_id'))
                        ->where('grup_id',Request::input('grup_id'))
                        ->first();
                        
                   if(!$exist){
                       $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
    	                       'pelatihan_id'=>Request::input('id'),
    	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
    	                       'grup_id'=>Request::input('grup_id'),
    	                       'created_by'=>CRUDBooster::myId(),
    	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
    	                       'created_at'=>now(),
    	                       'updated_by'=>CRUDBooster::myId(),
    	                       'owner_priv'=>Request::input('owner_priv'),
    	                       'status_id'=>3
                           ]);
                           
                       CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
                   }else{
                       CRUDBooster::redirect(CRUDBooster::mainpath(),"Data sudah ada","warning");
                   }
	            }else{
	               CRUDBooster::redirect(CRUDBooster::mainpath(),"Harap Memilih Kelompok","warning"); 
	            }
	        }else{
	            $exist = DB::table('surat_reg_pelatihan')
                    ->where('pelatihan_id',Request::input('id'))
                    ->where('warga_bjb_id',Request::input('warga_bjb_id'))
                    ->first();
                    
               if(!$exist){
                   $surat_baru = DB::table('surat_reg_pelatihan')->insertGetId([
	                       'pelatihan_id'=>Request::input('id'),
	                       'warga_bjb_id'=>Request::input('warga_bjb_id'),
	                       'created_by'=>CRUDBooster::myId(),
	                       'created_by_priv'=>CRUDBooster::myPrivilegeId(),
	                       'created_at'=>now(),
	                       'updated_by'=>CRUDBooster::myId(),
	                       'owner_priv'=>Request::input('owner_priv'),
	                       'status_id'=>3
                       ]);
                       
                   CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");
               }else{
                   CRUDBooster::redirect(CRUDBooster::mainpath(),"Data sudah ada","warning");
               }
	        }
            
	            
	       // return redirect(CRUDBooster::mainpath());

	    }

	}