<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	use Carbon\Carbon;
	use PDF;
	use Illuminate\Support\Facades\Validator;

	class AdminUmkmUsahaController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_usaha";
			$this->limit = "20";
			$this->orderby = "warga_bjb_id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "umkm_usaha";
			
			$this->usaha_eksis = DB::table($this->table)->where('warga_bjb_id',CRUDBooster::menik(CRUDBooster::me()->nik)->id)->count();
			$this->marketplace_eksis = DB::table('pasar_bjb')->where('warga_bjb_id',CRUDBooster::menik(CRUDBooster::me()->nik)->id)->count();
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"id","name"=>"id"];
			if(CRUDBooster::MyPrivilegeId()==2){
			    $this->col[] = ["label"=>"Nama Usaha","name"=>"nama_usaha"];
    			$this->col[] = ["label"=>"Bidang Usaha","name"=>"bidang_usaha"];
    			$this->col[] = ["label"=>"Sub Bidang Usaha","name"=>"sub_bidang_usaha"];
    			$this->col[] = ["label"=>"Brand","name"=>"brand"];
    			//$this->col[] = ["label"=>"Mulai Usaha","name"=>"mulai_usaha"];
    			$this->col[] = ["label"=>"Alamat Usaha","name"=>"alamat_usaha"];
    			$this->col[] = ["label"=>"Status Data","name"=>"status_id","join"=>"status_surat,status"];
			}else{
			    $this->col[] = ["label"=>"NIK Pemilik","name"=>"warga_bjb_id","join"=>"warga_bjb,nik"];
    			$this->col[] = ["label"=>"Nama Pemilik","name"=>"warga_bjb_id","join"=>"warga_bjb,nama_lgkp"];
    			//$this->col[] = ["label"=>"Alamat Pemilik","name"=>"(SELECT CONCAT(alamat2, ' RT.', rt , ' RW.', rw, ' KEL.', (SELECT name FROM villages WHERE id = warga_bjb.nama_kel), ' KEC.', (SELECT name FROM districts WHERE id = warga_bjb.nama_kec)) As alamat FROM warga_bjb WHERE warga_bjb.id=warga_bjb_id) as alamat","callback_php"=>'$row->alamat'];
    			$this->col[] = ["label"=>"Bidang Usaha","name"=>"bidang_usaha"];
    			$this->col[] = ["label"=>"Sub Bidang Usaha","name"=>"sub_bidang_usaha"];
    			$this->col[] = ["label"=>"Jenis Produk","name"=>"(SELECT GROUP_CONCAT(umkm_jenis_produk.jenis_produk) FROM umkm_jenis_produk_idv JOIN umkm_jenis_produk ON umkm_jenis_produk.id = umkm_jenis_produk_idv.umkm_jenis_produk_id WHERE umkm_jenis_produk_idv.umkm_usaha_id = umkm_usaha.id GROUP BY umkm_usaha.id) as jenis_produks","callback_php"=>'$row->jenis_produks'];
    			$this->col[] = ["label"=>"Nama Usaha","name"=>"nama_usaha"];
    			$this->col[] = ["label"=>"Brand","name"=>"brand"];
    			$this->col[] = ["label"=>"Alamat Usaha","name"=>"alamat_usaha"];
    			$this->col[] = ["label"=>"Status Data","name"=>"status_id","join"=>"status_surat,status"];
    			$this->col[] = ["label"=>"Updated by","name"=>"updated_by","join"=>"cms_users,name"];
    			$this->col[] = ["label"=>"Updated at","name"=>"updated_at"];
			}
			
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			if(CRUDBooster::MyPrivilegeId()==2){
			    $this->form[] = ['label'=>'NIK','name'=>'warga_bjb_id','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-6','value'=>CRUDBooster::menik(CRUDBooster::me()->nik)->id];
			    $this->form[] = ['label'=>'Lokasi','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
    			$this->form[] = ['label'=>'Latitude','name'=>'lat','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-4','readonly'=>'readonly'];
    			$this->form[] = ['label'=>'Longitude','name'=>'lon','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-4','readonly'=>'readonly'];
			}else{
			    $this->form[] = ['label'=>'NIK Pemilik','name'=>'warga_bjb_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-6','datatable'=>'warga_bjb,nik','datatable_format'=>"id,' - ',nik,' - ',nama_lgkp,' - ', tmpt_lhr,' - ',tgl_lhr",'datatable_where'=>'EXISTS (SELECT * FROM umkm_pemilik WHERE warga_bjb.id = umkm_pemilik.warga_bjb_id)'];
			    $this->form[] = ['label'=>'Koordinat','name'=>'gps','type'=>'osm','validation'=>'string|min:5|max:5000','width'=>'col-sm-10'];
    			$this->form[] = ['label'=>'Lat','name'=>'lat','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-4','readonly'=>'readonly'];
    			$this->form[] = ['label'=>'Lon','name'=>'lon','type'=>'text','validation'=>'min:1|max:255','width'=>'col-sm-4','readonly'=>'readonly'];
			}
			//$this->form[] = ['label'=>'NIK Pemilik','name'=>'warga_bjb_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-10','datatable'=>'warga_bjb,nik','datatable_format'=>"id,' - ',nik,' - ',nama_lgkp,' - ', tmpt_lhr,' - ',tgl_lhr",'datatable_where'=>'EXISTS (SELECT * FROM umkm_pemilik WHERE warga_bjb.id = umkm_pemilik.warga_bjb_id)'];//,'datamodal_table'=>'umkm_pemilik','datamodal_columns'=>'no_iumk','datamodal_size'=>'large'];//
			$this->form[] = ['label'=>'Nama Usaha','name'=>'nama_usaha','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Bidang Usaha','name'=>'bidang_usaha','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-4','datatable'=>'umkm_jenis_usaha,bidang','datatable_where'=>'parent_id=0'];
			$this->form[] = ['label'=>'Sub Bidang Usaha','name'=>'sub_bidang_usaha','type'=>'checkbox','width'=>'col-sm-4','datatable'=>'umkm_jenis_usaha,bidang','datatable_where'=>'parent_id<>0'];
			$this->form[] = [
				"label" => "Jenis Produk",
				"name" => "jenis_produk",
				"type" => "select2",
				"select2_multiple" => true,
				"datatable" => "umkm_jenis_produk,jenis_produk,keterangan,id",
				// "datatable_where" => "cms_users.id <> CRUDBooster::myId()",
				"relationship_table" => "umkm_jenis_produk_idv",
				"required" => false,
			];
			$this->form[] = ['label'=>'Brand','name'=>'brand','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Alamat Usaha','name'=>'alamat_usaha','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-4','datatable'=>'villages,name','datatable_where'=>'district_id like "'.CRUDBooster::getSetting('kode_kabupaten').'%"','parent_select'=>'district_id'];
			$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-4','datatable'=>'districts,name','datatable_where'=>'regency_id ='.CRUDBooster::getSetting('kode_kabupaten')];
			$this->form[] = ['label'=>'Kota/Kabupaten','name'=>'regency_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-4','datatable'=>'regencies,name','value'=>'6372'];
			$this->form[] = ['label'=>'Provinsi','name'=>'province_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-4','datatable'=>'provinces,name','value'=>'63'];
			$this->form[] = ['label'=>'Status Usaha','name'=>'status_usaha_id','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_status_tempat,status'];
			$this->form[] = ['label'=>'Perizinan Yang Dimiliki','name'=>'perizinan','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_perizinan,perizinan'];
			$this->form[] = ['label'=>'Fasilitas Pembiayaan/Permodalan','name'=>'permodalan_id','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_permodalan,permodalan'];
			//$this->form[] = ['label'=>'Penerima Bantuan','name'=>'penerima_bantuan','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_bantuan,bantuan'];
			$this->form[] = ['label'=>'Pemasaran','name'=>'pemasaran_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-4','datatable'=>'umkm_sistem_pemasaran,sistem_pemasaran'];
			$this->form[] = ['label'=>'Jumlah Karyawan Laki-laki','name'=>'j_kary_l','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Jumlah Karyawan Perempuan','name'=>'j_kary_p','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Jumlah Karyawan','name'=>'j_kary','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Modal Awal','name'=>'modal_awal','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Modal Saat Ini','name'=>'modal_saat_ini','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Update Modal','name'=>'update_modal','type'=>'date','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Aset Tetap','name'=>'aset_tetap','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Omset','name'=>'omset','type'=>'number','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Update Omset','name'=>'update_omset','type'=>'date','width'=>'col-sm-4'];
			if(CRUDBooster::MyPrivilegeId()!=2){
			    $this->form[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'textarea','validation'=>'string|min:5|max:5000','width'=>'col-sm-6'];
			}else{
			    $this->form[] = ['label'=>'Gambar','name'=>'photo','type'=>'upload','validation'=>'image|max:3000','width'=>'col-sm-5','help'=>'Tipe file yang didukung: JPG, JPEG, PNG, GIF, BMP'];
			 //   $columns[] = ['label'=>'File','name'=>'file','type'=>'upload','upload_type'=>'image'];
    // 			$columns[] = ['label'=>'Keterangan','name'=>'caption','type'=>'text'];
    // 			//$columns[] = ['label'=>'Table','name'=>'parent','type'=>'hidden','value'=>$this->table];
    			
    // 			$this->form[] = ['label'=>'Galeri Foto','name'=>'media','type'=>'slider','columns'=>$columns,'width'=>'col-sm-10','table'=>'media','parent'=>'umkm_usaha','foreign_key'=>'id_ortu'];
			}
			$this->form[] = ['label'=>'Updated by','name'=>'updated_by','type'=>'hidden','validation'=>'integer|min:0','width'=>'col-sm-6','value'=>CRUDBooster::myId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ['label'=>'NIK Pemilik','name'=>'warga_bjb_id','type'=>'datamodal','validation'=>'required|integer|min:0','width'=>'col-sm-10','datamodal_table'=>'warga_bjb','datamodal_columns'=>'nik,nama_lgkp,tmpt_lhr,tgl_lhr','datamodal_size'=>'large'];
			//$this->form[] = ['label'=>'Nama Usaha','name'=>'nama_usaha','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Bidang Usaha','name'=>'bidang_usaha','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_jenis_usaha,bidang'];
			//$this->form[] = ['label'=>'Brand','name'=>'brand','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Alamat Usaha','name'=>'alamat_usaha','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Provinsi','name'=>'province_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'provinces,name'];
			//$this->form[] = ['label'=>'Kota/Kabupaten','name'=>'regency_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'regencies,name'];
			//$this->form[] = ['label'=>'Kecamatan','name'=>'district_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'districts,name'];
			//$this->form[] = ['label'=>'Kelurahan','name'=>'village_id','type'=>'select2','validation'=>'required|integer|min:0','width'=>'col-sm-8','datatable'=>'villages,name'];
			//$this->form[] = ['label'=>'Status Usaha','name'=>'status_usaha_id','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_status_tempat,status'];
			//$this->form[] = ['label'=>'Perizinan Yang Dimiliki','name'=>'perizinan','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_perizinan,perizinan'];
			//$this->form[] = ['label'=>'Fasilitas Pembiayaan/Permodalan','name'=>'permodalan_id','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_permodalan,permodalan'];
			//$this->form[] = ['label'=>'Penerima Bantuan','name'=>'penerima_bantuan','type'=>'checkbox','validation'=>'required|min:1|max:255','width'=>'col-sm-10','datatable'=>'umkm_bantuan,bantuan'];
			//$this->form[] = ['label'=>'Pemasaran','name'=>'pemasaran_id','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'umkm_sistem_pemasaran,sistem_pemasaran'];
			//$this->form[] = ['label'=>'Jumlah Karyawan Laki-laki','name'=>'j_kary_l','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Jumlah Karyawan Perempuan','name'=>'j_kary_p','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Jumlah Karyawan','name'=>'j_kary','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Modal Awal','name'=>'modal_awal','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Modal Saat Ini','name'=>'modal_saat_ini','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Update Modal','name'=>'update_modal','type'=>'date','validation'=>'required|date','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Aset Tetap','name'=>'aset_tetap','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Omset','name'=>'omset','type'=>'number','validation'=>'required|integer|min:0','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Update Omset','name'=>'update_omset','type'=>'date','validation'=>'required|date','width'=>'col-sm-10'];
			//$this->form[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Produk','path'=>'produk','parent_columns'=>'nama_usaha,bidang_usaha,sub_bidang_usaha','foreign_key'=>'umkm_usaha_id','button_color'=>'info','button_icon'=>'fa fa-bars'];//,'showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId() OR [created_by_priv] == CRUDBooster::myParentPriv() OR [created_by_priv] == CRUDBooster::myParentPriv() '];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        //$this->addaction[] = ['label'=>'Buat Akun Pasar BJB','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('buat-akun').'/[id]'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();
	       // if(CRUDBooster::myPrivilegeId()==14){
	       //     $this->index_button[] = ['label'=>'Import file excell', 'url'=>CRUDBooster::adminPath('umkm_usaha/pilih-file'),'icon'=>'fa fa-arrow-down'];
	       // }
	        // if(CRUDBooster::myPrivilegeId()==2 && $this->usaha_eksis > 0 && $this->marketplace_eksis == 0){
	        //     $this->index_button[] = ['label'=>'Buat Akun Pasar BJB', 'url'=>CRUDBooster::mainpath('buat-akun'),'icon'=>'fa fa-arrow-down'];
	        // }else if(CRUDBooster::myPrivilegeId()==2 && $this->usaha_eksis > 0 && $this->marketplace_eksis == 1){
	        //     $this->index_button[] = ['label'=>'Login Pasar BJB', 'url'=>CRUDBooster::mainpath('buat-akun'),'icon'=>'fa fa-arrow-up'];
	        // }



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    
	     public function getIndex2() {
	        $data = [];
            $data['app_name'] = "UMKM";
            
            
            
            if(CRUDBooster::myPrivilegeId()==2){
                $data['profile'] = DB::table('cms_users')
                                ->join('warga_bjb','warga_bjb.nik','cms_users.nik')
                                ->leftJoin('villages','villages.id','warga_bjb.nama_kel')
                                ->leftJoin('districts','districts.id','warga_bjb.nama_kec')
                                ->where('cms_users.id',CRUDBooster::myId())
                                ->select(DB::raw('cms_users.*,warga_bjb.id as id_warga,warga_bjb.alamat,warga_bjb.rt,warga_bjb.rw,
                                                 villages.name as kelurahan, districts.name as kecamatan'))
                                ->first();
                
               
                
                $data['pemilik'] = DB::table('umkm_pemilik')
                                ->where('warga_bjb_id',$data['profile']->id_warga)
                                ->first();
                
                $data['usaha'] = DB::table('umkm_usaha')
                                ->where('warga_bjb_id',$data['profile']->id_warga)
                                ->get();
                                
                $data['pelatihan'] = DB::table('surat_reg_pelatihan')
                                ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                                ->where('warga_bjb_id',$data['profile']->id_warga)
                                ->where('status_id',5)
                                ->get();
                                
                $data['bantuan'] = DB::table('surat_permohonan_bantuan')
                                ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                ->where('warga_bjb_id',$data['profile']->id_warga)
                                ->where('status_id',5)
                                ->get();
                
                return view('perusahaan.home',$data);
            }else{
                return redirect(CRUDBooster::adminPath('surat_masuk'));
            }
            
            
	     }
	     
	     public function postSimpanIumk($id){
	         DB::table('umkm_pemilik')->where('id',$id)->update(['no_iumk'=>Request::input('no_iumk')]);
	         
	         return redirect()->back()->with('iumk_success', 'Nomor IUMK berhasil di simpan');   
	     }
	     
	     public function postSimpanNpwp($id){
	         DB::table('umkm_pemilik')->where('id',$id)->update(['no_npwp'=>Request::input('no_npwp')]);
	         
	         return redirect()->back()->with('npwp_success', 'Nomor NPWP berhasil di simpan');   
	     }
	     
	     public function postSimpanTelp($id){
	         DB::table('umkm_pemilik')->where('id',$id)->update(['no_telp'=>Request::input('no_telp')]);
	         
	         return redirect()->back()->with('telp_success', 'Nomor Telpon berhasil di simpan');   
	     }
	     
	     public function postDaftarPemilik($id){
	         DB::table('umkm_pemilik')->insert(['warga_bjb_id'=>$id,'updated_by'=>$id]);
	         
	         return redirect()->back()->with('pemilik_success', 'Pemilik berhasil di simpan');   
	     }
	     
	     public function getCetakProfil(){
	        $data = [];
            $data['app_name'] = "UMKM";
            
            $data['profile'] = DB::table('cms_users')
                            ->join('warga_bjb','warga_bjb.nik','cms_users.nik')
                            ->leftJoin('villages','villages.id','warga_bjb.nama_kel')
                            ->leftJoin('districts','districts.id','warga_bjb.nama_kec')
                            ->where('cms_users.id',CRUDBooster::myId())
                            ->select(DB::raw('cms_users.*,warga_bjb.id as id_warga,warga_bjb.alamat2,warga_bjb.rt,warga_bjb.rw,
                                             villages.name as kelurahan, districts.name as kecamatan'))
                            ->first();
            
           
            
            $data['pemilik'] = DB::table('umkm_pemilik')
                            ->where('warga_bjb_id',$data['profile']->id_warga)
                            ->first();
            
            $data['usaha'] = DB::table('umkm_usaha')
                            ->where('warga_bjb_id',$data['profile']->id_warga)
                            ->get();
                            
            $data['pelatihan'] = DB::table('surat_reg_pelatihan')
                                ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                                ->where('warga_bjb_id',$data['profile']->id_warga)
                                ->where('status_id',5)
                                ->get();
                                
            $data['bantuan'] = DB::table('surat_permohonan_bantuan')
                            ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                            ->where('warga_bjb_id',$data['profile']->id_warga)
                            ->where('status_id',5)
                            ->get();
            
            return view('umkm.index',$data);
            
            //  $pdf = PDF::loadView('umkm.index', $data);
            //  return $pdf->download('profil usaha'. $data['profile']->nama_lgkp . '.pdf');
 
	     }
	     
	     public function getPilihFile(){
	           $data=[];
	           $data['uploaded']=DB::table('uploaded')
	                            ->join('cms_users','cms_users.id','uploaded.updated_by')
	                            ->join('cms_privileges','cms_privileges.id','uploaded.updated_by_priv')
	                            ->where('updated_by_priv',CRUDBooster::myPrivilegeId())
	                            ->selectRaw('uploaded.*,cms_users.name as nama_user, cms_privileges.name as role')
	                            ->get();
	           
	           return view('import.pilih',$data);
	     }
	     
	     public function getImportFile($id){
	        $uploaded=DB::table('uploaded')->where('id',$id)->first();
	        $data['id']=$id;
	        $data['excel']=$uploaded->file;
	       // if(strlen($bantuan->upload_file)>0){
                 $this->cbView('import.xlsx',$data);
	    //    }else{
	            
	      //  }
	    }
	    
	    public function postImportExcel($id){
	        $selected_kolom=Request::input('selected_kolom');
	        $rows=Session::get('rows');
	        $excel=Request::input('excel');
	        $result = array();
	        
	        $ketemu=0;
	        $baru=0;
	        $sudah=0;
	        $tidakketemu=0;
	        $capilyes=0;
	        $capilno=0;
	       
        	foreach($rows as $ro){
        	    
        	    $found=DB::table('warga_bjb')->where('nik',$ro[$selected_kolom])->first();
        	    if($found){
        	        //var_dump( $selected_kolom . '-' .$ro[$selected_kolom] );
        	        $ketemu++;
        	        $exists=DB::table('umkm_usaha')->where('warga_bjb_id',$found->id)->get();
        	        
        	        if(sizeof($exists)>0){
            	        foreach($exists as $exist){
            	            similar_text($exist->nama_usaha,$ro['BIDANG USAHA'],$percent);
            	            if($percent<=50){
                	            $baru++;
                	            //DB::table('umkm_usaha')->insert(['warga_bjb_id'=>$found->id,'nama_usaha'=$ro['BIDANG USAHA'],'brand'=>$ro['BIDANG USAHA'],'alamat_usaha'=>$ro['ALAMAT LENGKAP'],'no_telp_usaha'=>$ro['NO. HP/WA'], 'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId()]);
                	            array_push($result, $ro[$selected_kolom] . ' ditambahkan lagi karena ('.$percent.') - detail ('. implode(",",$ro) . ')' );
                	        }else{
                	            $sudah++;
                	            array_push($result, $ro[$selected_kolom] . ' data sudah ada' );
                	        }
            	        }
        	        }else{
        	            $baru++;
        	            array_push($result, $ro[$selected_kolom] . ' ditambahkan - detail ('. implode(",",$ro) . ')' );
        	        }
        	        
        	    }else{
        	        $tidakketemu++;
        	        array_push($result, $ro[$selected_kolom] . ' Tidak Ditemukan ! - detail ('. implode(",",$ro) . ')'   );
        	       // $capil = CRUDBooster::updateNik($ro[$selected_kolom]);
        	       // if($capil->api_status=="1"){
        	       //     $capilyes++;
        	       //     array_push($result, $ro[$selected_kolom] . '-' .$ro['NAMA_PENERIMA'] . ' ada dalam data capil !'   );
        	       //    // $found2=DB::table('warga_bjb')->where('nik',$ro[$selected_kolom])->first();
        	       //    // DB::table('history_bantuan')->insert(['tanggal'=>now(),'warga_bjb_id'=>$found2->id,'bantuan_id'=>$id,'keterangan'=>'Import dari file '.$excel,'updated_by'=>CRUDBooster::myId(),'updated_by_priv'=>CRUDBooster::myPrivilegeId()]);
        	       //    // array_push($result, $ro[$selected_kolom] . ' ditambahkan' );
        	       //     //array_push($result, json_encode($capil)  );
        	       // }else{
        	       //     $capilno++;
        	       //     array_push($result, $ro[$selected_kolom] . '-' .$ro['NAMA_PENERIMA'] . ' Tidak teregistrasi !'   );
        	       // }
        	    }
        	}
        	DB::table('uploaded')->where('id',$id)->update(['logs'=>$ketemu. ' nik ditemukan, '. $baru . ' ditambahkan, '. $sudah . ' sudah ada, '. $tidakketemu . ' nik tidak ditemukan, ' . $capilyes . ' diambil di capil, ' . $capilno . ' tidak teregister.']);
        	array_push($result,$ketemu. ' nik ditemukan, '. $baru . ' ditambahkan, '. $sudah . ' sudah ada, '. $tidakketemu . ' nik tidak ditemukan, ' . $capilyes . ' diambil di capil, ' . $capilno . ' tidak teregister.' );
	        $data['result'] = $result;
	        $this->cbView('import.result',$data);
	    }
	    
	    public function getBuatAkun(){
	        $data = [];
	        $data['saya'] = CRUDBooster::menik(CRUDBooster::me()->nik); 
	        //$data['usaha'] = DB::table('umkm_usaha')->where('id',$id)->first();
	        $this->cbView('umkm.buatakun',$data);
	    }
	    
	    public function postBuatAkun(){
	        $validator = Validator::make(Request::all(), [
            //'email' => 'required|email|exists:'.config('crudbooster.USER_TABLE'),
                'user_pass' => 'required',
                'display_name' => 'required',
                'nickname' => 'required',
                'user_login' => 'required',
            ]);
    
            if ($validator->fails()) {
                $message = $validator->errors()->all();
    
                return redirect()->back()->with(['message' => implode(', ', $message), 'message_type' => 'danger']);
            }
	        $password = Request::input("user_pass");
	        $users = DB::table('cms_users')->where("nik", Request::input('user_login'))->first();
            //var_dump(Request::input('user_login') . '-' . $password);
            if (\Hash::check($password, $users->password)) {
                
				$ch = curl_init();

				curl_setopt($ch, CURLOPT_URL,"https://ukm.banjarbarukota.go.id/?wpwhpro_action=daftar&wpwhpro_api_key=lwohpsd4jilj3smhzbjhry4lncgqtzsdtv0jfgbdlmzcoqcowlcbqihcnnv3jcm1");
		
				// Receive server response ...
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_POST, 1);
				
		
				curl_setopt($ch, CURLOPT_POSTFIELDS,
							http_build_query(array('action' => 'create_user','user_email' => Request::input('user_email'), 'user_login' => Request::input('user_login'), 'user_pass' => Request::input('user_pass'), 'nickname' => Request::input('nickname'), 'display_name' => Request::input('nickname'),'role'=> 'Vendor')));
				
				$server_output = json_decode(curl_exec($ch));
				
				curl_close ($ch);
				if ($server_output->success==true){
				    DB::table('pasar_bjb')->insert(['warga_bjb_id'=>Request::input('warga_bjb_id'),'user_email' => Request::input('user_email'),'username'=>Request::input('user_login'), 'user_pass' => Request::input('user_pass'), 'nickname' => Request::input('nickname'), 'display_name' => Request::input('nickname')])
				                        ->where('id',Request::input('id'));
				                        
				    CRUDBooster::redirect(CRUDBooster::mainpath(),'Pembuatan Akun Berhasil',"info");
				}else{
				    CRUDBooster::redirect(CRUDBooster::mainpath('buat-akun/'.Request::input('id')),'Pembuatan akun gagal ' . json_encode($server_output->data->user_id),"danger");
				    //return redirect()->back()->with('message', 'Pembuatan akun gagal ' . $server_output->msg); 
				}
			
            }else{
                CRUDBooster::redirect(CRUDBooster::mainpath('buat-akun/'.Request::input('id')),'Verifikasi Password gagal !',"danger");
            }	
		}
		
		public function getByAdmin(){

	        $data = [];
	        
	        $data['page_title'] = "Daftarkan Usaha";
	        $data['created_by'] = CRUDBooster::myId();
	        $data['created_by_priv'] = CRUDBooster::myPrivilegeId();

	        $data['next'] = CRUDBooster::mainpath("step2");
	        
	        return view('umkm.addbyadmin', $data);
	    }
	    
	     public function postStep2(){
	        $data = [];
	        $data['page_title'] = "Data Warga " . Request::input('nik');
            $data['id'] = Request::input('id');
            $data['owner_priv'] = Request::input('owner_priv');
            
           // var_dump($data['pelatihan']);
	        
	        if(Request::input('nik')){
	            $warga_cloud = DB::table('warga_bjb')
	                            ->join('districts','warga_bjb.nama_kec','districts.id')
	                            ->join('villages','warga_bjb.nama_kel','villages.id')
	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
	                            ->where('nik',Request::input('nik'))
	                            ->first();
	            
	            if(!$warga_cloud->no_kk){
    	            $capil = CRUDBooster::updateNik(Request::input('nik'));
                
                    //var_dump($capil->local_exist);
                    
                    if($capil->api_status=="1"){
                        $locally = $capil->local_exist;
                        
                        
            	        $data['warga_bjb'] = DB::table('warga_bjb')
            	                            ->join('districts','warga_bjb.nama_kec','districts.id')
            	                            ->join('villages','warga_bjb.nama_kel','villages.id')
            	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
            	                            ->where('nik',Request::input('nik'))
            	                            ->first();
            	                            
            	       $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb']->id)
                            ->where('status_id',5)
                            ->get();
                            
                        $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                        ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                        ->where('warga_bjb_id',$data['warga_bjb']->id)
                                        ->where('status_id',5)
                                        ->get();
            	       
            	        $data['pesan'] = "Data dari capil";
            	        
        	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb']->id)->first();
        	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
        	            $data['next'] = CRUDBooster::mainpath("step3") ;
        	            
        	            return view('umkm.step2', $data);

                    }else{
                        return CRUDBooster::redirectBack($capil->api_message, "warning");
                    }
	            }else{
                        
        	        $data['warga_bjb'] = $warga_cloud;
        	        
        	        $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$data['warga_bjb']->id)
                            ->where('status_id',5)
                            ->get();
                            
                    $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                                    ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                                    ->where('warga_bjb_id',$data['warga_bjb']->id)
                                    ->where('status_id',5)
                                    ->get();
        	        
        	        $data['pesan'] = "Data dari siapkk";
        	        
    	            $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$data['warga_bjb']->id)->first();
    	            $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$data['warga_bjb']->id)->get();
    	            $data['next'] = CRUDBooster::mainpath("step3");
    	            
    	            return view('umkm.step2', $data);
        	        
	            }
    	        
	        }else{
	            return redirect()->back()->with('nikreq', 'Harap isi NIK !'); 
	        }
	    }
	    
	    public function postStep3(){
	        //Khusus usaha_required
	        $data = [];
	        $data['page_title'] = "Kelengkapan Data Usaha";
	        $data['warga_bjb_id'] = Request::input('warga_bjb_id');
	        
	        //if(Request::input('usaha_required')==1){
    	        //if(Request::input('no_iumk') && Request::input('no_npwp') && Request::input('nib_sku') && Request::input('no_telp') ){
    	        if( Request::input('no_telp') ){
    	            if(Request::input('pemilik_id')){
    	                DB::table('umkm_pemilik')->where('id',Request::input('pemilik_id'))->update(['no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp')]);
    	                $data['pemilik_id'] = Request::input('pemilik_id');
    	            }else{
    	                $pemilik = DB::table('umkm_pemilik')->insertGetId(['warga_bjb_id'=>Request::input('warga_bjb_id'),'no_iumk'=>Request::input('no_iumk'),'nib_sku' => Request::input('nib_sku'),'no_npwp' => Request::input('no_npwp'),'no_telp' => Request::input('no_telp'),'updated_by' => CRUDBooster::myId()]);
    	            
    	                $data['pemilik_id'] = $pemilik;
    	            }
    	            
    	            if(Request::input('usaha_baru')==0){
    	                $data['usaha'] = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->first();
    	            }else{
    	                $data['usaha_baru'] = Request::input('usaha_baru');
    	            }
    	            //if(Request::input('usaha_id')){
        	            $data['bidang_usaha'] =  DB::table('umkm_jenis_usaha')->where('parent_id',0)->get();
        	            $data['sub_bidang_usaha'] =  DB::table('umkm_jenis_usaha')->where('parent_id','>',0)->get();
        	            $data['kecamatan'] =  DB::table('districts')->where('regency_id','6372')->get();
        	            $data['kelurahan'] =  DB::table('villages')->where('district_id','like','6372%')->get();
        	            $data['umkm_status_tempat'] =  DB::table('umkm_status_tempat')->get();
        	            $data['umkm_perizinan'] =  DB::table('umkm_perizinan')->get();
        	            $data['umkm_permodalan'] =  DB::table('umkm_permodalan')->get();
        	           // $data['umkm_pemasaran'] =  DB::table('umkm_sistem_pemasaran')->get();
    	           // }else{
    	           //    //return redirect()->back()->with('usahareq', 'Harap Isi Data Ini !'); 
    	           // }
    	            $data['next'] = CRUDBooster::mainpath("step4") ;
    	            $data['prev'] = CRUDBooster::mainpath() ;
	                $data['galat'] = CRUDBooster::mainpath() ;
    	            //return redirect(CRUDBooster::adminPath('umkm_usaha/edit/'.Request::input('usaha_id')));
    	            return view('umkm.step3', $data);
    	        } else{
    	          //    CRUDBooster::redirectBack('Harap Lengkapi Data','warning');
    	            return redirect()->back()->with('usahareq', 'Harap Isi Data Ini !'); 
    	        }
	       // }
	    }
	    
	    public function postStep4(){
	        $data = [];
	        $data['page_title'] = "Selesai";
	        
	        $data['prev'] = CRUDBooster::mainpath() ;
	        $data['galat'] = CRUDBooster::mainpath() ;
    	        
            $newusaha = DB::table('umkm_usaha')->where('id',Request::input('usaha_id'))->insertGetId([
                            'warga_bjb_id'=>Request::input('warga_bjb_id'),
    	                    'nama_usaha'=>Request::input('nama_usaha'),
    	                    'bidang_usaha'=>implode(";",Request::input('bidang_usaha')),
    	                    'sub_bidang_usaha'=>implode(";",Request::input('sub_bidang_usaha')),
    	                    'brand'=>Request::input('brand'),
    	                    'alamat_usaha'=>Request::input('alamat_usaha'),
    	                    'province_id'=>63,
    	                    'regency_id'=>6372,
    	                    'district_id'=>Request::input('district_id'),
    	                    'village_id'=>Request::input('village_id'),
    	                    'status_usaha_id'=>implode(";",Request::input('status_usaha_id')),
    	                    'perizinan'=>implode(";",Request::input('perizinan')),
    	                    'permodalan_id'=>implode(";",Request::input('permodalan_id')),
    	                    'pemasaran_id'=>3,
    	                    'j_kary_l'=>Request::input('j_kary_l'),
    	                    'j_kary_p'=>Request::input('j_kary_p'),
    	                    'j_kary'=>Request::input('j_kary'),
    	                    'modal_awal'=>Request::input('modal_awal'),
    	                    'modal_saat_ini'=>Request::input('modal_saat_ini'),
    	                    'aset_tetap'=>Request::input('aset_tetap'),
    	                    'omset'=>Request::input('omset'),
	                       'updated_by'=>CRUDBooster::myId(),
	                       'status_id'=>3
    	                ]);
    	                
    	    $data['usaha_id'] = $newusaha ;
           
            return view('umkm.peta', $data);
            //CRUDBooster::redirect(CRUDBooster::mainpath(),"Data Berhasil Ditambahkan","success");

	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	        if(CRUDBooster::MyPrivilegeId()==2){
	            $query->where('warga_bjb_id',CRUDBooster::menik(CRUDBooster::me()->nik)->id);
	        }
	        if(CRUDBooster::myPrivilegeId()==5){
	            $query->where('umkm_usaha.village_id',CRUDBooster::me()->village_id)
	                  ->orWhere('warga_bjb.nama_kel',CRUDBooster::me()->village_id);
	        }
	        if(CRUDBooster::myPrivilegeId()==7){
	            $query->where('umkm_usaha.district_id',CRUDBooster::me()->district_id)
	                  ->orWhere('warga_bjb.nama_kec',CRUDBooster::me()->district_id);
	        }
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {
	       
        
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {
	        if(CRUDBooster::MyPrivilegeId()==2){
	            $usaha_baru = DB::table('umkm_usaha')->where('id',$id)->first();
	            $warga_bjb = DB::table('warga_bjb')->where('id',$usaha_baru->warga_bjb_id)->first();
	            $last_id = DB::table('surat_masuk')->insertGetId([
					'jenis_surat_id' => 8,
					'owner_priv' => 14,
					'nik' => $warga_bjb->nik,
					'nama_lgkp' => $warga_bjb->nama_lgkp,
					'tmpt_lhr' => $warga_bjb->tmpt_lhr,
					'tgl_lhr' => $warga_bjb->tgl_lhr,
					'alamat' => $warga_bjb->alamat2,
					'rt' => $warga_bjb->rt,
					'rw' => $warga_bjb->rw,
					'district_id' => $warga_bjb->nama_kec,
					'village_id' => $warga_bjb->nama_kel,
					'jk' => $warga_bjb->jk,
					'pekerjaan' => $warga_bjb->pekerjaan,
					'no_telp' => $warga_bjb->telp,
					'created_at' => Carbon::now(),
					'created_by' => CRUDBooster::myId(),
					'status_id' => 1,
					'status_by' => CRUDBooster::myId(),
					'status_by_priv' => CRUDBooster::myPrivilegeId(),
					'rel_table' => 'umkm_usaha',
					'rel_id' => $id
				]);
				
				$pemilik_umkm_eksis = DB::table('umkm_pemilik')->where('warga_bjb_id',$warga_bjb->id)->first();
                
                if(!$pemilik_umkm_eksis){
                    DB::table('umkm_pemilik')->insert(['warga_bjb_id'=>$warga_bjb->id,'updated_by'=> $warga_bjb->id]);
                }

    			
    			// $config['id_cms_users'] = $notified_user;
    			
    			// CRUDBooster::sendNotification($config);
    			
    			CRUDBooster::createMasterNotif("8",CRUDBooster::myName() . " membuat permohonan Ijin Usaha","umkm_usaha","openUrl;".$last_id.";".CRUDBooster::adminPath('surat_masuk'));
    			//return redirect(CRUDBooster::adminPath('umkm_usaha_saya'));
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here
            
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 
            //return redirectBack('Berhasil');
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}