<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	

	class AdminUmkmWargaBjbController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_lgkp";
			$this->limit = "20";
			$this->orderby = "id,desc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = true;
			$this->button_action_style = "button_icon";
			$this->button_add = true;
			$this->button_edit = true;
			$this->button_delete = true;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "warga_bjb";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"NIK","name"=>"nik"];
			$this->col[] = ["label"=>"Nama Lengkap","name"=>"nama_lgkp"];
			$this->col[] = ["label"=>"Jenis Kelamin","name"=>"jk"];
			$this->col[] = ["label"=>"Tempat Lahir","name"=>"tmpt_lhr"];
			$this->col[] = ["label"=>"Tanggal Lahir","name"=>"tgl_lhr"];
		    $this->col[] = ["label"=>"Umur","name"=>"TIMESTAMPDIFF(YEAR, warga_bjb.tgl_lhr, CURDATE()) as age","callback_php"=>"$row->age"];
			//$this->col[] = ["label"=>"Alamat","name"=>"(SELECT CONCAT(alamat2, ' RT.', rt , ' RW.', rw, ' KEL.', (SELECT name FROM villages WHERE id = warga_bjb.nama_kel), ' KEC.', (SELECT name FROM districts WHERE id = warga_bjb.nama_kec)) As alamat FROM warga_bjb ) as alamat","callback_php"=>'$row->alamat'];
		   // $this->col[] = ["label"=>"Alamat Pemilik","name"=>"(SELECT CONCAT(alamat2, ' RT.', rt , ' RW.', rw, ' KEL.', (SELECT name FROM villages WHERE id = warga_bjb.nama_kel), ' KEC.', (SELECT name FROM districts WHERE id = warga_bjb.nama_kec)) As alamat FROM warga_bjb) as alamat","callback_php"=>'$row->alamat'];
			$this->col[] = ["label"=>"Alamat","name"=>"alamat2"];
			$this->col[] = ["label"=>"RT","name"=>"rt"];
			$this->col[] = ["label"=>"RW","name"=>"rw"];
		//	$this->col[] = ["label"=>"Kode Kelurahan","name"=>"nama_kel"];
			$this->col[] = ["label"=>"Kelurahan","name"=>"nama_kel","join"=>"villages,name"];
	    //	$this->col[] = ["label"=>"Kode Kecamatan","name"=>"nama_kec"];
			$this->col[] = ["label"=>"Kecamatan","name"=>"nama_kec","join"=>"districts,name"];
			$this->col[] = ["label"=>"Kabupaten","name"=>"nama_kab","join"=>"regencies,name"];
			$this->col[] = ["label"=>"Provinsi","name"=>"nama_prop","join"=>"provinces,name"];
// 			$this->col[] = ["label"=>"Pendidikan Akhir","name"=>"pddk_akhir"];
// 			$this->col[] = ["label"=>"Pekerjaan","name"=>"pekerjaan"];
			$this->col[] = ["label"=>"Nomor KK","name"=>"no_kk"];
			$this->col[] = ["label"=>"Hashtag","name"=>"hashtag"];
			$this->col[] = ["label"=>"Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			$this->col[] = ["label"=>"Akun","name"=>"(SELECT IF(EXISTS(SELECT name FROM cms_users WHERE nik = warga_bjb.nik), 'Terdaftar', 'Tidak Terdaftar')) as akun","callback_php"=>"$row->akun"];
		//	$this->col[] = ["label"=>"Admin","name"=>"(SELECT IF(EXISTS(SELECT * FROM multi_privs WHERE nik = warga_bjb.nik), 'Ya', '-')) as akun","callback_php"=>"$row->akun"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'NIK','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-8','validation'=>'required|min:16|max:16'];
			$this->form[] = ['label'=>'Nama Lengkap','name'=>'nama_lgkp','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Jenis Kelamin','name'=>'jk','type'=>'radio','validation'=>'required|min:1|max:255','width'=>'col-sm-8','dataenum'=>'L|Laki-laki;P|Perempuan'];
			$this->form[] = ['label'=>'Tempat Lahir','name'=>'tmpt_lhr','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-6'];
			$this->form[] = ['label'=>'Tanggal Lahir','name'=>'tgl_lhr','type'=>'date','validation'=>'required|date','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Pendidikan Akhir','name'=>'pddk_akhir_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-4','datatable'=>'umkm_pddk_akhir,pddk_akhir'];
			$this->form[] = ['label'=>'Pddk Akhir','name'=>'pddk_akhir','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-4'];
			$this->form[] = ['label'=>'Pekerjaan','name'=>'pekerjaan_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-4','datatable'=>'umkm_pekerjaan,pekerjaan'];
			$this->form[] = ['label'=>'Pkrjn','name'=>'pekerjaan','type'=>'hidden','validation'=>'min:1|max:255','width'=>'col-sm-8'];
			//$this->form[] = ['label'=>'Alamat','name'=>'alamat','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			$this->form[] = ['label'=>'Alamat','name'=>'alamat2','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-10'];
			
			
            
            if(CRUDBooster::myPrivilegeId()==5){
                $this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-4'];
			    $this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-4'];
                $this->form[] = ['label'=>'Provinsi','name'=>'nama_prop','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>'63'];
			    $this->form[] = ['label'=>'Kabupaten','name'=>'nama_kab','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>'6372'];
    			$this->form[] = ['label'=>'Kecamatan','name'=>'nama_kec','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>CRUDBooster::me()->district_id];
    			$this->form[] = ['label'=>'Kelurahan','name'=>'nama_kel','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>CRUDBooster::me()->village_id];
			}else if(CRUDBooster::myPrivilegeId()==3){
			    $this->form[] = ['label'=>'RT','name'=>'rt','type'=>'hidden','validation'=>'required|numeric','width'=>'col-sm-4','value'=>CRUDBooster::me()->rt];
			    $this->form[] = ['label'=>'RW','name'=>'rw','type'=>'hidden','validation'=>'required|numeric','width'=>'col-sm-4','value'=>CRUDBooster::me()->rt];
                $this->form[] = ['label'=>'Provinsi','name'=>'nama_prop','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>'63'];
			    $this->form[] = ['label'=>'Kabupaten','name'=>'nama_kab','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>'6372'];
    			$this->form[] = ['label'=>'Kecamatan','name'=>'nama_kec','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>CRUDBooster::me()->district_id];
    			$this->form[] = ['label'=>'Kelurahan','name'=>'nama_kel','type'=>'hidden','validation'=>'required|min:1|max:255','width'=>'col-sm-6','value'=>CRUDBooster::me()->village_id];
			}else{
			    $this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-4'];
			    $this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|numeric','width'=>'col-sm-4'];
			    $this->form[] = ['label'=>'Provinsi','name'=>'nama_prop','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'provinces,name','value'=>'63'];
		    	$this->form[] = ['label'=>'Kabupaten','name'=>'nama_kab','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'regencies,name','value'=>'6372'];
			    $this->form[] = ['label'=>'Kecamatan','name'=>'nama_kec','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'districts,name','datatable_where'=>'regency_id ='.CRUDBooster::getSetting('kode_kabupaten')];
    			$this->form[] = ['label'=>'Kelurahan','name'=>'nama_kel','type'=>'select2','validation'=>'required|min:1|max:255','width'=>'col-sm-6','datatable'=>'villages,name','datatable_where'=>'district_id like "'.CRUDBooster::getSetting('kode_kabupaten').'%"'];
			}
			//$this->form[] = ['label'=>'Nomor Telepon','name'=>'telp','type'=>'text','validation'=>'numeric','width'=>'col-sm-4'];
			//$this->form[] = ['label'=>'BOT ID','name'=>'conv_id','type'=>'select2','validation'=>'min:1|max:255','width'=>'col-sm-4','datatable'=>'waconv,chat_id'];
			//if(strlen(['no_kk'])==0){
			    $this->form[] = ['label'=>'Nomor KK','name'=>'no_kk','type'=>'text','validation'=>'numeric','width'=>'col-sm-4', 'readonly'=>false];
			    $this->form[] = ['label'=>'Hashtag','name'=>'hashtag','type'=>'textarea','validation'=>'min:5','width'=>'col-sm-6'];
			//}
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'numeric','width'=>'col-sm-2', 'value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by_priv','type'=>'hidden','validation'=>'numeric','width'=>'col-sm-2', 'value'=>CRUDBooster::myPrivilegeId()];
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Nik","name"=>"nik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Lgkp","name"=>"nama_lgkp","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Jk","name"=>"jk","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tmpt Lhr","name"=>"tmpt_lhr","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tgl Lhr","name"=>"tgl_lhr","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Pddk Akhir","name"=>"pddk_akhir","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Pekerjaan","name"=>"pekerjaan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Alamat","name"=>"alamat","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Alamat2","name"=>"alamat2","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Rt","name"=>"rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Rw","name"=>"rw","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Kode Pos","name"=>"kode_pos","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Telp","name"=>"telp","type"=>"number","required"=>TRUE,"validation"=>"required|numeric","placeholder"=>"Anda hanya dapat memasukkan angka saja"];
			//$this->form[] = ["label"=>"Nama Prop","name"=>"nama_prop","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Kab","name"=>"nama_kab","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Kec","name"=>"nama_kec","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Kel","name"=>"nama_kel","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();
	        $this->sub_module[] = ['label'=>'Catatan','path'=>'catatan_warga','parent_columns'=>'nama_lgkp,alamat2','foreign_key'=>'warga_bjb_id','button_color'=>'warning','button_icon'=>'fa fa-sticky-note'];
            //$this->sub_module[] = ['label'=>'Buat Anun','path'=>'pengguna','parent_columns'=>'nama_usaha,bidang_usaha,sub_bidang_usaha','foreign_key'=>'umkm_usaha_id','button_color'=>'info','button_icon'=>'fa fa-bars'];//,'showIf'=>'[created_by_priv] == CRUDBooster::myPrivilegeId() OR [created_by_priv] == CRUDBooster::myParentPriv() OR [created_by_priv] == CRUDBooster::myParentPriv() '];

	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        //$this->addaction[] = ['label'=>'Catatan','icon'=>'fa fa-sticky-note','color'=>'warning','url'=>CRUDBooster::mainpath('buat-akun').'/[id]'];
	        if(CRUDBooster::myPrivilegeId()==1 || CRUDBooster::myPrivilegeId()==16 || CRUDBooster::myPrivilegeId()==14 || CRUDBooster::myPrivilegeId()==13 || CRUDBooster::myPrivilegeId()==5){
	            //$this->addaction[] = ['label'=>'Cek Akun','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::mainpath('cek-akun').'/[id]'];
	            $this->addaction[] = ['label'=>'Buat Akun','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('buat-akun').'/[id]','showIf'=>'[akun]=="Tidak Terdaftar"'];
	            $this->addaction[] = ['label'=>'Set Admin','icon'=>'fa fa-address-card','color'=>'danger','url'=>CRUDBooster::mainpath('set-admin').'/[id]','showIf'=>'[akun]=="Terdaftar"'];
	            //$this->addaction[] = ['label'=>'Refresh Data','icon'=>'fa fa-address-card','color'=>'warning','url'=>CRUDBooster::mainpath('refresh-data').'/[nik]'];
	        }


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();
	       // $this->index_button[] = ['label'=>'Tarik Data Capil','url'=>CRUDBooster::mainpath("pull-capil-index"),"icon"=>"fa fa-pull"];



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = '
	            $("#nama_prop").change(function() {
                  var sel = $("#nama_prop option:selected").val();
                  $.get("https://siapkk.banjarbarukota.go.id/api/list_kab?province_id=" + sel, function(data, status){
                    
                    $("#nama_kab").empty();
                    $("#nama_kab").append("<option value=>** Silahkan pilih Kabupaten</option>");
                    $.each(data.data, function(key,value) {
                      //console.log(value.name);
                      var id = value.id;
                      var caption = value.name;
                      $("#nama_kab").append("<option value=" + id + ">" + caption + "</option>");
                    });
                  });
                });
                
                
                $("#nama_kab").change(function() {
                  var sel = $("#nama_kab option:selected").val();
                  $.get("https://siapkk.banjarbarukota.go.id/api/list_kec?regency_id=" + sel, function(data, status){
                    
                    $("#nama_kec").empty();
                    $("#nama_kec").append("<option value=>** Silahkan pilih Kecamatan</option>");
                    $.each(data.data, function(key,value) {
                      //console.log(value.name);
                      var id = value.id;
                      var caption = value.name;
                      $("#nama_kec").append("<option value=" + id + ">" + caption + "</option>");
                    });
                  });
                });
                
                $("#nama_kec").change(function() {
                  var sel = $("#nama_kec option:selected").val();
                  $.get("https://siapkk.banjarbarukota.go.id/api/list_kel?district_id=" + sel, function(data, status){
                    
                    $("#nama_kel").empty();
                    $("#nama_kel").append("<option value=>** Silahkan pilih Kelurahan</option>");
                    $.each(data.data, function(key,value) {
                      console.log(value.name);
                      var id = value.id;
                      var caption = value.name;
                      $("#nama_kel").append("<option value=" + id + ">" + caption + "</option>");
                    });
                  });
                });
	        ';


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        //$this->load_js = array();
	        //$this->load_js[] = asset("/js/umkm_warga.js");
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }
	    

	    
	    public function getCekAkun($id){
	       if(!CRUDBooster::isCreate() && $this->global_privilege==FALSE || $this->button_add==FALSE) {    
            CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
          }
          
          $data = [];
          
          $data['page_title'] = 'Add Data';
          $data['warga'] = DB::table('warga_bjb')->where('id',$id)->first();
          
          $exist = DB::table('cms_users')->where('nik',$data['warga']->nik)->first();
          
          if(!$exist){
                return CRUDBooster::redirectBack("Warga belum terdaftar !", "warning");
            }else{
                return CRUDBooster::redirectBack("Warga sudah terdaftar", "success");
            }
	    }
	    
	    public function getBuatAkun($id){
	       if(!CRUDBooster::isCreate() && $this->global_privilege==FALSE || $this->button_add==FALSE) {    
            CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
          }
          
          $data = [];
          
          $data['page_title'] = 'Daftarkan Akun 1 LOGIN';
          $data['warga'] = DB::table('warga_bjb')->where('id',$id)->first();
          
          
          //Please use cbView method instead view method from laravel
          $this->cbView('custom.buat_akun',$data);
	    }
	    
	    public function postSimpanAkun(){
            $exist = DB::table('cms_users')->where('nik',Request::input('nik'))->first();
            
            if(!$exist){
                DB::table('cms_users')->insert([
                        'nik'=>Request::input('nik'),
                        'name'=>Request::input('name'),
                        'no_telp'=>Request::input('no_telp'),
                        'password'=>\Hash::make(Request::input('password')),
                        'id_cms_privileges'=>2,
                        'created_by'=>CRUDBooster::myId(),
                        'created_at'=>now(),
                        'status'=>'Active',
                        'verified'=>80
                    ]);
                CRUDBooster::redirect(CRUDBooster::mainpath(),"Akun " . Request::input('nik') . "  berhasil dibuat","success");
            }else{
                return CRUDBooster::redirectBack("Warga sudah terdaftar !", "warning");
            }
        }
        
        public function getSetAdmin($id){
	       if(!CRUDBooster::isCreate() && $this->global_privilege==FALSE || $this->button_add==FALSE) {    
            CRUDBooster::redirect(CRUDBooster::adminPath(),trans("crudbooster.denied_access"));
          }
          
          $data = [];
          
          $data['page_title'] = 'Daftarkan Sebagai Admin';
          $data['warga'] = DB::table('warga_bjb')->where('id',$id)->first();
          $data['cms_users'] = DB::table('cms_users')->where('nik',$data['warga']->nik)->first();
          $data['privs'] = DB::table('multi_privs')->where('cms_users_id',$data['cms_users']->id)->get();
          $data['aprivs'] = DB::table('cms_privileges')->where('id',3)->orWhere('id',4)->get();
          
          //Please use cbView method instead view method from laravel
          $this->cbView('custom.set_admin',$data);
	    }
	    
	    public function postSetAdmin(){
	        $exist = DB::table('multi_privs')->where('cms_privileges_id',Request::input('admin_id'))->where('cms_users_id',Request::input('cms_users_id'))->first();
	        if($exist){
	            dd($exist);
	        }else{
	            
	        }
	        
	    }
	    
	    
	    
	    public function getPullCapilIndex(){
	        $data = [];
	        $this->cbView('caplin.index',$data);
	    }
	    
	    public function getRefreshData($nik)
		{
		   $data['nik'] = $nik;
		   
		   //$this->CBView('refdata',$data);
		   $update = $this->update_nik($nik);
		   
		   //var_dump($update);
		  // return CRUDBooster::redirectBack($update, "success");
		   if($update->api_status<=0){
		      return CRUDBooster::redirectBack("Update gagal ! " . $update->api_message); 
		   }else{
		       return CRUDBooster::redirectBack("Update data berhasil. " . $update->api_message, "success");
		   }
		   
		}
		
		public function update_nik($nik)
        {
            $sk = '8ed90039d8a97c5b9fcc745ebc725a1f';
            $time = time();
            $agent = $_SERVER['HTTP_USER_AGENT'];
            
            $token = md5($sk . $time . $agent);
            
    		$data1 = [
    			'nik' => $nik,
    			'token' => '1234567890',
    			'mode' => 'cari_nik'
    		];
    
    		$curl = curl_init();
    
    		curl_setopt_array($curl, array(
    			CURLOPT_URL => "https://satu.banjarbarukota.go.id/siapkk/public/api/satu",
    			CURLOPT_RETURNTRANSFER => true,
    			CURLOPT_ENCODING => "",
    			CURLOPT_MAXREDIRS => 10,
    			CURLOPT_TIMEOUT => 30000,
    			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    			CURLOPT_CUSTOMREQUEST => "POST",
    			CURLOPT_POSTFIELDS => json_encode($data1),
    			CURLOPT_HTTPHEADER => array(
    				"accept: application/json",
    				"content-type: application/json",
    				"origin: https://siapkk.banjarbarukota.go.id",
    				"X-Authorization-Token:".$token,
    				"X-Authorization-Time:". $time,
    				"User-Agent:".$agent
    			),
    		));
    
    		$response = curl_exec($curl);
    		$err = curl_error($curl);
    
    		if ($err) {
    			$hasil = $err;
    		} else {
    			$hasil= json_decode($response);			
    		}
    		curl_close($curl);
    		
            return $hasil;
        }
        
        public function postPullCapil(){
            $capil = CRUDBooster::updateNik(Request::input('nik'));
            
            //var_dump($capil->local_exist);
            
            if($capil->api_status=="1"){
                $locally = $capil->local_exist;
                return CRUDBooster::redirectBack("Update data nik " . Request::input('nik') . " atas nama " . $locally->nama_lgkp . " berhasil", "success");
            }else{
                return CRUDBooster::redirectBack($capil->api_message, "warning");
            }
        }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function hook_query_index(&$query) {
	        //Your code here
	        if(CRUDBooster::myPrivilegeId()=="14"){
	           // $query->whereExists(function ($query) {
            //           $query->select(DB::raw(1))
            //                  ->from('umkm_pemilik')
            //                  ->whereRaw('warga_bjb.id = umkm_pemilik.warga_bjb_id');
            //         })->orWhere('updated_by_priv',CRUDBooster::myPrivilegeId());
	        }
	        if(CRUDBooster::myPrivilegeId()=="3"){
	            //rt
	            $query
	                ->where('nama_kec',CRUDBooster::me()->district_id)
	                ->where('nama_kel',CRUDBooster::me()->village_id)
	                ->whereRaw('CAST(warga_bjb.rw AS UNSIGNED)='.CRUDBooster::me()->rw)
	                ->whereRaw('CAST(warga_bjb.rt AS UNSIGNED)='.CRUDBooster::me()->rt);
	        }
	        if(CRUDBooster::myPrivilegeId()=="5"){
	            //kelurahan
	            $query->where('nama_kel',CRUDBooster::me()->village_id);
	        } 
	        if(CRUDBooster::myPrivilegeId()=="7"){
	            //kecamatan
	            $query->where('nama_kec',CRUDBooster::me()->district_id);
	        } 
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here
            $exist = DB::table('warga_bjb')
                     ->where('nik',$postdata['nik'])->get();
                     
            if(sizeof($exist)>0){
                return CRUDBooster::redirectBack("Nik sudah terdaftar !");
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        $new = DB::table('warga_bjb')->where('id',$id)->first();
	        $pekerjaan = DB::table('umkm_pekerjaan')->where('id',$new->pekerjaan_id)->first();
	        $pddk = DB::table('umkm_pddk_akhir')->where('id',$new->pddk_akhir_id)->first();
	        
	        DB::table('warga_bjb')->where('id',$id)->update(['pekerjaan'=>$pekerjaan->pekerjaan,'pddk_akhir'=>$pddk->pddk_akhir]); 
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here
	        $ori = DB::table('warga_bjb')
                     ->where('id',$id)->first();
                     
            $exist = DB::table('warga_bjb')
                     ->where('nik',$postdata['nik'])->get();
                    
                     
            if(sizeof($exist)>0 && $exist[0]->nik != $ori->nik ){
                return CRUDBooster::redirectBack("Nik sudah terdaftar !");
            }
	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        $new = DB::table('warga_bjb')->where('id',$id)->first();
	        $pekerjaan = DB::table('umkm_pekerjaan')->where('id',$new->pekerjaan_id)->first();
	        $pddk = DB::table('umkm_pddk_akhir')->where('id',$new->pddk_akhir_id)->first();
	        
	        DB::table('warga_bjb')->where('id',$id)->update(['pekerjaan'=>$pekerjaan->pekerjaan,'pddk_akhir'=>$pddk->pddk_akhir]); 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }
	    
	    public function getDetail($id) {
	        $data = [];
	        $data['warga'] = DB::table('warga_bjb')
	                            ->join('districts','warga_bjb.nama_kec','districts.id')
	                            ->join('villages','warga_bjb.nama_kel','villages.id')
	                            ->select(DB::raw('warga_bjb.*,villages.name as kelurahan,districts.name as kecamatan'))
	                            ->where('warga_bjb.id',$id)
	                            ->first();
	                            
	        $data['pemilik'] = DB::table('umkm_pemilik')->where('warga_bjb_id',$id)->first();
	        $data['usaha'] = DB::table('umkm_usaha')->where('warga_bjb_id',$id)->get();
	        
	        $data['histpelatihan'] = DB::table('surat_reg_pelatihan')
                            ->join('pelatihan','pelatihan.id','surat_reg_pelatihan.pelatihan_id')
                            ->where('warga_bjb_id',$id)
                            ->where('status_id',5)
                            ->get();
                            
            $data['histbantuan'] = DB::table('surat_permohonan_bantuan')
                            ->join('bantuan','bantuan.id','surat_permohonan_bantuan.relasi_id')
                            ->where('warga_bjb_id',$id)
                            ->where('status_id',5)
                            ->get();
                            
                            
            return view('warga.profile', $data);
	    }



	    //By the way, you can still create your own method in here... :) 


	}