<?php namespace App\Http\Controllers;

	use Session;
	use Request;
	use DB;
	use CRUDBooster;
	

	class AdminWargaBjbHistoryController extends \crocodicstudio\crudbooster\controllers\CBController {

	    public function cbInit() {

			# START CONFIGURATION DO NOT REMOVE THIS LINE
			$this->title_field = "nama_lgkp";
			$this->limit = "20";
			$this->orderby = "nama_lgkp,asc";
			$this->global_privilege = false;
			$this->button_table_action = true;
			$this->button_bulk_action = false;
			$this->button_action_style = "button_dropdown";
			$this->button_add = false;
			$this->button_edit = true;
			$this->button_delete = false;
			$this->button_detail = true;
			$this->button_show = false;
			$this->button_filter = true;
			$this->button_import = false;
			$this->button_export = false;
			$this->table = "warga_bjb";
			# END CONFIGURATION DO NOT REMOVE THIS LINE

			# START COLUMNS DO NOT REMOVE THIS LINE
			$this->col = [];
			$this->col[] = ["label"=>"Nik","name"=>"nik"];
			$this->col[] = ["label"=>"Nama Lgkp","name"=>"nama_lgkp"];
			$this->col[] = ["label"=>"Jk","name"=>"jk"];
			$this->col[] = ["label"=>"Tmpt Lhr","name"=>"tmpt_lhr"];
			$this->col[] = ["label"=>"Tgl Lhr","name"=>"tgl_lhr"];
			$this->col[] = ["label"=>"Alamat","name"=>"alamat2"];
			$this->col[] = ["label"=>"RT","name"=>"rt"];
			$this->col[] = ["label"=>"RW","name"=>"rw"];
			$this->col[] = ["label"=>"Bantuan","name"=>"(select count(id) from history_bantuan where warga_bjb_id = warga_bjb.id) as sum_bantuan","callback_php"=>'$row->sum_bantuan'];
			if(CRUDBooster::myPrivilegeId()=="14"){
			    $this->col[] = ["label"=>"Pelatihan","name"=>"(select count(id) from history_pelatihan where warga_bjb_id = warga_bjb.id) as sum_pelatihan","callback_php"=>'$row->sum_pelatihan'];
			}
			$this->col[] = ["label"=>"Catatan","name"=>"(select count(id) from history_catatan where warga_bjb_id = warga_bjb.id) as sum_catatan","callback_php"=>'$row->sum_catatan'];
			$this->col[] = ["label"=>"Updated At","name"=>"updated_at"];
			$this->col[] = ["label"=>"Last Updated By","name"=>"updated_by","join"=>"cms_users,name"];
			# END COLUMNS DO NOT REMOVE THIS LINE

			# START FORM DO NOT REMOVE THIS LINE
			$this->form = [];
			$this->form[] = ['label'=>'Nik','name'=>'nik','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','readonly'=>'true'];
			$this->form[] = ['label'=>'Nama Lgkp','name'=>'nama_lgkp','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','readonly'=>'true'];
			//$this->form[] = ['label'=>'Jk','name'=>'jk','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','readonly'=>'true'];
			//$this->form[] = ['label'=>'Tempat Lahir','name'=>'tmpt_lhr','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','readonly'=>'true'];
			//$this->form[] = ['label'=>'Tanggal Lahir','name'=>'tgl_lhr','type'=>'date','validation'=>'required|date','width'=>'col-sm-4','readonly'=>'true'];
			$this->form[] = ['label'=>'Alamat','name'=>'alamat2','type'=>'textarea','validation'=>'required|string|min:5|max:5000','width'=>'col-sm-6','readonly'=>'true'];
// 			$this->form[] = ['label'=>'RT','name'=>'rt','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','readonly'=>'true'];
// 			$this->form[] = ['label'=>'RW','name'=>'rw','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-2','readonly'=>'true'];
// 			$this->form[] = ['label'=>'Nama Kel','name'=>'nama_kel','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','datatable'=>'villages,name','readonly'=>'true'];
// 			$this->form[] = ['label'=>'Nama Kec','name'=>'nama_kec','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','datatable'=>'districts,name','readonly'=>'true'];
// 			$this->form[] = ['label'=>'Nama Kab','name'=>'nama_kab','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','datatable'=>'regencies,name','readonly'=>'true'];
// 			$this->form[] = ['label'=>'Nama Prop','name'=>'nama_prop','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','datatable'=>'provinces,name','readonly'=>'true'];
			$this->form[] = ['label'=>'No KK','name'=>'no_kk','type'=>'text','validation'=>'required|min:1|max:255','width'=>'col-sm-4','readonly'=>'true'];
			$this->form[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myId()];
			$this->form[] = ['label'=>'Updated By Priv','name'=>'updated_by_priv','type'=>'hidden','validation'=>'required|integer|min:0','width'=>'col-sm-4','value'=>CRUDBooster::myPrivilegeId()];
			//if(CRUDBooster::getCurrentMethod()=="getEdit"){
    			$columns[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'date','validation'=>'required','required'=>true]; 
    			$columns[] = ['label'=>'Bantuan','name'=>'bantuan_id','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','required'=>true,'datatable'=>'bantuan,bantuan','datatable_where'=>'updated_by_priv='.CRUDBooster::myPrivilegeId()];
    		    $columns[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'textarea'];
    		    $columns[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','datatable'=>'cms_users,name','value'=>CRUDBooster::myId()];
    		    $columns[] = ['label'=>'Privilege','name'=>'updated_by_priv','type'=>'hidden','value'=>CRUDBooster::myPrivilegeId()];

    			$this->form[] = ['label'=>'History Bantuan','name'=>'history_bantuan','type'=>'child','columns'=>$columns,'width'=>'col-sm-6','table'=>'history_bantuan','parent'=>'warga_bjb','foreign_key'=>'warga_bjb_id'];
    			if(CRUDBooster::myPrivilegeId()=="14"){
        			$columns2[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'date','validation'=>'required','required'=>true]; 
        			$columns2[] = ['label'=>'Pelatihan','name'=>'pelatihan_id','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','required'=>true,'datatable'=>'pelatihan,nama_pelatihan','datatable_where'=>'updated_by_priv='.CRUDBooster::myPrivilegeId()];
        		    $columns2[] = ['label'=>'Keterangan','name'=>'keterangan','type'=>'textarea'];
        		    $columns2[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','value'=>CRUDBooster::myId()];
    		        $columns2[] = ['label'=>'Privilege','name'=>'updated_by_priv','type'=>'hidden','value'=>CRUDBooster::myPrivilegeId()];
        		    
        			$this->form[] = ['label'=>'History Pelatihan','name'=>'history_pelatihan','type'=>'child','columns'=>$columns2,'width'=>'col-sm-6','table'=>'history_pelatihan','parent'=>'warga_bjb','foreign_key'=>'warga_bjb_id'];
    			}

    		    $columns3[] = ['label'=>'Field','name'=>'add_field','type'=>'text','required'=>true];
    		    $columns3[] = ['label'=>'Value','name'=>'add_value','type'=>'text','required'=>true];
    		    $columns3[] = ['label'=>'Tanggal','name'=>'tanggal','type'=>'hidden'];
    		    $columns3[] = ['label'=>'Updated By','name'=>'updated_by','type'=>'hidden','datatable'=>'cms_users,name','value'=>CRUDBooster::myId(),'hidden'=>true];
    		    $columns3[] = ['label'=>'Privilege','name'=>'updated_by_priv','type'=>'hidden','value'=>CRUDBooster::myPrivilegeId()];
    		 
    			$this->form[] = ['label'=>'Catatan lainnya','name'=>'history_catatan','type'=>'child','columns'=>$columns3,'width'=>'col-sm-6','table'=>'history_catatan','parent'=>'warga_bjb','foreign_key'=>'warga_bjb_id'];
    			
    // 			$columns4[] = ['label'=>'Pelapor','name'=>'pelapor_id','type'=>'hidden','required'=>true,'value'=>CRUDBooster::myId()];
    // 		    $columns4[] = ['label'=>'Aduan','name'=>'laporkan_id','type'=>'select','validation'=>'required|min:1|max:255','width'=>'col-sm-4','required'=>true,'datatable'=>'pilihan,item_pilihan'];
    		  
    		 
    // 			$this->form[] = ['label'=>'Aduan','name'=>'history_laporkan','type'=>'child','columns'=>$columns4,'width'=>'col-sm-6','table'=>'history_laporkan','parent'=>'warga_bjb','foreign_key'=>'terlapor_id'];
			//}
			# END FORM DO NOT REMOVE THIS LINE

			# OLD START FORM
			//$this->form = [];
			//$this->form[] = ["label"=>"Nik","name"=>"nik","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Lgkp","name"=>"nama_lgkp","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Jk","name"=>"jk","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tmpt Lhr","name"=>"tmpt_lhr","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Tgl Lhr","name"=>"tgl_lhr","type"=>"date","required"=>TRUE,"validation"=>"required|date"];
			//$this->form[] = ["label"=>"Pddk Akhir","name"=>"pddk_akhir","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Pddk Akhir Id","name"=>"pddk_akhir_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pddk_akhir,id"];
			//$this->form[] = ["label"=>"Pekerjaan","name"=>"pekerjaan","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Pekerjaan Id","name"=>"pekerjaan_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"pekerjaan,id"];
			//$this->form[] = ["label"=>"Alamat","name"=>"alamat","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Alamat2","name"=>"alamat2","type"=>"textarea","required"=>TRUE,"validation"=>"required|string|min:5|max:5000"];
			//$this->form[] = ["label"=>"Rt","name"=>"rt","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Rw","name"=>"rw","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Kode Pos","name"=>"kode_pos","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Telp","name"=>"telp","type"=>"number","required"=>TRUE,"validation"=>"required|numeric","placeholder"=>"Anda hanya dapat memasukkan angka saja"];
			//$this->form[] = ["label"=>"Conv Id","name"=>"conv_id","type"=>"select2","required"=>TRUE,"validation"=>"required|integer|min:0","datatable"=>"conv,id"];
			//$this->form[] = ["label"=>"Nama Prop","name"=>"nama_prop","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Kab","name"=>"nama_kab","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Kec","name"=>"nama_kec","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Nama Kel","name"=>"nama_kel","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"No Kk","name"=>"no_kk","type"=>"text","required"=>TRUE,"validation"=>"required|min:1|max:255"];
			//$this->form[] = ["label"=>"Updated By","name"=>"updated_by","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			//$this->form[] = ["label"=>"Updated By Priv","name"=>"updated_by_priv","type"=>"number","required"=>TRUE,"validation"=>"required|integer|min:0"];
			# OLD END FORM

			/* 
	        | ---------------------------------------------------------------------- 
	        | Sub Module
	        | ----------------------------------------------------------------------     
			| @label          = Label of action 
			| @path           = Path of sub module
			| @foreign_key 	  = foreign key of sub table/module
			| @button_color   = Bootstrap Class (primary,success,warning,danger)
			| @button_icon    = Font Awesome Class  
			| @parent_columns = Sparate with comma, e.g : name,created_at
	        | 
	        */
	        $this->sub_module = array();


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Action Button / Menu
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @url         = Target URL, you can use field alias. e.g : [id], [name], [title], etc
	        | @icon        = Font awesome class icon. e.g : fa fa-bars
	        | @color 	   = Default is primary. (primary, warning, succecss, info)     
	        | @showIf 	   = If condition when action show. Use field alias. e.g : [id] == 1
	        | 
	        */
	        $this->addaction = array();
	        $this->addaction[] = ['label'=>'Hist','icon'=>'fa fa-address-card','color'=>'warning','url'=>CRUDBooster::mainpath('edit').'/[id]'];
	       // $this->addaction[] = ['label'=>'Import data bantuan','icon'=>'fa fa-address-card','color'=>'info','url'=>CRUDBooster::mainpath('import-bantuan').'/[id]'];


	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add More Button Selected
	        | ----------------------------------------------------------------------     
	        | @label       = Label of action 
	        | @icon 	   = Icon from fontawesome
	        | @name 	   = Name of button 
	        | Then about the action, you should code at actionButtonSelected method 
	        | 
	        */
	        $this->button_selected = array();

	                
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add alert message to this module at overheader
	        | ----------------------------------------------------------------------     
	        | @message = Text of message 
	        | @type    = warning,success,danger,info        
	        | 
	        */
	        $this->alert        = array();
	                

	        
	        /* 
	        | ---------------------------------------------------------------------- 
	        | Add more button to header button 
	        | ----------------------------------------------------------------------     
	        | @label = Name of button 
	        | @url   = URL Target
	        | @icon  = Icon from Awesome.
	        | 
	        */
	        $this->index_button = array();
	        //$this->index_button[] = ['label'=>'Import Data Bantuan XLSX','url'=>CRUDBooster::mainpath('import-bantuan'),"icon"=>"fa fa-import"];



	        /* 
	        | ---------------------------------------------------------------------- 
	        | Customize Table Row Color
	        | ----------------------------------------------------------------------     
	        | @condition = If condition. You may use field alias. E.g : [id] == 1
	        | @color = Default is none. You can use bootstrap success,info,warning,danger,primary.        
	        | 
	        */
	        $this->table_row_color = array();     	          

	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | You may use this bellow array to add statistic at dashboard 
	        | ---------------------------------------------------------------------- 
	        | @label, @count, @icon, @color 
	        |
	        */
	        $this->index_statistic = array();



	        /*
	        | ---------------------------------------------------------------------- 
	        | Add javascript at body 
	        | ---------------------------------------------------------------------- 
	        | javascript code in the variable 
	        | $this->script_js = "function() { ... }";
	        |
	        */
	        $this->script_js = NULL;


            /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code before index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it before index table
	        | $this->pre_index_html = "<p>test</p>";
	        |
	        */
	        $this->pre_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include HTML Code after index table 
	        | ---------------------------------------------------------------------- 
	        | html code to display it after index table
	        | $this->post_index_html = "<p>test</p>";
	        |
	        */
	        $this->post_index_html = null;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include Javascript File 
	        | ---------------------------------------------------------------------- 
	        | URL of your javascript each array 
	        | $this->load_js[] = asset("myfile.js");
	        |
	        */
	        $this->load_js = array();
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Add css style at body 
	        | ---------------------------------------------------------------------- 
	        | css code in the variable 
	        | $this->style_css = ".style{....}";
	        |
	        */
	        $this->style_css = NULL;
	        
	        
	        
	        /*
	        | ---------------------------------------------------------------------- 
	        | Include css File 
	        | ---------------------------------------------------------------------- 
	        | URL of your css each array 
	        | $this->load_css[] = asset("myfile.css");
	        |
	        */
	        $this->load_css = array();
	        
	        
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for button selected
	    | ---------------------------------------------------------------------- 
	    | @id_selected = the id selected
	    | @button_name = the name of button
	    |
	    */
	    public function actionButtonSelected($id_selected,$button_name) {
	        //Your code here
	            
	    }


	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate query of index result 
	    | ---------------------------------------------------------------------- 
	    | @query = current sql query 
	    |
	    */
	    public function getImportBantuan(){
	        $data=[];
            $this->cbView('import.xlsx',$data);
	    }
	    
	    
	    public function hook_query_index(&$query) {
	        //Your code here
	       if(CRUDBooster::myPrivilegeId()=="14"){
	            $query->whereExists(function ($query) {
                       $query->select(DB::raw(1))
                             ->from('umkm_pemilik')
                             ->whereRaw('warga_bjb.id = umkm_pemilik.warga_bjb_id');
                    })->orWhere('updated_by_priv',CRUDBooster::myPrivilegeId());
	        }  
	        if(CRUDBooster::myPrivilegeId()=="5"){
	            $query->where('nama_kel',CRUDBooster::me()->village_id);
	        } 
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate row of index table html 
	    | ---------------------------------------------------------------------- 
	    |
	    */    
	    public function hook_row_index($column_index,&$column_value) {	        
	    	//Your code here
	    }

	    /*
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before add data is execute
	    | ---------------------------------------------------------------------- 
	    | @arr
	    |
	    */
	    public function hook_before_add(&$postdata) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after add public static function called 
	    | ---------------------------------------------------------------------- 
	    | @id = last insert id
	    | 
	    */
	    public function hook_after_add($id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for manipulate data input before update data is execute
	    | ---------------------------------------------------------------------- 
	    | @postdata = input post data 
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_edit(&$postdata,$id) {        
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after edit public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_edit($id) {
	        //Your code here 

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command before delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_before_delete($id) {
	        //Your code here

	    }

	    /* 
	    | ---------------------------------------------------------------------- 
	    | Hook for execute command after delete public static function called
	    | ----------------------------------------------------------------------     
	    | @id       = current id 
	    | 
	    */
	    public function hook_after_delete($id) {
	        //Your code here

	    }



	    //By the way, you can still create your own method in here... :) 


	}