<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiAddTransaksiController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "transaksi";        
				$this->permalink   = "add_transaksi";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        if($result['api_status']==1){
		            $transaksi = DB::table('transaksi')->where('id',$result['id'])->first();
		            $items = json_decode($transaksi->list_item_json);
		            
		            foreach($items as $item){
		                //$result['items'] = $transaksi->id . "," .$item->produk_id. "," . $item->qty . "," . $item->catatan ;
		                $produk = DB::table('produk')->join('umkm_usaha','umkm_usaha.id','produk.umkm_usaha_id')->where('produk.id',$item->produk_id)->first();
		                $owner = CRUDBooster::wargaToCms($produk->warga_bjb_id);
		                
		                DB::table('transaksi_item')->insert(['transaksi_id'=>$result['id'],'produk_id'=>$item->produk_id,'owner_id'=>$owner->id,'qty'=>$item->qty,'catatan'=>$item->catatan,'created_at'=>now()]);
		                DB::table('keranjang')->where('cms_users_id',$transaksi->pembeli_id)->where('produk_id',$item->produk_id)->where('status','new')->update(['transaksi_id'=>$result['id'],'status'=>'menunggu respon penjual']);
		                $selprod = $item->produk_id;
		            }
		            
		            $produk = DB::table('produk')->where('id',$selprod)->first();
		            if($produk->lokasi_id){
		                $lokasi = DB::table('lokasi')->where('id',$produk->lokasi_id)->first();
		                DB::table('transaksi')->where('id',$result['id'])->update(['penjual_lat'=>$lokasi->lat,'penjual_lon'=>$lokasi->lon,'jarak'=>$postdata['jarak'],'ongkir'=>$postdata['ongkir']]);
		            }else{
		                $lokasi = DB::table('umkm_usaha')->where('id',$produk->umkm_usaha_id)->first();
		                DB::table('transaksi')->where('id',$result['id'])->update(['penjual_lat'=>$lokasi->lat,'penjual_lon'=>$lokasi->lon,'jarak'=>$postdata['jarak'],'ongkir'=>$postdata['ongkir']]);
		            }
		            
		            
		        }
		    }

		}