<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiAmbilBeritaController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "informasi";        
				$this->permalink   = "ambil_berita";    
				$this->method_type = "get"; 
				$this->user_grup = array();
				$this->myId = "";
				$this->administ = array(1,3,4,5,6,7,8);
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
		         $this->myId = $postdata["user_id"];
		         $request_by = DB::Table('cms_users')
				                  ->where('id',$postdata["user_id"])
				                  ->select('id','name','display_name','photo','id_cms_privileges','district_id','village_id','rt','rw','icon')
				                  ->first();
				 
				 $administ = DB::Table('cms_users')
				                  ->where('district_id',$request_by->district_id)
				                  ->where('village_id',$request_by->village_id)
				                  ->whereIn('id_cms_privileges', $this->administ)
				                  ->orWhere('id_cms_privileges', 1)
				                  //->orWhere('id_cms_privileges', 12)
				                  ->select('id')
				                  ->get();
				                  
				foreach($administ as $admin){
                    array_push($this->user_grup,$admin->id);
                }
				
			     $kenalan = DB::Table('kenalan')
			                  ->where('user_id',$this->myId)
			                  ->select('target_id')
			                  ->get();
			                  
			    foreach($kenalan as $kenal){
                    array_push($this->user_grup,$kenal->target_id);
                }	
                
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
		        $query->whereIn('created_by', $this->user_grup)
		                ->orderBy('created_at','asc');
		              
		             // ->where('created_by', '<>',  $this->myId);
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
		        $result['sekitar'] =  $this->user_grup;
                foreach($result['data'] as $data){
				    $date=date_create($data->created_at);
				    $data->created_at = date_format($date,"d M Y H:i:s");
				    // if($data->user_id==$postdata['req_by']){
				    //     $data->nama = 'Saya';
				    //     $data->nama_tampilan = 'Saya';
				    // }
				   
				    $created_by = DB::Table('cms_users')
				                  ->where('id',$data->created_by)
				                  ->select('id','name','display_name','photo','id_cms_privileges','district_id','village_id','rt','rw','icon')
				                  ->first();
				    
				    $data->created_by = $created_by;
				    
				    $bagambar = DB::Table('media')->where('id_ortu',$data->id)->where('parent',$this->table)->get();
					if($bagambar){
						$gambarnya = array();
						foreach($bagambar as $gambar){
							array_push($gambarnya, $gambar);
						}
						$data->gambar = $gambarnya;							
					}
			    
					$penyuka = DB::Table('reaksi')
						            ->join('cms_users','cms_users.id','reaksi.user_id')
						            ->join('master_reaksi','master_reaksi.id','reaksi.master_reaksi_id')
						            ->where('reaksi.key_id',$data->id)
						            ->where('reaksi.master_reaksi_id','1')
						            ->select('reaksi.user_id','cms_users.nik','cms_users.name','cms_users.display_name','cms_users.photo','cms_users.icon')
						            ->get();
						            
					if($penyuka){
						$penyukanya = array();
						foreach($penyuka as $suka){
							array_push($penyukanya, $suka);
						}
						$data->penyuka = $penyukanya;
						$data->jpenyuka = sizeof($penyuka);
					}else{
					    $data->penyuka = null;
					    $data->jpenyuka = 0;
					}
					
					$ilike = DB::Table('reaksi')
					            ->where('key_id',$data->id)
					            ->where('master_reaksi_id','1')
					            ->where('nama_table',$this->table)
					            ->where('user_id',$postdata['user_id'])
					            ->first();
					 
					            
					if($ilike){
					    $data->ilike = $ilike->id;
					}else{
					    $data->ilike = 0;						
					}
					
					$lastkomen = DB::table('komentar')
						            ->leftJoin('cms_users','cms_users.id', 'komentar.user_id')
					               	->where('komentar.nama_table',$this->table)
						            ->where('komentar.key_id',$data->id)
						            ->select('komentar.*','cms_users.name as nama','cms_users.display_name as nama_tampilan','cms_users.photo','cms_users.email','cms_users.icon')
						            ->orderBy('komentar.id','DESC')
						            ->limit(3)
                                    ->get();
                                    
                    foreach($lastkomen as $lkomen){
                        if($lkomen->photo){
						    $lkomen->photo = 'https://siapkk.banjarbarukota.go.id/'.$lkomen->photo;
                        }
                        if($lkomen->gambar){
						    $lkomen->gambar = 'https://siapkk.banjarbarukota.go.id/'.$lkomen->gambar;
                        }
                        if($lkomen->icon){
						    $lkomen->icon = 'https://siapkk.banjarbarukota.go.id/'.$lkomen->icon;
                        }
					}
                    
                    $data->lastkomen = $lastkomen;
                    
                    $jkomen = DB::table('komentar')
					               	->where('komentar.nama_table',$this->table)
						            ->where('komentar.key_id',$data->id)
                                    ->count();
                    
                    $data->jkomen = $jkomen;
                    
                    $data->nama_table =$this->table;
					
					$data->user_grup =$this->user_grup;
				}
				
				$result['count'] = sizeof($result['data']);
		    }

		}