<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiAmbilNotifController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "cms_notifications";        
				$this->permalink   = "ambil_notif";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
				 $nik = $postdata['nik'];
				 $eksis = [];
				 
				 if($postdata['status']=='baru'){
					 $ada = DB::Table('cms_notifications')
							->where('nik',$nik)
							->get();
					$eksis = [];
					foreach($ada as $data){
						array_push($eksis,$data->master_notif_id);
					}
					
					$new = DB::Table('master_notif')
							->whereNotIn('id',$eksis)
							->where('to_all',1)
							->get();
					
					if(sizeof($new)>0){					
						foreach($new as $notif){
							DB::Table('cms_notifications')->insert(
								['nik'=>$postdata['nik'],
								 'id_cms_users' => CRUDBooster::nikToId($postdata['nik'])->id,
								 'master_notif_id' => $notif->id,
								 'content'=> $notif->content,
								 'nama_table'=> $notif->nama_table,
								 'url' => $notif->url,
								 'style' => $notif->style,
								 'gambar' => $notif->gambar,
								 'is_read' => 1,
								 'status' => 'baru',
								 'created_at' => now()
								]);
						}
					}
					
					$new = DB::Table('master_notif')
						->whereNotIn('id',$eksis)
						->where('target_privs','like','%'.$postdata['priv'].'%')
						->get();
						
					if(sizeof($new)>0){					
						foreach($new as $notif){
							DB::Table('cms_notifications')->insert(
								['nik'=>$postdata['nik'],
								 'id_cms_users' => CRUDBooster::nikToId($postdata['nik'])->id,
								 'master_notif_id' => $notif->id,
								 'content'=> $notif->content,
								 'nama_table'=> $notif->nama_table,
								 'url' => $notif->url,
								 'style' => $notif->style,
								 'gambar' => $notif->gambar,
								 'is_read' => 1,
								 'status' => 'baru',
								 'created_at' => now()
								]);
						}
					}
					
					$new = DB::Table('master_notif')
							->whereNotIn('id',$eksis)
							->where('target_tags','like','%'.$postdata['nik'].'%')
							->get();
							
					if(sizeof($new)>0){					
						foreach($new as $notif){
							DB::Table('cms_notifications')->insert(
								['nik'=>$postdata['nik'],
								 'id_cms_users' => CRUDBooster::nikToId($postdata['nik'])->id,
								 'master_notif_id' => $notif->id,
								 'content'=> $notif->content,
								 'nama_table'=> $notif->nama_table,
								 'url' => $notif->url,
								 'style' => $notif->style,
								 'gambar' => $notif->gambar,
								 'is_read' => 1,
								 'status' => 'baru',
								 'created_at' => now()
								]);
						}
					}

				 }
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
				$result['data'] = $result['data'];
				
				foreach($result['data'] as $data){
					DB::Table('cms_notifications')
						->where('id',$data->id)
						->update(['status' => 'terima']);
						
				}
		    }

		}