<?php namespace App\Http\Controllers;
        header("Access-Control-Allow-Origin: *");

		use Session;
		use Request;
		use DB;
		use CRUDBooster;
		use DateTime;

		class ApiBahandapController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "bahandap";        
				$this->permalink   = "bahandap";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
		        $query->where('updated_by','<>',119);
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                if($result['api_status']==1){
                    $exp_date = new DateTime($result['expired_at']);
                    $from_date = Now();
                    //$result['exp'] = $exp_date;
                    // $result['skg'] = $from_date;
                    if($result['hit_limit']>0){
                        $est = $from_date->diff($exp_date); 
                        $result['expin'] = $est->h . ' jam ' . $est->i . ' menit ' . $est->s . ' detik';
                        if($est->invert == 1){
                            $result['api_status'] = 0;
                            $result['api_message'] ="Link ini sudah kadaluwarsa";
                        }elseif($result['hit']>=$result['hit_limit']){
                            $result['api_status'] = 0;
                            $result['api_message'] ="Link ini sudah kadaluwarsa";
                        }else{
                            $result['api_status'] = 1;
                        }
                    }
                
                    DB::Table('bahandap')->where('id',$result['id'])->update(['hit' => $result['hit']+1]);
                }
		    }

		}