<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiCariLokasiController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "lokasi";        
				$this->permalink   = "cari_lokasi";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
					//$postdata['kata'] = "%" . $postdata['kata'] . "%";
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
				//$query->where('tags','like',)

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
				
				
				if($postdata['kata']){
    				$result['data'] = DB::Table($this->table)
    					->join('districts','districts.id','lokasi.district_id')
    					->join('villages','villages.id','lokasi.village_id')
    					->leftJoin('kategori_lokasi','kategori_lokasi.id','lokasi.default_icon')
    					->select('lokasi.*','districts.name as kecamatan', 'villages.name as kelurahan','kategori_lokasi.icon as default_icon_path',DB::raw('111.111 *
                            DEGREES(ACOS(LEAST(1.0, COS(RADIANS(lokasi.lat))
                                 * COS(RADIANS('.$postdata['user_lat'].'))
                                 * COS(RADIANS(lokasi.lon - '.$postdata['user_lon'].'))
                                 + SIN(RADIANS(lokasi.lat))
                                 * SIN(RADIANS('.$postdata['user_lat'].'))))) AS jarak_km'))
    					->where('lokasi.verified',$postdata['verified'])
    					->where('lokasi.tags','like','%'. $postdata['kata'] .'%')
    					->orWhere('lokasi.nama','like','%'. $postdata['kata'] .'%')
    					->orWhere('lokasi.jalan','like','%'. $postdata['kata'] .'%')
    					->get();
				}
				
				if($postdata['id']){
    				$result['data'] = DB::Table($this->table)
    					->join('districts','districts.id','lokasi.district_id')
    					->join('villages','villages.id','lokasi.village_id')
    					->leftJoin('kategori_lokasi','kategori_lokasi.id','lokasi.default_icon')
    					->select('lokasi.*','districts.name as kecamatan','villages.name as kelurahan','kategori_lokasi.icon as default_icon_path')
    					->where('lokasi.id', $postdata['id'])
    					->get();
				}
					
				foreach($result['data'] as $data){
						
						$bagambar = DB::Table('media')->where('id_ortu',$data->id)->where('parent',$this->table)->get();
						if($bagambar){
							$gambarnya = array();
							foreach($bagambar as $gambar){
								array_push($gambarnya, $gambar);
							}
							$data->gambar = $gambarnya;							
						}
						
						$gambarkomen = DB::Table('komentar')->where('nama_table','lokasi')->where('key_id',$data->id)->where('gambar','<>','NULL')->get();
						if($gambarkomen){
							$gambarkomennya = array();
							foreach($gambarkomen as $gambar){
								array_push($gambarkomennya, $gambar);
							}
							$data->gambarkomen = $gambarkomennya;							
						}
						
						$penyuka = DB::Table('reaksi')
						            ->join('cms_users','cms_users.id','reaksi.user_id')
						            ->join('master_reaksi','master_reaksi.id','reaksi.master_reaksi_id')
						            ->where('reaksi.nama_table','lokasi')
						            ->where('reaksi.key_id',$data->id)
						            ->where('reaksi.master_reaksi_id','1')
						            ->select('reaksi.user_id','cms_users.nik','cms_users.name','cms_users.display_name','cms_users.photo','cms_users.icon')
						            ->get();
						            
						if($penyuka){
							$penyukanya = array();
							foreach($penyuka as $suka){
								array_push($penyukanya, $suka);
							}
							$data->penyuka = $penyukanya;
							$data->jpenyuka = sizeof($penyuka);
						}else{
						    $data->penyuka = null;
						    $data->jpenyuka = 0;
						}
						
						$ilike = DB::Table('reaksi')
						            ->where('nama_table','lokasi')
						            ->where('key_id',$data->id)
						            ->where('master_reaksi_id','1')
						            ->where('user_id',$postdata['user_id'])
						            ->first();
						            
						if($ilike){
						    $data->ilike = $ilike->id;
						}else{
						    $data->ilike = 0;						
						}
						
						$lastkomen = DB::table('komentar')
						            ->leftJoin('cms_users','cms_users.id', 'komentar.user_id')
					               	->where('komentar.nama_table','lokasi')
						            ->where('komentar.key_id',$data->id)
						            ->select('komentar.*','cms_users.name as nama','cms_users.display_name as nama_tampilan','cms_users.photo','cms_users.email','cms_users.icon')
						            ->orderBy('komentar.id','DESC')
						            ->limit(5)
                                    ->get();
                                    
                        foreach($lastkomen as $lkomen){
                            if($lkomen->photo){
							    $lkomen->photo = 'https://siapkk.banjarbarukota.go.id/'.$lkomen->photo;
                            }
                            if($lkomen->gambar){
							    $lkomen->gambar = 'https://siapkk.banjarbarukota.go.id/'.$lkomen->gambar;
                            }
                            if($lkomen->icon){
							    $lkomen->icon = 'https://siapkk.banjarbarukota.go.id/'.$lkomen->icon;
                            }
                            $ilike = DB::Table('reaksi')
						            ->where('nama_table','komentar')
						            ->where('key_id',$lkomen->id)
						            ->where('master_reaksi_id','1')
						            ->where('user_id',$postdata['user_id'])
						            ->first();
						            
    						if($ilike){
    						    $lkomen->ilike = $ilike->id;
    						}else{
    						    $lkomen->ilike = 0;						
    						}
                                
						}
                        
                        $data->lastkomen = $lastkomen;
						
				}
				
		    }

		}