<?php namespace App\Http\Controllers;
        header('Access-Control-Allow-Headers: x-authorization-time,x-authorization-token');
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Allow-Origin: https://databaseumkm.banjarbarukota.go.id');

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiCekUmkmController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "apps";        
				$this->permalink   = "cek_umkm";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                if($result['api_status']==1){
                    if($postdata['nik']){
                        $warga = DB::table('warga_bjb')->where('nik',$postdata['nik'])->first();
                        if($warga){
                            $data = [];
                            $data['cari_status'] = 1;
                            $data['cari_message'] = 'success';
                            $data['nama_lgkp'] = $warga->nama_lgkp;
                            $pemilik = DB::table('umkm_pemilik')->where('warga_bjb_id',$warga->id)->first();
                            $data['no_iumk'] = $pemilik->no_iumk;
                            $data['nib_sku'] = $pemilik->nib_sku;
                            $data['no_npwp'] = $pemilik->no_npwp;
                            $usaha = DB::table('umkm_usaha')->where('warga_bjb_id',$warga->id)->select('nama_usaha','bidang_usaha','sub_bidang_usaha')->get();
                            $data['usaha'] = $usaha;
                        }else{
                            $data = [];
                            $data['cari_status'] = 0;
                            $data['cari_message'] = 'nik tidak ditemukan';
                        }
                        
                        $result['umkm']=$data;
                    }
                }
		    }

		}