<?php namespace App\Http\Controllers;
header("Access-Control-Allow-Origin: *");
		use Session;
		use Request;
		use DB;
		use CRUDBooster;
		use DateTime;

		class ApiDataCovidByGpsController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "covid19";        
				$this->permalink   = "data_covid_by_gps";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
		        //$query->where('covid19.warga_bjb_id','warga_bjb.id');

		    }

		    public function hook_after($postdata,&$result) {
		        if($postdata['kunci']){
		            $bahandap = DB::table('bahandap')->where('kunci',$postdata['kunci'])->first();
		            
		            if($bahandap){
		                $exp_date = new DateTime($bahandap->expired_at);
                        $from_date = Now();
                        $est = $from_date->diff($exp_date);
                        $result['hit'] = $bahandap->hit;
                        if($est->invert==0){
                            if($bahandap->hit >= $bahandap->hit_limit+1){
                                $result = [];
    		                    $result['api_status'] = 0;
                            }else{
                                foreach($result['data'] as $data){
                                    $warga = DB::table('warga_bjb')
                                            ->join('villages','warga_bjb.nama_kel','villages.id')
                                            ->join('districts','warga_bjb.nama_kec','districts.id')
                                            ->where('warga_bjb.id',$data->warga_bjb_id)
                                            ->selectRaw('warga_bjb.*, villages.name as kelurahan , districts.name as kecamatan')
                                            ->first();
                                    $today = new DateTime();
                                    $birthdate = new DateTime($warga->tgl_lhr);
                                    $interval = $today->diff($birthdate);
                                    $data->umur = $interval->format('%y tahun');
                                    $data->alamat = $warga->alamat2;
                                    $data->rt = $warga->rt;
                                    $data->rw = $warga->rw;
                                    $data->kecamatan = $warga->kecamatan;
                                    $data->kelurahan = $warga->kelurahan;
                                    
                                    $history = DB::table('covid19_history')
                                                ->join('covid19_status','covid19_history.covid19_status_id','covid19_status.id')
                                                ->where('covid19_id',$data->id)
                                                ->selectRaw('covid19_history.* , covid19_status.status, covid19_status.icon')
                                                ->orderBy('tanggal', 'DESC');
                                    
                                    $data->history = $history->get();
                                                
                                    $last_hist = $history->limit(1)->first();
                                    
                                    $data->last_status_id = $last_hist->covid19_status_id;
                                    $data->last_status = $last_hist->status;
                                    $data->last_status_icon = $last_hist->icon;
                                                
                                    DB::Table('bahandap')->where('id',$bahandap->id)->update(['hit' => $bahandap->hit+1]);
                                }
                            }
                        }else{
                             $result = [];
		                     $result['api_status'] = 0;
                        }
		            }else{
		                $result = [];
		                $result['api_status'] = 0;
		            }
		        }else{
		            $result = [];
		            $result['api_status'] = 0;
		        }
		    }

		}