<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiDetailHomecareController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "homecare";        
				$this->permalink   = "detail_homecare";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
                $query->orderBy('id','decs');
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                if($result['api_status']==1){
                    $pengirim = DB::table('cms_users')
		                        ->where('no_telp',$this->extNoTelp($result['created_by']))
		                        ->selectRaw('id,name,display_name,photo,no_telp')
		                        ->first();
		            $result['created_by'] = $pengirim;
                    $result['handler'] = DB::table('homecare_handle')
            		                            ->join('satuan_kerja','satuan_kerja.id','homecare_handle.dinas_id')
            		                            ->where('homecare_handle.homecare_id',$postdata['id'])
            		                            ->select('homecare_handle.*','satuan_kerja.satuan_kerja')
            		                            ->get();
            		
            		$result['komentar'] = DB::table('komentar')
            		                            ->where('key_id',$postdata['id'])
            		                            ->where('nama_table','homecare')
            		                            ->orderBy('id','desc')
            		                            ->limit(3)
            		                            ->get();
            		if($result['status']=='open'){                            
            		    DB::table('homecare')->where('id',$postdata['id'])->update(['status'=>'diterima']);
            		}
                }
		    }
		    
		    public function extNoTelp($chat_id){
                $notelp = preg_split("/@/", $chat_id);
			    $notelp = substr_replace($notelp[0],"0",0,2);
			    
			    return $notelp;
            }

		}