<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiDompetFlowController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "dompet_flow";        
				$this->permalink   = "dompet_flow";    
				$this->method_type = "post";    
		    }
		

		    public function hook_before(&$postdata) {
		        $cekssource = DB::table('dompet')
		                        ->where('dompetid',$postdata['source_dompet'])
		                        ->first();
		                        
		        if($cekssource){
		            $blokir = DB::table('dompet_error')->where('source_dompet',$postdata['source_dompet'])->where('kode',4)->count();
		            if($blokir>=3){
		               $resp = response()->json(['api_status'=>505,'api_message'=>'Dompet ada telah terblokir, harap hubungi admin !']);
                        $resp->send();
                        exit; 
		            }
    		        if($cekssource->pin == $postdata['pin']){
    		            $cekdest = DB::table('dompet')
		                        ->where('dompetid',$postdata['dest_dompet'])
		                        ->first();
		                if($cekdest){
		                    $cek_saldo = DB::table('dompet')
	                                              ->where('dompetid',$postdata['source_dompet'])
	                                              ->first();
		                    if($cek_saldo->saldo - $postdata['jumlah'] >= 0){
    		                    $update_saldo_dest = DB::table('dompet')
    		                                              ->where('dompetid',$postdata['dest_dompet'])
    		                                              ->update(['saldo' => DB::raw('saldo + ' . $postdata['jumlah'])]);
    		                    if($update_saldo_dest){
    		                        $update_saldo_source = DB::table('dompet')
    		                                              ->where('dompetid',$postdata['source_dompet'])
    		                                              ->update(['saldo' => DB::raw('saldo - ' . $postdata['jumlah'])]);
    		                        if($update_saldo_source){
    		                            unset($postdata['pin']);
    		                        }else{
    		                            DB::table('dompet_error')->insert(['kode'=>404,'dest_dompet'=>$postdata['dest_dompet'],'source_dompet'=>$postdata['source_dompet'],'log'=>'Dompet asal gagal terpotong, saldo dikembalikan !']);
    		                            DB::table('dompet')
	                                              ->where('dompetid',$postdata['dest_dompet'])
	                                              ->update(['saldo' => DB::raw('saldo - ' . $postdata['jumlah'])]);
	                                    $resp = response()->json(['api_status'=>-1,'api_message'=>'Dompet asal gagal terpotong, saldo dikembalikan !']);
                                       $resp->send();
                                       exit; 
    		                        }
    		                    }else{
    		                       DB::table('dompet_error')->insert(['kode'=>11,'dest_dompet'=>$postdata['dest_dompet'],'source_dompet'=>$postdata['source_dompet'],'log'=>'Update saldo gagal !']);
    		                       $resp = response()->json(['api_status'=>11,'api_message'=>'Update saldo gagal !']);
                                   $resp->send();
                                   exit; 
    		                    }
		                    }else{
		                        DB::table('dompet_error')->insert(['kode'=>12,'dest_dompet'=>$postdata['dest_dompet'],'source_dompet'=>$postdata['source_dompet'],'log'=>'Saldo tidak mencukupi !']);
		                        $resp = response()->json(['api_status'=>12,'api_message'=>'Saldo tidak mencukupi !']);
                                $resp->send();
                                exit; 
		                    }
		                }else{
		                    DB::table('dompet_error')->insert(['kode'=>13,'dest_dompet'=>$postdata['dest_dompet'],'source_dompet'=>$postdata['source_dompet'],'log'=>'Dompet Tujuan Tidak Ditemukan !']);
		                    $resp = response()->json(['api_status'=>13,'api_message'=>'Dompet Tujuan Tidak Ditemukan !']);
                            $resp->send();
                            exit;
		                }
    		            
    		        }else{
    		            DB::table('dompet_error')->insert(['kode'=>4,'dest_dompet'=>$postdata['dest_dompet'],'source_dompet'=>$postdata['source_dompet'],'log'=>'PIN SALAH !']);
    		            $resp = response()->json(['api_status'=>4,'api_message'=>'PIN SALAH !']);
                        $resp->send();
                        exit;
    		        }
		        }else{
		            DB::table('dompet_error')->insert(['kode'=>6,'dest_dompet'=>$postdata['dest_dompet'],'source_dompet'=>$postdata['source_dompet'],'log'=>'Dompet tidak ditemukan !']);
		            $resp = response()->json(['api_status'=>6,'api_message'=>'Dompet tidak ditemukan !']);
                    $resp->send();
                    exit;
		        }
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process

		    }

		}