<?php namespace App\Http\Controllers;
        header("Access-Control-Allow-Origin: *");

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiGetAnggotaByDewanController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "dewan_dprd";        
				$this->permalink   = "get_anggota_by_dewan";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		      //  $query->join('dprd','dprd.id','dewan_dprd.dprd_id')
		      //        ->join('dewan','dewan.id','dewan_dprd.dewan_id')
		      //        ->join('tier','tier.id','dewan_dprd.tier_id');
		      $query->orderBy('dewan_dprd.tier_id','asc');

		    }

		    public function hook_after($postdata,&$result) {
                if($result['api_status']==1){
                    foreach($result['data'] as $data){
                        $dprd = DB::table('dprd')->where('id',$data->dprd_id)->first();
                        $data->profil = $dprd;
                        $warga = DB::table('warga_bjb')->where('id',$dprd->warga_bjb_id)->first();
                        $data->warga = $warga;
                        $cms_users = DB::table('cms_users')->where('nik',$warga->nik)->first();
                        $data->hashtag = explode(' ',$cms_users->hashtag);
                        $partai = DB::table('partai_politik')->where('id',$dprd->partai_politik_id)->first();
                        $data->partai = $partai;
                        $fraksi = DB::table('partai_politik')->where('fraksi_id',$partai->fraksi_id)->get();
                        $data->fraksi = $fraksi;
                        $dewan = DB::table('dewan')->where('id',$data->dewan_id)->first();
                        $data->dewan = $dewan;
                        $tier = DB::table('tier')->where('id',$data->tier_id)->first();
                        $data->tier = $tier;
                        $dapil = DB::table('dapil')->where('id',$dprd->dapil_id)->first();
                        $data->dapil = $dapil;
                    }
                }
		    }

		}