<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiGetHomecareController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "homecare";        
				$this->permalink   = "get_homecare";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
                if($postdata['nik']){
                    $dinas=DB::table('cms_users')->join('multi_privs','cms_users.id','multi_privs.cms_users_id')->where('cms_users.nik',$postdata['nik'])->where('multi_privs.cms_privileges_id','27')->select('cms_users.*')->first();
                    if(!$dinas){
                        $resp = response()->json(['api_status'=>0,'api_message'=>'tidak terdaftar !','api_authorization'=> 'You are in debug mode !', 'data'=>'']);
                        $resp->send();
                        exit;
                    }else{
                        $data=DB::table('homecare')
                                ->join('homecare_handle','homecare_handle.homecare_id','homecare.id')
                                ->where('homecare_handle.dinas_id',$dinas->dinas_id)
                                ->select('homecare.*')
                                ->get();
                        if($postdata['status']){
                            $data=DB::table('homecare')
                                    ->join('homecare_handle','homecare_handle.homecare_id','homecare.id')
                                    ->where('homecare_handle.dinas_id',$dinas->dinas_id)
                                    ->where('homecare.status',$postdata['status'])
                                    ->select('homecare.*')
                                    ->get();
                        }
                        if(sizeof($data)>0){
                            foreach($data as $rd){
                                $pengirim = DB::table('cms_users')
		                        ->where('no_telp',$this->extNoTelp($rd->created_by))
		                        ->selectRaw('id,name,display_name,photo,no_telp,dinas_id')
		                        ->first();
            	               $rd->pengirim = $pengirim;
            	               if($pengirim != null){
            	                   $rd->created_by = $pengirim->name;
            	               }
            		            $rd->handler = DB::table('homecare_handle')
            		                            ->join('satuan_kerja','satuan_kerja.id','homecare_handle.dinas_id')
            		                            ->where('homecare_handle.homecare_id',$rd->id)
            		                            ->select('homecare_handle.*','satuan_kerja.satuan_kerja')
            		                            ->get();
            		                            
            		            $rd->photos = DB::table('homecare_media')
            		                            ->where('homecare_media.homecare_id',$rd->id)
            		                            ->get();
            		        }
                            $resp = response()->json(['api_status'=>1,'api_message'=>'sukses','api_authorization'=> 'You are in debug mode !', 'data'=>$data]);
                            $resp->send();
                            exit;
                        }else{
                            $resp = response()->json(['api_status'=>0,'api_message'=>'tidak ada data !', 'api_authorization'=> 'You are in debug mode !','data'=>array()]);
                            $resp->send();
                            exit;
                        }
                    }
                }
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql quer
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
		        foreach($result['data'] as $rd){
		            $pengirim = DB::table('cms_users')
		                        ->where('no_telp',$this->extNoTelp($rd->created_by))
		                        ->selectRaw('id,name,display_name,photo,no_telp,dinas_id')
		                        ->first();
	               $rd->pengirim = $pengirim;
	               if($pengirim != null){
	                   $rd->created_by = $pengirim->name;
	               }
		            $rd->handler = DB::table('homecare_handle')
		                            ->join('satuan_kerja','satuan_kerja.id','homecare_handle.dinas_id')
		                            ->where('homecare_handle.homecare_id',$rd->id)
		                            ->select('homecare_handle.*','satuan_kerja.satuan_kerja')
		                            ->get();
		                            
		            $rd->photos = DB::table('homecare_media')
    		                            ->where('homecare_media.homecare_id',$rd->id)
    		                            ->get();
		        }
		    }
		    
		    public function extNoTelp($chat_id){
                $notelp = preg_split("/@/", $chat_id);
			    $notelp = substr_replace($notelp[0],"0",0,2);
			    
			    return $notelp;
            }

		}