<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiGetTipeDokumenController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "tipe_dokumen";        
				$this->permalink   = "get_tipe_dokumen";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
                
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
                $query->where('parent_id','<>',0);
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                foreach($result['data'] as $data){
                    $data->total = DB::table('peraturan')->where('jenis_id',$data->id)->count();
                }
                $result['tahun']=DB::table('peraturan')->select('tahun', DB::raw('count(*) as total'))->where('tahun','<>','null')->groupBy('tahun')->orderBy('tahun','desc')->get();
                $result['status']=DB::table('peraturan')->select('status', DB::raw('count(*) as total'))->where('status','<>','null')->groupBy('status')->orderBy('status','desc')->get();
                $result['subjek']=DB::table('subjek')->get();
                foreach($result['subjek'] as $subjek){
                    $subjek->total = DB::table('peraturan_subjek')->where('id_subjek',$subjek->id)->count();
                }
                $result['lokasi']=DB::table('lokasi_dokumen')->get();
                foreach($result['lokasi'] as $lokasi){
                    $lokasi->total = DB::table('peraturan')->where('lokasi_id',$lokasi->id)->count();
                }
                $result['jenis']=DB::table('tipe_dokumen')->where('parent_id',0)->get();
                foreach($result['jenis'] as $jenis){
                    $jenis->total = DB::table('peraturan')->join('tipe_dokumen','tipe_dokumen.id','peraturan.jenis_id')->where('tipe_dokumen.parent_id',$jenis->id)->count();
                }
		    }

		}