<?php namespace App\Http\Controllers;
        
        header('Access-Control-Allow-Origin: *');
        
		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiGetUsahaController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "cms_users";        
				$this->permalink   = "get_usaha";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        $query = DB::Table('umkm_usaha')
		                ->leftJoin('provinces','provinces.id','umkm_usaha.province_id')
		                ->leftJoin('regencies','regencies.id','umkm_usaha.regency_id')
    					->leftJoin('districts','districts.id','umkm_usaha.district_id')
    					->leftJoin('villages','villages.id','umkm_usaha.village_id');
    					//->join('warga_bjb','warga_bjb.id','umkm_usaha.warga_bjb_id')
    		    if($postdata['user_lat']){
                    $query->select('umkm_usaha.*', 'provinces.name as provinsi', 'regencies.name as kabupaten','districts.name as kecamatan', 'villages.name as kelurahan',DB::raw('ROUND(111.111 *
                            DEGREES(ACOS(LEAST(1.0, COS(RADIANS(umkm_usaha.lat))
                                 * COS(RADIANS('.$postdata['user_lat'].'))
                                 * COS(RADIANS(umkm_usaha.lon - '.$postdata['user_lon'].'))
                                 + SIN(RADIANS(umkm_usaha.lat))
                                 * SIN(RADIANS('.$postdata['user_lat'].'))))),1) AS jarak_km'));
    		    }else{
    		        $query->select('umkm_usaha.*', 'provinces.name as provinsi', 'regencies.name as kabupaten','districts.name as kecamatan', 'villages.name as kelurahan',DB::raw('0 AS jarak_km'));
    		    }
                                 
                if($postdata['radius']>0){
                     	$query->whereRaw('111.111 *
                            DEGREES(ACOS(LEAST(1.0, COS(RADIANS(umkm_usaha.lat))
                                 * COS(RADIANS('.$postdata['user_lat'].'))
                                 * COS(RADIANS(umkm_usaha.lon - '.$postdata['user_lon'].'))
                                 + SIN(RADIANS(umkm_usaha.lat))
                                 * SIN(RADIANS('.$postdata['user_lat'].'))))) <= '.$postdata['radius']);
                }
                
                if($postdata['nik']){
                    $warga = DB::table('warga_bjb')->where('nik',$postdata['nik'])->first();
		            $query->where('umkm_usaha.warga_bjb_id',$warga->id);
		        }
		        
		        if($postdata['lokasi_id']){
		            $query->where('umkm_usaha.lokasi_id',$postdata['lokasi_id']);
		        }
                
		        if($postdata['cari']){
		            $query->where($postdata['cari'],$postdata['ini']);
		        }
		        
		        if($postdata['cariapa']){
		            $query->where($postdata['cariapa'],'like','%'. $postdata['cariini'] . '%');
		        }
		        
		        
		        
		        $query->limit($postdata['batas'])
                      ->orderBy('jarak_km','ASC');

		        $result['data'] = $query->get();
		        
		        foreach($result['data'] as $data){
					$warga2 = DB::table('warga_bjb')->where('id',$data->warga_bjb_id)->first();
					$owner = DB::table('cms_users')->where('nik',$warga2->nik)->first();
					$data->nik = $warga2->nik;
					$data->nama_owner = $owner->name;
					if($owner->no_telp){
						$data->telp = $owner->no_telp;
					}else{
						$data->telp = "Tidak ada";
					}
					$data->shared = $owner->tracking;
					if(strlen($owner->photo)==0){
		                $data->photo_user = "https://tabe.indera.id/vendor/crudbooster/avatar.jpg";
		            }else{
		                $data->photo_user = CRUDBooster::publicPath($owner->photo);
		            }
				
		            $numOfProduk = DB::table('produk')->where('umkm_usaha_id',$data->id)->count();
		            $data->numOfProduk = $numOfProduk;
		            if(strlen($data->photo)==0){
		                $data->photo = CRUDBooster::publicPath('images/default_photo.png');
		            }else{
		                $data->photo = CRUDBooster::publicPath($data->photo);
		            }
		            if(strlen($data->peta_icon)==0){
		                $data->peta_icon = CRUDBooster::publicPath('images/default_photo.png');
		            }else{
		                $data->peta_icon = CRUDBooster::publicPath($data->peta_icon);
		            }
		            if($data->jarak_km==null){
		                $data->jarak_km=0;
		            }
		            if($data->aset_tetap==null){
		                $data->aset_tetap=0;
		            }
		            if($data->omset==null){
		                $data->omset=0;
		            }
		            if($data->j_kary_l==null){
		                $data->j_kary_l=0;
		            }
		            if($data->j_kary_p==null){
		                $data->j_kary_p=0;
		            }
		            if($data->j_kary==null){
		                $data->j_kary=0;
		            }
		            if($data->lokasi_id!=null){
		                $lokasi = DB::table('lokasi')->where('id',$data->lokasi_id)->first();
		                $data->lat = $lokasi->lat;
		                $data->lon = $lokasi->lon;
		                $data->tempat_berusaha = $lokasi->nama;
		            }else{
		                $data->tempat_berusaha = "Tempat Sendiri";
		                $data->lokasi_id = 0;
		            }
		        }
                
                
  
    			$result['numOfData'] = sizeof($result['data']);
		    }

		}