<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiKeranjangCountController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "keranjang";        
				$this->permalink   = "keranjang_count";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process
                
		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
                $query->where('keranjang.status','new');
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                if($result['api_status']==1){
                    $result['data']="";
                    $result['numOfItems'] = DB::table('keranjang')->where('keranjang.status','new')->where('cms_users_id',$postdata['cms_users_id'])->count();
                    $belanjaan = DB::table('keranjang')
                                            ->join('produk','keranjang.produk_id','produk.id')
                                            ->where('keranjang.status','new')
                                            ->where('keranjang.cms_users_id',$postdata['cms_users_id'])
                                            ->sum('produk.harga');
                    
                    $result['belanjaan'] = (int)$belanjaan;
                }
		    }

		}