<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiKomentarController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "komentar";        
				$this->permalink   = "komentar";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query
				$query->join('cms_users','komentar.user_id','=','cms_users.id')
					->select('komentar.*','cms_users.name as nama','cms_users.display_name as nama_tampilan','cms_users.nik as nik','cms_users.photo as photo')
					->orderBy('created_at','asc')
					//->paginate(15);
					->get();
		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
				$terlibat = DB::table('komentar')
					->where('nama_table',$postdata['nama_table'])
					->where('key_id',$postdata['key_id'])
					->where('user_id','<>',$postdata['req_by'])
					->distinct()
					->get(['user_id']);
					
				$tlb = array();
				
				foreach($terlibat as $t){
					array_push($tlb,CRUDBooster::whoAmI($t->user_id)->nik);
				}
				
				$result['terlibat'] = $tlb;
				
				
				foreach($result['data'] as $data){
				    $date=date_create($data->created_at);
				    $data->created_at = date_format($date,"d M Y H:i:s");
				    $data->isSender = 0;
				    if($data->user_id==$postdata['req_by']){
				        $data->nama = 'Saya';
				        $data->nama_tampilan = 'Saya';
				        $data->isSender = 1;
				    }
				    if(!$data->nama_tampilan){
					    $data->nama_tampilan = $data->nama;
					}
					if($data->is_read==0){
						DB::table('komentar')
						->where('id',$data->id)
						->update(['is_read'=>1]);
					}
					if(!$data->photo){
					    $data->photo = "https://siapkk.banjarbarukota.go.id/vendor/crudbooster/avatar.jpg";
					}
					$penyuka = DB::Table('reaksi')
						            ->join('cms_users','cms_users.id','reaksi.user_id')
						            ->join('master_reaksi','master_reaksi.id','reaksi.master_reaksi_id')
						            ->where('reaksi.key_id',$data->id)
						            ->where('reaksi.master_reaksi_id','1')
						            ->select('reaksi.user_id','cms_users.nik','cms_users.name','cms_users.display_name','cms_users.photo','cms_users.icon')
						            ->get();
						            
					if($penyuka){
						$penyukanya = array();
						foreach($penyuka as $suka){
							array_push($penyukanya, $suka);
						}
						$data->penyuka = $penyukanya;
						$data->jpenyuka = sizeof($penyuka);
					}else{
					    $data->penyuka = null;
					    $data->jpenyuka = 0;
					}
					
					$ilike = DB::Table('reaksi')
					            ->where('key_id',$data->id)
					            ->where('master_reaksi_id','1')
					            ->where('user_id',$postdata['req_by'])
					            ->first();
					            
					if($ilike){
					    $data->ilike = $ilike->id;
					}else{
					    $data->ilike = 0;						
					}
				}
				
				$tentang = DB::Table($postdata['nama_table'])->where('id',$postdata['key_id'])->first();
				
	
			    if($postdata['nama_table']=="grup"){
			        $tentang->nama =$tentang->nama_grup;
			        $tentang->gambar_utama = $tentang->poto_grup;
			    }else if($postdata['nama_table']=="lokasi"){
			        
			    }
			    else if($postdata['nama_table']=="informasi"){
			        $tentang->nama = $tentang->judul;
			    }
			
				
				$result['tentang'] = $tentang;
				
				
				
				$result['count'] = sizeof($result['data']);
		    }

		}