<?php namespace App\Http\Controllers;

		use Session;
		use Request;
		use DB;
		use CRUDBooster;

		class ApiLaporanBanjirController extends \crocodicstudio\crudbooster\controllers\ApiController {

		    function __construct() {    
				$this->table       = "laporan_banjir";        
				$this->permalink   = "laporan_banjir";    
				$this->method_type = "get";    
		    }
		

		    public function hook_before(&$postdata) {
		        //This method will be execute before run the main process

		    }

		    public function hook_query(&$query) {
		        //This method is to customize the sql query

		    }

		    public function hook_after($postdata,&$result) {
		        //This method will be execute after run the main process
                // $result['data'] = DB::table('districts')
                //                     ->join('laporan_banjir','laporan_banjir.district_id','districts.id')
                //                     ->selectRaw('districts.name as Kecamatan, SUM(laporan_banjir.jumlah_terdampak) as Warga, SUM(laporan_banjir.jumlah_kk) as KK, SUM(laporan_banjir.jumlah_pengungsi) as Pengungsi, SUM(laporan_banjir.jumlah_posko) as Posko, SUM(laporan_banjir.korban_jiwa) as Korban')
                //                     ->groupBy('districts.name')
                //                     ->orderBy($postdata['order'],'desc')
                //                     ->get();
                                    
                $kecamatan = DB::table('districts')->get();
                
                foreach($kecamatan as $kec){
                    
                    $kec->warga = DB::table('laporan_banjir')
                                    ->where('district_id',$kec->id)
                                    ->sum('jumlah_terdampak');
                                    
                    $kec->kk = DB::table('laporan_banjir')
                                    ->where('district_id',$kec->id)
                                    ->sum('jumlah_kk');
                                    
                    $kec->pengungsi = DB::table('laporan_banjir')
                                    ->where('district_id',$kec->id)
                                    ->sum('jumlah_pengungsi');
                                    
                    $kec->korban_jiwa = DB::table('laporan_banjir')
                                    ->where('district_id',$kec->id)
                                    ->sum('korban_jiwa');
                                    
                    $kec->posko = DB::table('laporan_banjir')
                                    ->where('district_id',$kec->id)
                                    ->sum('jumlah_posko');
                                    
                    $kec->dapur_umum = DB::table('laporan_banjir')
                                    ->where('district_id',$kec->id)
                                    ->sum('jumlah_dapur_umum');
                    
                    $kec->jalan = DB::table('kerusakan')
                                    ->where('district_id',$kec->id)
                                    ->where('infrastruktur_id',5)
                                    ->count();
                                    
                    $kec->jalan_lingkungan = DB::table('kerusakan')
                                    ->where('district_id',$kec->id)
                                    ->where('infrastruktur_id',1)
                                    ->count();
                                    
                    $kec->sanitasi = DB::table('kerusakan')
                                    ->where('district_id',$kec->id)
                                    ->where('infrastruktur_id',2)
                                    ->count();
                                    
                    $kec->jembatan = DB::table('kerusakan')
                                    ->where('district_id',$kec->id)
                                    ->where('infrastruktur_id',3)
                                    ->count();
                                    
                    $kec->siring = DB::table('kerusakan')
                                    ->where('district_id',$kec->id)
                                    ->where('infrastruktur_id',4)
                                    ->count();
                }
                
                $sorted = $kecamatan->sortByDesc($postdata['order']); //sortBy($postdata['order'], [], true); //
                
                $result['data'] = $sorted->values()->all();
                                    
                
		    }

		}